/*
 * Decompiled with CFR 0.152.
 */
package kd.drp.mem.formplugin.cost;

import java.util.ArrayList;
import java.util.Date;
import java.util.EventObject;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.bill.MobileBillShowParameter;
import kd.bos.bill.OperationStatus;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IClientViewProxy;
import kd.bos.form.MobileFormShowParameter;
import kd.bos.form.ShowType;
import kd.bos.form.control.Control;
import kd.bos.form.control.events.ClickListener;
import kd.bos.form.control.events.MobileSearchTextChangeEvent;
import kd.bos.form.control.events.MobileSearchTextChangeListener;
import kd.bos.list.MobileSearch;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.user.UserServiceHelper;
import kd.drp.mem.common.DateUtil;
import kd.drp.mem.common.ToExecFilterUtil;
import kd.drp.mem.formplugin.basedata.MEMBillFormMobPlugin;
import kd.drp.mem.formplugin.cost.CostAppFormUtil;
import org.apache.commons.lang.StringUtils;

public class CustomerListMobFormPlugin
extends MEMBillFormMobPlugin
implements ClickListener,
MobileSearchTextChangeListener {
    private static final String MOBILESEARCHAP = "mobilesearchap";
    private static final String MENU = "menu";
    private static final String CUSINFOSTATISTICS = "cusinfostatistics";
    private static final String CUSTOMERNAME = "customername";
    private static final String EXECUTORYLIST = "executorylist";
    private static final String ENTRYENTITY = "entryentity";
    private static String[] colors = new String[]{"#55A0F5", "#F3974E", "#2EC6C8"};

    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.addClickListeners(new String[]{MENU, CUSINFOSTATISTICS});
        MobileSearch searchap = (MobileSearch)this.getView().getControl(MOBILESEARCHAP);
        searchap.addMobileSearchTextChangeListener((MobileSearchTextChangeListener)this);
    }

    public void click(EventObject evt) {
        super.click(evt);
        Control control = (Control)evt.getSource();
        String key = control.getKey();
        if (MENU.equals(key)) {
            this.openCostApplyList();
        } else if (CUSINFOSTATISTICS.equals(key)) {
            this.openExecutoryList();
        }
    }

    public void click(MobileSearchTextChangeEvent e) {
        this.initData();
    }

    public void afterBindData(EventObject e) {
        super.afterBindData(e);
        this.getView().setVisible(Boolean.FALSE, new String[]{"flexpanelap2"});
        this.initData();
    }

    private void openCostApplyList() {
        MobileBillShowParameter param = new MobileBillShowParameter();
        param.getOpenStyle().setShowType(ShowType.Floating);
        param.setFormId("mem_cost_apply_listmob");
        param.setStatus(OperationStatus.ADDNEW);
        this.getView().showForm((FormShowParameter)param);
    }

    private void openExecutoryList() {
        String customerId;
        block14: {
            Control entry = this.getView().getControl(ENTRYENTITY);
            String entryInfo = entry.getModel().getValue(CUSTOMERNAME).toString();
            customerId = null;
            try (DataSet datas = this.getCustomerDataSet();){
                if (datas == null) break block14;
                for (Row datarow : datas) {
                    String customerName = datarow.getString("customer.name");
                    if (customerName == null || !customerName.equals(entryInfo)) continue;
                    customerId = datarow.getString("customer.id");
                    break;
                }
            }
        }
        if (customerId == null) {
            return;
        }
        MobileFormShowParameter param = new MobileFormShowParameter();
        param.getOpenStyle().setShowType(ShowType.Floating);
        param.setFormId("mem_costexecute_listmob");
        param.setStatus(OperationStatus.ADDNEW);
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("customerId", customerId);
        Object beginDate = this.getView().getFormShowParameter().getCustomParam("beginDate");
        Object endDate = this.getView().getFormShowParameter().getCustomParam("endDate");
        params.put("beginDate", beginDate);
        params.put("endDate", endDate);
        param.setCustomParams(params);
        this.getView().showForm((FormShowParameter)param);
    }

    private void initData() {
        this.getView().setVisible(Boolean.FALSE, new String[]{"flexpanelap2"});
        this.getView().setVisible(Boolean.TRUE, new String[]{"flexpanelap1"});
        IDataModel model = this.getModel();
        model.beginInit();
        model.deleteEntryData(ENTRYENTITY);
        model.getDataEntity(true);
        try (DataSet datas = this.getCustomerDataSet();){
            if (datas != null) {
                ArrayList<String> custNameList = new ArrayList<String>();
                ArrayList<String> custIdList = new ArrayList<String>();
                for (Row datarow : datas) {
                    custNameList.add(datarow.getString("customer.name"));
                    custIdList.add(datarow.getString("customer.id"));
                }
                if (custIdList.size() == 0) {
                    this.getView().setVisible(Boolean.TRUE, new String[]{"flexpanelap2"});
                    this.getView().setVisible(Boolean.FALSE, new String[]{"flexpanelap1"});
                    return;
                }
                Set set = ToExecFilterUtil.getCostTypeSet();
                Long userId = UserServiceHelper.getCurrentUserId();
                Long mainOrgId = UserServiceHelper.getUserMainOrgId((long)userId);
                Map<String, Integer> currentUserNotExecMap = this.getCurrentUserNotExecCount(custIdList, set, mainOrgId);
                Map<String, Integer> executoryApplyCountMap = this.getExecutoryApplyCount(custIdList, set, mainOrgId);
                Map<String, Integer> unSpecifiedShopCountMap = this.unSpecifiedShopCount(custIdList, set, mainOrgId);
                Integer shopAmout = 0;
                String shopTxt = "";
                for (int i = 0; i < custNameList.size(); ++i) {
                    int rowIndex = model.createNewEntryRow(ENTRYENTITY);
                    String custId = (String)custIdList.get(i);
                    model.setValue(CUSTOMERNAME, custNameList.get(i), rowIndex);
                    shopAmout = unSpecifiedShopCountMap.get(custId);
                    shopTxt = shopAmout == null || shopAmout == 0 ? ResManager.loadKDString((String)"\u95e8\u5e97\u5df2\u5168\u90e8\u6307\u5b9a", (String)"CustomerListMobFormPlugin_0", (String)"drp-mem-formplugin", (Object[])new Object[0]) : String.format(ResManager.loadKDString((String)"\u5171 %s \u9879\u672a\u6307\u5b9a\u95e8\u5e97", (String)"CustomerListMobFormPlugin_1", (String)"drp-mem-formplugin", (Object[])new Object[0]), shopAmout);
                    model.setValue("shoptxt", (Object)shopTxt, rowIndex);
                    Integer total = executoryApplyCountMap.get(custId) == null ? Integer.valueOf(0) : executoryApplyCountMap.get(custId);
                    Integer exec = currentUserNotExecMap.get(custId) == null ? Integer.valueOf(0) : currentUserNotExecMap.get(custId);
                    Integer notExec = total - exec;
                    this.setColor(i, notExec.toString());
                    model.setValue(EXECUTORYLIST, (Object)notExec, rowIndex);
                    model.setValue("expensetype", (Object)total, rowIndex);
                }
            }
        }
        model.endInit();
        this.getView().updateView(ENTRYENTITY);
    }

    private List<QFilter> getExecFilter(List<String> custIdList, Set<Object> costTypeSet, Long mainOrgId) {
        ArrayList<QFilter> filterList = new ArrayList<QFilter>();
        Object beginDate = this.getView().getFormShowParameter().getCustomParam("beginDate");
        Object endDate = this.getView().getFormShowParameter().getCustomParam("endDate");
        if (beginDate != null && endDate != null) {
            QFilter f1 = new QFilter("costapplyentry.bill.begindate", ">=", beginDate);
            f1.and("costapplyentry.bill.begindate", "<=", endDate);
            QFilter f2 = new QFilter("costapplyentry.bill.begindate", "<=", beginDate);
            f2.and("costapplyentry.bill.enddate", ">=", beginDate);
            filterList.add(f1.or(f2));
        } else {
            Date date = new Date();
            date = DateUtil.getDayFirst((Date)date);
            filterList.add(new QFilter("costapplyentry.entrybegindate", "<=", (Object)date));
            filterList.add(new QFilter("costapplyentry.entryenddate", ">=", (Object)date));
        }
        ArrayList<Long> result = new ArrayList<Long>(custIdList.size());
        for (int i = 0; i < custIdList.size(); ++i) {
            result.add(Long.parseLong(custIdList.get(i)));
        }
        filterList.add(new QFilter("costapplyentry.bill.customer.id", "in", result));
        filterList.add(new QFilter("costapplyentry.bill.expensetype", "in", costTypeSet));
        filterList.add(new QFilter("creator", "=", (Object)UserServiceHelper.getCurrentUserId()));
        return filterList;
    }

    private List<QFilter> getEntryFilter(List<String> custIdList, Set<Object> costTypeSet, Long mainOrgId) {
        ArrayList<QFilter> filterList = new ArrayList<QFilter>();
        Object beginDate = this.getView().getFormShowParameter().getCustomParam("beginDate");
        Object endDate = this.getView().getFormShowParameter().getCustomParam("endDate");
        if (beginDate != null && endDate != null) {
            QFilter f1 = new QFilter("bill.begindate", ">=", beginDate);
            f1.and("bill.begindate", "<=", endDate);
            QFilter f2 = new QFilter("bill.begindate", "<=", beginDate);
            f2.and("bill.enddate", ">=", beginDate);
            filterList.add(f1.or(f2));
        } else {
            filterList.add(this.getEntryDateFilter());
        }
        ArrayList<Long> result = new ArrayList<Long>(custIdList.size());
        for (int i = 0; i < custIdList.size(); ++i) {
            result.add(Long.parseLong(custIdList.get(i)));
        }
        filterList.add(new QFilter("bill.billstatus", "in", (Object)new String[]{"E", "F"}));
        filterList.add(new QFilter("bill.customer.id", "in", result));
        filterList.add(new QFilter("bill.expensetype", "in", costTypeSet));
        return filterList;
    }

    private void setColor(int i, String txt) {
        int remainder = i % 3;
        this.setLabelColor("labelap1", i, colors[remainder], "", "");
        this.setLabelColor("labelap2", i, "", colors[remainder], txt);
    }

    private void setLabelColor(String key, int rowIndex, String backColor, String foreColor, String text) {
        HashMap activeItem = new HashMap();
        HashMap<String, String> propertiesMap = new HashMap<String, String>();
        if (StringUtils.isNotBlank((String)backColor)) {
            propertiesMap.put("bc", backColor);
        }
        if (StringUtils.isNotBlank((String)foreColor)) {
            propertiesMap.put("fc", foreColor);
        }
        if (StringUtils.isNotBlank((String)text)) {
            propertiesMap.put("text", text);
        }
        activeItem.put(key, propertiesMap);
        ((IClientViewProxy)this.getView().getService(IClientViewProxy.class)).invokeControlMethod(ENTRYENTITY, "setCustomProperties", new Object[]{rowIndex, activeItem});
    }

    private Map<String, Integer> getCurrentUserNotExecCount(List<String> custIdList, Set<Object> costTypeSet, Long mainOrgId) {
        HashMap<String, String> map = new HashMap<String, String>();
        HashMap<String, Integer> rsMap = new HashMap<String, Integer>();
        try (DataSet dataSet = QueryServiceHelper.queryDataSet((String)((Object)((Object)this)).getClass().getName(), (String)"mem_marketcostexecute", (String)"costapplyentry.id,costapplyentry.bill.customer.id", (QFilter[])this.getExecFilter(custIdList, costTypeSet, mainOrgId).toArray(new QFilter[1]), (String)"costapplyentry.bill.customer.id");){
            if (dataSet != null) {
                for (Row datarow : dataSet) {
                    String custId = datarow.getString("costapplyentry.bill.customer.id");
                    String entryId = datarow.getString("costapplyentry.id");
                    map.put(entryId, custId);
                }
            }
            Set entrySet = map.entrySet();
            for (Map.Entry entry : entrySet) {
                String custId = (String)entry.getKey();
                Integer rowCount = (Integer)rsMap.get(custId);
                if (rowCount != null) {
                    rsMap.put(custId, rowCount + 1);
                    continue;
                }
                rsMap.put(custId, 1);
            }
        }
        return rsMap;
    }

    private Map<String, Integer> unSpecifiedShopCount(List<String> custIdList, Set<Object> costTypeSet, Long mainOrgId) {
        HashMap<String, Integer> map = new HashMap<String, Integer>();
        List<QFilter> filterList = this.getEntryFilter(custIdList, costTypeSet, mainOrgId);
        filterList.add(new QFilter("shop.id", "is null", null).or("shop.id", "=", (Object)0));
        try (DataSet dataSet = QueryServiceHelper.queryDataSet((String)((Object)((Object)this)).getClass().getName(), (String)"mem_market_costapplyentry", (String)"bill.customer.id", (QFilter[])filterList.toArray(new QFilter[1]), null).groupBy(new String[]{"bill.customer.id"}).count("shop.id").finish();){
            if (dataSet != null) {
                for (Row datarow : dataSet) {
                    String custId = datarow.getString("bill.customer.id");
                    int showCount = datarow.getInteger("shop.id");
                    if (showCount > 0) {
                        map.put(custId, showCount);
                        continue;
                    }
                    map.put(custId, 0);
                }
            }
        }
        return map;
    }

    private Map<String, Integer> getExpensetypeCount(List<String> custIdList) {
        HashMap<String, Integer> map = new HashMap<String, Integer>();
        ArrayList<QFilter> filterList = new ArrayList<QFilter>();
        filterList.add(new QFilter("customer.id", "in", (Object)custIdList.toArray()));
        filterList.add(this.getDefaultFilter());
        try (DataSet dataSet = QueryServiceHelper.queryDataSet((String)((Object)((Object)this)).getClass().getName(), (String)"mem_market_cost_apply", (String)"customer.id,expensetype.id", (QFilter[])filterList.toArray(new QFilter[1]), null).groupBy(new String[]{"customer.id", "expensetype.id"}).finish().groupBy(new String[]{"customer.id"}).count("expensetype.id").finish();){
            if (dataSet != null) {
                for (Row datarow : dataSet) {
                    String custId = datarow.getString("customer.id");
                    int showCount = datarow.getInteger("expensetype.id");
                    map.put(custId, showCount);
                }
            }
        }
        return map;
    }

    private Map<String, Integer> getExecutoryApplyCount(List<String> custIdList, Set<Object> costTypeSet, Long mainOrgId) {
        HashMap<String, Integer> map = new HashMap<String, Integer>();
        try (DataSet dataSet = QueryServiceHelper.queryDataSet((String)((Object)((Object)this)).getClass().getName(), (String)"mem_market_costapplyentry", (String)"id,bill.customer.id", (QFilter[])this.getEntryFilter(custIdList, costTypeSet, mainOrgId).toArray(new QFilter[1]), null).groupBy(new String[]{"bill.customer.id"}).count("id").finish();){
            if (dataSet != null) {
                for (Row datarow : dataSet) {
                    String custId = datarow.getString("bill.customer.id");
                    int showCount = datarow.getInteger("id");
                    map.put(custId, showCount);
                }
            }
        }
        return map;
    }

    private DataSet getCustomerDataSet() {
        MobileSearch search = (MobileSearch)this.getView().getControl(MOBILESEARCHAP);
        String searchtxt = search.getText();
        QFilter f = this.getDefaultFilter();
        if (searchtxt != null && searchtxt.trim().length() != 0) {
            String likeValue = "%" + searchtxt.trim() + "%";
            QFilter searchFilter = new QFilter("customer.name", "like", (Object)likeValue);
            f.and(searchFilter);
        }
        Object beginDate = this.getView().getFormShowParameter().getCustomParam("beginDate");
        Object endDate = this.getView().getFormShowParameter().getCustomParam("endDate");
        if (beginDate != null && endDate != null) {
            QFilter f1 = new QFilter("begindate", ">=", beginDate);
            f1.and("begindate", "<=", endDate);
            QFilter f2 = new QFilter("begindate", "<=", beginDate);
            f2.and("enddate", ">=", beginDate);
            f.and(f1.or(f2));
        } else {
            f.and(ToExecFilterUtil.getDateFilter());
        }
        DataSet dataSet = QueryServiceHelper.queryDataSet((String)((Object)((Object)this)).getClass().getName(), (String)"mem_market_cost_apply", (String)"customer.id,customer.name", (QFilter[])f.toArray(), (String)"customer.name").groupBy(new String[]{"customer.id", "customer.name"}).finish();
        return dataSet;
    }

    protected QFilter getDefaultFilter() {
        return ToExecFilterUtil.getCostTypeFilter().and(ToExecFilterUtil.getBillStatusFilter()).and(CostAppFormUtil.getMobSetFilter());
    }

    private QFilter getEntryDateFilter() {
        Date date = new Date();
        date = DateUtil.getDayFirst((Date)date);
        QFilter filter = new QFilter("entrybegindate", "<=", (Object)date);
        filter.and("entryenddate", ">=", (Object)date);
        return filter;
    }
}

