/*
 * Decompiled with CFR 0.152.
 */
package kd.drp.mem.formplugin.cost;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Date;
import java.util.EventObject;
import java.util.List;
import kd.bos.bill.OperationStatus;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.entity.operate.Donothing;
import kd.bos.form.ShowType;
import kd.bos.form.control.EntryGrid;
import kd.bos.form.control.OperationColumn;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.field.FieldEdit;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.form.operatecol.OperationColItem;
import kd.bos.list.ListShowParameter;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.mvc.bill.BillModel;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.workflow.WorkflowServiceHelper;
import kd.bos.util.StringUtils;
import kd.drp.mem.common.BigDecimalUtil;
import kd.drp.mem.common.BizBillStatusEnum;
import kd.drp.mem.common.DateUtil;
import kd.drp.mem.common.ExecStatusEnum;
import kd.drp.mem.common.FreezeStatusEnum;
import kd.drp.mem.common.MEMFilterUtil;
import kd.drp.mem.common.MEMUtil;
import kd.drp.mem.formplugin.cost.CostAppFormUtil;
import kd.drp.mem.formplugin.cost.CostFormPlugin;
import net.sf.json.JSONObject;

public class MarketCostApplyEditFormPlugin
extends CostFormPlugin {
    public static final Log logger = LogFactory.getLog(MarketCostApplyEditFormPlugin.class);
    protected final String TOTALAMTUNAPPROVED = "totalamtunapproved";
    protected final String TOTALAMOUNT2 = "totalamount";
    protected final String AMTUNAPPROVED = "amtunapproved";
    protected final String ENDDATE2 = "enddate";
    protected final String BEGINDATE2 = "begindate";
    protected final String REACHRATE = "reachrate";
    protected final String ENTRYENTITY = "entryentity";
    protected final String PLANSALEQTY = "plansaleqty";
    protected final String ACTUALSALEQTY = "actualsaleqty";
    protected final String ENTRYENDDATE = "entryenddate";
    protected final String ENTRYBEGINDATE = "entrybegindate";
    protected volatile boolean triggerChangeEvent = true;

    public void initialize() {
        super.initialize();
        EntryGrid entryGrid = (EntryGrid)this.getControl("entryentity");
        entryGrid.addPackageDataListener(pkEvent -> {
            Object col = pkEvent.getSource();
            if (col instanceof OperationColumn && this.getOperateColumnName().equalsIgnoreCase(((OperationColumn)col).getKey())) {
                List operationColItems = (List)pkEvent.getFormatValue();
                for (OperationColItem operationColItem : operationColItems) {
                    DynamicObject entryInfo;
                    QFilter qfilter;
                    DynamicObject executeInfo;
                    if (!"viewexecdetail".equalsIgnoreCase(operationColItem.getOperationKey()) || (executeInfo = QueryServiceHelper.queryOne((String)"mem_marketcostexecute", (String)"id,costapplyentry", (QFilter[])(qfilter = MEMFilterUtil.createQFilter((String)"costapplyentry", (Object)(entryInfo = pkEvent.getRowData()).getPkValue())).toArray())) != null) continue;
                    operationColItem.setVisible(false);
                }
            }
        });
    }

    protected void initMinDate() {
    }

    @Override
    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.addF7Listener(this, "customer", "shop", "iteminfo", "expensetype");
    }

    protected String getOperateColumnName() {
        return "operationcolum";
    }

    @Override
    public void afterBindData(EventObject e) {
        super.afterBindData(e);
        if (this.getView().getFormShowParameter().getStatus() != OperationStatus.VIEW) {
            String value = (String)this.getModel().getValue("billstatus");
            if (BizBillStatusEnum.AUDIDPASS.getValue().equals(value) || BizBillStatusEnum.PARTREFUND.getValue().equals(value) || BizBillStatusEnum.CLOSED.getValue().equals(value)) {
                EntryGrid entryGrid = (EntryGrid)this.getControl(this.getEntryKey());
                List fields = entryGrid.getFieldEdits();
                for (int i = 0; i < fields.size(); ++i) {
                    FieldEdit fieldEdit = (FieldEdit)fields.get(i);
                    if (!"shop".equals(fieldEdit.getKey())) continue;
                    fieldEdit.setEnable("", false, -1);
                    break;
                }
            }
        }
        this.initMinDate();
    }

    public void afterCopyData(EventObject e) {
        BillModel model = (BillModel)e.getSource();
        model.setValue("billdate", (Object)new Date());
        DynamicObjectCollection ec = model.getEntityEntity(this.getEntryKey());
        for (int i = 0; i < ec.size(); ++i) {
            ((DynamicObject)ec.get(i)).set("amtapproved", null);
            ((DynamicObject)ec.get(i)).set("refundamount", null);
            ((DynamicObject)ec.get(i)).set("entrybegindate", null);
            ((DynamicObject)ec.get(i)).set("entryenddate", null);
            ((DynamicObject)ec.get(i)).set("AMTUNAPPROVED", ((DynamicObject)ec.get(i)).get("amount"));
        }
        model.setValue("totalamtunapproved", model.getValue("totalamount"));
        model.setValue("totalamtapproved", null);
        model.setValue("totalrefundamount", null);
        model.setValue("execstatus", (Object)ExecStatusEnum.UNECECUTE.getValue());
        model.setValue("freezestatus", (Object)FreezeStatusEnum.EMPTY.getValue());
        model.setValue("freezedate", null);
    }

    @Override
    public void afterCreateNewData(EventObject e) {
        super.afterCreateNewData(e);
        IDataModel model = this.getView().getModel();
        model.setValue("execstatus", (Object)ExecStatusEnum.UNECECUTE.getValue());
        model.setValue("freezestatus", (Object)FreezeStatusEnum.EMPTY.getValue());
    }

    @Override
    public void beforeF7Select(BeforeF7SelectEvent e) {
        String key;
        super.beforeF7Select(e);
        switch (key = e.getProperty().getName()) {
            case "customer": {
                this.setOuterCustomerFilter(e, "customer");
                break;
            }
            case "shop": {
                String value = (String)this.getModel().getValue("billstatus");
                if (BizBillStatusEnum.AUDIDPASS.getValue().equals(value) || BizBillStatusEnum.PARTREFUND.getValue().equals(value) || BizBillStatusEnum.CLOSED.getValue().equals(value)) {
                    ((ListShowParameter)e.getFormShowParameter()).setMultiSelect(false);
                } else {
                    ((ListShowParameter)e.getFormShowParameter()).setMultiSelect(true);
                }
                DynamicObject customer = this.getDynamicObject("customer");
                if (customer == null) {
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u9009\u62e9\u5ba2\u6237", (String)"MarketCostApplyEditFormPlugin_0", (String)"drp-mem-formplugin", (Object[])new Object[0]));
                    e.setCancel(true);
                    return;
                }
                QFilter filter = new QFilter("channel", "=", customer.getPkValue());
                filter.and("enabled", "=", (Object)"1");
                this.setF7Filter("shop", filter);
                ArrayList<QFilter> list = new ArrayList<QFilter>();
                list.add(filter);
                ((ListShowParameter)e.getFormShowParameter()).getListFilterParameter().setQFilters(list);
                break;
            }
            case "iteminfo": {
                QFilter qfilter = new QFilter("isonsell", "=", (Object)"1");
                this.setF7Filter("iteminfo", qfilter);
                ArrayList<QFilter> itemList = new ArrayList<QFilter>();
                itemList.add(qfilter);
                ((ListShowParameter)e.getFormShowParameter()).getListFilterParameter().setQFilters(itemList);
                break;
            }
        }
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs e) {
        super.beforeDoOperation(e);
        Object source = e.getSource();
        if (source instanceof Donothing) {
            boolean inProcess;
            Donothing donothing = (Donothing)source;
            if (("btnunfreeze".equals(donothing.getOperateKey()) || "unfreeze".equals(donothing.getOperateKey())) && (inProcess = WorkflowServiceHelper.inProcess((String)this.getView().getModel().getValue("id").toString()))) {
                this.getView().showMessage(ResManager.loadKDString((String)"\u5df2\u63d0\u4ea4\u89e3\u51bb\u5de5\u4f5c\u6d41", (String)"MarketCostApplyEditFormPlugin_1", (String)"drp-mem-formplugin", (Object[])new Object[0]));
                e.setCancel(true);
                e.setCancelMessage(ResManager.loadKDString((String)"\u5df2\u63d0\u4ea4\u89e3\u51bb\u5de5\u4f5c\u6d41.", (String)"MarketCostApplyEditFormPlugin_2", (String)"drp-mem-formplugin", (Object[])new Object[0]));
                return;
            }
            if ("changeshop".equals(donothing.getOperateKey())) {
                DynamicObjectCollection entrys = this.getModel().getEntryEntity("entryentity");
                int qty = 0;
                long currentTime = new Date().getTime();
                for (int i = 0; i < entrys.size(); ++i) {
                    DynamicObject eInfo = (DynamicObject)entrys.get(i);
                    if (eInfo.getDate("entrybegindate") != null && currentTime < eInfo.getDate("entrybegindate").getTime()) continue;
                    this.getView().setEnable(Boolean.FALSE, i, new String[]{"shop"});
                    ++qty;
                }
                if (qty == entrys.size()) {
                    this.getView().showErrorNotification(ResManager.loadKDString((String)"\u5f53\u524d\u65f6\u95f4\u5927\u4e8e\u6240\u6709\u7684\u5f00\u59cb\u65f6\u95f4,\u4e0d\u80fd\u53d8\u66f4\u95e8\u5e97", (String)"MarketCostApplyEditFormPlugin_3", (String)"drp-mem-formplugin", (Object[])new Object[0]));
                    e.setCancel(true);
                    e.setCancelMessage(ResManager.loadKDString((String)"\u5f53\u524d\u65f6\u95f4\u5927\u4e8e\u6240\u6709\u7684\u5f00\u59cb\u65f6\u95f4,\u4e0d\u80fd\u53d8\u66f4\u95e8\u5e97", (String)"MarketCostApplyEditFormPlugin_3", (String)"drp-mem-formplugin", (Object[])new Object[0]));
                    return;
                }
            }
            if ("scopesave".equals(donothing.getOperateKey())) {
                e.cancel = true;
                OperateOption option = OperateOption.create();
                option.setVariableValue("isExecScopeSave", "TRUE");
                this.getView().invokeOperation("save", option);
            }
        }
    }

    @Override
    public void afterDoOperation(AfterDoOperationEventArgs e) {
        int rowIndex;
        DynamicObject orderEntry;
        EntryGrid entryGrid;
        super.afterDoOperation(e);
        String operateKey = e.getOperateKey();
        if ("changeshop".equals(operateKey)) {
            entryGrid = (EntryGrid)this.getControl(this.getEntryKey());
            List fields = entryGrid.getFieldEdits();
            for (int i = 0; i < fields.size(); ++i) {
                FieldEdit fieldEdit = (FieldEdit)fields.get(i);
                if (!"shop".equals(fieldEdit.getKey())) continue;
                fieldEdit.setEnable("", true, -1);
                break;
            }
            DynamicObjectCollection entrys = this.getModel().getEntryEntity("entryentity");
            for (int i = 0; i < entrys.size(); ++i) {
                DynamicObject eInfo = (DynamicObject)entrys.get(i);
                long currentTime = new Date().getTime();
                if (eInfo.getDate("entrybegindate") != null && currentTime < eInfo.getDate("entrybegindate").getTime()) continue;
                this.getView().setEnable(Boolean.FALSE, i, new String[]{"shop"});
            }
        }
        if ("submit".equals(operateKey) || "audit".equals(operateKey) || "closebill".equals(operateKey) || "confirmchange".equals(operateKey)) {
            this.getView().updateView();
        }
        if ("viewexecdetail".equals(operateKey) && (orderEntry = this.getRowInfo("entryentity", rowIndex = (entryGrid = (EntryGrid)this.getControl(this.getEntryKey())).getModel().getEntryCurrentRowIndex("entryentity"))) != null && orderEntry.getPkValue() != null) {
            CostAppFormUtil.openCostExecuteDetailForm(this.getView(), null, orderEntry.getPkValue(), ShowType.MainNewTabPage);
        }
        if ("deleteentry".equals(operateKey)) {
            this.calcTotalAmount();
            this.calcBeginDate(-1, null);
            this.calcEndDate(-1, null);
        }
        if ("addentry".equals(operateKey)) {
            Boolean isCopyRelateEntity = Boolean.TRUE;
            int[] rowIndexs = new int[]{0};
            IDataModel model = (IDataModel)this.getView().getService(IDataModel.class);
            model.copyEntryRow("entryentity", rowIndexs, isCopyRelateEntity.booleanValue());
            this.calcTotalAmount();
        }
    }

    @Override
    protected String[] getEntryActionControl() {
        return new String[]{"tblnewentry", "tbldeleteentry"};
    }

    @Override
    public void propertyChanged(PropertyChangedArgs e) {
        super.propertyChanged(e);
        int index = this.getRowIndex(e);
        String key = e.getProperty().getName();
        if (!this.triggerChangeEvent) {
            return;
        }
        switch (key) {
            case "qty": {
                this.calcAmount(index);
                this.calcCostAmount(index, this.getRowInfo("entryentity", index), null);
                break;
            }
            case "customer": {
                this.clearShop(index);
                break;
            }
            case "price": {
                this.calcAmount(index);
                break;
            }
            case "amount": {
                this.setValue("amtunapproved", BigDecimalUtil.subtractObject((Object)this.getValue("AMOUNT", index), (Object)this.getValue("amtapproved", index)), index);
                this.calcTotalAmount();
                break;
            }
            case "entrybegindate": {
                this.triggerChangeEvent = false;
                this.calcBeginDate(index, (Date)e.getChangeSet()[0].getOldValue());
                break;
            }
            case "entryenddate": {
                this.triggerChangeEvent = false;
                this.calcEndDate(index, (Date)e.getChangeSet()[0].getOldValue());
                break;
            }
            case "actualsaleqty": {
                this.calcReachrate(index);
                break;
            }
            case "plansaleqty": {
                this.calcReachrate(index);
                break;
            }
            case "material": {
                this.calcCostAmount(index, "material");
                break;
            }
            case "amtapproved": {
                this.setValue("amtunapproved", BigDecimalUtil.subtractObject((Object)this.getValue("AMOUNT", index), (Object)this.getValue("amtapproved", index)), index);
                this.calcTotalAmount();
                break;
            }
            case "iteminfo": {
                this.setUnit(index);
                this.calcCostAmount(index, "iteminfo");
                break;
            }
            case "expensetype": {
                this.expensetypeChange();
            }
        }
    }

    private void expensetypeChange() {
        String s = this.getPageCache().get("entryDisplayMap");
        if (StringUtils.isNotEmpty((String)s)) {
            JSONObject totalExecJson = null;
            totalExecJson = !StringUtils.isEmpty((String)s) ? JSONObject.fromObject((Object)s) : new JSONObject();
            if (!totalExecJson.getBoolean("costprice")) {
                return;
            }
            DynamicObjectCollection entrys = this.getModel().getEntryEntity("entryentity");
            for (int i = 0; i < entrys.size(); ++i) {
                DynamicObject eInfo = (DynamicObject)entrys.get(i);
                BigDecimal costprice = eInfo.getBigDecimal("costprice");
                if (!totalExecJson.getBoolean("price")) {
                    this.setValue("price", costprice, i);
                    continue;
                }
                if (eInfo.getBigDecimal("price").compareTo(BigDecimal.ZERO) > 0 || costprice.compareTo(BigDecimal.ZERO) == 0) continue;
                this.setValue("price", costprice, i);
            }
        }
    }

    protected void calcCostAmount(int index, String key) {
        DynamicObject orderEntry = this.getRowInfo("entryentity", index);
        if (orderEntry != null) {
            DynamicObject material = orderEntry.getDynamicObject(key);
            BigDecimal costPrice = null;
            if (material != null) {
                costPrice = material.getBigDecimal("costprice");
            }
            this.setValue("costprice", costPrice, index);
            String s = this.getPageCache().get("entryDisplayMap");
            logger.info("entryDisplayMap:" + s);
            if (StringUtils.isNotEmpty((String)s)) {
                JSONObject totalExecJson = null;
                totalExecJson = !StringUtils.isEmpty((String)s) ? JSONObject.fromObject((Object)s) : new JSONObject();
                if (totalExecJson.getBoolean("costprice")) {
                    this.setValue("price", costPrice, index);
                } else {
                    logger.info("costprice si false");
                }
            } else {
                this.setValue("price", costPrice, index);
            }
            this.calcCostAmount(index, orderEntry, costPrice);
        }
    }

    protected void calcCostAmount(int index, DynamicObject orderEntry, BigDecimal costPrice) {
        if (costPrice == null) {
            costPrice = orderEntry.getBigDecimal("costprice");
        }
        BigDecimal qty = orderEntry.getBigDecimal("qty");
        int amtprecision = 2;
        BigDecimal costamount = BigDecimalUtil.multiplyObject((Object)costPrice, (Object)qty, (int)amtprecision);
        this.setValue("costamount", costamount, index);
    }

    protected void clearShop(int index) {
        DynamicObjectCollection entrys = this.getModel().getEntryEntity("entryentity");
        for (int i = 0; i < entrys.size(); ++i) {
            this.setValue("shop", null, i);
        }
    }

    protected void setUnit(int index) {
        Object assistUnit;
        Object itemPK = this.getEntryF7PKValue("entryentity", "iteminfo", index);
        Object baseUnit = MEMUtil.queryMasteridBaseUnitId((Object)itemPK);
        if (baseUnit != null) {
            this.getModel().setValue("baseunit", baseUnit, index);
        }
        if ((assistUnit = MEMUtil.queryMasteridAssistUnitId((Object)itemPK)) != null) {
            this.getModel().setValue("assistunit", assistUnit, index);
        }
    }

    protected void calcReachrate(int index) {
        BigDecimal plansaleqty;
        DynamicObject orderEntry = this.getRowInfo("entryentity", index);
        if (orderEntry != null && (plansaleqty = orderEntry.getBigDecimal("plansaleqty")) != null && plansaleqty.compareTo(BigDecimal.ZERO) != 0) {
            BigDecimal actualsaleqty = orderEntry.getBigDecimal("actualsaleqty");
            BigDecimal reachrate = BigDecimalUtil.multiplyObject((Object)actualsaleqty, (Object)100, (int)10);
            reachrate = BigDecimalUtil.divideObject((Object)reachrate, (Object)plansaleqty, (int)10);
            this.setValue("reachrate", reachrate, index);
        }
    }

    protected void calcBeginDate(int index, Date oldDate) {
        Date beginDate;
        DynamicObject orderEntry;
        if (index >= 0 && (orderEntry = this.getRowInfo("entryentity", index)) != null && orderEntry.getDate("entrybegindate") != null) {
            beginDate = orderEntry.getDate("entrybegindate");
            if ((beginDate = DateUtil.getDayLast((Date)beginDate)).getTime() < System.currentTimeMillis()) {
                this.getView().showMessage(String.format(ResManager.loadKDString((String)"\u7b2c%s\u884c\u5f00\u59cb\u65e5\u671f\u4e0d\u80fd\u5c0f\u4e8e\u5f53\u524d\u65e5\u671f.", (String)"MarketCostApplyEditFormPlugin_4", (String)"drp-mem-formplugin", (Object[])new Object[0]), index + 1));
                this.setValue("entrybegindate", oldDate, index);
                return;
            }
            Date endDate = orderEntry.getDate("entryenddate");
            if (endDate != null && (endDate = DateUtil.getDayLast((Date)endDate)).getTime() < beginDate.getTime()) {
                this.getView().showMessage(String.format(ResManager.loadKDString((String)"\u7b2c%s\u884c\u7ed3\u675f\u65e5\u671f\u5fc5\u987b\u5927\u4e8e\u5f00\u59cb\u65e5\u671f.", (String)"MarketCostApplyEditFormPlugin_5", (String)"drp-mem-formplugin", (Object[])new Object[0]), index + 1));
                this.setValue("entrybegindate", oldDate, index);
                return;
            }
        }
        DynamicObjectCollection entrys = this.getModel().getEntryEntity("entryentity");
        beginDate = null;
        for (DynamicObject entry : entrys) {
            Date date = entry.getDate("entrybegindate");
            if (beginDate != null && (date == null || beginDate.getTime() <= date.getTime())) continue;
            beginDate = date;
        }
        this.setValue("begindate", beginDate);
    }

    protected void calcEndDate(int index, Date oldDate) {
        Date endDate;
        DynamicObject orderEntry;
        if (index >= 0 && (orderEntry = this.getRowInfo("entryentity", index)) != null && orderEntry.getDate("entryenddate") != null) {
            endDate = orderEntry.getDate("entryenddate");
            if ((endDate = DateUtil.getDayFirst((Date)endDate)).getTime() < DateUtil.getDayFirst((Date)new Date()).getTime() && endDate.getTime() < System.currentTimeMillis()) {
                this.getView().showMessage(String.format(ResManager.loadKDString((String)"\u7b2c%s\u884c\u7ed3\u675f\u65e5\u671f\u5fc5\u987b\u5927\u4e8e\u5f53\u524d\u65e5\u671f.", (String)"MarketCostApplyEditFormPlugin_6", (String)"drp-mem-formplugin", (Object[])new Object[0]), index + 1));
                this.setValue("entryenddate", oldDate, index);
                return;
            }
            Date beginDate = orderEntry.getDate("entrybegindate");
            if (beginDate != null) {
                beginDate = DateUtil.getDayFirst((Date)beginDate);
                if (endDate.getTime() < beginDate.getTime()) {
                    this.getView().showMessage(String.format(ResManager.loadKDString((String)"\u7b2c%s\u884c\u7ed3\u675f\u65e5\u671f\u4e0d\u80fd\u5c0f\u4e8e\u5f00\u59cb\u65e5\u671f.", (String)"MarketCostApplyEditFormPlugin_7", (String)"drp-mem-formplugin", (Object[])new Object[0]), index + 1));
                    this.setValue("entryenddate", oldDate, index);
                    return;
                }
            }
        }
        DynamicObjectCollection entrys = this.getModel().getEntryEntity("entryentity");
        endDate = null;
        for (DynamicObject entry : entrys) {
            Date date = entry.getDate("entryenddate");
            if (endDate != null && (date == null || endDate.getTime() >= date.getTime())) continue;
            endDate = date;
        }
        this.setValue("enddate", endDate);
    }

    protected void calcAmount(int index) {
        DynamicObject orderEntry = this.getRowInfo("entryentity", index);
        if (orderEntry != null) {
            BigDecimal qty = orderEntry.getBigDecimal("qty");
            BigDecimal itemPrice = orderEntry.getBigDecimal("price");
            int amtprecision = 2;
            BigDecimal primAmount = BigDecimalUtil.multiplyObject((Object)itemPrice, (Object)qty, (int)amtprecision);
            this.setValue("amount", primAmount, index);
            this.setValue("amtunapproved", BigDecimalUtil.subtractObject((Object)primAmount, (Object)this.getValue("amtapproved", index)), index);
        }
        this.calcTotalAmount();
    }

    protected void calcTotalAmount() {
        DynamicObjectCollection entrys = this.getModel().getEntryEntity("entryentity");
        BigDecimal totalAmount = BigDecimal.ZERO;
        for (DynamicObject entry : entrys) {
            totalAmount = BigDecimalUtil.addObject((Object)totalAmount, (Object)entry.getBigDecimal("amount"));
        }
        this.setValue("totalamount", totalAmount);
        this.setValue("totalamtunapproved", BigDecimalUtil.subtractObject((Object)totalAmount, (Object)this.getValue("totalamtapproved")));
    }
}

