/*
 * Decompiled with CFR 0.152.
 */
package kd.drp.mem.formplugin.cost;

import java.math.BigDecimal;
import java.util.EventObject;
import java.util.HashSet;
import java.util.List;
import kd.bos.bill.OperationStatus;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.events.ChangeData;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.form.ShowType;
import kd.bos.form.control.events.ItemClickEvent;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.form.field.events.BeforeF7SelectListener;
import kd.bos.list.ListShowParameter;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.user.UserServiceHelper;
import kd.drp.mem.common.BigDecimalUtil;
import kd.drp.mem.common.MEMFilterUtil;
import kd.drp.mem.common.MEMUtil;
import kd.drp.mem.formplugin.cost.CostAppFormUtil;
import kd.drp.mem.formplugin.cost.CostFormPlugin;

public class MarketCostReimburseEditPlugin
extends CostFormPlugin
implements BeforeF7SelectListener {
    public static final Log logger = LogFactory.getLog(MarketCostReimburseEditPlugin.class);
    protected String TOOL_ENTRYS = "toolentrys";
    protected String TOOL_RECEIVABLE = "toolreceivable";
    protected String BTN_ADD_ENTRYS_ROW = "btnaddentrysrow";
    protected String BTN_DELETE_ENTRYS_ROW = "btnredeleteentrysrow";
    protected String BTN_ADD_RECEIVABLE_ROW = "btnaddreceivablerow";
    protected String BTN_DELETE_RECEIVABLE_ROW = "btndeletereceivablerow";
    protected String TOTAL_AMT_APPLY = "totalamtapply";
    protected String TOTAL_AMOUNT = "totalamount";
    protected String TOTAL_AMT_APPROVED = "totalamtapproved";
    protected String ENTRYS = "entrys";
    protected String AMT_APPLY = "amtapply";
    protected String AMT_APPROVED = "amtapproved";
    protected String AMT_UNAPPROVED = "amtunapproved";
    protected String TOTAL_AMT_INVOICE = "totalamtinvoice";
    protected String EXCLUDE_TAX_AMT = "excludetaxamt";
    protected String TAX_RATE = "taxrate";
    protected String OFFSET_BORROW = "offsetborrow";
    protected String BORROW = "borrow";
    protected String BRW_REASONS = "brwreasons";
    protected String BRW_CURRENCY = "brwcurrency";
    protected String BRW_RATE = "brwrate";
    protected String BRW_AMT = "brwamt";
    protected String BRW_AMT_LOCAL = "brwamtlocal";
    protected String OFFSET_AMT = "offsetamt";
    protected String OFFSET_AMT_LOCAL = "offsetamtlocal";
    protected String RECEIVABLE = "receivable";
    protected String PAYER = "payer";
    protected String PAYER_BANK = "payerbank";
    protected String PAYER_ACCOUNT = "payeraccount";
    protected String PAY_CURRENCY = "paycurrency";
    protected String PAY_RATE = "payrate";
    protected String RECEIVABLE_AMT = "receivableamt";
    protected String RECEIVABLE_AMT_LOCAL = "receivableamtlocal";

    @Override
    public void beforeF7Select(BeforeF7SelectEvent e) {
        String key;
        super.beforeF7Select(e);
        switch (key = e.getProperty().getName()) {
            case "payer": {
                DynamicObject customer = (DynamicObject)this.getModel().getValue("customer");
                if (customer == null) {
                    this.setF7CustomerFilter(e, "kingdee");
                    break;
                }
                this.setF7CustomerFilter(e, customer.getString("name"));
                break;
            }
        }
    }

    protected void setF7CustomerFilter(BeforeF7SelectEvent e, String cusomterName) {
        logger.info("cusomterName:" + cusomterName);
        if (EntityMetadataCache.getDataEntityType((String)"er_payeer").getAllFields().get("dept") != null && this.getModel().getValue("dept") != null) {
            logger.info("\u90e8\u95e8\u8fc7\u6ee4:" + this.getModel().getValue("dept"));
            QFilter filter = new QFilter("dept", "=", ((DynamicObject)this.getModel().getValue("dept")).getPkValue());
            logger.info("filter:" + filter);
            this.setF7Filter("payer", filter);
            if (e != null) {
                ((ListShowParameter)e.getFormShowParameter()).getListFilterParameter().setFilter(filter);
            }
        } else {
            QFilter filter = new QFilter("outpayer", "=", (Object)cusomterName);
            logger.info("cfilter:" + filter);
            DynamicObject[] customerCollection = BusinessDataServiceHelper.load((String)"er_payeer", (String)"outpayer", (QFilter[])filter.toArray());
            HashSet<Object> set = new HashSet<Object>(customerCollection.length);
            for (DynamicObject info : customerCollection) {
                set.add(info.get("outpayer"));
            }
            filter = new QFilter("outpayer", "in", set);
            this.setF7Filter("payer", filter);
            logger.info("cfilter:" + filter);
            if (e != null) {
                ((ListShowParameter)e.getFormShowParameter()).getListFilterParameter().setFilter(filter);
            }
        }
    }

    @Override
    public void afterDoOperation(AfterDoOperationEventArgs e) {
        List successPkIds;
        super.afterDoOperation(e);
        String operateKey = e.getOperateKey();
        if ("viewexecdetail".equals(operateKey) && (successPkIds = e.getOperationResult().getSuccessPkIds()) != null && successPkIds.size() > 0) {
            Object pk = successPkIds.get(0);
            DynamicObject marketCostReimburse = QueryServiceHelper.queryOne((String)"mem_market_cost_reimburse", (String)"id,sourcebillid", (QFilter[])MEMFilterUtil.getPKQFilter(pk));
            CostAppFormUtil.openCostExecuteDetailForm(this.getView(), marketCostReimburse.get("sourcebillid"), null, ShowType.MainNewTabPage);
        }
        if ("deleteoffset".equals(operateKey)) {
            // empty if block
        }
    }

    @Override
    protected String getEntryKey() {
        return this.ENTRYS;
    }

    @Override
    public void registerListener(EventObject eventobject) {
        super.registerListener(eventobject);
        this.addItemClickListeners(new String[]{this.TOOL_RECEIVABLE, this.TOOL_ENTRYS});
        this.addF7Listener(this, "payer");
    }

    public void itemClick(ItemClickEvent evt) {
        super.itemClick(evt);
        String eventKey = evt.getItemKey();
        if (this.BTN_DELETE_ENTRYS_ROW.equals(eventKey)) {
            this.btnDeleteEntrysRow_click((EventObject)evt);
        }
    }

    @Override
    protected String[] getEntryActionControl() {
        return new String[]{this.BTN_DELETE_ENTRYS_ROW};
    }

    protected void btnDeleteEntrysRow_click(EventObject evt) {
        this.calTotalAmount();
    }

    protected void loadOffsetBorrow() {
        if (this.getControl(this.OFFSET_BORROW) == null) {
            return;
        }
        long userId = UserServiceHelper.getCurrentUserId();
        QFilter filter = new QFilter("applier", "=", (Object)userId);
        StringBuilder selector = new StringBuilder();
        selector.append("id,");
        selector.append("number,");
        selector.append("bizdate,");
        selector.append("description,");
        selector.append("currency,currency.name,");
        selector.append("approveamount,");
        selector.append("loanamount,");
        selector.append("usedamount");
        DynamicObject[] documents = BusinessDataServiceHelper.load((String)"er_dailyloanbill", (String)selector.toString(), (QFilter[])new QFilter[]{filter});
        if (documents.length == 0) {
            return;
        }
        IDataModel model = this.getModel();
        model.beginInit();
        model.deleteEntryData(this.OFFSET_BORROW);
        model.getDataEntity(true);
        model.batchCreateNewEntryRow(this.OFFSET_BORROW, documents.length);
        for (int i = 0; i < documents.length; ++i) {
            DynamicObject dynamicObject = documents[i];
            model.setValue("applydate", dynamicObject.get("bizdate"), i);
            model.setValue("borrow", dynamicObject.getPkValue(), i);
            model.setValue("brwreasons", dynamicObject.get("description"), i);
            model.setValue("brwcurrency", dynamicObject.get("currency"), i);
            model.setValue("brwrate", (Object)1, i);
            model.setValue("brwamt", dynamicObject.get("approveamount"), i);
            model.setValue("brwamtlocal", dynamicObject.get("approveamount"), i);
            model.setValue("offsetamt", (Object)BigDecimalUtil.subtractObject((Object)dynamicObject.get("approveamount"), (Object)dynamicObject.get("usedamount")), i);
            model.setValue("offsetamtlocal", (Object)BigDecimalUtil.subtractObject((Object)dynamicObject.get("approveamount"), (Object)dynamicObject.get("usedamount")), i);
        }
        model.endInit();
        this.getView().updateView(this.OFFSET_BORROW);
    }

    @Override
    public void propertyChanged(PropertyChangedArgs e) {
        super.propertyChanged(e);
        String propertyName = e.getProperty().getName();
        ChangeData[] changeset = e.getChangeSet();
        String entityName = changeset[0].getDataEntity().getDataEntityType().getName();
        if (this.ENTRYS.equals(entityName)) {
            this.entrys_changed(e);
        }
        if (this.OFFSET_BORROW.equals(entityName)) {
            this.offsetborrow_changed(e);
        }
        if (this.EXCLUDE_TAX_AMT.equals(propertyName) || "taxamount".equals(propertyName)) {
            // empty if block
        }
        if (this.RECEIVABLE.equals(entityName)) {
            this.receivable_changed(e);
        }
        if ("iteminfo".equals(propertyName)) {
            this.setUnit(this.getRowIndex(e));
        }
    }

    private void setUnit(int index) {
        Object assistUnit;
        Object itemPK = this.getEntryF7PKValue("entry", "iteminfo", index);
        Object baseUnit = MEMUtil.queryMasteridBaseUnitId((Object)itemPK);
        if (baseUnit != null) {
            this.getModel().setValue("baseunit", baseUnit, index);
        }
        if ((assistUnit = MEMUtil.queryMasteridAssistUnitId((Object)itemPK)) != null) {
            this.getModel().setValue("assistunit", assistUnit, index);
        }
    }

    protected void offsetborrow_changed(PropertyChangedArgs e) {
        int rowIndex = e.getChangeSet()[0].getRowIndex();
        DynamicObject row = this.getModel().getEntryRowEntity(this.RECEIVABLE, rowIndex);
        if (row.getBigDecimal("offsetamt").compareTo(BigDecimal.ZERO) != 0) {
            row.set("offsetamtlocal", (Object)row.getBigDecimal("offsetamt"));
        }
    }

    protected void entrys_changed(PropertyChangedArgs e) {
        DynamicObject row;
        String propertyName = e.getProperty().getName();
        ChangeData[] changeset = e.getChangeSet();
        int rowIndex = changeset[0].getRowIndex();
        if ("amount".equals(propertyName) || this.AMT_APPLY.equals(propertyName)) {
            row = this.getModel().getEntryRowEntity(this.ENTRYS, rowIndex);
            BigDecimal amtApply = row.get(this.AMT_APPLY) == null ? BigDecimal.ZERO : (BigDecimal)row.get(this.AMT_APPLY);
            BigDecimal amount = row.get("amount") == null ? BigDecimal.ZERO : (BigDecimal)row.get("amount");
            row.set(this.AMT_APPROVED, (Object)amount);
            row.set(this.AMT_UNAPPROVED, (Object)amount.subtract(amount));
            this.calTotalAmount();
            this.getView().updateView(this.ENTRYS);
        }
        if (this.AMT_APPROVED.equals(propertyName) || this.AMT_APPLY.equals(propertyName)) {
            row = this.getModel().getEntryRowEntity(this.ENTRYS, rowIndex);
            BigDecimal amount = row.get("amount") == null ? BigDecimal.ZERO : (BigDecimal)row.get("amount");
            BigDecimal amtApproved = row.get(this.AMT_APPROVED) == null ? BigDecimal.ZERO : (BigDecimal)row.get(this.AMT_APPROVED);
            row.set(this.AMT_UNAPPROVED, (Object)amount.subtract(amtApproved));
            this.calTotalAmount();
            this.getView().updateView(this.ENTRYS);
        }
        if (this.AMT_UNAPPROVED.equals(propertyName)) {
            this.calTotalAmount();
        }
    }

    protected void calTotalAmount() {
        int rowCount = this.getModel().getEntryRowCount(this.ENTRYS);
        BigDecimal amtApplySum = BigDecimal.ZERO;
        BigDecimal amountSum = BigDecimal.ZERO;
        BigDecimal amtApprovedSum = BigDecimal.ZERO;
        BigDecimal amtUnApprovedSum = BigDecimal.ZERO;
        for (int rowIndex = 0; rowIndex < rowCount; ++rowIndex) {
            DynamicObject row = this.getModel().getEntryRowEntity(this.ENTRYS, rowIndex);
            BigDecimal amtApply = this.getModel().getValue(this.AMT_APPLY, rowIndex) == null ? BigDecimal.ZERO : (BigDecimal)this.getModel().getValue(this.AMT_APPLY, rowIndex);
            BigDecimal amount = this.getModel().getValue("amount", rowIndex) == null ? BigDecimal.ZERO : (BigDecimal)this.getModel().getValue("amount", rowIndex);
            BigDecimal amtApproved = this.getModel().getValue(this.AMT_APPROVED, rowIndex) == null ? BigDecimal.ZERO : (BigDecimal)this.getModel().getValue(this.AMT_APPROVED, rowIndex);
            BigDecimal amtUnApproved = this.getModel().getValue(this.AMT_UNAPPROVED, rowIndex) == null ? BigDecimal.ZERO : (BigDecimal)this.getModel().getValue(this.AMT_UNAPPROVED, rowIndex);
            amtApplySum = amtApplySum.add(amtApply);
            amountSum = amountSum.add(amount);
            amtApprovedSum = amtApprovedSum.add(amtApproved);
            amtUnApprovedSum = amtUnApprovedSum.add(amtUnApproved);
        }
        this.getModel().setValue(this.TOTAL_AMT_APPLY, (Object)amtApplySum);
        this.getModel().setValue(this.TOTAL_AMOUNT, (Object)amountSum);
        this.getModel().setValue(this.TOTAL_AMT_APPROVED, (Object)amtApprovedSum);
    }

    protected void receivable_changed(PropertyChangedArgs e) {
        String propertyName = e.getProperty().getName();
        ChangeData[] changeset = e.getChangeSet();
        int rowIndex = changeset[0].getRowIndex();
        DynamicObject row = this.getModel().getEntryRowEntity(this.RECEIVABLE, rowIndex);
        if (this.PAYER.equals(propertyName)) {
            DynamicObject payer = row.getDynamicObject(this.PAYER);
            if (payer != null) {
                StringBuilder selector = new StringBuilder();
                selector.append("id,");
                selector.append("payer,");
                selector.append("payer.id,");
                selector.append("payer.number,");
                selector.append("payer.name,");
                selector.append("outpayer,");
                selector.append("payerbank,");
                selector.append("payerbank.id,");
                selector.append("payerbank.number,");
                selector.append("payerbank.name,");
                selector.append("payeraccount");
                DynamicObject document = BusinessDataServiceHelper.loadSingle((Object)payer.getPkValue(), (String)payer.getDataEntityType().getName(), (String)selector.toString());
                if (document != null) {
                    row.set(this.PAYER_BANK, (Object)document.getDynamicObject("payerbank"));
                    row.set(this.PAYER_ACCOUNT, document.get("payeraccount"));
                    row.set(this.RECEIVABLE_AMT, this.getModel().getValue(this.TOTAL_AMT_APPROVED));
                    this.calReceivableAmtLocal(row);
                }
            } else {
                row.set(this.PAYER_BANK, null);
                row.set(this.PAYER_ACCOUNT, null);
            }
            this.getView().updateView(this.RECEIVABLE);
        }
        if (this.PAY_RATE.equals(propertyName) || this.RECEIVABLE_AMT.equals(propertyName)) {
            this.calReceivableAmtLocal(row);
            this.getView().updateView(this.RECEIVABLE);
        }
    }

    private void calReceivableAmtLocal(DynamicObject row) {
        row.set(this.RECEIVABLE_AMT_LOCAL, (Object)BigDecimalUtil.multiplyObject((Object)row.get(this.PAY_RATE), (Object)row.get(this.RECEIVABLE_AMT), (int)10));
    }

    protected void invoiceInfo_changed(PropertyChangedArgs e) {
        IDataModel dataModel = this.getModel();
        dataModel.setValue(this.TOTAL_AMT_INVOICE, (Object)BigDecimalUtil.addObject((Object)dataModel.getValue(this.EXCLUDE_TAX_AMT), (Object)dataModel.getValue("taxamount")));
    }

    @Override
    public void afterBindData(EventObject e) {
        super.afterBindData(e);
        if (this.getView().getFormShowParameter().getStatus().equals((Object)OperationStatus.ADDNEW)) {
            // empty if block
        }
    }

    @Override
    public void beforeBindData(EventObject e) {
        super.beforeBindData(e);
    }
}

