/*
 * Decompiled with CFR 0.152.
 */
package kd.drp.mem.formplugin.cost;

import java.util.Date;
import java.util.EventObject;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.events.ChangeData;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.form.FormShowParameter;
import kd.bos.form.ShowType;
import kd.bos.form.control.EntryGrid;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.field.FieldEdit;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.form.field.events.BeforeF7SelectListener;
import kd.bos.list.ListShowParameter;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.drp.mem.formplugin.basedata.MEMFormPlugin;

public class ShopBatchChangeEditFormPlugin
extends MEMFormPlugin
implements BeforeF7SelectListener {
    protected static final String CHANNEL = "channel";
    protected static final String ENTRYENTITY = "entryentity";
    protected static final String AFTERCHANGECHANNEL = "afterchangechannel";
    public static final String LASTSAVECHANNEL = "lastsavechannel";
    public static final String CREATER = "creater";
    public static final String SOURCESHOPID = "sourceshopid";

    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.addF7Listener(this, AFTERCHANGECHANNEL);
    }

    public void beforeF7Select(BeforeF7SelectEvent e) {
        String key;
        switch (key = e.getProperty().getName()) {
            case "afterchangechannel": {
                this.setChannelFilter(e);
            }
        }
    }

    protected void setChannelFilter(BeforeF7SelectEvent e) {
        HashSet<Object> innerorgs = new HashSet<Object>();
        QFilter filter = new QFilter("isinnerorg", "=", (Object)Boolean.FALSE);
        DynamicObjectCollection innerorgCustomerCollection = QueryServiceHelper.query((String)"mdr_customer", (String)"id", (QFilter[])filter.toArray());
        for (DynamicObject innerorgCustomer : innerorgCustomerCollection) {
            innerorgs.add(innerorgCustomer.get("id"));
        }
        filter = new QFilter("id", "in", innerorgs);
        this.setF7Filter(AFTERCHANGECHANNEL, filter);
        if (e != null) {
            ((ListShowParameter)e.getFormShowParameter()).getListFilterParameter().setFilter(filter);
        }
    }

    public void afterCreateNewData(EventObject e) {
        super.afterCreateNewData(e);
        Map customParams = this.getView().getFormShowParameter().getCustomParams();
        List shopPkCollection = (List)customParams.get("shop_pk_collection");
        if (shopPkCollection == null) {
            return;
        }
        IDataModel model = this.getModel();
        model.beginInit();
        model.deleteEntryData(ENTRYENTITY);
        DynamicObject[] shopInfos = BusinessDataServiceHelper.load((Object[])shopPkCollection.toArray(), (DynamicObjectType)EntityMetadataCache.getDataEntityType((String)"mem_shopmanage"));
        for (int i = 0; i < shopInfos.length; ++i) {
            int rowIndex = model.createNewEntryRow(ENTRYENTITY);
            DynamicObject shopInfo = shopInfos[i];
            this.setEntryFiledValue(shopInfo, rowIndex);
        }
    }

    protected void setEntryFiledValue(DynamicObject shopInfo, int rowIndex) {
        EntryGrid entryGrid = (EntryGrid)this.getControl(ENTRYENTITY);
        List fields = entryGrid.getFieldEdits();
        for (int i = 0; i < fields.size(); ++i) {
            FieldEdit fieldEdit = (FieldEdit)fields.get(i);
            String fieldname = fieldEdit.getFieldKey();
            if (LASTSAVECHANNEL.equals(fieldname)) continue;
            if (SOURCESHOPID.equals(fieldname)) {
                this.getModel().setValue(fieldname, shopInfo.getPkValue(), rowIndex);
                continue;
            }
            this.getModel().setValue(fieldname, shopInfo.get(fieldname), rowIndex);
        }
    }

    public void afterDoOperation(AfterDoOperationEventArgs e) {
        super.afterDoOperation(e);
        String key = e.getOperateKey();
        key.getClass();
    }

    public void propertyChanged(PropertyChangedArgs e) {
        String propertyName;
        super.propertyChanged(e);
        switch (propertyName = e.getProperty().getName()) {
            case "afterchangechannel": {
                ChangeData[] changeset = e.getChangeSet();
                if (changeset.length <= 0) break;
                Object newchannel = changeset[0].getNewValue();
                this.saveChannel(newchannel);
            }
        }
    }

    private void saveChannel(Object newchannel) {
        DynamicObjectCollection entry = this.getModel().getEntryEntity(ENTRYENTITY);
        for (int i = 0; i < entry.size(); ++i) {
            this.getModel().setValue(CHANNEL, newchannel, i);
        }
        this.getView().showSuccessNotification(ResManager.loadKDString((String)"\u6e20\u9053\u53d8\u66f4\u6210\u529f", (String)"ShopBatchChangeEditFormPlugin_1", (String)"drp-mem-formplugin", (Object[])new Object[0]));
    }

    protected void setLastSaveChannel(AfterDoOperationEventArgs e) {
        DynamicObjectCollection entry = this.getModel().getEntryEntity(ENTRYENTITY);
        for (int i = 0; i < entry.size(); ++i) {
            if ("save".equals(e.getOperateKey())) {
                this.getModel().setValue(LASTSAVECHANNEL, ((DynamicObject)entry.get(i)).get(CHANNEL), i);
                this.getView().showSuccessNotification(ResManager.loadKDString((String)"\u6570\u636e\u4fdd\u5b58\u6210\u529f", (String)"ShopBatchChangeEditFormPlugin_2", (String)"drp-mem-formplugin", (Object[])new Object[0]));
            }
            if (!"returndata".equals(e.getOperateKey())) continue;
            this.getModel().setValue(CHANNEL, ((DynamicObject)entry.get(i)).get(LASTSAVECHANNEL), i);
            this.getView().showSuccessNotification(ResManager.loadKDString((String)"\u6570\u636e\u8fd4\u56de\u6210\u529f", (String)"ShopBatchChangeEditFormPlugin_3", (String)"drp-mem-formplugin", (Object[])new Object[0]));
        }
    }

    protected void setAfterChangeChannel(AfterDoOperationEventArgs e) {
        Object propertychange = this.getModel().getValue(AFTERCHANGECHANNEL);
        if (propertychange != null) {
            EntryGrid entryGrid = (EntryGrid)this.getControl(ENTRYENTITY);
            int entrycount = entryGrid.getModel().getEntryRowCount(ENTRYENTITY);
            for (int i = 0; i < entrycount; ++i) {
                this.getModel().setValue(CHANNEL, propertychange, i);
            }
        } else {
            this.getView().showErrorNotification(ResManager.loadKDString((String)"\u53d8\u66f4\u540e\u6240\u5c5e\u6e20\u9053\u5b57\u6bb5\u4e0d\u80fd\u4e3a\u7a7a!", (String)"ShopBatchChangeEditFormPlugin_4", (String)"drp-mem-formplugin", (Object[])new Object[0]));
        }
    }

    protected void openChangeRecordForm(AfterDoOperationEventArgs e) {
        Map customParams = this.getView().getFormShowParameter().getCustomParams();
        Object shopPkCollection = customParams.get("shop_pk_collection");
        Object afterchangechannel = this.getModel().getValue(AFTERCHANGECHANNEL);
        Date failuretime = new Date();
        Object creater = this.getModel().getValue(CREATER);
        FormShowParameter param = new FormShowParameter();
        param.getOpenStyle().setShowType(ShowType.MainNewTabPage);
        param.setFormId("mem_shopchangerecord");
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("shop_pk_collection", shopPkCollection);
        params.put("afeter_change_channel", afterchangechannel);
        params.put("failuretime", failuretime);
        params.put("modifier", creater);
        param.setCustomParams(params);
        this.getView().showForm(param);
    }
}

