/*
 * Decompiled with CFR 0.152.
 */
package kd.drp.mem.formplugin.cost;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.mvc.list.ListDataProvider;
import kd.drp.mem.common.DistanceAndLocationUtil;
import kd.drp.mem.formplugin.model.CostExeAndDistenceModel;
import org.apache.commons.lang.StringUtils;

public class ShopDistanceDataProvider
extends ListDataProvider {
    public static final Log logger = LogFactory.getLog(ShopDistanceDataProvider.class);
    private String currentLon;
    private String currentLat;

    public ShopDistanceDataProvider(String currentLon, String currentLat) {
        this.currentLat = currentLat;
        this.currentLon = currentLon;
    }

    public DynamicObjectCollection getData(int start, int limit) {
        DynamicObjectCollection collection = super.getData(start, limit);
        DynamicObjectCollection copyCollection = new DynamicObjectCollection(collection.getDynamicObjectType(), null);
        List<CostExeAndDistenceModel> list = this.orderDatas(collection);
        for (int i = 0; i < list.size(); ++i) {
            CostExeAndDistenceModel obj = list.get(i);
            DynamicObject shop = obj.getCostExeObj();
            copyCollection.add((Object)shop);
        }
        return copyCollection;
    }

    private List<CostExeAndDistenceModel> orderDatas(DynamicObjectCollection datas) {
        ArrayList<CostExeAndDistenceModel> list = new ArrayList<CostExeAndDistenceModel>();
        if (datas.size() > 0) {
            String dis = "";
            logger.info("currentLat:" + this.currentLat + ",currentLon\uff1a" + this.currentLon);
            for (DynamicObject data : datas) {
                CostExeAndDistenceModel model = new CostExeAndDistenceModel();
                String shopLon = data.getBigDecimal("longitude").toString();
                String shopLat = data.getBigDecimal("latitude").toString();
                dis = DistanceAndLocationUtil.getDistance((String)this.currentLon, (String)this.currentLat, (String)shopLon, (String)shopLat);
                data.set("area", (Object)dis);
                logger.info("dis:" + dis);
                model.setCostExeId(data.getPkValue().toString());
                model.setDistence(dis);
                model.setCostExeObj(data);
                model.setDis(StringUtils.isBlank((String)dis) ? BigDecimal.ZERO : new BigDecimal(dis.replace("km", "")));
                list.add(model);
            }
        }
        list.sort(new Comparator<CostExeAndDistenceModel>(){

            @Override
            public int compare(CostExeAndDistenceModel o1, CostExeAndDistenceModel o2) {
                return o1.getDis().compareTo(o2.getDis());
            }
        });
        return list;
    }
}

