/*
 * Decompiled with CFR 0.152.
 */
package kd.drp.mem.formplugin.cost;

import java.util.ArrayList;
import java.util.EventObject;
import java.util.HashMap;
import java.util.List;
import kd.bos.bill.MobileBillShowParameter;
import kd.bos.bill.OperationStatus;
import kd.bos.bill.events.LocateEvent;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.datamodel.ListSelectedRow;
import kd.bos.entity.filter.FilterParameter;
import kd.bos.entity.list.IListDataProvider;
import kd.bos.exception.KDBizException;
import kd.bos.form.CloseCallBack;
import kd.bos.form.ConfirmCallBackListener;
import kd.bos.form.FormShowParameter;
import kd.bos.form.MessageBoxOptions;
import kd.bos.form.MessageBoxResult;
import kd.bos.form.MobileFormShowParameter;
import kd.bos.form.ShowType;
import kd.bos.form.control.Control;
import kd.bos.form.control.events.MobileSearchTextChangeEvent;
import kd.bos.form.control.events.MobileSearchTextChangeListener;
import kd.bos.form.events.BeforeCreateListDataProviderArgs;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.events.MessageBoxClosedEvent;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.list.BillList;
import kd.bos.list.MobileSearch;
import kd.bos.list.events.CreateListDataProviderListener;
import kd.bos.list.events.ListRowClickEvent;
import kd.bos.list.events.ListRowClickListener;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.mvc.bill.MobileBillView;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.drp.mem.formplugin.basedata.MEMBillFormMobPlugin;
import kd.drp.mem.formplugin.cost.ShopDistanceDataProvider;

public class ShopManListMobPlugin
extends MEMBillFormMobPlugin
implements MobileSearchTextChangeListener,
ListRowClickListener {
    protected static final String BILLLLISTAP = "billlistap";
    protected static final String MTOOLBARAP = "mtoolbarap";
    protected static final String SEARCH = "search";
    protected static final String BTNADDSHOP = "btnaddshop";
    public static final Log logger = LogFactory.getLog(ShopManListMobPlugin.class);

    protected void setToolVisibel() {
        BillList itemlist = (BillList)this.getControl(BILLLLISTAP);
        if (itemlist.getListModel().getDataCount() == 0 && itemlist.getListModel().getQueryResult().getCollection().size() == 0) {
            this.getView().setVisible(Boolean.FALSE, new String[]{"flexpanelap"});
            this.getView().setVisible(Boolean.TRUE, new String[]{"flexpanelap1"});
        } else {
            this.getView().setVisible(Boolean.TRUE, new String[]{"flexpanelap"});
            this.getView().setVisible(Boolean.FALSE, new String[]{"flexpanelap1"});
        }
    }

    public void beforeBindData(EventObject e) {
        super.beforeBindData(e);
        ((MobileBillView)this.getView()).locate();
    }

    public void locate(LocateEvent e) {
        super.locate(e);
        logger.info("locate start ------");
        if (e.getMobLocation() != null) {
            logger.info("locate CityId = " + e.getMobLocation().getCityId());
            logger.info("locate Latitude = " + e.getMobLocation().getLatitude());
            logger.info("locate Longitude = " + e.getMobLocation().getLongitude());
            logger.info("locate District = " + e.getMobLocation().getDistrict());
            Float latitude = Float.valueOf(e.getMobLocation().getLatitude());
            Float longitude = Float.valueOf(e.getMobLocation().getLongitude());
            String cityId = e.getMobLocation().getCityId();
            this.loadEntry(longitude, latitude, cityId);
        } else {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u672a\u83b7\u53d6\u5230\u624b\u673a\u5b9a\u4f4d\u4fe1\u606f\uff01", (String)"ShopManListMobPlugin_0", (String)"drp-mem-formplugin", (Object[])new Object[0]), Integer.valueOf(3000));
            logger.info("do not get MobLocation ------");
        }
    }

    protected void loadEntry(final Object longitude, final Object latitude, String cityId) {
        String context;
        BillList itemlist = (BillList)this.getControl(BILLLLISTAP);
        ArrayList<QFilter> filterList = new ArrayList<QFilter>();
        List<QFilter> defaultFilters = this.getDefaultFilters(cityId);
        if (defaultFilters != null && defaultFilters.size() != 0) {
            filterList.addAll(defaultFilters);
        }
        if ((context = this.getPageCache().get("searchTxt")) != null && !context.trim().equals("")) {
            String txt = "%" + context + "%";
            QFilter f = new QFilter("name", "like", (Object)txt);
            f.or("number", "like", (Object)txt);
            filterList.add(f);
        }
        FilterParameter filterParameter = new FilterParameter();
        filterParameter.setQFilters(filterList);
        itemlist.addCreateListDataProviderListener(new CreateListDataProviderListener(){

            public void createListDataProvider(BeforeCreateListDataProviderArgs arg0) {
                arg0.setListDataProvider((IListDataProvider)new ShopDistanceDataProvider(longitude.toString(), latitude.toString()));
            }
        });
        itemlist.setQueryFilterParameter(filterParameter);
        itemlist.refresh();
        this.setToolVisibel();
    }

    protected List<QFilter> getDefaultFilters(String cityId) {
        ArrayList<QFilter> filterList = new ArrayList<QFilter>();
        Object customerId = this.getView().getFormShowParameter().getCustomParam("customerId");
        if (customerId != null) {
            filterList.add(new QFilter("channel.id", "=", customerId));
        }
        return filterList;
    }

    public void registerListener(EventObject e) {
        this.addClickListeners(new String[]{BTNADDSHOP});
        BillList itemList = (BillList)this.getView().getControl(BILLLLISTAP);
        itemList.addListRowClickListener((ListRowClickListener)this);
        MobileSearch serach = (MobileSearch)this.getView().getControl(SEARCH);
        serach.addMobileSearchTextChangeListener((MobileSearchTextChangeListener)this);
    }

    public void click(MobileSearchTextChangeEvent e) {
        String context = e.getText();
        this.getPageCache().put("searchTxt", context.toString());
        ((MobileBillView)this.getView()).locate();
    }

    public void click(EventObject evt) {
        String key;
        super.click(evt);
        Control control = (Control)evt.getSource();
        switch (key = control.getKey()) {
            case "btnaddshop": {
                this.openAddShopPage();
                break;
            }
        }
    }

    protected void openAddShopPage() {
        Object customerId = this.getView().getFormShowParameter().getCustomParam("customerId");
        Object entryId = this.getView().getFormShowParameter().getCustomParam("entryId");
        HashMap<String, Object> customParam = new HashMap<String, Object>();
        customParam.put("customerId", customerId);
        customParam.put("entryId", entryId);
        MobileFormShowParameter mobparameter = new MobileFormShowParameter();
        mobparameter.setCustomParams(customParam);
        mobparameter.setStatus(OperationStatus.ADDNEW);
        mobparameter.getOpenStyle().setShowType(ShowType.Floating);
        mobparameter.setFormId("mem_shopmanageeditmob");
        mobparameter.setCloseCallBack(new CloseCallBack((IFormPlugin)this, "closeNewShop"));
        this.getView().showForm((FormShowParameter)mobparameter);
    }

    public void closedCallBack(ClosedCallBackEvent e) {
        if ("closeNewShop".equals(e.getActionId())) {
            ((MobileBillView)this.getView()).locate();
        }
    }

    public void listRowClick(ListRowClickEvent e) {
        BillList list = (BillList)this.getView().getControl(BILLLLISTAP);
        ListSelectedRow row = list.getCurrentSelectedRowInfo();
        String pkName = list.getEntityType().getPrimaryKey().getName();
        String entityName = list.getEntryEntity();
        if (row != null) {
            Object pk = row.getPrimaryKeyValue();
            QFilter filters = new QFilter(pkName, "=", pk);
            DynamicObject shopInfo = QueryServiceHelper.queryOne((String)entityName, (String)(pkName + ",name"), (QFilter[])filters.toArray());
            ConfirmCallBackListener callBack = new ConfirmCallBackListener("selectData");
            this.getView().showConfirm(String.format(ResManager.loadKDString((String)"\u786e\u8ba4\u9009\u62e9\u95e8\u5e97[%s]\u5417\uff1f", (String)"ShopManListMobPlugin_1", (String)"drp-mem-formplugin", (Object[])new Object[0]), shopInfo.getString("name")), MessageBoxOptions.YesNo, callBack);
        }
    }

    public void confirmCallBack(MessageBoxClosedEvent ms) {
        if ("selectData".equals(ms.getCallBackId())) {
            if (ms.getResult().equals((Object)MessageBoxResult.Yes)) {
                this.saveShop();
                this.openCostExecuteEdit();
            } else {
                return;
            }
        }
    }

    private void saveShop() {
        Object shopId = this.getShopId();
        Object entryId = this.getView().getFormShowParameter().getCustomParam("entryId");
        if (entryId != null) {
            DynamicObject entry = BusinessDataServiceHelper.loadSingle((Object)entryId, (String)"mem_market_costapplyentry");
            if (entry.get("shop") != null) {
                throw new KDBizException(ResManager.loadKDString((String)"\u5206\u5f55\u5df2\u6307\u5b9a\u95e8\u5e97\uff0c\u4e0d\u80fd\u91cd\u590d\u6307\u5b9a\uff01", (String)"ShopManListMobPlugin_2", (String)"drp-mem-formplugin", (Object[])new Object[0]));
            }
            entry.set("shop", shopId);
            SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{entry});
            this.getView().showSuccessNotification(ResManager.loadKDString((String)"\u95e8\u5e97\u6307\u5b9a\u6210\u529f\uff01", (String)"ShopManListMobPlugin_3", (String)"drp-mem-formplugin", (Object[])new Object[0]));
        }
    }

    private void openCostExecuteEdit() {
        Object entryId = this.getView().getFormShowParameter().getCustomParam("entryId");
        if (entryId == null) {
            return;
        }
        MobileBillShowParameter param = new MobileBillShowParameter();
        param.setStatus(OperationStatus.VIEW);
        param.setCustomParam("applyEntryId", entryId);
        param.setStatus(OperationStatus.ADDNEW);
        param.getOpenStyle().setShowType(ShowType.Floating);
        param.setFormId("mem_costexecute_editmob");
        this.getView().showForm((FormShowParameter)param);
    }

    private Object getShopId() {
        BillList list = (BillList)this.getView().getControl(BILLLLISTAP);
        ListSelectedRow row = list.getCurrentSelectedRowInfo();
        Object pk = row.getPrimaryKeyValue();
        return pk;
    }

    protected void selectData() {
        this.getView().returnDataToParent(this.getShopId());
        this.getView().close();
    }
}

