/*
 * Decompiled with CFR 0.152.
 */
package kd.drp.mem.formplugin.cost;

import java.util.EventObject;
import kd.bos.bill.MobileBillShowParameter;
import kd.bos.bill.OperationStatus;
import kd.bos.bill.events.LocateEvent;
import kd.bos.coderule.api.CodeRuleInfo;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.exception.KDBizException;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IMobileView;
import kd.bos.form.ShowType;
import kd.bos.form.control.Button;
import kd.bos.form.control.Control;
import kd.bos.form.control.events.ItemClickEvent;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.form.field.events.BeforeF7SelectListener;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.CodeRuleServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.drp.mem.common.MEMFilterUtil;
import kd.drp.mem.formplugin.basedata.MEMBillFormMobPlugin;

public class ShopManageEditMobPlugin
extends MEMBillFormMobPlugin
implements BeforeF7SelectListener {
    private static String CHANNEL = "channel";
    private static String CHANNELGROUP = "channelgroup";
    private static String REGION = "region";
    private static String SHOPREGION = "shopregion";
    public static final Log logger = LogFactory.getLog(ShopManageEditMobPlugin.class);

    public void afterDoOperation(AfterDoOperationEventArgs e) {
        super.afterDoOperation(e);
        if (e.getOperateKey().equals("save") && e.getOperationResult().isSuccess()) {
            this.saveShop(this.getModel().getValue("id"));
            this.openCostExecuteEdit();
        }
    }

    private void saveShop(Object shopId) {
        Object entryId = this.getView().getFormShowParameter().getCustomParam("entryId");
        if (entryId != null) {
            DynamicObject entry = BusinessDataServiceHelper.loadSingle((Object)entryId, (String)"mem_market_costapplyentry");
            if (entry.get("shop") != null) {
                throw new KDBizException(ResManager.loadKDString((String)"\u5206\u5f55\u5df2\u6307\u5b9a\u95e8\u5e97\uff0c\u4e0d\u80fd\u91cd\u590d\u6307\u5b9a\uff01", (String)"ShopManageEditMobPlugin_0", (String)"drp-mem-formplugin", (Object[])new Object[0]));
            }
            entry.set("shop", shopId);
            SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{entry});
            this.getView().showSuccessNotification(ResManager.loadKDString((String)"\u95e8\u5e97\u6307\u5b9a\u6210\u529f\uff01", (String)"ShopManageEditMobPlugin_1", (String)"drp-mem-formplugin", (Object[])new Object[0]));
        }
    }

    private void openCostExecuteEdit() {
        Object entryId = this.getView().getFormShowParameter().getCustomParam("entryId");
        if (entryId != null) {
            MobileBillShowParameter param = new MobileBillShowParameter();
            param.setStatus(OperationStatus.VIEW);
            param.setCustomParam("applyEntryId", entryId);
            param.setStatus(OperationStatus.ADDNEW);
            param.getOpenStyle().setShowType(ShowType.Floating);
            param.setFormId("mem_costexecute_editmob");
            this.getView().showForm((FormShowParameter)param);
        }
    }

    public void beforeBindData(EventObject eventobject) {
        super.beforeBindData(eventobject);
        this.getModel().setValue("channel", this.getView().getFormShowParameter().getCustomParam("customerId"));
        this.hiddenFlexpanelap("flexpanelap");
    }

    private String getShopNumber() {
        DynamicObject obj = BusinessDataServiceHelper.newDynamicObject((String)"mem_shopmanage");
        Object customerId = this.getView().getFormShowParameter().getCustomParam("customerId");
        if (customerId == null) {
            throw new KDBizException(ResManager.loadKDString((String)"\u672a\u4f20\u5165\u6e20\u9053\u53c2\u6570...", (String)"ShopManageEditMobPlugin_2", (String)"drp-mem-formplugin", (Object[])new Object[0]));
        }
        DynamicObject channel = BusinessDataServiceHelper.loadSingle((Object)customerId, (String)"mdr_customer");
        obj.set("channel", (Object)channel);
        CodeRuleInfo codeRuleInfo = CodeRuleServiceHelper.getCodeRule((String)obj.getDataEntityType().getName(), (DynamicObject)obj, null);
        if (codeRuleInfo == null) {
            // empty if block
        }
        return CodeRuleServiceHelper.getNumber((CodeRuleInfo)codeRuleInfo, (DynamicObject)obj);
    }

    private void setLocation() {
        ((IMobileView)this.getView()).locate();
    }

    public void locate(LocateEvent e) {
        super.locate(e);
        logger.info("locate in -------");
        if (e.getMobLocation() != null) {
            Float lon = Float.valueOf(e.getMobLocation().getLongitude());
            Float lat = Float.valueOf(e.getMobLocation().getLatitude());
            this.getModel().setValue("longitude", (Object)Double.valueOf(lon.toString()));
            this.getModel().setValue("latitude", (Object)Double.valueOf(lat.toString()));
            this.getModel().setValue("address", (Object)e.getMobLocation().getAddressdetail());
        } else {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u672a\u83b7\u53d6\u5230\u624b\u673a\u5b9a\u4f4d\u4fe1\u606f\uff01", (String)"ShopManageEditMobPlugin_3", (String)"drp-mem-formplugin", (Object[])new Object[0]), Integer.valueOf(3000));
        }
    }

    private void hiddenFlexpanelap(String key) {
        Control control = this.getView().getControl(key);
        control.getView().setVisible(Boolean.FALSE, new String[]{key});
    }

    public void registerListener(EventObject eventobject) {
        super.registerListener(eventobject);
        this.addClickListeners(new String[]{"buttonap"});
    }

    public void click(EventObject evt) {
        super.click(evt);
        Object key = evt.getSource();
        if (key instanceof Button) {
            logger.info("click in -------");
            this.setLocation();
        }
    }

    public void propertyChanged(PropertyChangedArgs e) {
        super.propertyChanged(e);
        String propertyName = e.getProperty().getName();
        IDataModel dataModel = this.getModel();
        if (CHANNEL.equals(propertyName)) {
            this.channel_changeed(dataModel);
        }
        if ("shoptype".equals(propertyName)) {
            this.shoptype_changeed(dataModel);
        }
        if (SHOPREGION.equals(propertyName)) {
            Object cityname = this.SetAreacodeText(e.getChangeSet()[0].getNewValue().toString());
            this.getModel().setValue("citynumber", cityname);
        }
    }

    private Object SetAreacodeText(String id) {
        QFilter qfliter = new QFilter("id", "=", (Object)id);
        DynamicObject admindivision = BusinessDataServiceHelper.loadSingle((String)"bd_admindivision", (String)"parent,citynumber,parent.id,parent.number,number,iscity", (QFilter[])qfliter.toArray());
        while (admindivision != null) {
            if (admindivision.getBoolean("iscity")) {
                return admindivision.getString("citynumber");
            }
            if ((admindivision = admindivision.getDynamicObject("parent")) == null) continue;
            admindivision = BusinessDataServiceHelper.loadSingle((String)"bd_admindivision", (String)"parent,citynumber,parent.id,parent.number,number,iscity", (QFilter[])MEMFilterUtil.getPKQFilter((Object)admindivision.getPkValue()));
        }
        return null;
    }

    protected void shoptype_changeed(IDataModel dataModel) {
        DynamicObject channelInfo = (DynamicObject)dataModel.getValue("shoptype");
        if (channelInfo != null) {
            this.getModel().setValue("area", (Object)channelInfo.getString("arearange"));
            QFilter filter = new QFilter("id", "=", channelInfo.getPkValue());
            StringBuilder selector = new StringBuilder();
            selector.append("id,");
            selector.append("number,");
            selector.append("name,");
            selector.append("channeltype,");
            selector.append("channeltype.id,");
            selector.append("channeltype.number,");
            selector.append("channeltype.name");
            DynamicObject[] documents = BusinessDataServiceHelper.load((String)channelInfo.getDataEntityType().getName(), (String)selector.toString(), (QFilter[])new QFilter[]{filter});
            if (documents != null && documents.length != 0) {
                DynamicObject info = documents[0];
                DynamicObject channeltype = (DynamicObject)info.get("channeltype");
                this.getModel().setValue("channeltype", (Object)channeltype);
            }
        }
    }

    protected void channel_changeed(IDataModel dataModel) {
        DynamicObject channelInfo = (DynamicObject)dataModel.getValue(CHANNEL);
        if (channelInfo != null) {
            QFilter filter = new QFilter("id", "=", channelInfo.getPkValue());
            StringBuilder selector = new StringBuilder();
            selector.append("id,");
            selector.append("number,");
            selector.append("name,");
            selector.append("customergroup,");
            selector.append("customergroup.id,");
            selector.append("customergroup.number,");
            selector.append("customergroup.name,");
            selector.append("region,");
            selector.append("region.id");
            selector.append("region.number");
            selector.append("region.name");
            DynamicObject[] documents = BusinessDataServiceHelper.load((String)channelInfo.getDataEntityType().getName(), (String)selector.toString(), (QFilter[])new QFilter[]{filter});
            if (documents != null && documents.length != 0) {
                DynamicObject info = documents[0];
                DynamicObject customergroup = (DynamicObject)info.get("customergroup");
                this.getModel().setValue(CHANNELGROUP, (Object)customergroup);
                DynamicObject region = (DynamicObject)info.get("region");
                this.getModel().setValue(REGION, (Object)region);
            }
        }
    }

    public void itemClick(ItemClickEvent evt) {
        super.itemClick(evt);
    }

    @Override
    public void beforeF7Select(BeforeF7SelectEvent arg0) {
    }
}

