/*
 * Decompiled with CFR 0.152.
 */
package kd.drp.mem.formplugin.cost;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.Date;
import java.util.EventObject;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.bill.MobileBillShowParameter;
import kd.bos.bill.OperationStatus;
import kd.bos.bill.events.LocateEvent;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.form.CloseCallBack;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IClientViewProxy;
import kd.bos.form.ShowType;
import kd.bos.form.cardentry.CardEntry;
import kd.bos.form.control.events.MobileSearchTextChangeEvent;
import kd.bos.form.control.events.MobileSearchTextChangeListener;
import kd.bos.form.control.events.RowClickEvent;
import kd.bos.form.control.events.RowClickEventListener;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.list.MobileSearch;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.mvc.form.MobileFormView;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.bos.servicehelper.user.UserServiceHelper;
import kd.drp.mem.common.DateUtil;
import kd.drp.mem.common.DistanceAndLocationUtil;
import kd.drp.mem.common.MEMUtil;
import kd.drp.mem.common.ToExecFilterUtil;
import kd.drp.mem.formplugin.basedata.MEMBillFormMobPlugin;
import kd.drp.mem.formplugin.model.CostExeAndDistenceModel;
import org.apache.commons.lang.StringUtils;

public class ToBeExecutedMobListPlugin
extends MEMBillFormMobPlugin
implements RowClickEventListener,
MobileSearchTextChangeListener {
    public static final Log logger = LogFactory.getLog(ToBeExecutedMobListPlugin.class);
    private static final String ENTRY_ENTITY = "entryentity";
    private static final String CACHE_TXT = "searchtxt";

    public void registerListener(EventObject e) {
        super.registerListener(e);
        CardEntry ce = (CardEntry)this.getView().getControl(ENTRY_ENTITY);
        ce.addRowClickListener((RowClickEventListener)this);
        MobileSearch searchap = (MobileSearch)this.getView().getControl("mobilesearchap");
        searchap.addMobileSearchTextChangeListener((MobileSearchTextChangeListener)this);
    }

    public void click(MobileSearchTextChangeEvent e) {
        String txt = e.getText();
        this.getPageCache().put(CACHE_TXT, txt.trim());
        ((MobileFormView)this.getView()).locate();
    }

    public void afterBindData(EventObject e) {
        super.afterBindData(e);
        this.getView().setVisible(Boolean.FALSE, new String[]{"flexpanelap", "flexpanelap2"});
        logger.info("afterBindData start ------");
        ((MobileFormView)this.getView()).locate();
        logger.info("afterBindData end ------");
        this.initData(null, null, "410");
    }

    public void locate(LocateEvent e) {
        super.locate(e);
        logger.info("locate start ------");
        if (e.getMobLocation() != null) {
            Float latitude = Float.valueOf(e.getMobLocation().getLatitude());
            Float longitude = Float.valueOf(e.getMobLocation().getLongitude());
            String cityId = e.getMobLocation().getCityId();
            this.initData(longitude, latitude, cityId);
        } else {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u672a\u83b7\u53d6\u5230\u624b\u673a\u5b9a\u4f4d\u4fe1\u606f\uff01", (String)"ToBeExecutedMobListPlugin_0", (String)"drp-mem-formplugin", (Object[])new Object[0]), Integer.valueOf(3000));
            logger.info("do not get MobLocation ------");
        }
    }

    private void initData(Object longitude, Object latitude, String cityId) {
        IDataModel model = this.getModel();
        model.beginInit();
        model.deleteEntryData(ENTRY_ENTITY);
        model.getDataEntity(true);
        DynamicObject[] exeData = this.getExecutedData(cityId);
        if (exeData.length == 0) {
            this.getView().setVisible(Boolean.TRUE, new String[]{"flexpanelap2"});
            this.getView().setVisible(Boolean.FALSE, new String[]{"flexpanelap"});
        } else {
            this.getView().setVisible(Boolean.TRUE, new String[]{"flexpanelap"});
            this.getView().setVisible(Boolean.FALSE, new String[]{"flexpanela2"});
        }
        Map<Long, Boolean> userExecuStatuMap = this.getExecuteStatus(exeData);
        List<CostExeAndDistenceModel> list = this.orderDatas(exeData, longitude, latitude);
        if (list.size() > 0) {
            model.batchCreateNewEntryRow(ENTRY_ENTITY, list.size());
            for (int i = 0; i < list.size(); ++i) {
                DynamicObject entryInfo = model.getEntryRowEntity(ENTRY_ENTITY, i);
                CostExeAndDistenceModel obj = list.get(i);
                DynamicObject data = obj.getCostExeObj();
                entryInfo.set("entrypk", (Object)data.getString("id"));
                entryInfo.set("itemname", (Object)data.getString("iteminfo.name"));
                if (data.getString("iteminfo.name") != null) {
                    String modelnum = data.getString("iteminfo.modelnum") == null ? "" : data.getString("iteminfo.modelnum");
                    this.setLabelText("lb_modelnum", i, modelnum);
                    entryInfo.set("modelnum", (Object)modelnum);
                }
                entryInfo.set("isexecuted", (Object)data.getBoolean("isexecuted"));
                entryInfo.set("amount", (Object)data.getBigDecimal("amount"));
                String costType = data.getString("bill.expensetype.name");
                entryInfo.set("costtype", (Object)costType);
                this.setLabelText("lb_itemname", i, data.getString("iteminfo.name"));
                this.setLabelText("lb_amount", i, data.getBigDecimal("amount").setScale(2, 4).toString());
                this.setLabelText("lb_costtype", i, costType);
                String shopName = data.getString("shop.name");
                if (StringUtils.isBlank((String)shopName)) {
                    entryInfo.set("shopname", (Object)"");
                    this.setLink("lb_shopname", i, "#ffffff", "#5656ff", ResManager.loadKDString((String)"\u672a\u6307\u5b9a\u95e8\u5e97", (String)"ToBeExecutedMobListPlugin_1", (String)"drp-mem-formplugin", (Object[])new Object[0]));
                    continue;
                }
                entryInfo.set("shopname", (Object)shopName);
                this.setLink("lb_shopname", i, "#ffffff", "#5656ff", shopName);
                if (userExecuStatuMap.get(data.getLong("id")).booleanValue()) {
                    this.setLink("lb_link", i, "#ffffff", "#5656ff", ResManager.loadKDString((String)"\u67e5\u770b\u7ed3\u679c", (String)"ToBeExecutedMobListPlugin_2", (String)"drp-mem-formplugin", (Object[])new Object[0]));
                }
                this.setLabelText("lb_distance", i, obj.getDistence());
            }
        }
        model.endInit();
        this.getView().updateView(ENTRY_ENTITY);
    }

    private Map<Long, Boolean> getExecuteStatus(DynamicObject[] exeData) {
        HashMap<Long, Boolean> execuMap = new HashMap<Long, Boolean>(3);
        if (exeData == null || exeData.length == 0) {
            return execuMap;
        }
        ArrayList<Long> entryids = new ArrayList<Long>(3);
        for (DynamicObject obj : exeData) {
            entryids.add(obj.getLong("id"));
            execuMap.put(obj.getLong("id"), false);
        }
        QFilter qFilter = new QFilter("costapplyentry.id", "in", (Object)entryids.toArray(new Long[entryids.size()]));
        qFilter.and("creator", "=", (Object)UserServiceHelper.getCurrentUserId());
        DynamicObjectCollection coll = QueryServiceHelper.query((String)"mem_marketcostexecute", (String)"id,costapplyentry", (QFilter[])qFilter.toArray(), (String)"createtime desc");
        for (DynamicObject obj : coll) {
            if (!execuMap.containsKey(obj.getLong("costapplyentry"))) continue;
            execuMap.put(obj.getLong("costapplyentry"), true);
        }
        return execuMap;
    }

    private List<CostExeAndDistenceModel> orderDatas(DynamicObject[] datas, Object longitude, Object latitude) {
        ArrayList<CostExeAndDistenceModel> list = new ArrayList<CostExeAndDistenceModel>();
        if (datas.length > 0) {
            String dis = "";
            for (DynamicObject data : datas) {
                DynamicObject shop = data.getDynamicObject("shop");
                CostExeAndDistenceModel model = new CostExeAndDistenceModel();
                if (shop != null) {
                    dis = this.getDistance(shop, longitude, latitude);
                }
                model.setCostExeId(data.getPkValue().toString());
                model.setDistence(dis);
                model.setCostExeObj(data);
                model.setDis(StringUtils.isBlank((String)dis) ? BigDecimal.ZERO : new BigDecimal(dis.replace("km", "")));
                list.add(model);
            }
        }
        list.sort(new Comparator<CostExeAndDistenceModel>(){

            @Override
            public int compare(CostExeAndDistenceModel o1, CostExeAndDistenceModel o2) {
                return o1.getDis().compareTo(o2.getDis());
            }
        });
        return list;
    }

    private String getDistance(DynamicObject shop, Object longitude, Object latitude) {
        String longitude1 = longitude == null ? "113.961587" : longitude.toString();
        String latitude1 = latitude == null ? "22.540112" : latitude.toString();
        String longitude2 = shop.getBigDecimal("longitude").toString();
        String latitude2 = shop.getBigDecimal("latitude").toString();
        if (StringUtils.isBlank((String)longitude2) || StringUtils.isBlank((String)latitude2)) {
            logger.error("getDistance :shop have no longitude and latitude");
            return "";
        }
        return DistanceAndLocationUtil.getDistance((String)longitude1, (String)latitude1, (String)longitude2, (String)latitude2);
    }

    private void setLink(String key, int rowIndex, String backColor, String foreColor, String text) {
        HashMap activeItem = new HashMap();
        HashMap<String, String> propertiesMap = new HashMap<String, String>();
        propertiesMap.put("bc", backColor);
        propertiesMap.put("fc", foreColor);
        propertiesMap.put("text", text);
        activeItem.put(key, propertiesMap);
        ((IClientViewProxy)this.getView().getService(IClientViewProxy.class)).invokeControlMethod(ENTRY_ENTITY, "setCustomProperties", new Object[]{rowIndex, activeItem});
    }

    private void setLabelText(String key, int rowIndex, String text) {
        HashMap activeItem = new HashMap();
        HashMap<String, String> propertiesMap = new HashMap<String, String>();
        propertiesMap.put("text", text);
        activeItem.put(key, propertiesMap);
        ((IClientViewProxy)this.getView().getService(IClientViewProxy.class)).invokeControlMethod(ENTRY_ENTITY, "setCustomProperties", new Object[]{rowIndex, activeItem});
    }

    public void entryRowClick(RowClickEvent evt) {
        super.entryRowClick(evt);
        CardEntry ce = (CardEntry)this.getView().getControl(ENTRY_ENTITY);
        int[] rows = ce.getSelectRows();
        if (rows.length == 0) {
            this.getView().showMessage(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u4e00\u884c\uff01", (String)"ToBeExecutedMobListPlugin_3", (String)"drp-mem-formplugin", (Object[])new Object[0]));
            return;
        }
        int rowIndex = ce.getSelectRows()[0];
        DynamicObject rowData = this.getModel().getEntryRowEntity(ENTRY_ENTITY, rowIndex);
        Object entryPk = rowData.get("entrypk");
        DynamicObject entry = BusinessDataServiceHelper.loadSingle((Object)entryPk, (String)"mem_market_costapplyentry");
        Date date = new Date();
        date = DateUtil.getDayFirst((Date)date);
        Date begin = entry.getDate("entrybegindate");
        Date end = entry.getDate("entryenddate");
        if (begin.compareTo(date) > 0) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u6d3b\u52a8\u65f6\u95f4\u672a\u5230\uff0c\u4e0d\u5141\u8bb8\u6267\u884c", (String)"ToBeExecutedMobListPlugin_4", (String)"drp-mem-formplugin", (Object[])new Object[0]), Integer.valueOf(2000));
        } else if (end.compareTo(date) < 0) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u6d3b\u52a8\u65f6\u95f4\u7ed3\u675f\uff0c\u4e0d\u5141\u8bb8\u6267\u884c", (String)"ToBeExecutedMobListPlugin_5", (String)"drp-mem-formplugin", (Object[])new Object[0]), Integer.valueOf(2000));
        } else if (StringUtils.isBlank((String)rowData.getString("shopname"))) {
            this.openShopChoose(entryPk);
        } else {
            this.openCostExecuteEdit(entryPk);
        }
    }

    private DynamicObject[] getExecutedData(String cityId) {
        StringBuilder oql = new StringBuilder();
        oql.append("id,bill.id,bill.expensetype.name,bill.expensetype.parent.name,");
        oql.append("shop.id,shop.name,shop.longitude,shop.latitude");
        oql.append(",isexecuted,iteminfo.id,");
        if (MEMUtil.isSplitMDEApp()) {
            oql.append("iteminfo.title,");
        }
        oql.append("iteminfo.name,iteminfo.modelnum,");
        oql.append("amount");
        DynamicObject[] datas = BusinessDataServiceHelper.load((String)"mem_market_costapplyentry", (String)oql.toString(), (QFilter[])this.getFilter(cityId).toArray());
        return datas;
    }

    private QFilter getFilter(String cityId) {
        Object customerId;
        String searchtxt = this.getPageCache().get(CACHE_TXT);
        QFilter f = new QFilter("id", ">", (Object)0);
        if (searchtxt != null && StringUtils.isNotBlank((String)searchtxt.toString())) {
            String likeValue = "%" + searchtxt + "%";
            QFilter searchFilter = new QFilter("shop.name", "like", (Object)likeValue);
            if (MEMUtil.isSplitMDEApp()) {
                searchFilter.or("iteminfo.title", "like", (Object)likeValue);
            } else {
                searchFilter.or("iteminfo.name", "like", (Object)likeValue);
            }
            f.and(searchFilter);
        }
        if ((customerId = this.getView().getFormShowParameter().getCustomParam("customerId")) != null) {
            f.and("bill.customer.id", "=", (Object)Long.parseLong(customerId.toString()));
        }
        f.and(new QFilter("bill.billstatus", "in", (Object)new String[]{"E", "F"}));
        f.and(new QFilter("bill.expensetype", "in", (Object)ToExecFilterUtil.getCostTypeSet()));
        Long userId = UserServiceHelper.getCurrentUserId();
        Long mainOrgId = UserServiceHelper.getUserMainOrgId((long)userId);
        Object beginDate = this.getView().getFormShowParameter().getCustomParam("beginDate");
        Object endDate = this.getView().getFormShowParameter().getCustomParam("endDate");
        if (beginDate != null && endDate != null) {
            QFilter f1 = new QFilter("bill.begindate", ">=", beginDate);
            f1.and("bill.begindate", "<=", endDate);
            QFilter f2 = new QFilter("bill.begindate", "<=", beginDate);
            f2.and("bill.enddate", ">=", beginDate);
            f.and(f1.or(f2));
        } else {
            f.and(this.getDateFilter());
        }
        return f;
    }

    private QFilter getDateFilter() {
        Date date = new Date();
        date = DateUtil.getDayFirst((Date)date);
        QFilter filter = new QFilter("entrybegindate", "<=", (Object)date);
        filter.and("entryenddate", ">=", (Object)date);
        return filter;
    }

    private void openCostExecuteEdit(Object entryId) {
        if (entryId == null) {
            return;
        }
        Object executeId = this.queryCostExecute(entryId);
        MobileBillShowParameter param = new MobileBillShowParameter();
        if (executeId != null) {
            param.setPkId(executeId);
            param.setStatus(OperationStatus.VIEW);
        } else {
            param.setCustomParam("applyEntryId", entryId);
        }
        param.getOpenStyle().setShowType(ShowType.Floating);
        param.setFormId("mem_costexecute_editmob");
        this.getView().showForm((FormShowParameter)param);
    }

    private Object queryCostExecute(Object entryId) {
        QFilter f = new QFilter("costapplyentry.id", "=", (Object)Long.parseLong(entryId.toString()));
        f.and("creator", "=", (Object)UserServiceHelper.getCurrentUserId());
        DynamicObjectCollection rs = QueryServiceHelper.query((String)"mem_marketcostexecute", (String)"id,costapplyentry", (QFilter[])f.toArray(), (String)"createtime desc");
        return rs.size() > 0 ? ((DynamicObject)rs.get(0)).get("id") : null;
    }

    private void openShopChoose(Object entryId) {
        MobileBillShowParameter param = new MobileBillShowParameter();
        param.getOpenStyle().setShowType(ShowType.Floating);
        param.setCustomParam("customerId", this.getBillCustomer());
        param.setCustomParam("entryId", this.getClickRowPk());
        param.setFormId("mem_shopmanlistmob");
        param.setCloseCallBack(new CloseCallBack((IFormPlugin)this, "closeShopChoose"));
        this.getView().showForm((FormShowParameter)param);
    }

    private Object getBillCustomer() {
        Object entryPk = this.getClickRowPk();
        QFilter filter = new QFilter("id", "=", (Object)Long.parseLong("0"));
        if (entryPk != null) {
            filter = new QFilter("id", "=", (Object)Long.parseLong(entryPk.toString()));
        }
        DynamicObject rs = QueryServiceHelper.queryOne((String)"mem_market_costapplyentry", (String)"id,bill,bill.customer.id", (QFilter[])filter.toArray());
        return rs.get("bill.customer.id");
    }

    public void closedCallBack(ClosedCallBackEvent e) {
        super.closedCallBack(e);
        if ("closeShopChoose".equals(e.getActionId())) {
            Object shopId = e.getReturnData();
            if (shopId == null) {
                return;
            }
            if (!QueryServiceHelper.exists((String)"mem_shopmanage", (Object)shopId)) {
                return;
            }
            ((MobileFormView)this.getView()).locate();
        }
    }

    private void saveShop(Object shopId) {
        Object entryId = this.getClickRowPk();
        if (entryId != null) {
            DynamicObject entry = BusinessDataServiceHelper.loadSingle((Object)entryId, (String)"mem_market_costapplyentry");
            entry.set("shop", shopId);
            SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{entry});
            this.getView().showSuccessNotification(ResManager.loadKDString((String)"\u95e8\u5e97\u6307\u5b9a\u6210\u529f\uff01", (String)"ToBeExecutedMobListPlugin_6", (String)"drp-mem-formplugin", (Object[])new Object[0]));
        }
    }

    private Object getClickRowPk() {
        CardEntry ce = (CardEntry)this.getView().getControl(ENTRY_ENTITY);
        int[] rows = ce.getSelectRows();
        if (rows.length == 0) {
            this.getView().showMessage(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u4e00\u884c\uff01", (String)"ToBeExecutedMobListPlugin_3", (String)"drp-mem-formplugin", (Object[])new Object[0]));
            return null;
        }
        int rowIndex = ce.getSelectRows()[0];
        DynamicObject rowData = this.getModel().getEntryRowEntity(ENTRY_ENTITY, rowIndex);
        return rowData.get("entrypk");
    }
}

