/*
 * Decompiled with CFR 0.152.
 */
package kd.drp.ocic.opplugin.inbill;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.entity.operate.result.OperateErrorInfo;
import kd.bos.entity.plugin.AbstractOperationServicePlugIn;
import kd.bos.entity.plugin.AddValidatorsEventArgs;
import kd.bos.entity.plugin.PreparePropertysEventArgs;
import kd.bos.entity.plugin.args.BeginOperationTransactionArgs;
import kd.bos.entity.validate.AbstractValidator;
import kd.bos.entity.validate.ErrorLevel;
import kd.drp.ocic.business.channelinv.ChannelInvAccHelper;
import kd.drp.ocic.business.helper.SnMainFileHelper;
import kd.drp.ocic.util.CommonUtils;
import kd.drp.ocic.validator.inbill.ChannelInBillSNValidator;
import kd.drp.ocic.validator.inbill.StockinBillCommonValidator;
import kd.drp.ocic.validator.invacc.InvAccUpdateAuditValidator;

public class ChannelInBillAuditOp
extends AbstractOperationServicePlugIn {
    public void onPreparePropertys(PreparePropertysEventArgs e) {
        e.getFieldKeys().add("supplychannelid");
        e.getFieldKeys().add("itemid");
        e.getFieldKeys().add("auxptyid");
        e.getFieldKeys().add("lotnumberid");
        e.getFieldKeys().add("lotnumber");
        e.getFieldKeys().add("warehouse");
        e.getFieldKeys().add("locationid");
        e.getFieldKeys().add("stocktype");
        e.getFieldKeys().add("stockstatus");
        e.getFieldKeys().add("ownerid");
        e.getFieldKeys().add("ownertype");
        e.getFieldKeys().add("keeperid");
        e.getFieldKeys().add("keepertype");
        e.getFieldKeys().add("itemnumber");
        e.getFieldKeys().add("producedate");
        e.getFieldKeys().add("expirydate");
        e.getFieldKeys().add("baseunitid");
        e.getFieldKeys().add("baseqty");
        e.getFieldKeys().add("unitid");
        e.getFieldKeys().add("qty");
        e.getFieldKeys().add("assistunitid");
        e.getFieldKeys().add("assistqty");
        e.getFieldKeys().add("inway");
        e.getFieldKeys().add("org");
        e.getFieldKeys().add("sellorgchannel");
        e.getFieldKeys().add("inchannelid");
        e.getFieldKeys().add("billno");
        e.getFieldKeys().add("projectid");
        e.getFieldKeys().add("producedate");
        e.getFieldKeys().add("expirydate");
        e.getFieldKeys().add("serialqty");
        e.getFieldKeys().add("serialnumber");
        e.getFieldKeys().add("serialid");
        e.getFieldKeys().add("billtypeid");
        e.getFieldKeys().add("intype");
        e.getFieldKeys().add("settlecurrencyid");
        e.getFieldKeys().add("materialid");
        e.getFieldKeys().add("instocktime");
        e.getFieldKeys().add("serialcomment");
        e.getFieldKeys().add("billentry.seq");
    }

    public void onAddValidators(AddValidatorsEventArgs e) {
        super.onAddValidators(e);
        e.addValidator((AbstractValidator)new StockinBillCommonValidator());
        e.addValidator((AbstractValidator)new ChannelInBillSNValidator());
        e.addValidator((AbstractValidator)new InvAccUpdateAuditValidator());
    }

    public void beginOperationTransaction(BeginOperationTransactionArgs e) {
        DynamicObject[] bills = e.getDataEntities();
        ArrayList<Long> billIdList = new ArrayList<Long>(bills.length);
        for (DynamicObject bill : bills) {
            billIdList.add(bill.getLong("id"));
        }
        SnMainFileHelper.saveSnMainFileByAudit(billIdList, (String)"ocic_channelinbill");
        Map errorMessageData = ChannelInvAccHelper.updateChannelInvAccByBillAudit(billIdList, (String)"ocic_channelinbill");
        if (!CommonUtils.isNull((Object)errorMessageData)) {
            for (Map.Entry errorMessageEntry : errorMessageData.entrySet()) {
                List errorMessages = (List)errorMessageEntry.getValue();
                for (DynamicObject bill : bills) {
                    OperateErrorInfo errorInfo = new OperateErrorInfo("errorcode_001", ErrorLevel.Error, bill.getPkValue());
                    errorInfo.setMessage((String)errorMessages.get(0));
                    this.operationResult.addErrorInfo(errorInfo);
                }
            }
            e.setDataEntities(new DynamicObject[0]);
        }
    }
}

