/*
 * Decompiled with CFR 0.152.
 */
package kd.drp.ocic.opplugin.inbill;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.entity.plugin.IImportPlugin;
import kd.bos.entity.plugin.ImportLogger;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;

public class ChannelInBillImportPlugin
implements IImportPlugin {
    public boolean beforeImportData(Map<String, Object> data, Map<String, Object> option, List<ImportLogger.ImportLog> importlogs) {
        JSONArray billentries = (JSONArray)data.get("billentry");
        int size = billentries.size();
        Map<String, Long> stockMap = this.getStokMap(data);
        for (int i = 0; i < size; ++i) {
            JSONObject locationObject;
            String stockNumber = (String)((JSONObject)((JSONArray)data.get("billentry")).get(i)).getJSONObject("warehouse").get((Object)"number");
            if (!stockMap.containsKey(stockNumber) || (locationObject = ((JSONObject)((JSONArray)data.get("billentry")).get(i)).getJSONObject("locationid")) != null) continue;
            importlogs.add(new ImportLogger.ImportLog("\u4ed3\u5e93\u542f\u7528\u4ed3\u4f4d\uff0c\u4ed3\u4f4d\u4e0d\u5b58\u5728\uff0c\u8bf7\u4fee\u6539"));
            return false;
        }
        return true;
    }

    private Map<String, Long> getStokMap(Map<String, Object> data) {
        JSONArray billentries = (JSONArray)data.get("billentry");
        int size = billentries.size();
        HashSet<String> stockMapset = new HashSet<String>(10);
        for (int i = 0; i < size; ++i) {
            String stockNumber_each = (String)((JSONObject)((JSONArray)data.get("billentry")).get(i)).getJSONObject("warehouse").get((Object)"number");
            stockMapset.add(stockNumber_each);
        }
        QFilter allstockFilter = new QFilter("number", "in", stockMapset);
        DynamicObjectCollection stockCollection = QueryServiceHelper.query((String)"ocic_warehouse", (String)"id,number,enablelocation", (QFilter[])allstockFilter.toArray());
        HashMap<String, Long> stockMap = new HashMap<String, Long>(10);
        if (stockCollection != null && stockCollection.size() > 0) {
            for (int i = 0; i < stockCollection.size(); ++i) {
                if (!((DynamicObject)stockCollection.get(i)).getBoolean("enablelocation")) continue;
                stockMap.put(((DynamicObject)stockCollection.get(i)).getString("number"), ((DynamicObject)stockCollection.get(i)).getLong("id"));
            }
        }
        return stockMap;
    }

    public List<Object> importData(Map<String, Object> data, Map<String, Object> option, List<ImportLogger.ImportLog> importlogs) {
        JSONArray billentries = (JSONArray)data.get("billentry");
        int size = billentries.size();
        Map<String, Long> stockMap = this.getStokMap(data);
        for (int i = 0; i < size; ++i) {
            String stockNumber = (String)((JSONObject)((JSONArray)data.get("billentry")).get(i)).getJSONObject("warehouse").get((Object)"number");
            if (!stockMap.containsKey(stockNumber)) continue;
            String stockAddressNumber = (String)((JSONObject)((JSONArray)data.get("billentry")).get(i)).getJSONObject("locationid").get((Object)"number");
            StringBuilder sql = new StringBuilder();
            sql.append("select fentryid from t_dbd_location where fid = ? and fnumber = ?");
            JSONObject node = (JSONObject)DB.query((DBRoute)DBRoute.of((String)"drp"), (String)sql.toString(), (Object[])new Object[]{stockMap.get(stockNumber), stockAddressNumber}, rs -> {
                JSONObject tempNode = new JSONObject();
                while (rs.next()) {
                    tempNode.put("id", (Object)rs.getLong("fentryid"));
                }
                return tempNode;
            });
            ((JSONObject)((JSONArray)data.get("billentry")).get(i)).put("locationid", (Object)node);
        }
        return super.importData(data, option, importlogs);
    }
}

