/*
 * Decompiled with CFR 0.152.
 */
package kd.drp.ocic.opplugin.inbill;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.entity.plugin.AbstractOperationServicePlugIn;
import kd.bos.entity.plugin.AddValidatorsEventArgs;
import kd.bos.entity.plugin.PreparePropertysEventArgs;
import kd.bos.entity.plugin.args.BeginOperationTransactionArgs;
import kd.bos.entity.plugin.args.EndOperationTransactionArgs;
import kd.bos.entity.validate.AbstractValidator;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.drp.ocic.business.helper.LotHelper;
import kd.drp.ocic.business.helper.SnMainFileHelper;
import kd.drp.ocic.pojo.LotVO;
import kd.drp.ocic.pojo.SnMainFileVO;
import kd.drp.ocic.validator.inbill.StockinBillWriteLotIdValidator;
import kd.drp.ocic.validator.inbill.StockinBillWriteSNValidator;

public class ChannelInBillSubmitOp
extends AbstractOperationServicePlugIn {
    public void onPreparePropertys(PreparePropertysEventArgs e) {
        super.onPreparePropertys(e);
        e.getFieldKeys().add("billno");
        e.getFieldKeys().add("supplychannelid");
        e.getFieldKeys().add("itemid");
        e.getFieldKeys().add("lotnumberid");
        e.getFieldKeys().add("lotnumber");
        e.getFieldKeys().add("projectid");
        e.getFieldKeys().add("producedate");
        e.getFieldKeys().add("expirydate");
        e.getFieldKeys().add("serialqty");
        e.getFieldKeys().add("serialnumber");
        e.getFieldKeys().add("serialid");
        e.getFieldKeys().add("auxptyid");
        e.getFieldKeys().add("locationid");
        e.getFieldKeys().add("billtypeid");
        e.getFieldKeys().add("intype");
        e.getFieldKeys().add("settlecurrencyid");
        e.getFieldKeys().add("materialid");
        e.getFieldKeys().add("instocktime");
        e.getFieldKeys().add("serialcomment");
        e.getFieldKeys().add("billentry.seq");
    }

    public void onAddValidators(AddValidatorsEventArgs e) {
        super.onAddValidators(e);
        e.addValidator((AbstractValidator)new StockinBillWriteLotIdValidator());
        e.addValidator((AbstractValidator)new StockinBillWriteSNValidator());
    }

    public void endOperationTransaction(EndOperationTransactionArgs e) {
        super.endOperationTransaction(e);
    }

    public void beginOperationTransaction(BeginOperationTransactionArgs e) {
        ArrayList<DynamicObject> billEntities = new ArrayList<DynamicObject>(10);
        ArrayList<DynamicObject> redBillEntities = new ArrayList<DynamicObject>(10);
        DynamicObject[] dataEntities = e.getDataEntities();
        for (DynamicObject dataEntity : dataEntities) {
            if (this.isOppositeDirection((String)dataEntity.get("inway"))) {
                billEntities.add(dataEntity);
                continue;
            }
            redBillEntities.add(dataEntity);
        }
        if (!CollectionUtils.isEmpty(billEntities)) {
            List lotVOS = LotHelper.saveLotByDynamicObjects(billEntities, (String)"ocic_channelinbill");
            HashMap itemIdAndLotMap = new HashMap(10);
            for (LotVO vo : lotVOS) {
                itemIdAndLotMap.putIfAbsent(vo.getItemID(), new HashMap(10));
                ((Map)itemIdAndLotMap.get(vo.getItemID())).put(vo.getNumber(), vo.getLotID());
            }
            List snMainFileVOS = SnMainFileHelper.saveSnMainFileBySave(billEntities, (String)"ocic_channelinbill");
            HashMap itemIdAndSNMap = new HashMap(10);
            for (SnMainFileVO vo : snMainFileVOS) {
                itemIdAndSNMap.putIfAbsent(vo.getItemID(), new HashMap(10));
                ((Map)itemIdAndSNMap.get(vo.getItemID())).put(vo.getNumber(), vo.getSnMainFileID());
            }
            if (!CollectionUtils.isEmpty((Collection)snMainFileVOS) || !CollectionUtils.isEmpty((Collection)lotVOS)) {
                for (DynamicObject entity : dataEntities) {
                    DynamicObjectCollection entries = entity.getDynamicObjectCollection("billentry");
                    for (DynamicObject entry : entries) {
                        Map snNumberIdMap;
                        Long itemId = (Long)entry.getDynamicObject("itemid").getPkValue();
                        String lotNumber = entry.getString("lotnumber");
                        Map lotNumberIdMap = (Map)itemIdAndLotMap.get(itemId);
                        if (!CollectionUtils.isEmpty((Map)lotNumberIdMap)) {
                            Long lotId = (Long)lotNumberIdMap.get(lotNumber);
                            entry.set("lotnumberid_id", (Object)lotId);
                        }
                        if (CollectionUtils.isEmpty((Map)(snNumberIdMap = (Map)itemIdAndSNMap.get(itemId)))) continue;
                        DynamicObjectCollection subEntries = entry.getDynamicObjectCollection("subentryentity");
                        for (DynamicObject subEntry : subEntries) {
                            String snNumber = subEntry.getString("serialnumber");
                            Long snId = (Long)snNumberIdMap.get(snNumber);
                            subEntry.set("serialid_id", (Object)snId);
                        }
                    }
                }
            }
        }
        if (!CollectionUtils.isEmpty(redBillEntities)) {
            LotHelper.saveLotByDynamicObjects(redBillEntities, (String)"ocic_channelinbill");
            for (DynamicObject entity : redBillEntities) {
                DynamicObjectCollection entryColl = entity.getDynamicObjectCollection("billentry");
                for (DynamicObject entry : entryColl) {
                    DynamicObject item = entry.getDynamicObject("itemid");
                    if (null == item || !item.getBoolean("enableserial")) continue;
                    DynamicObjectCollection subEntries = entry.getDynamicObjectCollection("subentryentity");
                    for (DynamicObject subEntry : subEntries) {
                        String snNumber = subEntry.getString("serialnumber");
                        DynamicObject[] sns = BusinessDataServiceHelper.load((String)"ocic_snmainfile", (String)"id", (QFilter[])new QFilter[]{new QFilter("number", "=", (Object)snNumber)});
                        Long snId = (Long)sns[0].getPkValue();
                        subEntry.set("serialid", (Object)snId);
                    }
                }
            }
        }
    }

    private boolean isOppositeDirection(String directionCode) {
        return "1".equals(directionCode);
    }
}

