/*
 * Decompiled with CFR 0.152.
 */
package kd.drp.ocic.opplugin.outbill;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.entity.operate.result.OperateErrorInfo;
import kd.bos.entity.plugin.AbstractOperationServicePlugIn;
import kd.bos.entity.plugin.AddValidatorsEventArgs;
import kd.bos.entity.plugin.PreparePropertysEventArgs;
import kd.bos.entity.plugin.args.BeginOperationTransactionArgs;
import kd.bos.entity.validate.AbstractValidator;
import kd.bos.entity.validate.ErrorLevel;
import kd.drp.ocic.business.channelinv.ChannelInvAccHelper;
import kd.drp.ocic.business.helper.LotHelper;
import kd.drp.ocic.business.helper.SnMainFileHelper;
import kd.drp.ocic.util.CommonUtils;
import kd.drp.ocic.validator.invacc.InvAccUpdateAuditValidator;
import kd.drp.ocic.validator.outbill.ChannelOutBillLotValidator;
import kd.drp.ocic.validator.outbill.ChannelOutBillSNValidator;

public class ChannelOutBillAuditOp
extends AbstractOperationServicePlugIn {
    public void onPreparePropertys(PreparePropertysEventArgs e) {
        super.onPreparePropertys(e);
        ArrayList<String> keys = new ArrayList<String>(32);
        keys.add("itemid");
        keys.add("auxptyid");
        keys.add("lotid");
        keys.add("lotnumber");
        keys.add("stockid");
        keys.add("stockaddrid");
        keys.add("stocktypeid");
        keys.add("stockstatusid");
        keys.add("ownerid");
        keys.add("ownertype");
        keys.add("keeperid");
        keys.add("keepertype");
        keys.add("projectid");
        keys.add("productdate");
        keys.add("expiredate");
        keys.add("baseunitid");
        keys.add("basequantity");
        keys.add("unitid");
        keys.add("quantity");
        keys.add("auxptyunitid");
        keys.add("auxquantity");
        keys.add("outdirection");
        keys.add("org");
        keys.add("saleorgchannelid");
        keys.add("outchannelid");
        keys.add("billno");
        keys.add("snquantity");
        keys.add("serialnumber");
        keys.add("serialid");
        keys.add("materielid");
        keys.add("creator");
        keys.add("createtime");
        keys.add("srcbillentryid");
        keys.add("serialcomment");
        keys.add("chnloutbill_sn");
        keys.add("serialid");
        keys.add("billentry.seq");
        keys.add("outdate");
        e.getFieldKeys().addAll(keys);
    }

    public void onAddValidators(AddValidatorsEventArgs e) {
        super.onAddValidators(e);
        e.addValidator((AbstractValidator)new ChannelOutBillSNValidator());
        e.addValidator((AbstractValidator)new ChannelOutBillLotValidator());
        e.addValidator((AbstractValidator)new InvAccUpdateAuditValidator());
    }

    public void beginOperationTransaction(BeginOperationTransactionArgs e) {
        DynamicObject[] bills = e.getDataEntities();
        ArrayList<Long> billIdList = new ArrayList<Long>(bills.length);
        for (DynamicObject bill : bills) {
            billIdList.add(bill.getLong("id"));
        }
        SnMainFileHelper.saveSnMainFileByAudit(billIdList, (String)"ocic_channeloutbill");
        LotHelper.saveLotByDynamicObjects(Arrays.asList(bills), (String)"ocic_channeloutbill");
        Map errorMessageData = ChannelInvAccHelper.updateChannelInvAccByBillAudit(billIdList, (String)"ocic_channeloutbill");
        if (!CommonUtils.isNull((Object)errorMessageData)) {
            for (Map.Entry errorMessageEntry : errorMessageData.entrySet()) {
                List errorMessages = (List)errorMessageEntry.getValue();
                for (DynamicObject bill : bills) {
                    OperateErrorInfo errorInfo = new OperateErrorInfo("errorcode_001", ErrorLevel.Error, bill.getPkValue());
                    errorInfo.setMessage((String)errorMessages.get(0));
                    this.operationResult.addErrorInfo(errorInfo);
                }
            }
            e.setDataEntities(new DynamicObject[0]);
        }
    }
}

