/*
 * Decompiled with CFR 0.152.
 */
package kd.drp.ocic.opplugin.outbill;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.entity.operate.result.OperateErrorInfo;
import kd.bos.entity.plugin.AbstractOperationServicePlugIn;
import kd.bos.entity.plugin.AddValidatorsEventArgs;
import kd.bos.entity.plugin.PreparePropertysEventArgs;
import kd.bos.entity.plugin.args.BeginOperationTransactionArgs;
import kd.bos.entity.validate.AbstractValidator;
import kd.bos.entity.validate.ErrorLevel;
import kd.drp.ocic.business.channelinv.ChannelInvAccHelper;
import kd.drp.ocic.business.helper.LotHelper;
import kd.drp.ocic.business.helper.SnMainFileHelper;
import kd.drp.ocic.util.CommonUtils;
import kd.drp.ocic.validator.invacc.InvAccUpdateUnAuditValidator;
import kd.drp.ocic.validator.outbill.ChannelOutBillUnAuditSNValidator;

public class ChannelOutBillUnAuditOp
extends AbstractOperationServicePlugIn {
    public void onPreparePropertys(PreparePropertysEventArgs e) {
        super.onPreparePropertys(e);
        ArrayList<String> keys = new ArrayList<String>(16);
        keys.add("billno");
        keys.add("billentry.seq");
        keys.add("itemid");
        keys.add("lotid");
        keys.add("lotnumber");
        keys.add("projectid");
        keys.add("productdate");
        keys.add("expiredate");
        keys.add("snquantity");
        keys.add("serialnumber");
        keys.add("serialid");
        keys.add("srcbillentryid");
        keys.add("serialcomment");
        keys.add("chnloutbill_sn");
        keys.add("serialid");
        e.getFieldKeys().addAll(keys);
    }

    public void onAddValidators(AddValidatorsEventArgs e) {
        e.addValidator((AbstractValidator)new ChannelOutBillUnAuditSNValidator());
        e.addValidator((AbstractValidator)new InvAccUpdateUnAuditValidator());
    }

    public void beginOperationTransaction(BeginOperationTransactionArgs e) {
        DynamicObject[] bills = e.getDataEntities();
        ArrayList<Long> billIdList = new ArrayList<Long>(bills.length);
        for (DynamicObject bill : bills) {
            billIdList.add(bill.getLong("id"));
        }
        SnMainFileHelper.saveSnMainFileByUnAudit(billIdList, (String)"ocic_channeloutbill");
        LotHelper.deleteLot(billIdList, (String)"ocic_channeloutbill");
        Map errorMessageData = ChannelInvAccHelper.updateChannelInvAccByBillUnAudit(billIdList, (String)"ocic_channeloutbill");
        if (!CommonUtils.isNull((Object)errorMessageData)) {
            for (Map.Entry errorMessageEntry : errorMessageData.entrySet()) {
                List errorMessages = (List)errorMessageEntry.getValue();
                for (DynamicObject bill : bills) {
                    OperateErrorInfo errorInfo = new OperateErrorInfo("errorcode_001", ErrorLevel.Error, bill.getPkValue());
                    errorInfo.setMessage((String)errorMessages.get(0));
                    this.operationResult.addErrorInfo(errorInfo);
                }
            }
            e.setDataEntities(new DynamicObject[0]);
        }
    }
}

