/*
 * Decompiled with CFR 0.152.
 */
package kd.drp.ocic.opplugin.warehouse;

import java.util.List;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.entity.operate.result.OperateErrorInfo;
import kd.bos.entity.validate.AbstractValidator;
import kd.bos.entity.validate.ErrorLevel;
import kd.bos.entity.validate.ValidationErrorInfo;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.drp.ocic.util.StringUtils;

public class WarehouseSaveValidator
extends AbstractValidator {
    public void validate() {
        String tipMsg1 = "\u6bcf\u4e2a\u6e20\u9053\u53ea\u80fd\u6709\u4e00\u4e2a\u9ed8\u8ba4\u6536\u8d27\u4ed3\u5e93\u3002";
        String tipMsg2 = "\u6bcf\u4e2a\u6e20\u9053\u53ea\u80fd\u6709\u4e00\u4e2a\u9ed8\u8ba4\u53d1\u8d27\u4ed3\u5e93\u3002";
        String tipMsg3 = "\u6bcf\u4e2a\u6e20\u9053\u53ea\u80fd\u6709\u4e00\u4e2a\u9ed8\u8ba4\u9000\u8d27\u4ed3\u5e93\u3002";
        String tipMsg4 = "\u6bcf\u4e2a\u6e20\u9053\u4ed3\u5e93\u53ea\u80fd\u6709\u4e00\u4e2a\u9ed8\u8ba4\u4ed3\u4f4d\u3002";
        for (ExtendedDataEntity dataEntity : this.dataEntities) {
            DynamicObjectCollection locationColl;
            DynamicObject dataDynObj = dataEntity.getDataEntity();
            long warehouseId = dataDynObj.getLong("id");
            DynamicObject ownerChannelDynObj = dataDynObj.getDynamicObject("ownerchannelid");
            if (ownerChannelDynObj != null) {
                ValidationErrorInfo erroInfo;
                QFilter filter = new QFilter("ownerchannelid", "=", ownerChannelDynObj.getPkValue());
                DynamicObject[] warehouseDynObjs = BusinessDataServiceHelper.load((String)"ocic_warehouse", (String)StringUtils.join((CharSequence)",", (Object[])new Object[]{"isdefault", "isdelivery", "isreturn"}), (QFilter[])new QFilter[]{filter});
                int isdefaultCount = 0;
                int isdeliveryCount = 0;
                int isreturnCount = 0;
                for (DynamicObject warehouseDynObj : warehouseDynObjs) {
                    if (warehouseDynObj.getLong("id") == warehouseId) continue;
                    if (warehouseDynObj.getBoolean("isdefault")) {
                        ++isdefaultCount;
                    }
                    if (warehouseDynObj.getBoolean("isdelivery")) {
                        ++isdeliveryCount;
                    }
                    if (!warehouseDynObj.getBoolean("isreturn")) continue;
                    ++isreturnCount;
                }
                if (dataDynObj.getBoolean("isdefault") && isdefaultCount > 0) {
                    erroInfo = new ValidationErrorInfo("", dataDynObj.getPkValue(), dataEntity.getDataEntityIndex(), dataEntity.getRowIndex(), "errorcode_001", "\u4fdd\u5b58", tipMsg1, ErrorLevel.Error);
                    this.validateResult.addErrorInfo((OperateErrorInfo)erroInfo);
                }
                if (dataDynObj.getBoolean("isdelivery") && isdeliveryCount > 0) {
                    erroInfo = new ValidationErrorInfo("", dataDynObj.getPkValue(), dataEntity.getDataEntityIndex(), dataEntity.getRowIndex(), "errorcode_002", "\u4fdd\u5b58", tipMsg2, ErrorLevel.Error);
                    this.validateResult.addErrorInfo((OperateErrorInfo)erroInfo);
                }
                if (dataDynObj.getBoolean("isreturn") && isreturnCount > 0) {
                    erroInfo = new ValidationErrorInfo("", dataDynObj.getPkValue(), dataEntity.getDataEntityIndex(), dataEntity.getRowIndex(), "errorcode_003", "\u4fdd\u5b58", tipMsg3, ErrorLevel.Error);
                    this.validateResult.addErrorInfo((OperateErrorInfo)erroInfo);
                }
            }
            if ((locationColl = dataDynObj.getDynamicObjectCollection("entryentity")) != null && locationColl.size() > 0) {
                List locationDynObjList = locationColl.stream().filter(locationDynObj -> locationDynObj.getBoolean("defaultlocation")).collect(Collectors.toList());
                if (locationDynObjList.size() <= 1) continue;
                ValidationErrorInfo erroInfo = new ValidationErrorInfo("", dataDynObj.getPkValue(), dataEntity.getDataEntityIndex(), dataEntity.getRowIndex(), "errorcode_003", "\u4fdd\u5b58", tipMsg4, ErrorLevel.Error);
                this.validateResult.addErrorInfo((OperateErrorInfo)erroInfo);
                continue;
            }
            if (!dataDynObj.getBoolean("enablelocation")) continue;
            ValidationErrorInfo erroInfo = new ValidationErrorInfo("", dataDynObj.getPkValue(), dataEntity.getDataEntityIndex(), dataEntity.getRowIndex(), "errorcode_004", "\u4fdd\u5b58", "\u4ed3\u4f4d\u4fe1\u606f\u4e0d\u80fd\u4e3a\u7a7a", ErrorLevel.Error);
            this.validateResult.addErrorInfo((OperateErrorInfo)erroInfo);
        }
    }
}

