/*
 * Decompiled with CFR 0.152.
 */
package kd.drp.ocic.validator.inbill;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.entity.operate.result.OperateErrorInfo;
import kd.bos.entity.validate.AbstractValidator;
import kd.bos.entity.validate.ErrorLevel;
import kd.bos.entity.validate.ValidationErrorInfo;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.drp.ocic.enums.SnStatusEnum;
import kd.drp.ocic.util.DateUtils;
import kd.drp.ocic.util.StringUtils;

public class ChannelInBillSNValidator
extends AbstractValidator {
    public void validate() {
        if (this.dataEntities == null || this.dataEntities.length == 0) {
            return;
        }
        DynamicObject[] snDynObjs = this.getSNMainFileDynObjs(this.dataEntities);
        String snNumber = "";
        String snStatus = "";
        String tipMsg = "";
        String inWay = "";
        String itemNumber = "";
        long itemId = 0L;
        long auxptyId = 0L;
        String lotNum = "";
        long projectId = 0L;
        Date productDate = null;
        Date effectDate = null;
        ArrayList<String> snList = new ArrayList<String>();
        DynamicObject alertbillDynObj = null;
        HashSet<String> snNumberSet = new HashSet<String>();
        for (ExtendedDataEntity dataEntity : this.dataEntities) {
            DynamicObject billDynObj;
            alertbillDynObj = billDynObj = dataEntity.getDataEntity();
            DynamicObjectCollection entryColl = billDynObj.getDynamicObjectCollection("billentry");
            if (entryColl == null || entryColl.size() <= 0) continue;
            int seq = 0;
            for (DynamicObject entryDynObj : entryColl) {
                int snSize;
                ValidationErrorInfo erroInfo;
                String lotNumber;
                DynamicObject itemDynObj = entryDynObj.getDynamicObject("itemid");
                if (itemDynObj == null || itemDynObj.getLong("id") == 0L) continue;
                Boolean enableserial = itemDynObj.getBoolean("enableserial");
                if (!enableserial.booleanValue()) {
                    entryDynObj.set("serialqty", (Object)0L);
                }
                BigDecimal snQty = entryDynObj.getBigDecimal("serialqty");
                DynamicObjectCollection snEntryColl = entryDynObj.getDynamicObjectCollection("subentryentity");
                int snCount = 0;
                snNumberSet.clear();
                if (snEntryColl != null && snEntryColl.size() > 0) {
                    for (DynamicObject snEntryDynObj : snEntryColl) {
                        snNumber = snEntryDynObj.getString("serialnumber");
                        if (!StringUtils.isNotEmpty((String)snNumber)) continue;
                        snList.add(snNumber);
                        snNumberSet.add(snNumber);
                        ++snCount;
                    }
                }
                ++seq;
                itemNumber = itemDynObj.getString("number");
                if (snQty.compareTo(BigDecimal.valueOf(snNumberSet.size())) != 0) {
                    tipMsg = String.format("\u7b2c%s\u884c\u5206\u5f55\u4e2d\u5546\u54c1\u7f16\u7801\u4e3a%s\u7684\u5e8f\u5217\u53f7\u6570\u91cf\u548c\u5e8f\u5217\u53f7\u8868\u8bb0\u5f55\u6761\u6570\u4e0d\u4e00\u81f4\u3002", seq, itemNumber);
                    ValidationErrorInfo erroInfo2 = new ValidationErrorInfo("", billDynObj.getPkValue(), dataEntity.getDataEntityIndex(), dataEntity.getRowIndex(), "errorcode_002", "\u5e8f\u5217\u53f7\u68c0\u67e5", tipMsg, ErrorLevel.Error);
                    this.validateResult.addErrorInfo((OperateErrorInfo)erroInfo2);
                }
                if ((lotNumber = entryDynObj.getString("lotnumber")) != null && billDynObj.getString("inway").equals("2")) {
                    Iterator it = snNumberSet.iterator();
                    while (it.hasNext()) {
                        if (this.snMainCheckIsFalse((String)it.next(), lotNumber)) continue;
                        tipMsg = String.format("\u7b2c%s\u884c\u5206\u5f55\u4e2d\u5546\u54c1\u7f16\u7801\u4e3a%s\u7684\u5e8f\u5217\u53f7%s\u4e0d\u5c5e\u4e8e\u6b64\u6279\u53f7\uff0c\u8bf7\u68c0\u67e5\u3002", seq, itemNumber, snNumber);
                        erroInfo = new ValidationErrorInfo("", billDynObj.getPkValue(), dataEntity.getDataEntityIndex(), dataEntity.getRowIndex(), "errorcode_005", "\u5e8f\u5217\u53f7\u68c0\u67e5", tipMsg, ErrorLevel.Error);
                        this.validateResult.addErrorInfo((OperateErrorInfo)erroInfo);
                    }
                }
                if (snNumberSet.size() != snCount) {
                    tipMsg = String.format("\u7b2c%s\u884c\u5206\u5f55\u4e2d\u5546\u54c1\u7f16\u7801\u4e3a%s\u7684\u5e8f\u5217\u53f7\u5b58\u5728\u91cd\u590d\u3002", seq, itemNumber);
                    ValidationErrorInfo erroInfo3 = new ValidationErrorInfo("", billDynObj.getPkValue(), dataEntity.getDataEntityIndex(), dataEntity.getRowIndex(), "errorcode_001", "\u5e8f\u5217\u53f7\u68c0\u67e5", tipMsg, ErrorLevel.Error);
                    this.validateResult.addErrorInfo((OperateErrorInfo)erroInfo3);
                    continue;
                }
                int n = snSize = snEntryColl == null ? 0 : snEntryColl.size();
                if (snQty.compareTo(BigDecimal.valueOf(snSize)) != 0) {
                    tipMsg = String.format("\u7b2c%s\u884c\u5206\u5f55\u4e2d\u5546\u54c1\u7f16\u7801\u4e3a%s\u7684\u5e8f\u5217\u53f7\u6570\u91cf\u548c\u5e8f\u5217\u53f7\u8868\u8bb0\u5f55\u6761\u6570\u4e0d\u4e00\u81f4\u3002", seq, itemNumber);
                    erroInfo = new ValidationErrorInfo("", billDynObj.getPkValue(), dataEntity.getDataEntityIndex(), dataEntity.getRowIndex(), "errorcode_002", "\u5e8f\u5217\u53f7\u68c0\u67e5", tipMsg, ErrorLevel.Error);
                    this.validateResult.addErrorInfo((OperateErrorInfo)erroInfo);
                    continue;
                }
                if (snQty.compareTo(BigDecimal.ZERO) <= 0) continue;
                inWay = billDynObj.getString("inway");
                if ("2".equals(inWay)) {
                    for (DynamicObject eachSubEntry : snEntryColl) {
                        String eachNumber = eachSubEntry.getString("serialnumber");
                        boolean flag = false;
                        for (DynamicObject snDynObj : snDynObjs) {
                            if (!eachNumber.equals(snDynObj.getString("number"))) continue;
                            flag = true;
                        }
                        if (flag) continue;
                        tipMsg = String.format("\u7b2c%s\u884c\u5206\u5f55\u4e2d\u5546\u54c1\u7f16\u7801\u4e3a%s\u7684\u5e8f\u5217\u53f7\u4e0d\u5728\u5e93\uff0c\u8bf7\u68c0\u67e5", seq, eachNumber);
                        ValidationErrorInfo erroInfo4 = new ValidationErrorInfo("", billDynObj.getPkValue(), dataEntity.getDataEntityIndex(), dataEntity.getRowIndex(), "errorcode_002", "\u5e8f\u5217\u53f7\u68c0\u67e5", tipMsg, ErrorLevel.Error);
                        this.validateResult.addErrorInfo((OperateErrorInfo)erroInfo4);
                    }
                }
                for (DynamicObject snDynObj : snDynObjs) {
                    String snKey;
                    Iterator erroInfo5;
                    snStatus = snDynObj.getString("snstatus");
                    snNumber = snDynObj.getString("number");
                    String billstatus = billDynObj.getString("billstatus");
                    if (billstatus.equals("C")) continue;
                    if ("1".equals(inWay) && SnStatusEnum.INSTOCK.getValue().equals(snStatus)) {
                        tipMsg = String.format("\u7b2c%s\u884c\u5206\u5f55\u4e2d\u5546\u54c1\u7f16\u7801\u4e3a%s\u7684\u5e8f\u5217\u53f7%s\u5df2\u5728\u5e93\u3002", seq, itemNumber, snNumber);
                        erroInfo5 = new ValidationErrorInfo("", billDynObj.getPkValue(), dataEntity.getDataEntityIndex(), dataEntity.getRowIndex(), "errorcode_004", "\u5e8f\u5217\u53f7\u68c0\u67e5", tipMsg, ErrorLevel.Error);
                        this.validateResult.addErrorInfo((OperateErrorInfo)erroInfo5);
                        continue;
                    }
                    if ("1".equals(inWay) && !SnStatusEnum.ONWAY.getValue().equals(snStatus)) {
                        tipMsg = String.format("\u7b2c%s\u884c\u5206\u5f55\u4e2d\u5546\u54c1\u7f16\u7801\u4e3a%s\u7684\u5e8f\u5217\u53f7%s\u4e0d\u4e3a\u5728\u9014\u72b6\u6001\uff0c\u8bf7\u68c0\u67e5\u3002", seq, itemNumber, snNumber);
                        erroInfo5 = new ValidationErrorInfo("", billDynObj.getPkValue(), dataEntity.getDataEntityIndex(), dataEntity.getRowIndex(), "errorcode_004", "\u5e8f\u5217\u53f7\u68c0\u67e5", tipMsg, ErrorLevel.Error);
                        this.validateResult.addErrorInfo((OperateErrorInfo)erroInfo5);
                        continue;
                    }
                    if ("2".equals(inWay) && !SnStatusEnum.INSTOCK.getValue().equals(snStatus)) {
                        tipMsg = String.format("\u7b2c%s\u884c\u5206\u5f55\u4e2d\u5546\u54c1\u7f16\u7801\u4e3a%s\u7684\u5e8f\u5217\u53f7%s\u4e0d\u5728\u5e93\u3002", seq, itemNumber, snNumber);
                        erroInfo5 = new ValidationErrorInfo("", billDynObj.getPkValue(), dataEntity.getDataEntityIndex(), dataEntity.getRowIndex(), "errorcode_005", "\u5e8f\u5217\u53f7\u68c0\u67e5", tipMsg, ErrorLevel.Error);
                        this.validateResult.addErrorInfo((OperateErrorInfo)erroInfo5);
                        continue;
                    }
                    snNumberSet.clear();
                    for (DynamicObject snEntryDynObj : snEntryColl) {
                        if (!snNumber.equals(snEntryDynObj.getString("serialnumber"))) continue;
                        snEntryDynObj.set("serialid", (Object)snDynObj.getLong("id"));
                        snNumberSet.add(snEntryDynObj.getString("serialnumber"));
                    }
                    if (snNumberSet.size() <= 0) continue;
                    itemId = entryDynObj.getLong("itemid_id");
                    auxptyId = entryDynObj.getLong("auxptyid_id");
                    lotNum = entryDynObj.getString("lotnumber");
                    projectId = entryDynObj.getLong("projectid_id");
                    productDate = DateUtils.getDataFormat((Date)entryDynObj.getDate("producedate"), (boolean)true);
                    effectDate = DateUtils.getDataFormat((Date)entryDynObj.getDate("expirydate"), (boolean)false);
                    String billEntryKey = StringUtils.join((CharSequence)"_", (Object[])new Object[]{itemId, auxptyId, lotNum, projectId, productDate, effectDate});
                    if (billEntryKey.equals(snKey = StringUtils.join((CharSequence)"_", (Object[])new Object[]{snDynObj.getLong("itemid_id"), snDynObj.getLong("auxptyid_id"), snDynObj.getString("lotnum"), snDynObj.getLong("projectid_id"), DateUtils.getDataFormat((Date)snDynObj.getDate("productdate"), (boolean)true), DateUtils.getDataFormat((Date)snDynObj.getDate("effectivedate"), (boolean)false)}))) continue;
                    tipMsg = "\u7b2c%s\u884c\u5206\u5f55\u4e2d\u5546\u54c1\u7f16\u7801\u4e3a%s\u7684\u5e8f\u5217\u53f7%s\u4e0e\u5546\u54c1\u3001\u8f85\u52a9\u5c5e\u6027\u3001\u6279\u53f7\u3001\u9879\u76ee\u53f7\u3001\u751f\u4ea7\u65e5\u671f\u3001\u6709\u6548\u65e5\u671f\u81f3\u4e0d\u4e00\u81f4\u3002";
                    tipMsg = String.format(tipMsg, seq, itemNumber, snNumber);
                    ValidationErrorInfo erroInfo6 = new ValidationErrorInfo("", billDynObj.getPkValue(), dataEntity.getDataEntityIndex(), dataEntity.getRowIndex(), "errorcode_003", "\u5e8f\u5217\u53f7\u68c0\u67e5", tipMsg, ErrorLevel.Error);
                    this.validateResult.addErrorInfo((OperateErrorInfo)erroInfo6);
                }
            }
        }
        Map result = snList.stream().collect(Collectors.groupingBy(Function.identity(), Collectors.counting()));
        for (Map.Entry entry : result.entrySet()) {
            if (entry.getValue().compareTo(1L) <= 0) continue;
            tipMsg = String.format("\u5206\u5f55\u4e2d\u5e8f\u5217\u53f7%s, \u51fa\u73b0%s\u6b21\uff0c\u8bf7\u68c0\u67e5\u3002", entry.getKey(), entry.getValue());
            ValidationErrorInfo erroInfo = new ValidationErrorInfo("", alertbillDynObj.getPkValue(), this.dataEntities[0].getDataEntityIndex(), this.dataEntities[0].getRowIndex(), "errorcode_004", "\u5e8f\u5217\u53f7\u68c0\u67e5", tipMsg, ErrorLevel.Error);
            this.validateResult.addErrorInfo((OperateErrorInfo)erroInfo);
        }
    }

    private boolean snMainCheckIsFalse(String serialnumber, String lotNum) {
        Boolean status = Boolean.FALSE;
        QFilter lotnumfilter = new QFilter("lotnum", "=", (Object)lotNum);
        QFilter snfilter = new QFilter("number", "=", (Object)serialnumber);
        DynamicObject[] result = BusinessDataServiceHelper.load((String)"ocic_snmainfile", (String)"id", (QFilter[])new QFilter[]{lotnumfilter, snfilter});
        if (null != result && result.length > 0) {
            status = Boolean.TRUE;
        }
        return status;
    }

    private DynamicObject[] getSNMainFileDynObjs(ExtendedDataEntity[] billDataEntities) {
        String snNumber = "";
        HashSet<String> billSNSet = new HashSet<String>();
        for (ExtendedDataEntity dataEntity : billDataEntities) {
            DynamicObject billDynObj = dataEntity.getDataEntity();
            DynamicObjectCollection entryColl = billDynObj.getDynamicObjectCollection("billentry");
            if (entryColl == null || entryColl.size() <= 0) continue;
            for (DynamicObject entryDynObj : entryColl) {
                DynamicObject itemDynObj = entryDynObj.getDynamicObject("itemid");
                if (itemDynObj == null || itemDynObj.getLong("id") == 0L) continue;
                DynamicObjectCollection snEntryColl = entryDynObj.getDynamicObjectCollection("subentryentity");
                for (DynamicObject snEntryDynObj : snEntryColl) {
                    snNumber = snEntryDynObj.getString("serialnumber");
                    if (!StringUtils.isNotEmpty((String)snNumber)) continue;
                    billSNSet.add(snNumber);
                }
            }
        }
        QFilter filter = new QFilter("number", "in", (Object)billSNSet.toArray());
        DynamicObject[] snDynObjs = BusinessDataServiceHelper.load((String)"ocic_snmainfile", (String)String.join((CharSequence)",", "id", "number", "snstatus", "lotid", "lotnum", "itemid", "auxptyid", "auxptyid", "projectid", "productdate", "effectivedate"), (QFilter[])new QFilter[]{filter});
        return snDynObjs;
    }
}

