/*
 * Decompiled with CFR 0.152.
 */
package kd.drp.ocic.validator.inbill;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.IdentityHashMap;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.entity.validate.AbstractValidator;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.drp.mdr.common.itemcontrol.ItemSaleControlUtil;
import kd.drp.ocic.business.helper.LotHelper;
import kd.drp.ocic.util.DateUtils;
import kd.drp.ocic.util.StringUtils;

public class StockinBillCommonValidator
extends AbstractValidator {
    public void validate() {
        for (ExtendedDataEntity dataEntity : this.dataEntities) {
            DynamicObject entity = dataEntity.getDataEntity();
            this.validateBillHeader(dataEntity, entity);
            DynamicObjectCollection entries = entity.getDynamicObjectCollection("billentry");
            if (entries.size() == 0) {
                this.addErrorMessage(dataEntity, "\u81f3\u5c11\u8981\u6709\u4e00\u6761\u5206\u5f55\uff01");
            }
            ArrayList<DynamicObject> lotEntryCollection = new ArrayList<DynamicObject>();
            for (int i = 0; i < entries.getRowCount(); ++i) {
                DynamicObject entry = (DynamicObject)entries.get(i);
                if (entry == null) continue;
                this.validateEntryData(dataEntity, entry, i);
                if (entry.get("lotnumber") == null) continue;
                lotEntryCollection.add(entry);
            }
            this.examEntryLotDuplicate(dataEntity, lotEntryCollection);
        }
    }

    private String checkItemIsSaleable(DynamicObjectCollection entries, DynamicObject entity) {
        int i;
        StringBuilder sb = new StringBuilder();
        List<QFilter> itemFilters = this.getItemFilter(entity);
        DynamicObject[] validItems = BusinessDataServiceHelper.load((String)"mdr_item_info", (String)"id", (QFilter[])itemFilters.toArray(new QFilter[0]));
        ArrayList<Long> validIds = new ArrayList<Long>(8);
        for (DynamicObject validItem : validItems) {
            validIds.add(validItem.getLong("id"));
        }
        int entryRowCount = entries.size();
        for (i = 0; i < entryRowCount; ++i) {
            DynamicObject item = ((DynamicObject)entries.get(i)).getDynamicObject("itemid");
            if (null == item || validIds.contains(item.getPkValue())) continue;
            sb.append(i + 1);
            sb.append(',');
        }
        i = sb.lastIndexOf(",");
        if (0 < i) {
            sb.deleteCharAt(i);
        }
        return sb.toString();
    }

    protected List<QFilter> getItemFilter(DynamicObject entity) {
        ArrayList<QFilter> fs = new ArrayList<QFilter>(10);
        fs.add(ItemSaleControlUtil.getItemFilterUsePageCache((Object)entity.getDynamicObject("supplychannelid"), (Object)entity.getDynamicObject("inchannelid"), null));
        fs.add(new QFilter("isonsell", "=", (Object)"1"));
        fs.add(new QFilter("nonsingle", "=", (Object)"0"));
        return fs;
    }

    private void examEntryLotDuplicate(ExtendedDataEntity dataEntity, List<DynamicObject> lotEntryCollection) {
        IdentityHashMap<String, String> lotIdentities = new IdentityHashMap<String, String>();
        for (DynamicObject entryDynObj : lotEntryCollection) {
            long itemId = entryDynObj.getDynamicObject("itemid") == null ? 0L : entryDynObj.getLong("itemid_id");
            long auxptyId = entryDynObj.getDynamicObject("auxptyid") == null ? 0L : entryDynObj.getLong("auxptyid_id");
            String lotnumber = entryDynObj.getString("lotnumber");
            long lotNumberId = entryDynObj.get("lotnumberid") == null ? 0L : entryDynObj.getLong("lotnumberid_id");
            Date productDate = DateUtils.getDataFormat((Date)entryDynObj.getDate("producedate"), (boolean)true);
            Date effectDate = DateUtils.getDataFormat((Date)entryDynObj.getDate("expirydate"), (boolean)false);
            long wareHouseId = entryDynObj.getDynamicObject("warehouse") == null ? 0L : entryDynObj.getLong("warehouse_id");
            long locationId = entryDynObj.getDynamicObject("locationid") == null ? 0L : entryDynObj.getLong("locationid_id");
            long stockstatus = entryDynObj.getDynamicObject("stockstatus") == null ? 0L : entryDynObj.getLong("stockstatus_id");
            long stocktype = entryDynObj.getDynamicObject("stocktype") == null ? 0L : entryDynObj.getLong("stocktype_id");
            long ownerid = entryDynObj.getDynamicObject("ownerid") == null ? 0L : entryDynObj.getLong("ownerid_id");
            long keeperid = entryDynObj.getDynamicObject("keeperid") == null ? 0L : entryDynObj.getLong("keeperid_id");
            String lotIdentity = StringUtils.join((CharSequence)"_", (Object[])new Object[]{itemId, auxptyId, lotnumber, lotNumberId, productDate, effectDate, wareHouseId, locationId, stockstatus, stocktype, ownerid, keeperid});
            lotIdentities.put(lotnumber, lotIdentity);
        }
        HashMap countEntities = new HashMap();
        for (Map.Entry lotIdentity : lotIdentities.entrySet()) {
            if (!countEntities.containsKey(lotIdentity.getKey())) {
                HashMap lotRowEntity = new HashMap();
                lotRowEntity.put(lotIdentity.getValue(), 1);
                countEntities.put(lotIdentity.getKey(), lotRowEntity);
                continue;
            }
            if (!((Map)countEntities.get(lotIdentity.getKey())).containsKey(lotIdentity.getValue())) continue;
            HashMap revisedRowEntity = new HashMap();
            revisedRowEntity.put(lotIdentity.getValue(), (Integer)((Map)countEntities.get(lotIdentity.getKey())).get(lotIdentity.getValue()) + 1);
            countEntities.put(lotIdentity.getKey(), revisedRowEntity);
        }
        for (Map.Entry m : countEntities.entrySet()) {
            String[] rs = ((Map)m.getValue()).toString().split("=");
            String v = rs[1];
            if (((Map)m.getValue()).containsValue(1)) continue;
            this.addErrorMessage(dataEntity, "\u6279\u53f7\u4e3a" + (String)m.getKey() + "\u7684\u5206\u5f55\uff0c\u51fa\u73b0\u4e86{" + v + "\u6b21\uff0c\u8bf7\u68c0\u67e5");
        }
    }

    private void validateBillHeader(ExtendedDataEntity dataEntity, DynamicObject entity) {
        String settlecurrencyid;
        String instocktime;
        String intype;
        String supplychannelid;
        String inway;
        String sellorgchannel;
        String org;
        String inchannelid;
        DynamicObject billtypeid;
        String billno = entity.getString("billno");
        if (billno == null) {
            this.addErrorMessage(dataEntity, "\u7f3a\u5c11\u5165\u5e93\u5355\u53f7\uff01");
        }
        if ((billtypeid = entity.getDynamicObject("billtypeid")) == null) {
            this.addErrorMessage(dataEntity, "\u7f3a\u5c11\u5355\u636e\u7c7b\u578b\uff01");
        }
        if ((inchannelid = entity.getString("inchannelid")) == null) {
            this.addErrorMessage(dataEntity, "\u7f3a\u5c11\u5165\u5e93\u6e20\u9053\uff01");
        }
        if ((org = entity.getString("org")) == null) {
            this.addErrorMessage(dataEntity, "\u7f3a\u5c11\u9500\u552e\u7ec4\u7ec7\uff01");
        }
        if ((sellorgchannel = entity.getString("sellorgchannel")) == null) {
            this.addErrorMessage(dataEntity, "\u7f3a\u5c11\u9500\u552e\u7ec4\u7ec7\u6e20\u9053\uff01");
        }
        if ((inway = entity.getString("inway")) == null) {
            this.addErrorMessage(dataEntity, "\u7f3a\u5c11\u5165\u5e93\u65b9\u5411\uff01");
        }
        if ((supplychannelid = entity.getString("supplychannelid")) == null) {
            this.addErrorMessage(dataEntity, "\u7f3a\u5c11\u4f9b\u8d27\u6e20\u9053\uff01");
        }
        if ((intype = entity.getString("intype")) == null) {
            this.addErrorMessage(dataEntity, "\u7f3a\u5c11\u5165\u5e93\u65b9\u5f0f\uff01");
        }
        if ((instocktime = entity.getString("instocktime")) == null) {
            this.addErrorMessage(dataEntity, "\u7f3a\u5c11\u5165\u5e93\u65e5\u671f\uff01");
        }
        if ((settlecurrencyid = entity.getString("settlecurrencyid")) == null) {
            this.addErrorMessage(dataEntity, "\u7f3a\u5c11\u5e01\u522b\uff01");
        }
    }

    private void validateEntryData(ExtendedDataEntity dataEntity, DynamicObject entry, int i) {
        this.checkEntryCompulsory(dataEntity, entry, i);
        this.checkItemLotNumber(dataEntity, entry, i);
    }

    private void checkEntryCompulsory(ExtendedDataEntity dataEntity, DynamicObject rowObj, int rowNo) {
        DynamicObjectCollection subRowObj;
        DynamicObject location;
        DynamicObject auxpty;
        DynamicObject itemid = (DynamicObject)rowObj.get("itemid");
        if (null == itemid) {
            this.addErrorMessage(dataEntity, "\u7b2c" + (rowNo + 1) + "\u884c\uff0c\u5546\u54c1\u7f16\u7801\u4e0d\u5b58\u5728");
            return;
        }
        Boolean assistunit = (Boolean)itemid.get("hasattr");
        if (assistunit.booleanValue() && (auxpty = (DynamicObject)rowObj.get("auxptyid")) == null) {
            this.addErrorMessage(dataEntity, "\u7b2c" + (rowNo + 1) + "\u884c\uff0c\u8f85\u52a9\u5c5e\u6027\u672a\u586b\u5199");
            return;
        }
        DynamicObject unitid = (DynamicObject)rowObj.get("unitid");
        if (unitid == null) {
            this.addErrorMessage(dataEntity, "\u7b2c" + (rowNo + 1) + "\u884c\uff0c\u8ba1\u91cf\u5355\u4f4d\u4e0d\u5b58\u5728");
            return;
        }
        BigDecimal qty = (BigDecimal)rowObj.get("qty");
        if (BigDecimal.ZERO.compareTo(qty) > 0) {
            this.addErrorMessage(dataEntity, "\u7b2c" + (rowNo + 1) + "\u884c\uff0c\u6570\u91cf\u4e0d\u6b63\u786e\uff0c\u8bf7\u68c0\u67e5");
            return;
        }
        DynamicObject baseunitid = (DynamicObject)rowObj.get("baseunitid");
        if (baseunitid == null) {
            this.addErrorMessage(dataEntity, "\u7b2c" + (rowNo + 1) + "\u884c\uff0c\u57fa\u672c\u8ba1\u91cf\u5355\u4f4d\u4e0d\u5b58\u5728");
            return;
        }
        BigDecimal baseqty = (BigDecimal)rowObj.get("baseqty");
        if (BigDecimal.ZERO.compareTo(baseqty) >= 0) {
            this.addErrorMessage(dataEntity, "\u7b2c" + (rowNo + 1) + "\u884c\uff0c\u57fa\u672c\u6570\u91cf\u4e0d\u6b63\u786e\uff0c\u8bf7\u68c0\u67e5");
            return;
        }
        DynamicObject warehouse = (DynamicObject)rowObj.get("warehouse");
        if (warehouse == null) {
            this.addErrorMessage(dataEntity, "\u7b2c" + (rowNo + 1) + "\u884c\uff0c\u4ed3\u5e93\u4e0d\u5b58\u5728\uff0c\u8bf7\u68c0\u67e5");
            return;
        }
        Boolean locationStatus = (Boolean)warehouse.get("enablelocation");
        if (locationStatus.booleanValue() && (location = (DynamicObject)rowObj.get("locationid")) == null) {
            this.addErrorMessage(dataEntity, "\u7b2c" + (rowNo + 1) + "\u884c\uff0c\u4ed3\u5e93\u5df2\u542f\u7528\u4ed3\u4f4d\uff0c\u8bf7\u68c0\u67e5\u4ed3\u4f4d\u662f\u5426\u8f93\u5165");
            return;
        }
        DynamicObject stockstatus = (DynamicObject)rowObj.get("stockstatus");
        if (stockstatus == null) {
            this.addErrorMessage(dataEntity, "\u7b2c" + (rowNo + 1) + "\u884c\uff0c\u5e93\u5b58\u72b6\u6001\u4e0d\u5b58\u5728");
            return;
        }
        DynamicObject stocktype = (DynamicObject)rowObj.get("stocktype");
        if (stocktype == null) {
            this.addErrorMessage(dataEntity, "\u7b2c" + (rowNo + 1) + "\u884c\uff0c\u5e93\u5b58\u7c7b\u578b\u4e0d\u5b58\u5728");
            return;
        }
        DynamicObject ownerid = (DynamicObject)rowObj.get("ownerid");
        if (ownerid == null) {
            this.addErrorMessage(dataEntity, "\u7b2c" + (rowNo + 1) + "\u884c\uff0c\u8d27\u4e3b\u4e0d\u5b58\u5728");
            return;
        }
        String ownertype = (String)rowObj.get("ownertype");
        if (ownertype == null) {
            this.addErrorMessage(dataEntity, "\u7b2c" + (rowNo + 1) + "\u884c\uff0c\u8d27\u4e3b\u7c7b\u578b\u4e0d\u5b58\u5728");
            return;
        }
        DynamicObject keeperid = (DynamicObject)rowObj.get("keeperid");
        if (keeperid == null) {
            this.addErrorMessage(dataEntity, "\u7b2c" + (rowNo + 1) + "\u884c\uff0c\u4fdd\u7ba1\u8005\u4e0d\u5b58\u5728");
            return;
        }
        String keepertype = (String)rowObj.get("keepertype");
        if (keepertype == null) {
            this.addErrorMessage(dataEntity, "\u7b2c" + (rowNo + 1) + "\u884c\uff0c\u4fdd\u7ba1\u8005\u7c7b\u578b\u4e0d\u5b58\u5728");
            return;
        }
        boolean enableserial = itemid.getBoolean("enableserial");
        if (enableserial && (subRowObj = rowObj.getDynamicObjectCollection("subentryentity")).size() == 0) {
            this.addErrorMessage(dataEntity, "\u7b2c" + (rowNo + 1) + "\u884c\uff0c\u5546\u54c1\u5df2\u542f\u7528\u5e8f\u5217\u53f7\uff0c\u8bf7\u586b\u5199\u5e8f\u5217\u53f7");
            return;
        }
    }

    private void checkItemLotNumber(ExtendedDataEntity dataEntity, DynamicObject rowObj, int rowNo) {
        if (rowObj == null || rowObj.get("itemid") == null) {
            return;
        }
        boolean enableFlag = ((DynamicObject)rowObj.get("itemid")).getBoolean("enablelot");
        if (enableFlag) {
            DynamicObject auxpty;
            String lotNum = (String)rowObj.get("lotnumber");
            if (StringUtils.isEmpty((String)lotNum)) {
                this.addErrorMessage(dataEntity, "\u7b2c" + (rowNo + 1) + "\u884c\uff0c\u6279\u53f7\u4e3a\u7a7a\uff0c\u8bf7\u68c0\u67e5\uff01");
                return;
            }
            String itemId = ((DynamicObject)rowObj.get("itemid")).getPkValue().toString();
            String LotNumber = rowObj.get("lotnumber").toString();
            boolean assistAttr = ((DynamicObject)rowObj.get("itemid")).getBoolean("hasattr");
            String auxptyId = null;
            if (assistAttr && (auxpty = (DynamicObject)rowObj.get("auxptyid")) != null) {
                auxptyId = auxpty.getPkValue().toString();
            }
            this.checkWhetherLotNumBanned(dataEntity, itemId, LotNumber, rowNo, auxptyId);
            if (this.isOppositeDirection(dataEntity, rowNo)) {
                this.checkInWayBatchArchive(dataEntity, rowNo, rowObj);
            } else {
                this.checkItemBatchNumberExists(dataEntity, rowNo, rowObj);
            }
        }
    }

    private void checkWhetherLotNumBanned(ExtendedDataEntity dataEntity, String itemid, String number, int rowNo, String auxptyId) {
        DynamicObject[] result;
        QFilter itemidFilter = new QFilter("itemid", "=", (Object)itemid);
        QFilter idFilter = new QFilter("number", "=", (Object)number);
        QFilter enableFilter = new QFilter("enable", "=", (Object)"0");
        QFilter auxptyIdFilter = null;
        if (auxptyId != null) {
            auxptyIdFilter = new QFilter("auxptyid", "=", (Object)auxptyId);
        }
        if (null != (result = BusinessDataServiceHelper.load((String)"ocic_lot", (String)"id", (QFilter[])new QFilter[]{itemidFilter, idFilter, enableFilter, auxptyIdFilter})) && result.length > 0) {
            this.addErrorMessage(dataEntity, "\u7b2c" + (rowNo + 1) + "\u884c,\u5546\u54c1\u5b58\u5728\u7981\u7528\u7684\u6279\u53f7\uff0c\u8bf7\u68c0\u67e5");
        }
    }

    private void checkItemBatchNumberExists(ExtendedDataEntity dataEntity, int rowNo, DynamicObject rowObj) {
        boolean status = false;
        if (null != rowObj) {
            status = this.checkLotExist((String)rowObj.get("lotnumber"), rowObj);
            if (!status) {
                this.addErrorMessage(dataEntity, "\u7b2c" + (rowNo + 1) + "\u884c\uff0c\u6279\u53f7\u4e0d\u5b58\u5728\uff0c\u4e0d\u5141\u8bb8\u4fdd\u5b58\uff01");
                return;
            }
            Long lotID = this.checkLotNumber(((DynamicObject)rowObj.get("itemid")).getPkValue().toString(), rowObj.get("lotnumber").toString());
            if (lotID == 0L) {
                this.addErrorMessage(dataEntity, "\u7b2c" + (rowNo + 1) + "\u884c\uff0c\u6279\u53f7\u4e0e\u5546\u54c1\u4e0d\u4e00\u81f4\uff0c\u8bf7\u68c0\u67e5");
                return;
            }
        }
    }

    private void checkInWayBatchArchive(ExtendedDataEntity dataEntity, int rowNo, DynamicObject rowObj) {
        boolean existFlag = true;
        if (rowObj != null) {
            String LotNumber;
            existFlag = this.checkLotExist(rowObj.get("lotnumber").toString(), rowObj);
            if (!existFlag) {
                return;
            }
            String itemId = ((DynamicObject)rowObj.get("itemid")).getPkValue().toString();
            Long lotID = this.checkLotNumber(itemId, LotNumber = rowObj.get("lotnumber").toString());
            if (lotID == 0L) {
                Long returned_data = this.checkQtyFromLOtTrace(itemId, rowObj);
                if (returned_data.compareTo(1L) > 0) {
                    this.addErrorMessage(dataEntity, "\u7b2c" + (rowNo + 1) + "\u884c\uff0c\u6279\u53f7\u4e0e\u5546\u54c1\u4e0d\u4e00\u81f4\uff0c\u8bf7\u68c0\u67e5");
                    return;
                }
                if (returned_data.compareTo(2L) < 0) {
                    Long lotId = this.getLotIdFromLotTbl(itemId, rowObj);
                    ArrayList<Long> ids = new ArrayList<Long>();
                    ids.add(lotId);
                    LotHelper.deleteLot(ids, (String)"ocic_channelinbill");
                } else if (returned_data.compareTo(0L) == 0) {
                    return;
                }
            } else {
                rowObj.set("lotnumberid", (Object)lotID);
            }
        }
    }

    private Long getLotIdFromLotTbl(String itemid, DynamicObject rowObj) {
        QFilter itemIdFilter;
        Long LotId = 0L;
        String LotNumber = rowObj.get("lotnumber").toString();
        QFilter lotNumberFilter = new QFilter("number", "=", (Object)LotNumber);
        DynamicObject[] result = BusinessDataServiceHelper.load((String)"ocic_lot", (String)"id", (QFilter[])new QFilter[]{lotNumberFilter, itemIdFilter = new QFilter("itemid", "=", (Object)itemid)});
        if (null != result && result.length > 0) {
            LotId = result[0].getLong("id");
        }
        return LotId;
    }

    private Long checkQtyFromLOtTrace(String itemid, DynamicObject rowObj) {
        Long return_data = 0L;
        String LotNumber = rowObj.get("lotnumber").toString();
        Long LotId = 0L;
        QFilter lotNumberFilter = new QFilter("number", "=", (Object)LotNumber);
        QFilter itemIdFilter = new QFilter("itemid", "=", (Object)itemid);
        DynamicObject[] result = BusinessDataServiceHelper.load((String)"ocic_lot", (String)"id", (QFilter[])new QFilter[]{lotNumberFilter, itemIdFilter});
        if (null != result && result.length > 0) {
            LotId = result[0].getLong("id");
        }
        if (LotId.compareTo(0L) > 0) {
            QFilter lotIdFilter = new QFilter("lotid", "=", (Object)LotId);
            DynamicObject[] rs = BusinessDataServiceHelper.load((String)"ocic_lotmovetrack", (String)"id", (QFilter[])new QFilter[]{lotIdFilter});
            return_data = rs != null && rs.length < 2 ? Long.valueOf(1L) : Long.valueOf(2L);
        }
        return return_data;
    }

    private Boolean checkLotExist(String number, DynamicObject rowObj) {
        QFilter numberFilter;
        boolean status = false;
        if (rowObj == null) {
            return status;
        }
        DynamicObject itemid = (DynamicObject)rowObj.get("itemid");
        if (itemid == null) {
            return status;
        }
        QFilter itemIdFilter = new QFilter("itemid", "=", itemid.getPkValue());
        DynamicObject[] result = BusinessDataServiceHelper.load((String)"ocic_lot", (String)"id", (QFilter[])new QFilter[]{itemIdFilter, numberFilter = new QFilter("number", "=", (Object)number)});
        if (null != result && result.length > 0) {
            status = true;
        }
        return status;
    }

    private Long checkLotNumber(String itemid, String number) {
        Long rs = 0L;
        QFilter itemidFilter = new QFilter("itemid", "=", (Object)itemid);
        QFilter idFilter = new QFilter("number", "=", (Object)number);
        DynamicObject[] result = BusinessDataServiceHelper.load((String)"ocic_lot", (String)"id", (QFilter[])new QFilter[]{itemidFilter, idFilter});
        if (null != result && result.length > 0) {
            rs = result[0].getLong("id");
        }
        return rs;
    }

    private boolean isOppositeDirection(ExtendedDataEntity dataEntity, int rowNo) {
        String inWay = dataEntity.getDataEntity().getString("inway");
        if (inWay == null) {
            this.addErrorMessage(dataEntity, "\u7b2c" + (rowNo + 1) + "\u884c, \u5165\u5e93\u65b9\u5411\u4e0d\u5b58\u5728");
        }
        return "1".equals(inWay);
    }
}

