/*
 * Decompiled with CFR 0.152.
 */
package kd.drp.ocic.validator.inbill;

import java.math.BigDecimal;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.entity.validate.AbstractValidator;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.drp.ocic.util.StringUtils;

public class StockinBillWriteLotIdValidator
extends AbstractValidator {
    public void validate() {
        for (ExtendedDataEntity dataEntity : this.dataEntities) {
            DynamicObject entity = dataEntity.getDataEntity();
            DynamicObjectCollection entries = entity.getDynamicObjectCollection("billentry");
            for (int i = 0; i < entries.getRowCount(); ++i) {
                DynamicObject entry = (DynamicObject)entries.get(i);
                this.validateEntryData(dataEntity, entry, i);
            }
        }
    }

    private void validateEntryData(ExtendedDataEntity dataEntity, DynamicObject entry, int i) {
        this.checkItemLotNumber(dataEntity, entry, i);
    }

    private void checkItemLotNumber(ExtendedDataEntity dataEntity, DynamicObject rowObj, int rowNo) {
        if (rowObj == null || rowObj.get("itemid") == null) {
            return;
        }
        boolean enableFlag = ((DynamicObject)rowObj.get("itemid")).getBoolean("enablelot");
        if (enableFlag) {
            String lotNum = (String)rowObj.get("lotnumber");
            if (StringUtils.isEmpty((String)lotNum)) {
                return;
            }
            if (this.isOppositeDirection(dataEntity, rowNo)) {
                this.checkInWayBatchArchive(dataEntity, rowNo, rowObj);
            } else {
                this.checkItemBatchNumberExists(dataEntity, rowNo, rowObj);
            }
        }
    }

    private void checkItemBatchNumberExists(ExtendedDataEntity dataEntity, int rowNo, DynamicObject rowObj) {
        boolean status = false;
        if (null != rowObj) {
            status = this.checkLotExist((String)rowObj.get("lotnumber"));
            if (!status) {
                return;
            }
            Long lotID = this.checkLotNumberReverse(((DynamicObject)rowObj.get("itemid")).getPkValue().toString(), rowObj.get("lotnumber").toString());
            if (lotID.compareTo(0L) > 0) {
                rowObj.set("lotnumberid", (Object)lotID);
            }
        }
    }

    private void checkInWayBatchArchive(ExtendedDataEntity dataEntity, int rowNo, DynamicObject rowObj) {
        boolean existFlag = true;
        if (rowObj != null) {
            existFlag = this.checkLotExist(rowObj.get("lotnumber").toString());
            if (!existFlag) {
                return;
            }
            Long lotID = this.checkLotNumber(((DynamicObject)rowObj.get("itemid")).getPkValue().toString(), rowObj.get("lotnumber").toString());
            if (lotID == 0L) {
                return;
            }
            rowObj.set("lotnumberid", (Object)lotID);
        }
    }

    private Boolean checkLotExist(String number) {
        boolean status = false;
        QFilter numberFilter = new QFilter("number", "=", (Object)number);
        DynamicObject[] result = BusinessDataServiceHelper.load((String)"ocic_lot", (String)"id", (QFilter[])new QFilter[]{numberFilter});
        if (null != result && result.length > 0) {
            status = true;
        }
        return status;
    }

    private Long checkLotNumberReverse(String itemid, String number) {
        Long rs = 0L;
        QFilter itemidFilter = new QFilter("itemid", "=", (Object)itemid);
        QFilter idFilter = new QFilter("number", "=", (Object)number);
        QFilter enableFilter = new QFilter("enable", "=", (Object)"1");
        DynamicObject[] result = BusinessDataServiceHelper.load((String)"ocic_lot", (String)"id", (QFilter[])new QFilter[]{itemidFilter, idFilter, enableFilter});
        if (null != result && result.length > 0) {
            rs = result[0].getLong("id");
        }
        return rs;
    }

    private Long checkLotNumber(String itemid, String number) {
        Long rs = 0L;
        QFilter itemidFilter = new QFilter("itemid", "=", (Object)itemid);
        QFilter idFilter = new QFilter("number", "=", (Object)number);
        DynamicObject[] result = BusinessDataServiceHelper.load((String)"ocic_lot", (String)"id", (QFilter[])new QFilter[]{itemidFilter, idFilter});
        if (null != result && result.length > 0) {
            rs = result[0].getLong("id");
        }
        return rs;
    }

    private boolean isOppositeDirection(ExtendedDataEntity dataEntity, int rowNo) {
        String inWay = dataEntity.getDataEntity().getString("inway");
        if (inWay == null) {
            // empty if block
        }
        return "1".equals(inWay);
    }

    private void checkItemQuantity(ExtendedDataEntity entity, DynamicObject rowEntity, int rowNo) {
        BigDecimal quantity;
        if (null != rowEntity && (null == (quantity = (BigDecimal)rowEntity.get("qty")) || BigDecimal.ZERO.compareTo(quantity) >= 0)) {
            this.addErrorMessage(entity, "\u7b2c" + (rowNo + 1) + "\u884c\uff0c \u5546\u54c1\u6570\u91cf\u4e0d\u6b63\u786e\uff0c\u8bf7\u68c0\u67e5\u3002");
        }
    }
}

