/*
 * Decompiled with CFR 0.152.
 */
package kd.drp.ocic.validator.outbill;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.utils.ArrayUtils;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.entity.validate.AbstractValidator;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.drp.ocic.business.helper.LotHelper;
import kd.drp.ocic.util.StringUtils;

public class ChannelOutBillLotValidator
extends AbstractValidator {
    private ExtendedDataEntity currentDataEntity = null;
    private List<ExtendedDataEntity> oppositeBills = new ArrayList<ExtendedDataEntity>();
    private List<ExtendedDataEntity> normalBills = new ArrayList<ExtendedDataEntity>();
    private List<DynamicObject> waitCreateLotNumbers = new ArrayList<DynamicObject>();

    public void validate() {
        for (ExtendedDataEntity dataEntity : this.dataEntities) {
            if (this.isOppositiveOutDirection(dataEntity.getDataEntity())) {
                this.oppositeBills.add(dataEntity);
                this.waitCreateLotNumbers.add(dataEntity.getDataEntity());
                continue;
            }
            this.normalBills.add(dataEntity);
        }
        this.doValidatorBillEntities(this.normalBills, false);
        if (!CollectionUtils.isEmpty(this.oppositeBills)) {
            LotHelper.saveLotByDynamicObjects(this.waitCreateLotNumbers, (String)"ocic_channeloutbill");
            this.doValidatorBillEntities(this.oppositeBills, true);
        }
    }

    private void doValidatorBillEntities(List<ExtendedDataEntity> dataEntities, boolean isOppositeOut) {
        if (!CollectionUtils.isEmpty(dataEntities)) {
            Iterator<ExtendedDataEntity> iterator = dataEntities.iterator();
            while (iterator.hasNext()) {
                ExtendedDataEntity dataEntity;
                this.currentDataEntity = dataEntity = iterator.next();
                DynamicObject entity = dataEntity.getDataEntity();
                DynamicObjectCollection entries = entity.getDynamicObjectCollection("billentry");
                for (int i = 0; i < entries.getRowCount(); ++i) {
                    DynamicObject entry = (DynamicObject)entries.get(i);
                    this.validateEntryData(entry, i, isOppositeOut);
                }
            }
        }
    }

    private void validateEntryData(DynamicObject entry, int i, boolean isOppositeOut) {
        this.validateLotNumber(isOppositeOut, entry, i);
    }

    private void validateLotNumber(boolean isOppositeOut, DynamicObject entry, int i) {
        if (null == entry) {
            return;
        }
        DynamicObject item = entry.getDynamicObject("itemid");
        if (null == item) {
            return;
        }
        boolean enablelot = item.getBoolean("enablelot");
        if (!enablelot) {
            return;
        }
        String lotNum = entry.getString("lotnumber");
        DynamicObject lotId = entry.getDynamicObject("lotid");
        if (StringUtils.isEmpty((String)lotNum)) {
            this.addErrorMessage(this.currentDataEntity, "\u7b2c" + (i + 1) + "\u884c\u5206\u5f55\uff0c\u6279\u53f7\u672a\u8f93\u5165\uff1b\u8bf7\u68c0\u67e5\uff01");
            return;
        }
        Object[] lots = BusinessDataServiceHelper.load((String)"ocic_lot", (String)"id", (QFilter[])new QFilter[]{new QFilter("number", "=", (Object)lotNum).and(new QFilter("itemid", "=", item.getPkValue()))});
        if (!isOppositeOut) {
            if (ArrayUtils.isEmpty((Object[])lots)) {
                this.addErrorMessage(this.currentDataEntity, "\u7b2c" + (i + 1) + "\u884c\u5206\u5f55\uff0c\u6279\u53f7\u4e0d\u5b58\u5728\uff0c\u8bf7\u68c0\u67e5\u3002");
                return;
            }
            entry.set("lotid", lots[0].getPkValue());
        } else {
            if (null == lotId) {
                if (ArrayUtils.isEmpty((Object[])lots)) {
                    this.addErrorMessage(this.currentDataEntity, "\u7b2c" + (i + 1) + "\u884c\u5206\u5f55\uff0c\u6279\u53f7\u4e0d\u5b58\u5728\uff0c\u8bf7\u68c0\u67e5\u3002");
                    return;
                }
                entry.set("lotid", lots[0].getPkValue());
                return;
            }
            if (null != lotId && ArrayUtils.isEmpty((Object[])lots)) {
                this.addErrorMessage(this.currentDataEntity, "\u7b2c" + (i + 1) + "\u884c\u5206\u5f55\uff0c\u6279\u53f7\u4e0e\u5546\u54c1\u4e0d\u4e00\u81f4\uff0c\u8bf7\u68c0\u67e5\u3002");
                return;
            }
        }
    }

    private boolean isOppositiveOutDirection(DynamicObject entity) {
        if (null == entity) {
            return false;
        }
        String outDirection = entity.getString("outdirection");
        return "2".equals(outDirection);
    }
}

