/*
 * Decompiled with CFR 0.152.
 */
package kd.drp.ocic.validator.outbill;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.entity.operate.result.OperateErrorInfo;
import kd.bos.entity.validate.AbstractValidator;
import kd.bos.entity.validate.ErrorLevel;
import kd.bos.entity.validate.ValidationErrorInfo;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.servicehelper.BusinessDataServiceHelper;

public class ChannelOutBillUnAuditSNValidator
extends AbstractValidator {
    private Set<Long> notUnAuditSnFileIdSet = new HashSet<Long>();

    public void validate() {
        this.notUnAuditSnFileIdSet = this.getNotUnAuditSnFileIdSet(this.dataEntities);
        if (this.dataEntities == null || this.dataEntities.length == 0) {
            return;
        }
        for (ExtendedDataEntity dataEntity : this.dataEntities) {
            this.checkCanNotUnAuditEntity(dataEntity);
        }
    }

    private void checkCanNotUnAuditEntity(ExtendedDataEntity dataEntity) {
        DynamicObject billDynObj = dataEntity.getDataEntity();
        DynamicObjectCollection entryColl = billDynObj.getDynamicObjectCollection("billentry");
        if (CollectionUtils.isEmpty((Collection)entryColl)) {
            return;
        }
        long snFileId = 0L;
        String tipMsg = "";
        String itemNumber = "";
        for (DynamicObject entryDynObj : entryColl) {
            DynamicObject itemDynObj = entryDynObj.getDynamicObject("itemid");
            if (itemDynObj == null || itemDynObj.getLong("id") == 0L) continue;
            DynamicObjectCollection snEntryColl = entryDynObj.getDynamicObjectCollection("chnloutbill_sn");
            itemNumber = itemDynObj.getString("number");
            for (DynamicObject snEntryDynObj : snEntryColl) {
                snFileId = snEntryDynObj.getLong("serialid_id");
                if (!this.notUnAuditSnFileIdSet.contains(snFileId)) continue;
                tipMsg = String.format("\u5546\u54c1\u7f16\u7801\u4e3a%s\u7684\u5e8f\u5217\u53f7\u5df2\u53d1\u751f\u540e\u7eed\u4e1a\u52a1\u3002", itemNumber);
                ValidationErrorInfo erroInfo = new ValidationErrorInfo("", billDynObj.getPkValue(), dataEntity.getDataEntityIndex(), dataEntity.getRowIndex(), "errorcode_001", "\u5e8f\u5217\u53f7\u68c0\u67e5", tipMsg, ErrorLevel.Error);
                this.validateResult.addErrorInfo((OperateErrorInfo)erroInfo);
            }
        }
    }

    private Set<Long> getNotUnAuditSnFileIdSet(ExtendedDataEntity[] billDataEntities) {
        long snFileId = 0L;
        HashSet<Long> billSNSet = new HashSet<Long>();
        for (ExtendedDataEntity dataEntity : billDataEntities) {
            DynamicObject[] billDynObj = dataEntity.getDataEntity();
            DynamicObjectCollection entryColl = billDynObj.getDynamicObjectCollection("billentry");
            if (entryColl == null || entryColl.size() <= 0) continue;
            for (DynamicObject entryDynObj : entryColl) {
                DynamicObject itemDynObj = entryDynObj.getDynamicObject("itemid");
                if (itemDynObj == null || itemDynObj.getLong("id") == 0L) continue;
                DynamicObjectCollection snEntryColl = entryDynObj.getDynamicObjectCollection("chnloutbill_sn");
                for (DynamicObject snEntryDynObj : snEntryColl) {
                    snFileId = snEntryDynObj.getLong("serialid_id");
                    if (snFileId <= 0L) continue;
                    billSNSet.add(snFileId);
                }
            }
        }
        HashSet<Long> notUnAuditSnFileIdSet = new HashSet<Long>();
        if (CollectionUtils.isEmpty(billSNSet)) {
            return notUnAuditSnFileIdSet;
        }
        QFilter snFileIdFilter = new QFilter("snmainfileid", "in", (Object)billSNSet.toArray());
        DynamicObject[] trackDynObjs = BusinessDataServiceHelper.load((String)"ocic_snmovetrack", (String)String.join((CharSequence)",", "id", "snmainfileid", "billid", "billentryid", "billentityid"), (QFilter[])new QFilter[]{snFileIdFilter});
        List<Object> snDynObjTrackList = new ArrayList<DynamicObject>();
        if (trackDynObjs != null && trackDynObjs.length > 0) {
            for (DynamicObject snTrackDynObj2 : trackDynObjs) {
                snDynObjTrackList.add(snTrackDynObj2);
            }
            Map<Long, List<DynamicObject>> snTrackDynObjMap = snDynObjTrackList.stream().collect(Collectors.groupingBy(snTrackDynObj -> snTrackDynObj.getLong("snmainfileid_id")));
            DynamicObject trackDynObj = null;
            for (ExtendedDataEntity dataEntity : billDataEntities) {
                DynamicObject billDynObj = dataEntity.getDataEntity();
                DynamicObjectCollection entryColl = billDynObj.getDynamicObjectCollection("billentry");
                if (entryColl == null || entryColl.size() <= 0) continue;
                for (DynamicObject entryDynObj : entryColl) {
                    DynamicObject itemDynObj = entryDynObj.getDynamicObject("itemid");
                    if (itemDynObj == null || itemDynObj.getLong("id") == 0L) continue;
                    DynamicObjectCollection snEntryColl = entryDynObj.getDynamicObjectCollection("chnloutbill_sn");
                    for (DynamicObject snEntryDynObj : snEntryColl) {
                        snFileId = snEntryDynObj.getLong("serialid_id");
                        snDynObjTrackList = snTrackDynObjMap.get(snFileId);
                        if (snDynObjTrackList == null || (trackDynObj = (DynamicObject)(snDynObjTrackList = snDynObjTrackList.stream().sorted(Comparator.comparing(snTrackDynObj -> snTrackDynObj.getLong("id"))).collect(Collectors.toList())).get(snDynObjTrackList.size() - 1)).getLong("billid") == billDynObj.getLong("id") && trackDynObj.getLong("billentryid") == entryDynObj.getLong("id") && billDynObj.getDataEntityType().getName().equals(trackDynObj.getString("billentityid_id"))) continue;
                        notUnAuditSnFileIdSet.add(snFileId);
                    }
                }
            }
        }
        return notUnAuditSnFileIdSet;
    }
}

