/*
 * Decompiled with CFR 0.152.
 */
package kd.drp.ocic.validator.outbill;

import java.math.BigDecimal;
import java.util.ArrayList;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.entity.validate.AbstractValidator;
import kd.drp.ocic.util.StringUtils;

public class StockoutBillSaveValidator
extends AbstractValidator {
    public void validate() {
        ArrayList<String> entryKeys = new ArrayList<String>();
        for (ExtendedDataEntity dataEntity : this.dataEntities) {
            DynamicObject entity = dataEntity.getDataEntity();
            DynamicObjectCollection entries = entity.getDynamicObjectCollection("billentry");
            entryKeys.clear();
            for (DynamicObject entry : entries) {
                String itemId = "itemId_" + entry.getLong("itemid_id");
                String assistProp = "assist_" + entry.getLong("auxptyid_id");
                String lotNumber = "lotNumber_" + entry.getString("lotnumber");
                String stockId = "stockId_" + entry.getLong("stockid_id");
                String locationId = "locationId_" + entry.getLong("stockaddrid_id");
                String stockStatus = "stockStatus_" + entry.getLong("stockstatusid_id");
                String stockType = "stockType_" + entry.getLong("stocktypeid_id");
                String entryKey = StringUtils.join((CharSequence)"_", (Object[])new Object[]{itemId, assistProp, lotNumber, stockId, locationId, stockStatus, stockType});
                if (entryKeys.contains(entryKey)) {
                    this.addErrorMessage(dataEntity, "\u5b58\u5728\u76f8\u540c\u7684\u5206\u5f55\uff0c\u8bf7\u68c0\u67e5\u662f\u5426\u91cd\u590d\u5f55\u5165\u3002");
                }
                entryKeys.add(entryKey);
            }
            for (int i = 0; i < entries.getRowCount(); ++i) {
                DynamicObject entry;
                entry = (DynamicObject)entries.get(i);
                this.validateEntryData(dataEntity, entry, i);
            }
        }
    }

    private void validateEntryData(ExtendedDataEntity dataEntity, DynamicObject entry, int i) {
        this.checkItemQuantity(dataEntity, entry, i);
        this.checkAssistantProperties(dataEntity, entry, i);
        this.checkStockLocation(dataEntity, entry, i);
    }

    private void checkStockLocation(ExtendedDataEntity entity, DynamicObject rowEntity, int i) {
        DynamicObject stockLocation;
        boolean enablelocation;
        DynamicObject stock;
        if (null != rowEntity && null != (stock = rowEntity.getDynamicObject("stockid")) && (enablelocation = stock.getBoolean("enablelocation")) && null == (stockLocation = rowEntity.getDynamicObject("stockaddrid"))) {
            this.addErrorMessage(entity, "\u7b2c" + (i + 1) + "\u884c\uff0c\u4ed3\u4f4d\u4e3a\u7a7a\uff0c\u8bf7\u68c0\u67e5\u3002");
        }
    }

    private void checkItemQuantity(ExtendedDataEntity entity, DynamicObject rowEntity, int rowNo) {
        BigDecimal quantity;
        if (null != rowEntity && (null == (quantity = (BigDecimal)rowEntity.get("quantity")) || BigDecimal.ZERO.compareTo(quantity) >= 0)) {
            this.addErrorMessage(entity, "\u7b2c" + (rowNo + 1) + "\u884c\uff0c \u5546\u54c1\u6570\u91cf\u4e0d\u6b63\u786e\uff0c\u8bf7\u68c0\u67e5\u3002");
        }
    }

    private void checkAssistantProperties(ExtendedDataEntity entity, DynamicObject rowEntity, int rowNo) {
        DynamicObject auxpty;
        boolean hasattr;
        DynamicObject item;
        if (null != rowEntity && null != (item = rowEntity.getDynamicObject("itemid")) && (hasattr = item.getBoolean("hasattr")) && null == (auxpty = rowEntity.getDynamicObject("auxptyid"))) {
            this.addErrorMessage(entity, "\u7b2c" + (rowNo + 1) + "\u884c\uff0c\u5546\u54c1\u542f\u7528\u3010\u8f85\u52a9\u5c5e\u6027\u3011\uff0c\u5176\u4e3a\u5fc5\u5f55\u5b57\u6bb5\u3002");
        }
    }
}

