/*
 * Decompiled with CFR 0.152.
 */
package kd.drp.ocic.business.channelinv;

import java.math.BigDecimal;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.algo.Algo;
import kd.bos.algo.DataSet;
import kd.bos.algo.DataSetBuilder;
import kd.bos.algo.DataType;
import kd.bos.algo.Field;
import kd.bos.algo.Row;
import kd.bos.algo.RowMeta;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.entity.MainEntityType;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.MetadataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.TimeServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.drp.ocic.business.channelinv.InvValidateInfoLogger;
import kd.drp.ocic.business.helper.PrecisionAccountHelper;
import kd.drp.ocic.business.helper.UnitConvertHelper;
import kd.drp.ocic.business.sn.ValidateInfoLogger;
import kd.drp.ocic.enums.ChannelInvAccInOutTypeEnum;
import kd.drp.ocic.enums.OperateTypeEnum;
import kd.drp.ocic.pojo.ChannelInvAccLogVO;
import kd.drp.ocic.pojo.ChannelInvAccVO;
import kd.drp.ocic.util.CommonUtils;
import kd.drp.ocic.util.DateUtils;
import kd.drp.ocic.util.StringUtils;

public class InvAccProcessor {
    public final List<DynamicObject> queryChannelInvAcc(List<ChannelInvAccVO> invAccVOList) {
        if (CommonUtils.isNull(invAccVOList)) {
            return new ArrayList<DynamicObject>(0);
        }
        DynamicObject[] invAccDynObjs = this.queryChannelInvAccByVo(invAccVOList);
        List invAccDynObjList = CommonUtils.convertToList((DynamicObject[])invAccDynObjs);
        return invAccDynObjList;
    }

    public final List<DynamicObject> queryChannelInvAccByill(List<Long> billIdList) {
        if (CommonUtils.isNull(billIdList)) {
            return new ArrayList<DynamicObject>(0);
        }
        List<ChannelInvAccVO> invAccVOList = this.getChannelInvAccVo(billIdList, null);
        if (CommonUtils.isNull(invAccVOList)) {
            return new ArrayList<DynamicObject>(0);
        }
        return this.queryChannelInvAcc(invAccVOList);
    }

    public final void updateChannelInvAcc(List<ChannelInvAccVO> invAccVOList) {
        if (CommonUtils.isNull(invAccVOList)) {
            return;
        }
        invAccVOList = this.queryInvAccId(invAccVOList);
        this.batchSaveChannelInvAcc(invAccVOList);
    }

    private List<ChannelInvAccVO> queryInvAccId(List<ChannelInvAccVO> invAccVOList) {
        DynamicObject[] invAccDynObjs = this.queryChannelInvAccByVo(invAccVOList);
        ArrayList<ChannelInvAccVO> mergeInvAccVOList = new ArrayList<ChannelInvAccVO>();
        Map<String, List<ChannelInvAccVO>> invAccVOMap = invAccVOList.stream().collect(Collectors.groupingBy(invAccVO -> this.createUpdateKey((ChannelInvAccVO)invAccVO)));
        if (!CommonUtils.isNull((Object)invAccDynObjs)) {
            String invAccKeyStr = "";
            for (DynamicObject invAccDynObj : invAccDynObjs) {
                invAccKeyStr = this.getBaseDataLongPkId(invAccDynObj, "channelid") + "_" + this.getBaseDataLongPkId(invAccDynObj, "itemid") + "_" + this.getBaseDataLongPkId(invAccDynObj, "baseunitid") + "_" + this.getBaseDataLongPkId(invAccDynObj, "saleorgid") + "_" + this.getBaseDataLongPkId(invAccDynObj, "salechannelid") + "_" + this.getBaseDataLongPkId(invAccDynObj, "auxptyid") + "_" + this.getBaseDataLongPkId(invAccDynObj, "lotid") + "_" + this.getBaseDataLongPkId(invAccDynObj, "channelstockid") + "_" + this.getBaseDataLongPkId(invAccDynObj, "channellocationid") + "_" + this.getBaseDataLongPkId(invAccDynObj, "channelstockstatusid") + "_" + this.getBaseDataLongPkId(invAccDynObj, "channelstocktypeid") + "_" + this.getBaseDataLongPkId(invAccDynObj, "ownerid") + "_" + invAccDynObj.get("ownertype") + "_" + this.getBaseDataLongPkId(invAccDynObj, "keeperid") + "_" + invAccDynObj.get("keepertype") + "_" + this.getBaseDataLongPkId(invAccDynObj, "projectid") + "_" + DateUtils.getDataFormat((Date)invAccDynObj.getDate("productdate"), (boolean)true) + "_" + DateUtils.getDataFormat((Date)invAccDynObj.getDate("effectivedate"), (boolean)false);
                List<ChannelInvAccVO> existInvAccList = invAccVOMap.get(invAccKeyStr);
                if (existInvAccList == null || existInvAccList.size() <= 0) continue;
                ChannelInvAccVO invAccVO2 = existInvAccList.get(0);
                invAccVO2.setInvAccID(invAccDynObj.getLong("id"));
                BigDecimal mergeBaseQty = BigDecimal.ZERO;
                for (ChannelInvAccVO channelInvAccVO : existInvAccList) {
                    mergeBaseQty = mergeBaseQty.add(channelInvAccVO.getBaseQty());
                }
                invAccVO2.setBaseQty(mergeBaseQty);
                invAccVO2.put((Object)"billupdatekey", (Object)this.createUpdateKey(invAccVO2));
                mergeInvAccVOList.add(invAccVO2);
                invAccVOMap.remove(invAccKeyStr);
            }
        }
        if (invAccVOMap.size() > 0) {
            for (Map.Entry<String, List<ChannelInvAccVO>> entry : invAccVOMap.entrySet()) {
                List<ChannelInvAccVO> invAccList = entry.getValue();
                ChannelInvAccVO invAccVO3 = invAccList.get(0);
                BigDecimal mergeBaseQty = BigDecimal.ZERO;
                for (ChannelInvAccVO channelInvAccVO : invAccList) {
                    mergeBaseQty = mergeBaseQty.add(channelInvAccVO.getBaseQty());
                }
                invAccVO3.setBaseQty(mergeBaseQty);
                invAccVO3.put((Object)"billupdatekey", (Object)this.createUpdateKey(invAccVO3));
                mergeInvAccVOList.add(invAccVO3);
            }
        }
        return mergeInvAccVOList;
    }

    private DynamicObject[] queryChannelInvAccByVo(List<ChannelInvAccVO> invAccVOList) {
        if (CommonUtils.isNull(invAccVOList)) {
            return new DynamicObject[0];
        }
        List<QFilter> filterList = this.getFilterList(invAccVOList);
        MainEntityType type = MetadataServiceHelper.getDataEntityType((String)"ocic_channelinvacc");
        DynamicObject[] invAccDynObjs = BusinessDataServiceHelper.load((String)"ocic_channelinvacc", (String)String.join((CharSequence)",", type.getFields().keySet()), (QFilter[])filterList.toArray(new QFilter[filterList.size()]));
        return invAccDynObjs;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final Map<Long, List<String>> checkChannelInvAccData(List<Long> billIdList, OperateTypeEnum operateType) {
        ValidateInfoLogger validateInfo = new ValidateInfoLogger();
        if (CommonUtils.isNull(billIdList)) {
            return validateInfo.getValidateInfo();
        }
        List<ChannelInvAccVO> invAccVOList = this.getChannelInvAccVo(billIdList, operateType);
        if (CommonUtils.isNull(invAccVOList)) {
            return validateInfo.getValidateInfo();
        }
        DataSet channelInvAccDataSet = this.queryChannelInvAccDataSetByVo(invAccVOList);
        if (channelInvAccDataSet == null) {
            return validateInfo.getValidateInfo();
        }
        try {
            Row invAccDataSetRow = null;
            int lineseq = 0;
            long billid = 0L;
            String entrykey = "";
            while (channelInvAccDataSet.hasNext()) {
                invAccDataSetRow = channelInvAccDataSet.next();
                if (invAccDataSetRow == null) continue;
                lineseq = invAccDataSetRow.getInteger("seq");
                billid = invAccDataSetRow.getLong("billid");
                entrykey = invAccDataSetRow.getString("entrykey");
                String checkErrMsg = this.validateNegativeInventory(invAccDataSetRow);
                if ("checksuccess".equals(checkErrMsg)) continue;
                validateInfo.putBillEntryInfo(billid, entrykey, lineseq, checkErrMsg);
            }
        }
        finally {
            channelInvAccDataSet.close();
        }
        return validateInfo.getValidateInfo();
    }

    private String validateNegativeInventory(Row invAccDataSetRow) {
        String checkSNStatusMsg = "checksuccess";
        BigDecimal billSumBaseQty = invAccDataSetRow.getBigDecimal("billsumbaseqty");
        BigDecimal inStockBaseQty = invAccDataSetRow.getBigDecimal("baseqty");
        if (CommonUtils.isNull((Object)inStockBaseQty)) {
            inStockBaseQty = BigDecimal.ZERO;
        }
        String inoutType = invAccDataSetRow.getString("billinouttype");
        String negativeinventoryStr = invAccDataSetRow.getString("isnegativeinventory");
        boolean isnegativeinventory = Boolean.parseBoolean(negativeinventoryStr);
        if (!isnegativeinventory && ChannelInvAccInOutTypeEnum.OUT.getValue().equals(inoutType) && billSumBaseQty.compareTo(inStockBaseQty) > 0) {
            checkSNStatusMsg = "\u6e20\u9053\u4e0d\u80fd\u5141\u8bb8\u8d1f\u5e93\u5b58\uff1a\u6b64\u6b21\u8981\u66f4\u65b0\u7684\u6570\u91cf\u5927\u4e8e\u6e20\u9053\u5373\u65f6\u5e93\u5b58\u6570\u91cf\u3002";
            return checkSNStatusMsg;
        }
        return checkSNStatusMsg;
    }

    public final Map<Long, List<String>> updateChannelInvAccByBill(List<Long> billIdList, OperateTypeEnum operateType) {
        String checkErrMsg;
        InvValidateInfoLogger validateInfo = new InvValidateInfoLogger();
        if (CommonUtils.isNull(billIdList)) {
            return validateInfo.getValidateInfo();
        }
        List<ChannelInvAccVO> invAccVOList = this.createChannelInvAccVoByBill(billIdList, operateType);
        boolean isThrow = this.batchSaveChannelInvAcc(invAccVOList);
        if (isThrow && !"checksuccess".equals(checkErrMsg = "\u6e20\u9053\u5373\u65f6\u5e93\u5b58\u5b58\u5728\u91cd\u590d\u8bb0\u5f55\uff0c\u5e93\u5b58\u66f4\u65b0\u5931\u8d25\u3002")) {
            validateInfo.putBillEntryInfo(invAccVOList.get(0).getBillId(), invAccVOList.get(0).getBillEntryKey(), 0, checkErrMsg);
        }
        List<ChannelInvAccLogVO> invAccLogVOList = this.getChannelInvAccLogVo(billIdList);
        this.batchSaveChannelInvAccLog(invAccLogVOList);
        return validateInfo.getValidateInfo();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private List<ChannelInvAccVO> createChannelInvAccVoByBill(List<Long> billIdList, OperateTypeEnum operateType) {
        List<ChannelInvAccVO> billInvAccVOList = this.getChannelInvAccVo(billIdList, operateType);
        if (CommonUtils.isNull(billInvAccVOList)) {
            return new ArrayList<ChannelInvAccVO>();
        }
        DataSet channelInvAccDataSet = this.queryChannelInvAccDataSetByVo(billInvAccVOList);
        if (channelInvAccDataSet == null) {
            return new ArrayList<ChannelInvAccVO>();
        }
        ArrayList<ChannelInvAccVO> invBillAccVOList = new ArrayList<ChannelInvAccVO>(billInvAccVOList.size());
        try {
            Row invAccDataSetRow = null;
            while (channelInvAccDataSet.hasNext()) {
                invAccDataSetRow = channelInvAccDataSet.next();
                if (invAccDataSetRow == null) continue;
                ChannelInvAccVO invAccVO = new ChannelInvAccVO();
                invAccVO.setItemID(invAccDataSetRow.getLong("billitemid").longValue());
                invAccVO.setMaterialID(invAccDataSetRow.getLong("billmaterialid").longValue());
                invAccVO.setAuxPtyID(invAccDataSetRow.getLong("billauxptyid").longValue());
                invAccVO.setProjectID(invAccDataSetRow.getLong("billprojectid").longValue());
                invAccVO.setProductDate(invAccDataSetRow.getDate("billproductdate"));
                invAccVO.setEffectiveDate(invAccDataSetRow.getDate("billeffectivedate"));
                invAccVO.setChannelID(invAccDataSetRow.getLong("billchannelid").longValue());
                invAccVO.setSaleOrgID(invAccDataSetRow.getLong("billsaleorgid").longValue());
                invAccVO.setSaleChannelID(invAccDataSetRow.getLong("billsalechannelid").longValue());
                invAccVO.setChannelStockId(invAccDataSetRow.getLong("billchannelstockid").longValue());
                invAccVO.setChannelLocationID(invAccDataSetRow.getLong("billchannellocationid").longValue());
                invAccVO.setChannelStockStatusID(invAccDataSetRow.getLong("billchannelstockstatusid").longValue());
                invAccVO.setChannelStockTypeID(invAccDataSetRow.getLong("billchannelstocktypeid").longValue());
                invAccVO.setOwnerID(invAccDataSetRow.getLong("billownerid").longValue());
                invAccVO.setOwnerType(invAccDataSetRow.getString("billownertype"));
                invAccVO.setKeeperID(invAccDataSetRow.getLong("billkeeperid").longValue());
                invAccVO.setKeeperType(invAccDataSetRow.getString("billkeepertype"));
                invAccVO.setBaseUnitID(invAccDataSetRow.getLong("billbaseunitid").longValue());
                invAccVO.setBaseQty(invAccDataSetRow.getBigDecimal("billbaseqty"));
                invAccVO.setLotID(invAccDataSetRow.getLong("billlotid").longValue());
                invAccVO.setLotNum(invAccDataSetRow.getString("billlotnum"));
                if (ChannelInvAccInOutTypeEnum.OUT.getValue().equals(invAccDataSetRow.getString("billinouttype"))) {
                    invAccVO.setInOutType(ChannelInvAccInOutTypeEnum.OUT);
                } else {
                    invAccVO.setInOutType(ChannelInvAccInOutTypeEnum.IN);
                }
                invAccVO.put((Object)"billupdatekey", (Object)invAccDataSetRow.getString("billupdatekey"));
                if (!CommonUtils.isNull((Object)invAccDataSetRow.getLong("id"))) {
                    invAccVO.setInvAccID(invAccDataSetRow.getLong("id").longValue());
                }
                invBillAccVOList.add(invAccVO);
            }
        }
        finally {
            channelInvAccDataSet.close();
        }
        return invBillAccVOList;
    }

    private DataSet queryChannelInvAccDataSetByVo(List<ChannelInvAccVO> invAccVOList) {
        if (CommonUtils.isNull(invAccVOList)) {
            return null;
        }
        List<QFilter> filterList = this.getFilterList(invAccVOList);
        HashSet channelIdSet = new HashSet();
        DataSetBuilder dataSetBuilder = this.getDataSetBuilder();
        for (ChannelInvAccVO invAccVO : invAccVOList) {
            dataSetBuilder.append(new Object[]{invAccVO.getBillId(), invAccVO.getBillEntryId(), invAccVO.getBillEntryKey(), invAccVO.getEntrySeq(), invAccVO.getInOutType().getValue(), invAccVO.getSaleOrgID(), invAccVO.getSaleChannelID(), invAccVO.getChannelID(), invAccVO.getItemID(), invAccVO.getMaterialID(), invAccVO.getAuxPtyID(), invAccVO.getLotID(), invAccVO.getLotNum(), invAccVO.getChannelStockId(), invAccVO.getChannelLocationID(), invAccVO.getChannelStockStatusID(), invAccVO.getChannelStockTypeID(), invAccVO.getOwnerID(), invAccVO.getOwnerType(), invAccVO.getKeeperID(), invAccVO.getKeeperType(), invAccVO.getProjectID(), invAccVO.getProductDate(), invAccVO.getEffectiveDate(), invAccVO.getBaseUnitID(), invAccVO.getBaseQty(), this.createUpdateKey(invAccVO)});
            CommonUtils.collectionAddValue(channelIdSet, (Object)invAccVO.getChannelID());
        }
        DataSet billDataSet = dataSetBuilder.build();
        DataSet groupBillDataSet = billDataSet.copy();
        groupBillDataSet = groupBillDataSet.groupBy(new String[]{"billupdatekey"}).sum("billbaseqty").finish();
        DataSet mergeBillDataSet = billDataSet.leftJoin(groupBillDataSet).on("billupdatekey", "billupdatekey").select(billDataSet.getRowMeta().getFieldNames(), new String[]{"billbaseqty as billsumbaseqty"}).finish();
        MainEntityType type = MetadataServiceHelper.getDataEntityType((String)"ocic_channelinvacc");
        DataSet invAccDataSet = QueryServiceHelper.queryDataSet((String)InvAccProcessor.class.getName(), (String)"ocic_channelinvacc", (String)("id," + String.join((CharSequence)",", type.getFields().keySet())), (QFilter[])filterList.toArray(new QFilter[filterList.size()]), null);
        DataSet billInvAccDataSet = mergeBillDataSet.leftJoin(invAccDataSet).on("billsaleorgid", "saleorgid").on("billsalechannelid", "salechannelid").on("billchannelid", "channelid").on("billitemid", "itemid").on("billmaterialid", "materialid").on("billauxptyid", "auxptyid").on("billlotid", "lotid").on("billlotnum", "lotnum").on("billchannelstockid", "channelstockid").on("billchannellocationid", "channellocationid").on("billchannelstockstatusid", "channelstockstatusid").on("billchannelstocktypeid", "channelstocktypeid").on("billownerid", "ownerid").on("billownertype", "ownertype").on("billkeeperid", "keeperid").on("billkeepertype", "keepertype").on("billprojectid", "projectid").on("billproductdate", "productdate").on("billeffectivedate", "effectivedate").on("billbaseunitid", "baseunitid").select(mergeBillDataSet.getRowMeta().getFieldNames(), invAccDataSet.getRowMeta().getFieldNames()).finish();
        if (channelIdSet.size() > 0) {
            QFilter qfilter = new QFilter("id", "in", (Object)channelIdSet.toArray());
            DataSet channelinfoDataSet = QueryServiceHelper.queryDataSet((String)InvAccProcessor.class.getName(), (String)"mdr_customer", (String)StringUtils.join((CharSequence)",", (Object[])new Object[]{"id", "isnegativeinventory"}), (QFilter[])qfilter.toArray(), null);
            DataSet result = billInvAccDataSet.leftJoin(channelinfoDataSet).on("billchannelid", "id").select(billInvAccDataSet.getRowMeta().getFieldNames(), new String[]{"isnegativeinventory"}).finish();
            return result.orderBy(new String[]{"billid", "entryid", "seq"});
        }
        ArrayList<Field> fieldList = new ArrayList<Field>();
        fieldList.add(new Field("id", (DataType)DataType.StringType));
        fieldList.add(new Field("isnegativeinventory", (DataType)DataType.StringType));
        RowMeta rowMeta = new RowMeta(fieldList.toArray(new Field[fieldList.size()]));
        DataSetBuilder channelDataSetBuilder = Algo.create((String)"channelinfo").createDataSetBuilder(rowMeta);
        for (ChannelInvAccVO invAccVO : invAccVOList) {
            channelDataSetBuilder.append(new Object[]{this.createUpdateKey(invAccVO), "true"});
        }
        DataSet channelinfoDataSet = dataSetBuilder.build();
        DataSet result = billInvAccDataSet.leftJoin(channelinfoDataSet).on("billupdatekey", "id").select(billInvAccDataSet.getRowMeta().getFieldNames(), new String[]{"isnegativeinventory"}).finish();
        return result.orderBy(new String[]{"billid", "entryid", "seq"});
    }

    private List<QFilter> getFilterList(List<ChannelInvAccVO> invAccVOList) {
        Integer listSize = invAccVOList.size();
        ArrayList<QFilter> filterList = new ArrayList<QFilter>(listSize);
        HashSet channelIdSet = new HashSet(listSize);
        HashSet itemIdSet = new HashSet(listSize);
        HashSet saleOrgIdSet = new HashSet(listSize);
        HashSet saleChannelIdSet = new HashSet(listSize);
        HashSet auxPtyIdSet = new HashSet(listSize);
        HashSet lotIdSet = new HashSet(listSize);
        HashSet stockIdSet = new HashSet(listSize);
        HashSet locationIdSet = new HashSet(listSize);
        HashSet stockStatusIdSet = new HashSet(listSize);
        HashSet stockTypeIdSet = new HashSet(listSize);
        HashSet ownerIdSet = new HashSet(listSize);
        HashSet ownerTypeIdSet = new HashSet(listSize);
        HashSet keeperIdSet = new HashSet(listSize);
        HashSet keeperTypeIdSet = new HashSet(listSize);
        HashSet projectIdSet = new HashSet(listSize);
        HashSet productDateSet = new HashSet(listSize);
        HashSet effectiveDateSet = new HashSet(listSize);
        HashSet baseUnitIdSet = new HashSet(listSize);
        for (ChannelInvAccVO invAccVO : invAccVOList) {
            CommonUtils.collectionAddValue(channelIdSet, (Object)invAccVO.getChannelID());
            CommonUtils.collectionAddValue(itemIdSet, (Object)invAccVO.getItemID());
            CommonUtils.collectionAddValue(saleOrgIdSet, (Object)invAccVO.getSaleOrgID());
            CommonUtils.collectionAddValue(saleChannelIdSet, (Object)invAccVO.getSaleChannelID());
            CommonUtils.collectionAddValue(auxPtyIdSet, (Object)invAccVO.getAuxPtyID());
            CommonUtils.collectionAddValue(lotIdSet, (Object)invAccVO.getLotID());
            CommonUtils.collectionAddValue(stockIdSet, (Object)invAccVO.getChannelStockId());
            CommonUtils.collectionAddValue(locationIdSet, (Object)invAccVO.getChannelLocationID());
            CommonUtils.collectionAddValue(stockStatusIdSet, (Object)invAccVO.getChannelStockStatusID());
            CommonUtils.collectionAddValue(stockTypeIdSet, (Object)invAccVO.getChannelStockTypeID());
            CommonUtils.collectionAddValue(ownerIdSet, (Object)invAccVO.getOwnerID());
            CommonUtils.collectionAddValue(ownerTypeIdSet, (Object)invAccVO.getOwnerType());
            CommonUtils.collectionAddValue(keeperIdSet, (Object)invAccVO.getKeeperID());
            CommonUtils.collectionAddValue(keeperTypeIdSet, (Object)invAccVO.getKeeperType());
            CommonUtils.collectionAddValue(projectIdSet, (Object)invAccVO.getProjectID());
            CommonUtils.collectionAddValue(productDateSet, (Object)invAccVO.getProductDate());
            CommonUtils.collectionAddValue(effectiveDateSet, (Object)invAccVO.getEffectiveDate());
            CommonUtils.collectionAddValue(baseUnitIdSet, (Object)invAccVO.getBaseUnitID());
        }
        if (channelIdSet.size() > 0) {
            filterList.add(new QFilter("channelid", "in", (Object)channelIdSet.toArray()));
        }
        if (itemIdSet.size() > 0) {
            filterList.add(new QFilter("itemid", "in", (Object)itemIdSet.toArray()));
        }
        if (saleOrgIdSet.size() > 0) {
            filterList.add(new QFilter("saleorgid", "in", (Object)saleOrgIdSet.toArray()));
        }
        if (saleChannelIdSet.size() > 0) {
            filterList.add(new QFilter("salechannelid", "in", (Object)saleChannelIdSet.toArray()));
        }
        if (auxPtyIdSet.size() > 0) {
            filterList.add(new QFilter("auxptyid", "in", (Object)auxPtyIdSet.toArray()));
        }
        if (lotIdSet.size() > 0) {
            filterList.add(new QFilter("lotid", "in", (Object)lotIdSet.toArray()));
        }
        if (stockIdSet.size() > 0) {
            filterList.add(new QFilter("channelstockid", "in", (Object)stockIdSet.toArray()));
        }
        if (locationIdSet.size() > 0) {
            filterList.add(new QFilter("channellocationid", "in", (Object)locationIdSet.toArray()));
        }
        if (stockStatusIdSet.size() > 0) {
            filterList.add(new QFilter("channelstockstatusid", "in", (Object)stockStatusIdSet.toArray()));
        }
        if (stockTypeIdSet.size() > 0) {
            filterList.add(new QFilter("channelstocktypeid", "in", (Object)stockTypeIdSet.toArray()));
        }
        if (ownerIdSet.size() > 0) {
            filterList.add(new QFilter("ownerid", "in", (Object)ownerIdSet.toArray()));
        }
        if (ownerTypeIdSet.size() > 0) {
            filterList.add(new QFilter("ownertype", "in", (Object)ownerTypeIdSet.toArray()));
        }
        if (keeperIdSet.size() > 0) {
            filterList.add(new QFilter("keeperid", "in", (Object)keeperIdSet.toArray()));
        }
        if (keeperTypeIdSet.size() > 0) {
            filterList.add(new QFilter("keepertype", "in", (Object)keeperTypeIdSet.toArray()));
        }
        if (projectIdSet.size() > 0) {
            filterList.add(new QFilter("projectid", "in", (Object)projectIdSet.toArray()));
        }
        if (productDateSet.size() > 0) {
            filterList.add(new QFilter("productdate", "in", (Object)productDateSet.toArray()));
        }
        if (effectiveDateSet.size() > 0) {
            filterList.add(new QFilter("effectivedate", "in", (Object)effectiveDateSet.toArray()));
        }
        if (baseUnitIdSet.size() > 0) {
            filterList.add(new QFilter("baseunitid", "in", (Object)baseUnitIdSet.toArray()));
        }
        return filterList;
    }

    private DataSetBuilder getDataSetBuilder() {
        ArrayList<Field> fieldList = new ArrayList<Field>(38);
        fieldList.add(new Field("billid", (DataType)DataType.LongType));
        fieldList.add(new Field("entryid", (DataType)DataType.LongType));
        fieldList.add(new Field("entrykey", (DataType)DataType.StringType));
        fieldList.add(new Field("seq", (DataType)DataType.LongType));
        fieldList.add(new Field("billinouttype", (DataType)DataType.StringType));
        fieldList.add(new Field("billsaleorgid", (DataType)DataType.LongType));
        fieldList.add(new Field("billsalechannelid", (DataType)DataType.LongType));
        fieldList.add(new Field("billchannelid", (DataType)DataType.LongType));
        fieldList.add(new Field("billitemid", (DataType)DataType.LongType));
        fieldList.add(new Field("billmaterialid", (DataType)DataType.LongType));
        fieldList.add(new Field("billauxptyid", (DataType)DataType.LongType));
        fieldList.add(new Field("billlotid", (DataType)DataType.LongType));
        fieldList.add(new Field("billlotnum", (DataType)DataType.StringType));
        fieldList.add(new Field("billchannelstockid", (DataType)DataType.LongType));
        fieldList.add(new Field("billchannellocationid", (DataType)DataType.LongType));
        fieldList.add(new Field("billchannelstockstatusid", (DataType)DataType.LongType));
        fieldList.add(new Field("billchannelstocktypeid", (DataType)DataType.LongType));
        fieldList.add(new Field("billownerid", (DataType)DataType.LongType));
        fieldList.add(new Field("billownertype", (DataType)DataType.StringType));
        fieldList.add(new Field("billkeeperid", (DataType)DataType.LongType));
        fieldList.add(new Field("billkeepertype", (DataType)DataType.StringType));
        fieldList.add(new Field("billprojectid", (DataType)DataType.LongType));
        fieldList.add(new Field("billproductdate", (DataType)DataType.DateType));
        fieldList.add(new Field("billeffectivedate", (DataType)DataType.DateType));
        fieldList.add(new Field("billbaseunitid", (DataType)DataType.LongType));
        fieldList.add(new Field("billbaseqty", (DataType)DataType.BigDecimalType));
        fieldList.add(new Field("billupdatekey", (DataType)DataType.StringType));
        RowMeta rowMeta = new RowMeta(fieldList.toArray(new Field[fieldList.size()]));
        DataSetBuilder dataSetBuilder = Algo.create((String)"entryidToChannelInvAcc").createDataSetBuilder(rowMeta);
        return dataSetBuilder;
    }

    private String createUpdateKey(ChannelInvAccVO invAccVO) {
        String invAccKeyStr = StringUtils.join((CharSequence)"_", (Object[])new Object[]{invAccVO.getChannelID(), invAccVO.getItemID(), invAccVO.getBaseUnitID(), invAccVO.getSaleOrgID(), invAccVO.getSaleChannelID(), invAccVO.getAuxPtyID(), invAccVO.getLotID(), invAccVO.getChannelStockId(), invAccVO.getChannelLocationID(), invAccVO.getChannelStockStatusID(), invAccVO.getChannelStockTypeID(), invAccVO.getOwnerID(), invAccVO.getOwnerType(), invAccVO.getKeeperID(), invAccVO.getKeeperType(), invAccVO.getProjectID(), DateUtils.getDataFormat((Date)invAccVO.getProductDate(), (boolean)true), DateUtils.getDataFormat((Date)invAccVO.getEffectiveDate(), (boolean)false)});
        return invAccKeyStr;
    }

    private boolean batchSaveChannelInvAcc(List<ChannelInvAccVO> invAccVOList) {
        if (CommonUtils.isNull(invAccVOList)) {
            return false;
        }
        boolean isThrow = false;
        ArrayList<DynamicObject> invAccDynObjList = new ArrayList<DynamicObject>(16);
        List invAccIdList = invAccVOList.stream().filter(invAccVO -> invAccVO.getInvAccID() > 0L).map(ChannelInvAccVO::getInvAccID).collect(Collectors.toList());
        DynamicObject[] invAccDynObjs = BusinessDataServiceHelper.load((Object[])invAccIdList.toArray(), (DynamicObjectType)MetadataServiceHelper.getDataEntityType((String)"ocic_channelinvacc"));
        DynamicObject newInvAccDynObj = null;
        BigDecimal baseQty = BigDecimal.ZERO;
        BigDecimal stockQty = BigDecimal.ZERO;
        BigDecimal assistQty = BigDecimal.ZERO;
        long stockUnitId = 0L;
        long assistUnitId = 0L;
        List itemIDList = invAccVOList.stream().filter(invAccVO -> invAccVO.getItemID() > 0L).map(ChannelInvAccVO::getItemID).collect(Collectors.toList());
        QFilter filter = new QFilter("id", "in", itemIDList);
        Map itemDynObjMap = BusinessDataServiceHelper.loadFromCache((String)"mdr_item_info", (String)StringUtils.join((CharSequence)",", (Object[])new Object[]{"stockunit", "assistunit"}), (QFilter[])new QFilter[]{filter});
        for (ChannelInvAccVO invAccVO2 : invAccVOList) {
            if (invAccVO2.getInvAccID() > 0L) {
                for (DynamicObject dynObj : invAccDynObjs) {
                    if (invAccVO2.getInvAccID() != dynObj.getLong("id")) continue;
                    newInvAccDynObj = dynObj;
                }
            } else {
                newInvAccDynObj = BusinessDataServiceHelper.newDynamicObject((String)"ocic_channelinvacc");
            }
            if (invAccVO2.getInvAccID() <= 0L) {
                newInvAccDynObj.set("saleorgid", (Object)invAccVO2.getSaleOrgID());
                newInvAccDynObj.set("salechannelid", (Object)invAccVO2.getSaleChannelID());
                newInvAccDynObj.set("channelid", (Object)invAccVO2.getChannelID());
                newInvAccDynObj.set("itemid", (Object)invAccVO2.getItemID());
                newInvAccDynObj.set("materialid", (Object)invAccVO2.getMaterialID());
                newInvAccDynObj.set("auxptyid", (Object)invAccVO2.getAuxPtyID());
                newInvAccDynObj.set("lotnum", (Object)invAccVO2.getLotNum());
                newInvAccDynObj.set("lotid", (Object)invAccVO2.getLotID());
                newInvAccDynObj.set("channelstockid", (Object)invAccVO2.getChannelStockId());
                newInvAccDynObj.set("channellocationid", (Object)invAccVO2.getChannelLocationID());
                newInvAccDynObj.set("channelstockstatusid", (Object)invAccVO2.getChannelStockStatusID());
                newInvAccDynObj.set("channelstocktypeid", (Object)invAccVO2.getChannelStockTypeID());
                newInvAccDynObj.set("ownerid", (Object)invAccVO2.getOwnerID());
                newInvAccDynObj.set("ownertype", (Object)invAccVO2.getOwnerType());
                newInvAccDynObj.set("keeperid", (Object)invAccVO2.getKeeperID());
                newInvAccDynObj.set("keepertype", (Object)invAccVO2.getKeeperType());
                newInvAccDynObj.set("projectid", (Object)invAccVO2.getProjectID());
                newInvAccDynObj.set("productdate", (Object)invAccVO2.getProductDate());
                newInvAccDynObj.set("effectivedate", (Object)invAccVO2.getEffectiveDate());
                newInvAccDynObj.set("baseunitid", (Object)invAccVO2.getBaseUnitID());
                baseQty = PrecisionAccountHelper.dealWithprecision(invAccVO2.getBaseUnitID(), invAccVO2.getBaseQty());
                baseQty = ChannelInvAccInOutTypeEnum.IN.equals((Object)invAccVO2.getInOutType()) ? baseQty : baseQty.negate();
                newInvAccDynObj.set("creator", (Object)RequestContext.get().getUserId());
                newInvAccDynObj.set("createtime", (Object)TimeServiceHelper.now());
                newInvAccDynObj.set("updatekey", invAccVO2.get((Object)"billupdatekey"));
            } else {
                baseQty = newInvAccDynObj.getBigDecimal("baseqty");
                baseQty = ChannelInvAccInOutTypeEnum.IN.equals((Object)invAccVO2.getInOutType()) ? baseQty.add(invAccVO2.getBaseQty()) : baseQty.subtract(invAccVO2.getBaseQty());
                baseQty = PrecisionAccountHelper.dealWithprecision(invAccVO2.getBaseUnitID(), baseQty);
                newInvAccDynObj.set("modifier", (Object)RequestContext.get().getUserId());
                newInvAccDynObj.set("modifytime", (Object)TimeServiceHelper.now());
            }
            if (itemDynObjMap.containsKey(invAccVO2.getItemID())) {
                stockUnitId = this.getBaseDataLongPkId((DynamicObject)itemDynObjMap.get(invAccVO2.getItemID()), "stockunit");
                assistUnitId = this.getBaseDataLongPkId((DynamicObject)itemDynObjMap.get(invAccVO2.getItemID()), "assistunit");
            }
            stockQty = UnitConvertHelper.calculateDestQty(baseQty, invAccVO2.getMaterialID(), invAccVO2.getBaseUnitID(), stockUnitId);
            assistQty = UnitConvertHelper.calculateDestQty(baseQty, invAccVO2.getMaterialID(), invAccVO2.getBaseUnitID(), assistUnitId);
            newInvAccDynObj.set("baseqty", (Object)baseQty);
            newInvAccDynObj.set("stockunitid", (Object)stockUnitId);
            newInvAccDynObj.set("stockqty", (Object)stockQty);
            newInvAccDynObj.set("assistunitid", (Object)assistUnitId);
            newInvAccDynObj.set("assistqty", (Object)assistQty);
            invAccDynObjList.add(newInvAccDynObj);
        }
        try {
            SaveServiceHelper.save((DynamicObject[])invAccDynObjList.toArray(new DynamicObject[invAccDynObjList.size()]));
        }
        catch (Throwable ex) {
            Throwable cause = ex.getCause();
            if (cause instanceof SQLException) {
                String errMsg = cause.getMessage();
                if (StringUtils.isNotEmpty((String)errMsg) && errMsg.indexOf("IDX_OCIC_CHANNELINVACC_KEY") != -1) {
                    isThrow = true;
                }
                throw ex;
            }
            throw ex;
        }
        return isThrow;
    }

    private void batchSaveChannelInvAccLog(List<ChannelInvAccLogVO> invAccVOList) {
        if (invAccVOList == null || invAccVOList.size() == 0) {
            return;
        }
        ArrayList<DynamicObject> invAccDynObjList = new ArrayList<DynamicObject>(10);
        DynamicObject newInvAccDynObj = null;
        BigDecimal baseQty = BigDecimal.ZERO;
        BigDecimal stockQty = BigDecimal.ZERO;
        BigDecimal assistQty = BigDecimal.ZERO;
        for (ChannelInvAccLogVO invAccLogVO : invAccVOList) {
            newInvAccDynObj = BusinessDataServiceHelper.newDynamicObject((String)"ocic_channelinvacclog");
            newInvAccDynObj.set("saleorgid", (Object)invAccLogVO.getSaleOrgID());
            newInvAccDynObj.set("salechannelid", (Object)invAccLogVO.getSaleChannelID());
            newInvAccDynObj.set("channelid", (Object)invAccLogVO.getChannelID());
            newInvAccDynObj.set("itemid", (Object)invAccLogVO.getItemID());
            newInvAccDynObj.set("auxptyid", (Object)invAccLogVO.getAuxPtyID());
            newInvAccDynObj.set("lotnum", (Object)invAccLogVO.getLotNum());
            newInvAccDynObj.set("channelstockid", (Object)invAccLogVO.getChannelStockId());
            newInvAccDynObj.set("channellocationid", (Object)invAccLogVO.getChannelLocationID());
            newInvAccDynObj.set("channelstockstatusid", (Object)invAccLogVO.getChannelStockStatusID());
            newInvAccDynObj.set("channelstocktypeid", (Object)invAccLogVO.getChannelStockTypeID());
            newInvAccDynObj.set("ownerid", (Object)invAccLogVO.getOwnerID());
            newInvAccDynObj.set("ownertype", (Object)invAccLogVO.getOwnerType());
            newInvAccDynObj.set("keeperid", (Object)invAccLogVO.getKeeperID());
            newInvAccDynObj.set("keepertype", (Object)invAccLogVO.getKeeperType());
            newInvAccDynObj.set("projectid", (Object)invAccLogVO.getProjectID());
            newInvAccDynObj.set("productdate", (Object)invAccLogVO.getProductDate());
            newInvAccDynObj.set("effectivedate", (Object)invAccLogVO.getEffectiveDate());
            baseQty = PrecisionAccountHelper.dealWithprecision(invAccLogVO.getBaseUnitID(), invAccLogVO.getBaseQty());
            stockQty = UnitConvertHelper.calculateDestQty(baseQty, invAccLogVO.getMaterialID(), invAccLogVO.getBaseUnitID(), invAccLogVO.getStockUnitId());
            assistQty = UnitConvertHelper.calculateDestQty(baseQty, invAccLogVO.getMaterialID(), invAccLogVO.getBaseUnitID(), invAccLogVO.getAssistUnitId());
            newInvAccDynObj.set("baseunitid", (Object)invAccLogVO.getBaseUnitID());
            newInvAccDynObj.set("baseqty", (Object)baseQty);
            newInvAccDynObj.set("stockunitid", (Object)invAccLogVO.getStockUnitId());
            newInvAccDynObj.set("stockqty", (Object)stockQty);
            newInvAccDynObj.set("assistunitid", (Object)invAccLogVO.getAssistUnitId());
            newInvAccDynObj.set("assistqty", (Object)assistQty);
            newInvAccDynObj.set("billid", (Object)invAccLogVO.getBillID());
            newInvAccDynObj.set("billentityid", (Object)invAccLogVO.getBillEntityID());
            newInvAccDynObj.set("billno", (Object)invAccLogVO.getBillNo());
            newInvAccDynObj.set("billentryid", (Object)invAccLogVO.getBillEntryID());
            newInvAccDynObj.set("creator", (Object)RequestContext.get().getUserId());
            newInvAccDynObj.set("createtime", (Object)TimeServiceHelper.now());
            invAccDynObjList.add(newInvAccDynObj);
        }
        SaveServiceHelper.save((DynamicObject[])invAccDynObjList.toArray(new DynamicObject[invAccDynObjList.size()]));
    }

    protected List<ChannelInvAccVO> getChannelInvAccVo(List<Long> billIdList, OperateTypeEnum operateType) {
        return null;
    }

    protected List<ChannelInvAccLogVO> getChannelInvAccLogVo(List<Long> billIdList) {
        return null;
    }

    protected long getBaseDataLongPkId(DynamicObject billDynObj, String fieldKey) {
        return billDynObj.getLong(fieldKey + "_id");
    }

    protected String getBaseDataStringPkId(DynamicObject billDynObj, String fieldKey) {
        return billDynObj.getString(fieldKey + "_id");
    }
}

