/*
 * Decompiled with CFR 0.152.
 */
package kd.drp.ocic.business.channelinv;

import java.util.ArrayList;
import java.util.List;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.MetadataServiceHelper;
import kd.drp.ocic.business.channelinv.InvAccProcessor;
import kd.drp.ocic.enums.ChannelInvAccInOutTypeEnum;
import kd.drp.ocic.enums.OperateTypeEnum;
import kd.drp.ocic.pojo.ChannelInvAccLogVO;
import kd.drp.ocic.pojo.ChannelInvAccVO;

public class RetailBillInvAccProcessor
extends InvAccProcessor {
    @Override
    protected List<ChannelInvAccVO> getChannelInvAccVo(List<Long> billIdList, OperateTypeEnum operateType) {
        DynamicObject[] billDynObjs;
        ArrayList<ChannelInvAccVO> invAccVOList = new ArrayList<ChannelInvAccVO>();
        if (billIdList == null || billIdList.size() == 0) {
            return invAccVOList;
        }
        for (DynamicObject retailBillDynObj : billDynObjs = BusinessDataServiceHelper.load((Object[])billIdList.toArray(), (DynamicObjectType)MetadataServiceHelper.getDataEntityType((String)"ococ_retailbill"))) {
            DynamicObjectCollection entryColl = retailBillDynObj.getDynamicObjectCollection("entryentity");
            if (entryColl == null || entryColl.size() <= 0) continue;
            for (DynamicObject entryDynObj : entryColl) {
                ChannelInvAccVO invAccVO = new ChannelInvAccVO();
                if (!"B".equalsIgnoreCase(entryDynObj.getString("stockupdate"))) continue;
                invAccVO.setItemID(this.getBaseDataLongPkId(entryDynObj, "goodsid"));
                invAccVO.setMaterialID(this.getBaseDataLongPkId(entryDynObj, "materialid"));
                invAccVO.setAuxPtyID(this.getBaseDataLongPkId(entryDynObj, "auxpropid"));
                invAccVO.setProductDate(entryDynObj.getDate("productdate"));
                invAccVO.setEffectiveDate(entryDynObj.getDate("expirydate"));
                invAccVO.setChannelID(this.getBaseDataLongPkId(retailBillDynObj, "branchid"));
                invAccVO.setSaleOrgID(this.getBaseDataLongPkId(retailBillDynObj, "bizorgid"));
                invAccVO.setSaleChannelID(this.getBaseDataLongPkId(retailBillDynObj, "branchid"));
                invAccVO.setChannelStockId(this.getBaseDataLongPkId(entryDynObj, "stockid"));
                invAccVO.setChannelLocationID(this.getBaseDataLongPkId(entryDynObj, "stockpositionid"));
                invAccVO.setChannelStockStatusID(this.getBaseDataLongPkId(entryDynObj, "channelstockstatusid"));
                invAccVO.setChannelStockTypeID(this.getBaseDataLongPkId(entryDynObj, "channelstocktypeid"));
                invAccVO.setOwnerID(this.getBaseDataLongPkId(entryDynObj, "ownerid"));
                invAccVO.setOwnerType(entryDynObj.getString("ownertype"));
                invAccVO.setKeeperID(this.getBaseDataLongPkId(entryDynObj, "keeperid"));
                invAccVO.setKeeperType(entryDynObj.getString("keepertype"));
                invAccVO.setBaseUnitID(this.getBaseDataLongPkId(entryDynObj, "baseunitid"));
                invAccVO.setBaseQty(entryDynObj.getBigDecimal("baseunitqty"));
                invAccVO.setLotID(this.getBaseDataLongPkId(entryDynObj, "lotid"));
                invAccVO.setLotNum(entryDynObj.getString("lotno"));
                if (OperateTypeEnum.AUDIT.equals((Object)operateType)) {
                    invAccVO.setInOutType(ChannelInvAccInOutTypeEnum.OUT);
                } else {
                    invAccVO.setInOutType(ChannelInvAccInOutTypeEnum.IN);
                }
                invAccVO.setBillId(retailBillDynObj.getLong("id"));
                invAccVO.setBillEntryId(entryDynObj.getLong("id"));
                invAccVO.setBillEntryKey("entryentity");
                invAccVO.setEntrySeq(entryDynObj.getLong("seq"));
                invAccVOList.add(invAccVO);
            }
        }
        return invAccVOList;
    }

    @Override
    protected List<ChannelInvAccLogVO> getChannelInvAccLogVo(List<Long> billIdList) {
        DynamicObject[] billDynObjs;
        ArrayList<ChannelInvAccLogVO> invAccLogVOList = new ArrayList<ChannelInvAccLogVO>();
        if (billIdList == null || billIdList.size() == 0) {
            return invAccLogVOList;
        }
        for (DynamicObject retailBillDynObj : billDynObjs = BusinessDataServiceHelper.load((Object[])billIdList.toArray(), (DynamicObjectType)MetadataServiceHelper.getDataEntityType((String)"ococ_retailbill"))) {
            DynamicObjectCollection entryColl = retailBillDynObj.getDynamicObjectCollection("entryentity");
            if (entryColl == null || entryColl.size() <= 0) continue;
            for (DynamicObject entryDynObj : entryColl) {
                ChannelInvAccLogVO invAccLotVO = new ChannelInvAccLogVO();
                invAccLotVO.setItemID(this.getBaseDataLongPkId(entryDynObj, "goodsid"));
                invAccLotVO.setMaterialID(this.getBaseDataLongPkId(entryDynObj, "materialid"));
                invAccLotVO.setAuxPtyID(this.getBaseDataLongPkId(entryDynObj, "auxpropid"));
                invAccLotVO.setProductDate(entryDynObj.getDate("expirydate"));
                invAccLotVO.setEffectiveDate(entryDynObj.getDate("expirydate"));
                invAccLotVO.setChannelID(this.getBaseDataLongPkId(retailBillDynObj, "branchid"));
                invAccLotVO.setSaleOrgID(this.getBaseDataLongPkId(retailBillDynObj, "bizorgid"));
                invAccLotVO.setSaleChannelID(this.getBaseDataLongPkId(retailBillDynObj, "branchid"));
                invAccLotVO.setChannelStockId(this.getBaseDataLongPkId(entryDynObj, "stockid"));
                invAccLotVO.setChannelLocationID(this.getBaseDataLongPkId(entryDynObj, "stockpositionid"));
                invAccLotVO.setChannelStockStatusID(this.getBaseDataLongPkId(entryDynObj, "channelstockstatusid"));
                invAccLotVO.setChannelStockTypeID(this.getBaseDataLongPkId(entryDynObj, "channelstocktypeid"));
                invAccLotVO.setOwnerID(this.getBaseDataLongPkId(entryDynObj, "ownerid"));
                invAccLotVO.setOwnerType(entryDynObj.getString("ownertype"));
                invAccLotVO.setKeeperID(this.getBaseDataLongPkId(entryDynObj, "keeperid"));
                invAccLotVO.setKeeperType(entryDynObj.getString("keepertype"));
                invAccLotVO.setBaseUnitID(this.getBaseDataLongPkId(entryDynObj, "baseunitid"));
                invAccLotVO.setBaseQty(entryDynObj.getBigDecimal("baseunitqty"));
                invAccLotVO.setStockUnitId(this.getBaseDataLongPkId(entryDynObj, "stockunitid"));
                invAccLotVO.setAssistUnitId(this.getBaseDataLongPkId(entryDynObj, "auxunitid"));
                invAccLotVO.setLotID(this.getBaseDataLongPkId(entryDynObj, "lotid"));
                invAccLotVO.setLotNum(entryDynObj.getString("lotno"));
                invAccLotVO.setBillID(retailBillDynObj.getLong("id"));
                invAccLotVO.setBillEntityID("ococ_retailbill");
                invAccLotVO.setBillNo(retailBillDynObj.getString("billno"));
                invAccLotVO.setBillEntryID(entryDynObj.getLong("id"));
                invAccLogVOList.add(invAccLotVO);
            }
        }
        return invAccLogVOList;
    }
}

