/*
 * Decompiled with CFR 0.152.
 */
package kd.drp.ocic.business.helper;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.db.tx.Transactional;
import kd.bos.entity.MainEntityType;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.MetadataServiceHelper;
import kd.bos.servicehelper.TimeServiceHelper;
import kd.bos.servicehelper.operation.DeleteServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.drp.ocic.enums.DataStatusEnum;
import kd.drp.ocic.enums.EnableStatusEnum;
import kd.drp.ocic.enums.MoveDirectEnum;
import kd.drp.ocic.pojo.LotMoveTrackVO;
import kd.drp.ocic.pojo.LotVO;
import kd.drp.ocic.util.DateUtils;
import kd.drp.ocic.util.StringUtils;
import org.apache.commons.lang3.exception.ExceptionUtils;

public class LotProcessor {
    private static final String MDR_ITEM_INFO = "mdr_item_info";
    private static final String ERR_001 = "\u6279\u53f7\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a";
    private static final String ERR_002 = "\u8be5\u5546\u54c1\u5b58\u5728\u8f85\u52a9\u5c5e\u6027\uff0c\u8f85\u52a9\u5c5e\u6027\u4e0d\u80fd\u4e3a\u7a7a";
    private static final String ERR_003 = "\u5546\u54c1\u4e0d\u80fd\u4e3a\u7a7a\u3002";
    private static final String ERR_004 = "\u751f\u4ea7\u65e5\u671f\u4e0d\u80fd\u4e3a\u7a7a\u3002";
    private static final String ERR_005 = "\u6709\u6548\u65e5\u671f\u4e0d\u80fd\u4e3a\u7a7a\u3002";
    private static Log logger = LogFactory.getLog(LotProcessor.class);

    public List<LotVO> saveLotByDynamicObjects(List<DynamicObject> dynObjList, String billFormId) {
        if (dynObjList == null || dynObjList.isEmpty() || StringUtils.isEmpty((String)billFormId)) {
            return new ArrayList<LotVO>(0);
        }
        ArrayList<LotVO> lotVOList = new ArrayList(dynObjList.size());
        switch (billFormId) {
            case "ocic_channelinbill": {
                lotVOList = this.getInBillLotVO(dynObjList.toArray(new DynamicObject[dynObjList.size()]));
                break;
            }
            case "ocic_channeloutbill": {
                lotVOList = this.getOutBillLotVO(dynObjList.toArray(new DynamicObject[dynObjList.size()]));
            }
        }
        this.deleteLot(dynObjList.stream().filter(billDynObj -> billDynObj.getLong("id") > 0L).map(billDynObj -> billDynObj.getLong("id")).collect(Collectors.toList()), billFormId);
        this.batchSaveLot(lotVOList);
        return lotVOList;
    }

    private List<LotVO> getOutBillLotVO(DynamicObject[] billDynObjs) {
        if (billDynObjs == null || billDynObjs.length == 0) {
            return new ArrayList<LotVO>();
        }
        ArrayList<LotVO> lotVOList = new ArrayList<LotVO>(billDynObjs.length);
        for (DynamicObject entryDynObj : billDynObjs) {
            DynamicObjectCollection lotEntryColl = entryDynObj.getDynamicObjectCollection("billentry");
            if (lotEntryColl == null || lotEntryColl.size() <= 0) continue;
            int seq = 0;
            for (DynamicObject lotEntryDynObj : lotEntryColl) {
                String snNumber = lotEntryDynObj.getString("lotnumber");
                if (StringUtils.isEmpty((String)snNumber)) continue;
                LotVO lotVO = new LotVO();
                this.setOutBillLotData(lotEntryDynObj, lotVO);
                ArrayList<LotMoveTrackVO> lotMoveTrackVOList = new ArrayList<LotMoveTrackVO>();
                LotMoveTrackVO trackVO = new LotMoveTrackVO();
                lotVO.setCreatorID(this.getBaseDataLongPkId(entryDynObj, "creator"));
                lotVO.setCreateTime(TimeServiceHelper.now());
                trackVO.setSeq((long)(++seq));
                trackVO.setBillEntityID("ocic_channeloutbill");
                this.setOutBillLotMoveTrackData(entryDynObj, lotEntryDynObj, trackVO);
                lotMoveTrackVOList.add(trackVO);
                lotVO.setLotMoveTrackVOList(lotMoveTrackVOList);
                lotVOList.add(lotVO);
            }
        }
        return lotVOList;
    }

    private void setOutBillLotMoveTrackData(DynamicObject entryDynObj, DynamicObject lotEntryDynObj, LotMoveTrackVO trackVO) {
        if ("1".equals(entryDynObj.getString("outdirection"))) {
            trackVO.setMoveDirect(MoveDirectEnum.MOVEDIRECT_DES);
            trackVO.setDestChannelID(this.getBaseDataLongPkId(entryDynObj, "outchannelid"));
            trackVO.setDestWarehouseID(this.getBaseDataLongPkId(lotEntryDynObj, "stockid"));
            trackVO.setDestLocationID(this.getBaseDataLongPkId(lotEntryDynObj, "stockaddrid"));
            trackVO.setDestSaleChannelID(this.getBaseDataLongPkId(entryDynObj, "saleorgchannelid"));
        } else {
            trackVO.setMoveDirect(MoveDirectEnum.MOVEDIRECT_SRC);
            trackVO.setSrcChannelID(this.getBaseDataLongPkId(entryDynObj, "outchannelid"));
            trackVO.setSrcWarehouseID(this.getBaseDataLongPkId(lotEntryDynObj, "stockid"));
            trackVO.setSrcLocationID(this.getBaseDataLongPkId(lotEntryDynObj, "stockaddrid"));
            trackVO.setSrcSaleChannelID(this.getBaseDataLongPkId(entryDynObj, "saleorgchannelid"));
        }
        trackVO.setBillID(entryDynObj.getLong("id"));
        trackVO.setBillNo(entryDynObj.getString("billno"));
        trackVO.setBillDate(entryDynObj.getDate("outdate"));
        trackVO.setQty(lotEntryDynObj.getBigDecimal("quantity"));
        trackVO.setUnitID(this.getBaseDataLongPkId(lotEntryDynObj, "unitid"));
        trackVO.setMoveDate(new Date());
    }

    private void setOutBillLotData(DynamicObject lotEntryDynObj, LotVO lotVO) {
        lotVO.setBillEntryId(((Long)lotEntryDynObj.getPkValue()).longValue());
        lotVO.setNumber(StringUtils.trim((String)lotEntryDynObj.getString("lotnumber")));
        lotVO.setItemID(this.getBaseDataLongPkId(lotEntryDynObj, "itemid"));
        lotVO.setMaterialID(this.getBaseDataLongPkId(lotEntryDynObj, "materielid"));
        lotVO.setAuxPtyID(this.getBaseDataLongPkId(lotEntryDynObj, "auxptyid"));
        lotVO.setProductDate(lotEntryDynObj.getDate("productdate"));
        lotVO.setEffectiveDate(lotEntryDynObj.getDate("expiredate"));
    }

    private List<LotVO> getInBillLotVO(DynamicObject[] billDynObjs) {
        if (billDynObjs == null || billDynObjs.length == 0) {
            return new ArrayList<LotVO>();
        }
        ArrayList<LotVO> lotVOList = new ArrayList<LotVO>(billDynObjs.length);
        for (DynamicObject entryDynObj : billDynObjs) {
            DynamicObjectCollection lotEntryColl = entryDynObj.getDynamicObjectCollection("billentry");
            if (lotEntryColl == null || lotEntryColl.size() <= 0) continue;
            int seq = 0;
            for (DynamicObject lotEntryDynObj : lotEntryColl) {
                String snNumber = lotEntryDynObj.getString("lotnumber");
                if (StringUtils.isEmpty((String)snNumber)) continue;
                LotVO lotVO = new LotVO();
                this.setInBillLotData(lotEntryDynObj, lotVO);
                ArrayList<LotMoveTrackVO> lotMoveTrackVOList = new ArrayList<LotMoveTrackVO>();
                LotMoveTrackVO trackVO = new LotMoveTrackVO();
                trackVO.setBillEntityID("ocic_channelinbill");
                trackVO.setSeq((long)(++seq));
                lotVO.setCreatorID(this.getBaseDataLongPkId(entryDynObj, "creator"));
                lotVO.setCreateTime(TimeServiceHelper.now());
                this.setInBillLotMoveTrackData(entryDynObj, lotEntryDynObj, trackVO);
                lotMoveTrackVOList.add(trackVO);
                lotVO.setLotMoveTrackVOList(lotMoveTrackVOList);
                lotVOList.add(lotVO);
            }
        }
        return lotVOList;
    }

    private void setInBillLotData(DynamicObject lotEntryDynObj, LotVO lotVO) {
        lotVO.setBillEntryId(((Long)lotEntryDynObj.getPkValue()).longValue());
        lotVO.setNumber(lotEntryDynObj.getString("lotnumber"));
        lotVO.setItemID(this.getBaseDataLongPkId(lotEntryDynObj, "itemid"));
        lotVO.setMaterialID(this.getBaseDataLongPkId(lotEntryDynObj, "materialid"));
        lotVO.setAuxPtyID(this.getBaseDataLongPkId(lotEntryDynObj, "auxptyid"));
        lotVO.setProductDate(lotEntryDynObj.getDate("producedate"));
        lotVO.setEffectiveDate(lotEntryDynObj.getDate("expirydate"));
    }

    private void setInBillLotMoveTrackData(DynamicObject entryDynObj, DynamicObject lotEntryDynObj, LotMoveTrackVO trackVO) {
        if ("1".equals(entryDynObj.getString("inway"))) {
            trackVO.setMoveDirect(MoveDirectEnum.MOVEDIRECT_SRC);
            trackVO.setSrcChannelID(this.getBaseDataLongPkId(entryDynObj, "inchannelid"));
            trackVO.setSrcWarehouseID(this.getBaseDataLongPkId(lotEntryDynObj, "warehouse"));
            trackVO.setSrcLocationID(this.getBaseDataLongPkId(lotEntryDynObj, "locationid"));
            trackVO.setSrcSaleChannelID(this.getBaseDataLongPkId(entryDynObj, "org"));
        } else {
            trackVO.setMoveDirect(MoveDirectEnum.MOVEDIRECT_DES);
            trackVO.setDestChannelID(this.getBaseDataLongPkId(entryDynObj, "inchannelid"));
            trackVO.setDestWarehouseID(this.getBaseDataLongPkId(lotEntryDynObj, "warehouse"));
            trackVO.setDestLocationID(this.getBaseDataLongPkId(lotEntryDynObj, "locationid"));
            trackVO.setDestSaleChannelID(this.getBaseDataLongPkId(entryDynObj, "org"));
        }
        trackVO.setQty(lotEntryDynObj.getBigDecimal("qty"));
        trackVO.setUnitID(this.getBaseDataLongPkId(lotEntryDynObj, "unitid"));
        trackVO.setMoveDate(new Date());
        trackVO.setBillID(entryDynObj.getLong("id"));
        trackVO.setBillEntryID(lotEntryDynObj.getLong("id"));
        trackVO.setBillNo(entryDynObj.getString("billno"));
        trackVO.setBillDate(entryDynObj.getDate("instocktime"));
    }

    public Map<String, DynamicObject> getChanelOutMoveTrackMap(DynamicObject[] billDynObjs, String billFormId) {
        HashSet<Long> billIdSet = new HashSet<Long>();
        HashSet<Long> billEntryIdSet = new HashSet<Long>();
        for (DynamicObject billDynObj : billDynObjs) {
            DynamicObjectCollection entryColl = billDynObj.getDynamicObjectCollection("billentry");
            if (entryColl == null || entryColl.size() <= 0) continue;
            for (DynamicObject entryDynObj : entryColl) {
                DynamicObjectCollection snEntryColl = entryDynObj.getDynamicObjectCollection("chnloutbill_sn");
                if (snEntryColl == null || snEntryColl.size() <= 0) continue;
                billIdSet.add(billDynObj.getLong("id"));
                billEntryIdSet.add(entryDynObj.getLong("id"));
            }
        }
        QFilter billIdFilter = new QFilter("billid", "in", (Object)billIdSet.toArray());
        QFilter billEntryIdFilter = new QFilter("billentryid", "in", (Object)billEntryIdSet.toArray());
        QFilter billEntityIdFilter = new QFilter("billentityid", "=", (Object)billFormId);
        String selectors = String.join((CharSequence)",", "billdate", "moveDate", "billentityid", "billno", "srcchannel", "srcwarehouse", "srclocation", "deschannel", "deswarehouse", "deslocation", "billid", "billentryid", "lotid");
        DynamicObject[] moveTrackDynObjs = BusinessDataServiceHelper.load((String)"ocic_lotmovetrack", (String)selectors, (QFilter[])new QFilter[]{billIdFilter, billEntryIdFilter, billEntityIdFilter});
        HashMap<String, DynamicObject> moveTrackMap = new HashMap<String, DynamicObject>();
        if (moveTrackDynObjs != null && moveTrackDynObjs.length > 0) {
            for (DynamicObject moveTrackDynObj : moveTrackDynObjs) {
                String key = moveTrackDynObj.getLong("billid") + "_" + moveTrackDynObj.getLong("billentryid");
                moveTrackMap.put(key, moveTrackDynObj);
            }
        }
        return moveTrackMap;
    }

    private long getBaseDataLongPkId(DynamicObject billDynObj, String fieldKey) {
        return billDynObj.getLong(fieldKey + "_id");
    }

    private String getBaseDataStringPkId(DynamicObject billDynObj, String fieldKey) {
        return billDynObj.getString(fieldKey + "_id");
    }

    public List<LotVO> saveLot(List<Long> billIds, String billFormId) {
        if (billIds == null || billIds.isEmpty() || StringUtils.isEmpty((String)billFormId) || !"ocic_channelinbill".equals(billFormId.replaceAll(" ", "")) && !"ocic_channeloutbill".equals(billFormId.replaceAll(" ", ""))) {
            return new ArrayList<LotVO>();
        }
        List<LotVO> gainLotList = this.getLotVo(billIds, billFormId);
        if (gainLotList == null || gainLotList.isEmpty()) {
            return new ArrayList<LotVO>();
        }
        ArrayList<LotVO> saveLotVOList = new ArrayList<LotVO>(gainLotList.size());
        List<LotMoveTrackVO> lotMoveTrackVOList = this.getLotMoveTrackVO(billIds, billFormId);
        Map<Long, List<LotMoveTrackVO>> moveGroupMap = lotMoveTrackVOList.stream().filter(lotMove -> lotMove.getLotID() > 0L && lotMove.getBillID() > 0L).collect(Collectors.groupingBy(LotMoveTrackVO::getLotID));
        for (LotVO lot : gainLotList) {
            if (!moveGroupMap.containsKey(lot.getLotID())) continue;
            lot.setLotMoveTrackVOList(moveGroupMap.get(lot.getLotID()));
        }
        saveLotVOList.addAll(this.batchSaveLot(gainLotList));
        return saveLotVOList;
    }

    @Transactional
    public List<LotVO> batchSaveLot(List<LotVO> lotVOList) {
        if (lotVOList == null || lotVOList.isEmpty()) {
            return new ArrayList<LotVO>();
        }
        List<LotVO> saveLotVOList = new ArrayList<LotVO>(lotVOList.size());
        this.checkLotData(lotVOList);
        ArrayList<LotVO> errorLotVOList = new ArrayList<LotVO>(lotVOList.size());
        for (LotVO lotVO : lotVOList) {
            if (!StringUtils.isBlank((String)lotVO.getErrorMsg())) {
                errorLotVOList.add(lotVO);
                continue;
            }
            saveLotVOList.add(lotVO);
        }
        this.queryLotData(saveLotVOList);
        saveLotVOList = this.batchSaveLotData(saveLotVOList);
        ArrayList<LotMoveTrackVO> lotMoveTrackList = new ArrayList<LotMoveTrackVO>(lotVOList.size());
        for (LotVO lotVO : lotVOList) {
            if (lotVO.getLotMoveTrackVOList() == null || lotVO.getLotMoveTrackVOList().size() <= 0) continue;
            for (LotMoveTrackVO lotMoveTrackVO : lotVO.getLotMoveTrackVOList()) {
                lotMoveTrackVO.setLotID(lotVO.getLotID());
            }
            lotMoveTrackList.addAll(lotVO.getLotMoveTrackVOList());
        }
        this.batchSaveLotMoveTrackVO(lotMoveTrackList);
        saveLotVOList.addAll(errorLotVOList);
        return saveLotVOList;
    }

    private void checkLotData(List<LotVO> lotVOList) {
        List itemIds = lotVOList.stream().filter(lotVO -> lotVO != null && lotVO.getItemID() > 0L).map(LotVO::getItemID).collect(Collectors.toList());
        QFilter filter = new QFilter("id", "in", (Object)itemIds.toArray());
        DynamicObject[] items = BusinessDataServiceHelper.load((String)MDR_ITEM_INFO, (String)"id,hasattr", (QFilter[])new QFilter[]{filter});
        ArrayList<Long> itemHasattrIds = null;
        if (items != null && items.length > 0) {
            itemHasattrIds = new ArrayList<Long>(items.length);
            for (DynamicObject item : items) {
                if (StringUtils.isBlank((String)item.get("hasattr").toString()) || !item.get("hasattr").equals("1")) continue;
                itemHasattrIds.add(item.getLong("id"));
            }
        }
        StringBuilder sd = new StringBuilder();
        for (LotVO lotVO2 : lotVOList) {
            lotVO2.setErrorMsg(null);
            if (StringUtils.isEmpty((String)lotVO2.getNumber())) {
                sd.append(ERR_001);
            }
            if (itemHasattrIds != null && itemHasattrIds.size() > 0 && itemHasattrIds.contains(lotVO2.getItemID()) && lotVO2.getAuxPtyID() < 0L) {
                lotVO2.setErrorMsg(ERR_002);
                continue;
            }
            if (lotVO2.getItemID() <= 0L) {
                sd.append(ERR_003);
            }
            if (lotVO2.getUseLotDate().booleanValue() && lotVO2.getProductDate() == null) {
                sd.append(ERR_004);
            }
            if (lotVO2.getUseLotDate().booleanValue() && lotVO2.getEffectiveDate() == null) {
                sd.append(ERR_005);
            }
            lotVO2.setErrorMsg(sd.toString());
        }
    }

    private void queryLotData(List<LotVO> lotVOList) {
        if (lotVOList == null || lotVOList.isEmpty()) {
            return;
        }
        List itemIds = lotVOList.stream().filter(lotVO -> lotVO != null && lotVO.getItemID() > 0L).map(LotVO::getItemID).collect(Collectors.toList());
        QFilter filter = new QFilter("itemId", "in", (Object)itemIds.toArray());
        DynamicObject[] items = BusinessDataServiceHelper.load((String)"ocic_lot", (String)"id,itemId,number,auxptyid", (QFilter[])new QFilter[]{filter});
        if (items != null && items.length > 0) {
            HashMap<String, DynamicObject> resultMap = new HashMap<String, DynamicObject>(items.length);
            DynamicObject[] dynamicObjectArray = items;
            int n = dynamicObjectArray.length;
            for (int i = 0; i < n; ++i) {
                DynamicObject object;
                DynamicObject resultDynObj = object = dynamicObjectArray[i];
                resultMap.put(resultDynObj.getString("number") + this.getBaseDataLongPkId(resultDynObj, "itemId") + this.getBaseDataLongPkId(resultDynObj, "auxPtyId"), resultDynObj);
            }
            for (LotVO lotVO2 : lotVOList) {
                if (resultMap.get(lotVO2.getNumber() + lotVO2.getItemID() + lotVO2.getAuxPtyID()) == null) continue;
                DynamicObject dyj = (DynamicObject)resultMap.get(lotVO2.getNumber() + lotVO2.getItemID() + lotVO2.getAuxPtyID());
                lotVO2.setLotID(dyj.getLong("id"));
            }
        }
    }

    @Transactional
    private List<LotVO> batchSaveLotData(List<LotVO> lotVOs) {
        if (lotVOs == null || lotVOs.isEmpty()) {
            return new ArrayList<LotVO>();
        }
        ArrayList<DynamicObject> tempArrays = new ArrayList<DynamicObject>(lotVOs.size());
        DynamicObject[] lotes = BusinessDataServiceHelper.load((Object[])lotVOs.stream().filter(lotVO -> lotVO.getLotID() > 0L).map(LotVO::getLotID).collect(Collectors.toList()).toArray(), (DynamicObjectType)MetadataServiceHelper.getDataEntityType((String)"ocic_lot"));
        Map<String, Long> newLotInfoMap = this.batchSaveLotInfo(lotVOs.stream().filter(lotVO -> lotVO.getLotID() < 1L).collect(Collectors.toList()));
        DynamicObject newLotDynObj = null;
        Date time = TimeServiceHelper.now();
        String userId = RequestContext.get().getUserId();
        HashMap<String, DynamicObject> lotMap = new HashMap<String, DynamicObject>(lotes == null ? 1 : lotes.length);
        if (lotes != null && lotes.length > 0) {
            for (DynamicObject lot : lotes) {
                lotMap.put(lot.getString("number") + lot.getLong("id"), lot);
            }
        }
        for (LotVO temp : lotVOs) {
            if (temp.getLotID() > 0L && lotMap.get(temp.getNumber() + temp.getLotID()) != null) {
                newLotDynObj = (DynamicObject)lotMap.get(temp.getNumber() + temp.getLotID());
            } else {
                newLotDynObj = BusinessDataServiceHelper.newDynamicObject((String)"ocic_lot");
                newLotDynObj.set("creator", (Object)userId);
                newLotDynObj.set("createtime", (Object)time);
                newLotDynObj.set("enable", (Object)EnableStatusEnum.ENABLE.getValue());
                newLotDynObj.set("status", (Object)DataStatusEnum.AUDITED);
                newLotDynObj.set("lotinfo", (Object)newLotInfoMap.get(temp.getNumber()));
            }
            if (temp.getProductDate() != null && temp.getEffectiveDate() != null) {
                DynamicObjectCollection lotDatecols = newLotDynObj.getDynamicObjectCollection("ocic_lotdate");
                if (lotDatecols != null && lotDatecols.size() > 0) {
                    for (DynamicObject lotDate : lotDatecols) {
                        if (DateUtils.isSameDay((Date)lotDate.getDate("productdate"), (Date)temp.getProductDate()) && DateUtils.isSameDay((Date)lotDate.getDate("expiredate"), (Date)temp.getEffectiveDate())) continue;
                        lotDate.set("productdate", (Object)temp.getProductDate());
                        lotDate.set("expiredate", (Object)temp.getEffectiveDate());
                    }
                } else if (lotDatecols != null && lotDatecols.getDynamicObjectType() != null) {
                    DynamicObject lotDateTemp = new DynamicObject(lotDatecols.getDynamicObjectType());
                    lotDateTemp.set("productdate", (Object)temp.getProductDate());
                    lotDateTemp.set("expiredate", (Object)temp.getEffectiveDate());
                    lotDatecols.add((Object)lotDateTemp);
                    newLotDynObj.set("ocic_lotdate", (Object)lotDatecols);
                }
            } else {
                newLotDynObj.getDynamicObjectCollection("ocic_lotdate").clear();
            }
            newLotDynObj.set("scmLotId", (Object)temp.getScmLotId());
            newLotDynObj.set("number", (Object)temp.getNumber());
            newLotDynObj.set("itemId", (Object)temp.getItemID());
            newLotDynObj.set("auxPtyId", (Object)temp.getAuxPtyID());
            newLotDynObj.set("materialId", (Object)temp.getMaterialID());
            newLotDynObj.set("modifier", (Object)userId);
            newLotDynObj.set("modifytime", (Object)time);
            tempArrays.add(newLotDynObj);
        }
        try {
            Object[] resultObjs = SaveServiceHelper.save((DynamicObject[])tempArrays.toArray(new DynamicObject[tempArrays.size()]));
            if (resultObjs != null && resultObjs.length > 0) {
                HashMap<String, DynamicObject> resultMap = new HashMap<String, DynamicObject>(resultObjs.length);
                for (Object object : resultObjs) {
                    DynamicObject resultDynObj = (DynamicObject)object;
                    resultMap.put(resultDynObj.getString("number") + this.getBaseDataLongPkId(resultDynObj, "itemId") + this.getBaseDataLongPkId(resultDynObj, "auxPtyId"), resultDynObj);
                }
                for (LotVO temp : lotVOs) {
                    if (resultMap.get(temp.getNumber() + temp.getItemID() + temp.getAuxPtyID()) == null) continue;
                    DynamicObject resultDynObj = (DynamicObject)resultMap.get(temp.getNumber() + temp.getItemID() + temp.getAuxPtyID());
                    temp.setLotID(resultDynObj.getLong("id"));
                }
            }
        }
        catch (Throwable e) {
            logger.error("\u6e20\u9053\u4e91\u66f4\u65b0\u4e3b\u6863\u5931\u8d25:");
            logger.error(ExceptionUtils.getStackTrace((Throwable)e));
            throw e;
        }
        return lotVOs;
    }

    private Map<String, Long> batchSaveLotInfo(List<LotVO> lotVOs) {
        HashMap<String, Long> map = new HashMap<String, Long>(lotVOs.size());
        DynamicObject newLotDynObj = null;
        ArrayList<DynamicObject> tempArrays = new ArrayList<DynamicObject>(lotVOs.size());
        Date time = TimeServiceHelper.now();
        String userId = RequestContext.get().getUserId();
        for (LotVO lotVO : lotVOs) {
            newLotDynObj = BusinessDataServiceHelper.newDynamicObject((String)"ocic_lotinfo");
            newLotDynObj.set("creator", (Object)userId);
            newLotDynObj.set("createtime", (Object)time);
            newLotDynObj.set("enable", (Object)EnableStatusEnum.ENABLE.getValue());
            newLotDynObj.set("status", (Object)DataStatusEnum.AUDITED);
            newLotDynObj.set("modifier", (Object)userId);
            newLotDynObj.set("modifytime", (Object)time);
            newLotDynObj.set("number", (Object)lotVO.getNumber());
            tempArrays.add(newLotDynObj);
        }
        try {
            Object[] resultObjs = SaveServiceHelper.save((DynamicObject[])tempArrays.toArray(new DynamicObject[tempArrays.size()]));
            if (resultObjs != null && resultObjs.length > 0) {
                for (Object object : resultObjs) {
                    DynamicObject resultDynObj = (DynamicObject)object;
                    map.put(resultDynObj.getString("number"), (Long)resultDynObj.getPkValue());
                }
            }
        }
        catch (Throwable e) {
            logger.error("\u6e20\u9053\u4e91\u66f4\u65b0\u4e3b\u6863\u5931\u8d25:");
            logger.error(ExceptionUtils.getStackTrace((Throwable)e));
            throw e;
        }
        return map;
    }

    @Transactional
    private void batchSaveLotMoveTrackVO(List<LotMoveTrackVO> lotMoveTractVOList) {
        if (lotMoveTractVOList == null || lotMoveTractVOList.isEmpty()) {
            return;
        }
        ArrayList<DynamicObject> lotMoveTrackList = new ArrayList<DynamicObject>(lotMoveTractVOList.size());
        List lotMoveTrackIdList = lotMoveTractVOList.stream().filter(lotMove -> lotMove.getLotID() > 0L).map(LotMoveTrackVO::getLotID).collect(Collectors.toList());
        QFilter billIdFilter = new QFilter("lotid", "in", (Object)lotMoveTrackIdList.toArray());
        MainEntityType type = MetadataServiceHelper.getDataEntityType((String)"ocic_lotmovetrack");
        DynamicObject[] moveTrackDynObjs = BusinessDataServiceHelper.load((String)"ocic_lotmovetrack", (String)String.join((CharSequence)",", type.getFields().keySet()), (QFilter[])new QFilter[]{billIdFilter});
        HashMap<Long, DynamicObject> srcMoveTrackMap = new HashMap<Long, DynamicObject>();
        HashMap<String, DynamicObject> billMoveTrackMap = new HashMap<String, DynamicObject>();
        String keyStr = "";
        if (moveTrackDynObjs != null && moveTrackDynObjs.length > 0) {
            long lotId = 0L;
            for (DynamicObject moveTrackDynObj : moveTrackDynObjs) {
                if (MoveDirectEnum.MOVEDIRECT_SRC.getValue().equals(moveTrackDynObj.getString("movedirect"))) {
                    lotId = this.getBaseDataLongPkId(moveTrackDynObj, "lotid");
                    srcMoveTrackMap.put(lotId, moveTrackDynObj);
                }
                keyStr = moveTrackDynObj.getLong("billid") + "_" + moveTrackDynObj.getLong("billentryid") + "_" + this.getBaseDataStringPkId(moveTrackDynObj, "billentityid");
                billMoveTrackMap.put(keyStr, moveTrackDynObj);
            }
        }
        HashSet<Long> billIdSet = new HashSet<Long>();
        HashSet<Long> billEntryIdSet = new HashSet<Long>();
        HashSet<String> billEntityIdSet = new HashSet<String>();
        DynamicObject newlotMoveTrackDynObj = null;
        for (LotMoveTrackVO lotMoveTrackVO : lotMoveTractVOList) {
            if (lotMoveTrackVO.isDeleteSnMoveTrack()) {
                billIdSet.add(lotMoveTrackVO.getBillID());
                billEntryIdSet.add(lotMoveTrackVO.getBillEntryID());
                billEntityIdSet.add(lotMoveTrackVO.getBillEntityID());
            }
            newlotMoveTrackDynObj = billMoveTrackMap.get(keyStr = lotMoveTrackVO.getBillID() + "_" + lotMoveTrackVO.getBillEntryID() + "_" + lotMoveTrackVO.getBillEntityID()) != null ? (DynamicObject)billMoveTrackMap.get(keyStr) : BusinessDataServiceHelper.newDynamicObject((String)"ocic_lotmovetrack");
            if (MoveDirectEnum.MOVEDIRECT_DES.equals((Object)lotMoveTrackVO.getMoveDirect()) && srcMoveTrackMap.get(lotMoveTrackVO.getLotID()) != null) {
                DynamicObject srcDyn = (DynamicObject)srcMoveTrackMap.get(lotMoveTrackVO.getLotID());
                lotMoveTrackVO.setSrcChannelID(this.getBaseDataLongPkId(srcDyn, "srcchannel"));
                lotMoveTrackVO.setSrcWarehouseID(this.getBaseDataLongPkId(srcDyn, "srcwarehouse"));
                lotMoveTrackVO.setSrcLocationID(this.getBaseDataLongPkId(srcDyn, "srclocation"));
                lotMoveTrackVO.setSrcSaleChannelID(this.getBaseDataLongPkId(srcDyn, "srcsalechannelid"));
            }
            this.buildMoveTrack(lotMoveTrackVO, newlotMoveTrackDynObj);
            lotMoveTrackList.add(newlotMoveTrackDynObj);
        }
        if (lotMoveTrackList.size() > 0) {
            try {
                SaveServiceHelper.save((DynamicObject[])lotMoveTrackList.toArray(new DynamicObject[lotMoveTrackList.size()]));
            }
            catch (Throwable e) {
                logger.error("\u6e20\u9053\u4e91\u66f4\u65b0\u6e20\u9053\u4e3b\u6863\u79fb\u52a8\u8f68\u8ff9\u5931\u8d25:");
                logger.error(ExceptionUtils.getStackTrace((Throwable)e));
                throw e;
            }
        }
        if (billIdSet.size() > 0) {
            QFilter delBillIdFilter = new QFilter("billid", "in", (Object)billIdSet.toArray());
            QFilter billEntryIdFilter = new QFilter("billentryid", "in", (Object)billEntryIdSet.toArray());
            QFilter billEntityIdFilter = new QFilter("billentityid", "in", (Object)billEntityIdSet.toArray());
            try {
                DeleteServiceHelper.delete((String)"ocic_lotmovetrack", (QFilter[])new QFilter[]{delBillIdFilter, billEntryIdFilter, billEntityIdFilter});
            }
            catch (Throwable e) {
                logger.error("\u6e20\u9053\u4e91\u5220\u9664\u6e20\u9053\u4e3b\u6863\u79fb\u52a8\u8f68\u8ff9\u5931\u8d25:");
                logger.error(ExceptionUtils.getStackTrace((Throwable)e));
                throw e;
            }
        }
    }

    private void buildMoveTrack(LotMoveTrackVO editModel, DynamicObject moveTrack) {
        moveTrack.set("billdate", (Object)editModel.getBillDate());
        moveTrack.set("billno", (Object)editModel.getBillNo());
        moveTrack.set("qty", (Object)editModel.getQty());
        moveTrack.set("unit", (Object)editModel.getUnitID());
        moveTrack.set("billentityid", (Object)editModel.getBillEntityID());
        moveTrack.set("billid", (Object)editModel.getBillID());
        moveTrack.set("billentryid", (Object)editModel.getBillEntryID());
        moveTrack.set("lotid", (Object)editModel.getLotID());
        moveTrack.set("moveDate", (Object)editModel.getMoveDate());
        moveTrack.set("movedirect", (Object)editModel.getMoveDirect().getValue());
        moveTrack.set("srcchannel", (Object)editModel.getSrcChannelID());
        moveTrack.set("srcwarehouse", (Object)editModel.getSrcWarehouseID());
        moveTrack.set("srclocation", (Object)editModel.getSrcLocationID());
        moveTrack.set("deschannel", (Object)editModel.getDestChannelID());
        moveTrack.set("deswarehouse", (Object)editModel.getDestWarehouseID());
        moveTrack.set("deslocation", (Object)editModel.getDestLocationID());
    }

    protected List<LotVO> getLotVo(List<Long> billIds, String billFormId) {
        if (billIds == null || billIds.size() < 1 || StringUtils.isBlank((String)billFormId) || !"ocic_channelinbill".equals(billFormId.replaceAll(" ", "")) && !"ocic_channeloutbill".equals(billFormId.replaceAll(" ", ""))) {
            return null;
        }
        String queryFormName = "ocic_channelinbill".equals(billFormId.replaceAll(" ", "")) ? "ocic_channelinbill" : "ocic_channeloutbill";
        DynamicObject[] channelBills = BusinessDataServiceHelper.load((Object[])billIds.toArray(), (DynamicObjectType)MetadataServiceHelper.getDataEntityType((String)queryFormName));
        if (channelBills == null || channelBills.length < 1) {
            return null;
        }
        ArrayList<LotVO> lotVOList = new ArrayList<LotVO>(channelBills.length);
        for (DynamicObject channel : channelBills) {
            if (StringUtils.isBlank((String)channel.getString("lotnumber"))) continue;
            LotVO lot = new LotVO();
            lot.setItemID(channel.getLong("itemId"));
            lot.setNumber(channel.getString("lotnumber"));
            lot.setMaterialID(channel.getLong("material"));
            lot.setCreatorID(channel.getLong("creator"));
            lot.setCreateTime(channel.getDate("createtime"));
            if (channel.getLong("auxptyid") > 0L) {
                lot.setAuxPtyID(channel.getLong("auxptyid"));
            }
            lotVOList.add(lot);
        }
        return lotVOList;
    }

    protected List<LotMoveTrackVO> getLotMoveTrackVO(List<Long> billIds, String billFormId) {
        if (billIds == null || billIds.isEmpty() || StringUtils.isBlank((String)billFormId)) {
            return null;
        }
        DynamicObject[] moves = BusinessDataServiceHelper.load((Object[])billIds.toArray(), (DynamicObjectType)MetadataServiceHelper.getDataEntityType((String)"ocic_lotmovetrack"));
        if (moves == null || moves.length < 1) {
            return null;
        }
        ArrayList<LotMoveTrackVO> moveTrackVOList = new ArrayList<LotMoveTrackVO>(moves.length);
        for (DynamicObject move : moves) {
            if (StringUtils.isBlank((String)move.getString("billentityid")) || !billFormId.replaceAll(" ", "").equals(move.getString("billentityid"))) continue;
            LotMoveTrackVO moveTrackVO = new LotMoveTrackVO();
            moveTrackVO.setMoveDirect(!StringUtils.isBlank((String)move.getString("movedirect")) && move.getString("movedirect").equals(MoveDirectEnum.MOVEDIRECT_DES.name()) ? MoveDirectEnum.MOVEDIRECT_DES : MoveDirectEnum.MOVEDIRECT_SRC);
            moveTrackVO.setMoveDate(move.getDate("moveDate") != null ? move.getDate("moveDate") : null);
            moveTrackVO.setBillID(move.getLong("billid") > 0L ? move.getLong("billid") : 0L);
            moveTrackVO.setBillEntityID(!StringUtils.isBlank((String)move.getString("billentityid")) ? move.getString("billentityid") : "");
            moveTrackVO.setBillNo(!StringUtils.isBlank((String)move.getString("billno")) ? move.getString("billno") : "");
            moveTrackVO.setBillDate(move.getDate("billdate") != null ? move.getDate("billdate") : null);
            moveTrackVO.setQty(move.getBigDecimal("qty") != null ? move.getBigDecimal("qty") : new BigDecimal(0));
            moveTrackVO.setUnitID(move.getLong("unit") > 0L ? move.getLong("unit") : 0L);
            moveTrackVO.setSrcChannelID(move.getLong("srcchannel") > 0L ? move.getLong("srcchannel") : 0L);
            moveTrackVO.setSrcWarehouseID(move.getLong("srcwarehouse") > 0L ? move.getLong("srcwarehouse") : 0L);
            moveTrackVO.setSrcLocationID(move.getLong("srclocation") > 0L ? move.getLong("srclocation") : 0L);
            moveTrackVO.setDestChannelID(move.getLong("deschannel") > 0L ? move.getLong("deschannel") : 0L);
            moveTrackVOList.add(moveTrackVO);
        }
        return moveTrackVOList;
    }

    public void deleteLot(List<Long> billIds, String billFormId) {
        DynamicObject[] lotes;
        if (billIds == null || billIds.isEmpty() || StringUtils.isBlank((String)billFormId)) {
            return;
        }
        QFilter filter = new QFilter("billid", "in", billIds);
        QFilter billEntityIdFilter = new QFilter("billentityid", "=", (Object)billFormId);
        DynamicObject[] moves = BusinessDataServiceHelper.load((String)"ocic_lotmovetrack", (String)"id,lotid,billid,BILLENTITYID", (QFilter[])new QFilter[]{filter, billEntityIdFilter});
        if (moves == null || moves.length < 1) {
            return;
        }
        ArrayList<Long> deleteLotTrackIds = new ArrayList<Long>(moves.length);
        ArrayList<Long> deleteLotIds = new ArrayList<Long>(moves.length);
        for (DynamicObject move : moves) {
            deleteLotTrackIds.add(move.getLong("id"));
            deleteLotIds.add(this.getBaseDataLongPkId(move, "lotid"));
        }
        if (deleteLotTrackIds.size() > 0) {
            try {
                DeleteServiceHelper.delete((String)"ocic_lotmovetrack", (QFilter[])new QFilter("id", "in", deleteLotTrackIds).toArray());
            }
            catch (Throwable e) {
                logger.error("\u6e20\u9053\u4e91\u5220\u9664\u6e20\u9053\u4e3b\u6863\u79fb\u52a8\u8f68\u8ff9\u5931\u8d25:");
                logger.error(ExceptionUtils.getStackTrace((Throwable)e));
                throw e;
            }
        }
        if (deleteLotIds.size() > 0 && (lotes = BusinessDataServiceHelper.load((Object[])deleteLotIds.toArray(), (DynamicObjectType)MetadataServiceHelper.getDataEntityType((String)"ocic_lot"))) != null && lotes.length > 0) {
            for (DynamicObject lotDyn : lotes) {
                lotDyn.getDynamicObjectCollection("ocic_lotdate").clear();
            }
            try {
                SaveServiceHelper.save((DynamicObject[])lotes);
            }
            catch (Throwable e) {
                logger.error("\u6e20\u9053\u4e91\u5220\u9664\u6e20\u9053\u4e3b\u6863\u6709\u6548\u671f\u5931\u8d25:");
                logger.error(ExceptionUtils.getStackTrace((Throwable)e));
                throw e;
            }
        }
    }

    public Set<Long> gainOcicLotByItemID(String itemID) {
        if (StringUtils.isEmpty((String)itemID)) {
            return new HashSet<Long>();
        }
        QFilter filter = new QFilter("itemId", "=", (Object)itemID);
        DynamicObject[] lotDbjs = BusinessDataServiceHelper.load((String)"ocic_lot", (String)"id,lotid,number", (QFilter[])new QFilter[]{filter});
        if (lotDbjs == null || lotDbjs.length < 1) {
            return new HashSet<Long>();
        }
        HashSet<Long> lotSets = new HashSet<Long>();
        for (DynamicObject dbj : lotDbjs) {
            if (dbj.getLong("number") <= 0L) continue;
            lotSets.add(dbj.getLong("number"));
        }
        return lotSets;
    }
}

