/*
 * Decompiled with CFR 0.152.
 */
package kd.drp.ocic.business.helper;

import java.math.BigDecimal;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.servicehelper.basedata.BaseDataServiceHelper;
import kd.drp.ocic.business.helper.PrecisionAccountHelper;

public class UnitConvertHelper {
    private static final Log log = LogFactory.getLog(UnitConvertHelper.class);

    public static BigDecimal getUnitRateConv(Long materialId, Long srcUnitId, Long desUnitId) {
        BigDecimal unitRate = null;
        if (materialId == null || srcUnitId == null || srcUnitId == 0L || desUnitId == null || desUnitId == 0L) {
            unitRate = BigDecimal.ZERO;
        } else if (srcUnitId.longValue() == desUnitId.longValue()) {
            unitRate = BigDecimal.ONE;
        } else {
            try {
                DynamicObject muConv = BaseDataServiceHelper.getMUConv((Long)materialId, (Long)srcUnitId, (Long)desUnitId);
                if (muConv != null && muConv.getInt("numerator") != 0) {
                    unitRate = new BigDecimal(muConv.getInt("numerator")).divide(new BigDecimal(muConv.getInt("denominator")), 10, 4);
                }
            }
            catch (Exception e) {
                log.error(String.format("\u5355\u4f4d\u6362\u7b97\u63a5\u53e3\u8c03\u7528\u65f6\u51fa\u73b0\u5f02\u5e38 - \u53c2\u6570 \u6e90\u5355\u4f4did:%s \u76ee\u6807\u5355\u4f4did:%s \u7269\u6599id\uff1a%s", srcUnitId, desUnitId, materialId), (Throwable)e);
            }
        }
        if (unitRate == null) {
            unitRate = BigDecimal.ZERO;
        }
        return unitRate;
    }

    public static BigDecimal calculateDestQty(BigDecimal srcQty, Long materialId, Long srcUnitId, Long desUnitId) {
        BigDecimal unitRate = null;
        if (materialId > 0L && srcUnitId > 0L && desUnitId > 0L) {
            unitRate = UnitConvertHelper.getUnitRateConv(materialId, srcUnitId, desUnitId);
        }
        BigDecimal destQty = BigDecimal.ZERO;
        if (unitRate != null) {
            unitRate = unitRate.setScale(10, 4);
            destQty = srcQty.multiply(unitRate);
            destQty = PrecisionAccountHelper.dealWithprecision(desUnitId, destQty);
        }
        return destQty;
    }
}

