/*
 * Decompiled with CFR 0.152.
 */
package kd.drp.ocic.formplugin.lotPlugins;

import java.util.EventObject;
import kd.bos.base.AbstractBasePlugIn;
import kd.bos.bill.BillOperationStatus;
import kd.bos.bill.BillShowParameter;
import kd.bos.bill.OperationStatus;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.form.FormShowParameter;
import kd.bos.form.ShowType;
import kd.bos.form.control.Control;
import kd.bos.form.control.EntryGrid;
import kd.bos.form.control.events.CellClickEvent;
import kd.bos.form.control.events.CellClickListener;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.drp.ocic.util.StringUtils;

public class LotBillEdit
extends AbstractBasePlugIn
implements CellClickListener {
    private String[] COLS = new String[]{"movedirect", "movedate", "billentityid", "billno", "billdate", "qty", "unit", "srcchannel", "srcwarehouse", "srclocation", "deschannel", "deswarehouse", "deslocation", "billid", "srcsalechannelid", "destsalechannelid"};

    public void afterLoadData(EventObject e) {
        super.afterLoadData(e);
        Object pkId = this.getModel().getValue("id");
        QFilter filter = new QFilter("lotid", "=", pkId);
        DynamicObjectCollection dataEntities = QueryServiceHelper.query((String)"ocic_lotmovetrack", (String)StringUtils.join((CharSequence)",", (Object[])this.COLS), (QFilter[])new QFilter[]{filter}, (String)"movedate desc");
        if (dataEntities != null && dataEntities.size() > 0) {
            int[] size;
            this.getModel().deleteEntryData("entryentity");
            for (int index : size = this.getModel().batchCreateNewEntryRow("entryentity", dataEntities.size())) {
                DynamicObject row = (DynamicObject)dataEntities.get(index);
                for (String col : this.COLS) {
                    this.getModel().setValue(col, row.get(col), index);
                }
            }
        }
        this.getModel().setDataChanged(false);
    }

    public void registerListener(EventObject e) {
        super.registerListener(e);
        EntryGrid entryentity = (EntryGrid)this.getControl("entryentity");
        entryentity.addCellClickListener((CellClickListener)this);
    }

    public void cellClick(CellClickEvent cellClickEvent) {
        String fieldKey = cellClickEvent.getFieldKey();
        if ("billno".equals(fieldKey)) {
            this.dealRelation(cellClickEvent);
        }
    }

    public void dealRelation(CellClickEvent evt) {
        DynamicObject entryRowEntity;
        int n;
        Control con = (Control)evt.getSource();
        if ("entryentity".equals(con.getKey()) && (n = evt.getRow()) > -1 && (entryRowEntity = this.getView().getModel().getEntryRowEntity("entryentity", n)) != null) {
            String billFormId = entryRowEntity.getString("billentityid_id");
            long billid = entryRowEntity.getLong("billid");
            this.showBillForm(billFormId, billid);
        }
    }

    private void showBillForm(String billFormId, long billid) {
        if (billid < 1L) {
            return;
        }
        BillShowParameter formshowParameter = new BillShowParameter();
        formshowParameter.setBillStatus(BillOperationStatus.VIEW);
        formshowParameter.setStatus(OperationStatus.VIEW);
        formshowParameter.setFormId(billFormId);
        formshowParameter.setPkId((Object)billid);
        formshowParameter.getOpenStyle().setShowType(ShowType.MainNewTabPage);
        this.getView().showForm((FormShowParameter)formshowParameter);
    }

    public void cellDoubleClick(CellClickEvent cellClickEvent) {
    }
}

