/*
 * Decompiled with CFR 0.152.
 */
package kd.drp.ocic.formplugin.sn;

import java.util.EventObject;
import kd.bos.base.AbstractBasePlugIn;
import kd.bos.bill.BillOperationStatus;
import kd.bos.bill.BillShowParameter;
import kd.bos.bill.OperationStatus;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.form.FormShowParameter;
import kd.bos.form.ShowType;
import kd.bos.form.control.Control;
import kd.bos.form.control.EntryGrid;
import kd.bos.form.control.events.CellClickEvent;
import kd.bos.form.control.events.CellClickListener;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.drp.ocic.util.StringUtils;

public class SnMainFileEdit
extends AbstractBasePlugIn
implements CellClickListener {
    private static String[] COLS = new String[]{"movedirect", "movedate", "billid", "billentityid", "billno", "billdate", "srcchannelid", "srcchannelstockid", "srcchannellocationid", "srcsaleorgid", "srcsalechannelid", "destchannelid", "destchannelstockid", "destchannellocationid", "destsaleorgid", "destsalechannelid", "remark"};

    public void afterLoadData(EventObject e) {
        super.afterLoadData(e);
        Object pkId = this.getModel().getValue("id");
        QFilter filters = new QFilter("snmainfileid", "=", pkId);
        DynamicObjectCollection dataEntities = QueryServiceHelper.query((String)"ocic_snmovetrack", (String)String.join((CharSequence)",", COLS), (QFilter[])new QFilter[]{filters}, (String)"id asc");
        if (dataEntities != null && dataEntities.size() > 0) {
            int[] size;
            this.getModel().deleteEntryData("moveentry");
            for (int index : size = this.getModel().batchCreateNewEntryRow("moveentry", dataEntities.size())) {
                DynamicObject row = (DynamicObject)dataEntities.get(index);
                for (String col : COLS) {
                    this.getModel().setValue(col, row.get(col), index);
                }
            }
        }
        this.getModel().setDataChanged(false);
    }

    public void registerListener(EventObject e) {
        super.registerListener(e);
        EntryGrid entryentity = (EntryGrid)this.getControl("moveentry");
        entryentity.addCellClickListener((CellClickListener)this);
    }

    public void cellClick(CellClickEvent evt) {
        String fieldKey = evt.getFieldKey();
        if ("billno".equals(fieldKey)) {
            this.dealRelation(evt);
        }
    }

    public void dealRelation(CellClickEvent evt) {
        DynamicObject entryRowEntity;
        int n;
        Control con = (Control)evt.getSource();
        if ("moveentry".equals(con.getKey()) && (n = evt.getRow()) > -1 && (entryRowEntity = this.getView().getModel().getEntryRowEntity("moveentry", n)) != null) {
            String billFormId = entryRowEntity.getString("billentityid_id");
            String billid = entryRowEntity.getString("billid");
            this.showBillForm(billFormId, billid);
        }
    }

    private void showBillForm(String billFormId, String billid) {
        if (StringUtils.isBlank((String)billid)) {
            return;
        }
        BillShowParameter formshowParameter = new BillShowParameter();
        formshowParameter.setBillStatus(BillOperationStatus.VIEW);
        formshowParameter.setStatus(OperationStatus.VIEW);
        formshowParameter.setFormId(billFormId);
        formshowParameter.setPkId((Object)billid);
        formshowParameter.getOpenStyle().setShowType(ShowType.MainNewTabPage);
        this.getView().showForm((FormShowParameter)formshowParameter);
    }

    public void cellDoubleClick(CellClickEvent evt) {
    }
}

