/*
 * Decompiled with CFR 0.152.
 */
package kd.drp.ocic.formplugin.stockinPlugins;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Date;
import java.util.EventObject;
import java.util.List;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.IDataEntityType;
import kd.bos.entity.datamodel.events.AfterAddRowEventArgs;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.form.ConfirmCallBackListener;
import kd.bos.form.ConfirmTypes;
import kd.bos.form.IPageCache;
import kd.bos.form.MessageBoxOptions;
import kd.bos.form.MessageBoxResult;
import kd.bos.form.control.Control;
import kd.bos.form.control.events.BeforeItemClickEvent;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.BeforeClosedEvent;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.events.MessageBoxClosedEvent;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.form.field.events.BeforeF7SelectListener;
import kd.bos.form.operate.AbstractOperate;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.list.ListShowParameter;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.drp.mdr.common.f7.F7Utils;
import kd.drp.mdr.common.itemcontrol.ItemSaleControlUtil;
import kd.drp.mdr.common.util.CustomerUtil;
import kd.drp.mdr.common.util.UserUtil;
import kd.drp.mdr.formplugin.MdrBasePlugin;
import kd.drp.ocic.business.helper.UnitConvertHelper;
import kd.drp.ocic.enums.SnStatusEnum;
import org.apache.commons.lang3.StringUtils;

public class StockInBillEdit
extends MdrBasePlugin
implements BeforeF7SelectListener {
    protected static final String OP_ADDENTRY = "newentry";
    private BigDecimal MAX_QTY = new BigDecimal("999999999999.999999999");

    public void beforeClosed(BeforeClosedEvent e) {
    }

    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.addClickListeners(new String[]{"lotnumber"});
        this.addClickListeners(new String[]{"serialnumber"});
        this.addF7Listener(this, new String[]{"inchannelid", "supplychannelid", "warehouse", "locationid", "unitid", "itemid", "lotnumberid", "materialid", "serialid"});
    }

    public void click(EventObject evt) {
        String key;
        super.click(evt);
        switch (key = ((Control)evt.getSource()).getKey()) {
            case "lotnumber": {
                BasedataEdit lotnumberid = (BasedataEdit)this.getControl("lotnumberid");
                if (null == lotnumberid) break;
                List<Long> lotIds = this.filterLotIdByItemId();
                QFilter idFilter = new QFilter("id", "in", lotIds);
                lotnumberid.setQFilter(idFilter);
                lotnumberid.setF7MultipleSelect(false);
                lotnumberid.click();
                break;
            }
            case "serialnumber": {
                BasedataEdit EF_serialnumberid = (BasedataEdit)this.getControl("serialid");
                if (null == EF_serialnumberid) break;
                List<Long> SNIds = this.filterSQNIdByItemId();
                QFilter SNFilter = new QFilter("id", "in", SNIds);
                EF_serialnumberid.setQFilter(SNFilter);
                EF_serialnumberid.setF7MultipleSelect(false);
                EF_serialnumberid.click();
            }
        }
    }

    public void changeChannelIdConfirm() {
        int entryRowCount = this.getModel().getEntryRowCount("billentry");
        if (entryRowCount > 0) {
            ConfirmCallBackListener confirmCallBacks = new ConfirmCallBackListener("changeChannelCallBack", (IFormPlugin)this);
            this.getView().showConfirm("\u5165\u5e93\u6e20\u9053\u53d1\u751f\u53d8\u66f4\uff0c\u662f\u5426\u5220\u9664\u5206\u5f55\uff1f", MessageBoxOptions.YesNo, ConfirmTypes.Default, confirmCallBacks);
        }
    }

    public void confirmCallBack(MessageBoxClosedEvent messageBoxClosedEvent) {
        if ("changeChannelCallBack".equals(messageBoxClosedEvent.getCallBackId()) && messageBoxClosedEvent.getResult().equals((Object)MessageBoxResult.Yes)) {
            this.getModel().deleteEntryData("billentry");
        }
    }

    public void beforeF7Select(BeforeF7SelectEvent e) {
        String propName = e.getProperty().getName();
        int currentRowIndex = e.getRow();
        ListShowParameter showParameter = (ListShowParameter)e.getFormShowParameter();
        ArrayList<QFilter> qFilters = new ArrayList<QFilter>();
        switch (propName) {
            case "inchannelid": {
                showParameter.getListFilterParameter().setQFilters(this.getinChannelFilters());
                break;
            }
            case "warehouse": {
                List<Long> warehouseIds = this.getIdsFromOcicWareHouse();
                qFilters.add(new QFilter("id", "in", warehouseIds));
                showParameter.getListFilterParameter().setQFilters(qFilters);
                break;
            }
            case "locationid": {
                Boolean warehouseStatus = this.whetherWarehouseChoose();
                if (!warehouseStatus.booleanValue()) {
                    e.setCancel(true);
                    this.getView().showMessage("\u8bf7\u5148\u9009\u62e9\u4ed3\u5e93");
                    break;
                }
                long wid = ((DynamicObject)this.getModel().getEntryRowEntity("billentry", currentRowIndex).get("warehouse")).getLong("id");
                QFilter qf2 = new QFilter("warehouseid", "=", (Object)wid);
                showParameter.getListFilterParameter().setFilter(qf2);
                break;
            }
            case "supplychannelid": {
                if (null == this.getInChannel()) {
                    this.getView().showMessage("\u8bf7\u5148\u9009\u62e9\u5165\u5e93\u6e20\u9053");
                    e.setCancel(true);
                    break;
                }
                QFilter enableFilter = new QFilter("enable", "=", (Object)"1");
                QFilter authorizeQfilter = new QFilter("id", "in", this.getIdsFromMdrCustomerAuthorize());
                qFilters.add(enableFilter);
                qFilters.add(authorizeQfilter);
                showParameter.getListFilterParameter().setQFilters(qFilters);
                break;
            }
            case "itemid": {
                F7Utils.addF7Filter((BeforeF7SelectEvent)e, this.getItemFilter());
                break;
            }
            case "unitid": {
                List<Long> filterIds;
                if (!this.whetherItemChoose()) {
                    e.setCancel(true);
                    this.getView().showMessage("\u8bf7\u5148\u9009\u62e9\u5546\u54c1");
                }
                if ((filterIds = this.getUnitFilterRange(currentRowIndex, e)) == null || filterIds.size() <= 0) break;
                qFilters.add(new QFilter("id", "in", this.getUnitFilterRange(currentRowIndex, e)));
                showParameter.getListFilterParameter().setQFilters(qFilters);
            }
        }
    }

    private List<Long> filterLotIdByItemId() {
        DynamicObject[] result;
        ArrayList<Long> ids = new ArrayList<Long>();
        DynamicObject rowObj = this.getCurrentRowInfo("billentry");
        if (null == rowObj) {
            return ids;
        }
        DynamicObject itemObj = (DynamicObject)rowObj.get("itemid");
        if (null == itemObj) {
            return ids;
        }
        Long itemId = (Long)itemObj.getPkValue();
        QFilter itemIdFilter = new QFilter("itemid", "=", (Object)itemId);
        QFilter enableFilter = new QFilter("enable", "=", (Object)"1");
        QFilter auxptyFilter = null;
        DynamicObject auxpty = (DynamicObject)rowObj.get("auxptyid");
        if (null != auxpty) {
            Long auxptyId = (Long)auxpty.getPkValue();
            auxptyFilter = new QFilter("auxptyid", "=", (Object)auxptyId);
        }
        if ((result = BusinessDataServiceHelper.load((String)"ocic_lot", (String)"id", (QFilter[])new QFilter[]{itemIdFilter, enableFilter, auxptyFilter})) != null && result.length > 0) {
            for (DynamicObject dynamicobject : result) {
                ids.add((Long)dynamicobject.getPkValue());
            }
        }
        return ids;
    }

    private List<Long> filterSQNIdByItemId() {
        QFilter lockstatusFilter;
        DynamicObject[] result;
        ArrayList<Long> ids = new ArrayList<Long>();
        DynamicObject rowObj = this.getCurrentRowInfo("billentry");
        if (null == rowObj) {
            return ids;
        }
        DynamicObject itemObj = (DynamicObject)rowObj.get("itemid");
        if (null == itemObj) {
            return ids;
        }
        Long itemId = (Long)itemObj.getPkValue();
        QFilter itemIdFilter = new QFilter("itemid", "=", (Object)itemId);
        QFilter auxptyFilter = null;
        DynamicObject auxpty = (DynamicObject)rowObj.get("auxptyid");
        if (null != auxpty) {
            Long auxptyId = (Long)auxpty.getPkValue();
            auxptyFilter = new QFilter("auxptyid", "=", (Object)auxptyId);
        }
        QFilter billTypeFilter = null;
        billTypeFilter = this.whetherPositiveInWay() ? new QFilter("snstatus", "=", (Object)SnStatusEnum.ONWAY.getValue()) : new QFilter("snstatus", "=", (Object)SnStatusEnum.INSTOCK.getValue());
        QFilter lotNumFilter = null;
        String lotNum = this.getStringValue("lotnumber");
        if (lotNum != null) {
            lotNumFilter = new QFilter("lotnum", "=", (Object)lotNum);
        }
        QFilter producedateFilter = null;
        Date producedate = (Date)rowObj.get("producedate");
        if (producedate != null) {
            producedateFilter = new QFilter("productdate", "=", (Object)producedate);
        }
        QFilter effectivedateFilter = null;
        Date effectivedate = (Date)rowObj.get("expirydate");
        if (effectivedate != null) {
            effectivedateFilter = new QFilter("effectivedate", "=", effectivedateFilter);
        }
        QFilter warehouseFilter = null;
        DynamicObject warehouse = (DynamicObject)rowObj.get("warehouse");
        if (warehouse != null) {
            Long warehouseId = (Long)warehouse.getPkValue();
            warehouseFilter = new QFilter("channelstockid", "=", (Object)warehouseId);
        }
        QFilter locationFilter = null;
        DynamicObject location = (DynamicObject)rowObj.get("locationid");
        if (location != null) {
            Long locationId = (Long)location.getPkValue();
            locationFilter = new QFilter("channellocationid", "=", (Object)locationId);
        }
        QFilter stockstatusFilter = null;
        DynamicObject stockstatus = (DynamicObject)rowObj.get("stockstatus");
        if (stockstatus != null) {
            Long stockstatusId = (Long)stockstatus.getPkValue();
            stockstatusFilter = new QFilter("channelstockstatusid", "=", (Object)stockstatusId);
        }
        QFilter stocktypeFilter = null;
        DynamicObject stocktype = (DynamicObject)rowObj.get("stocktype");
        if (stocktype != null) {
            Long stocktypeId = (Long)stocktype.getPkValue();
            stocktypeFilter = new QFilter("channelstocktypeid", "=", (Object)stocktypeId);
        }
        QFilter ownerFilter = null;
        DynamicObject owner = (DynamicObject)rowObj.get("ownerid");
        if (owner != null) {
            Long ownerId = (Long)owner.getPkValue();
            ownerFilter = new QFilter("ownerid", "=", (Object)ownerId);
        }
        QFilter ownertypeFilter = null;
        String ownertype = (String)rowObj.get("ownertype");
        if (ownertype != null) {
            ownertypeFilter = new QFilter("ownertype", "=", (Object)ownertype);
        }
        QFilter keeperFilter = null;
        DynamicObject keeper = (DynamicObject)rowObj.get("keeperid");
        if (keeper != null) {
            Long keeperId = (Long)keeper.getPkValue();
            keeperFilter = new QFilter("keeperid", "=", (Object)keeperId);
        }
        QFilter keepertypeFilter = null;
        String keepertype = (String)rowObj.get("keepertype");
        if (keepertype != null) {
            keepertypeFilter = new QFilter("keepertype", "=", (Object)keepertype);
        }
        if ((result = BusinessDataServiceHelper.load((String)"ocic_snmainfile", (String)"id", (QFilter[])new QFilter[]{itemIdFilter, auxptyFilter, billTypeFilter, lotNumFilter, producedateFilter, effectivedateFilter, warehouseFilter, locationFilter, stockstatusFilter, stocktypeFilter, ownerFilter, ownertypeFilter, keeperFilter, keepertypeFilter, lockstatusFilter = new QFilter("lockstatus", "=", (Object)"0")})) != null && result.length > 0) {
            for (DynamicObject dynamicobject : result) {
                ids.add((Long)dynamicobject.getPkValue());
            }
        }
        return ids;
    }

    private boolean whetherWarehouseChoose() {
        boolean status = false;
        DynamicObject warehouse = (DynamicObject)this.getView().getModel().getValue("warehouse");
        if (warehouse != null) {
            status = true;
        }
        return status;
    }

    private void setStockStatusAndStockType(int rowIndex) {
        this.setDefaultStockStatus(rowIndex);
        this.setDefaultStockType(rowIndex);
    }

    private void setDefaultStockStatus(int rowIndex) {
        QFilter nameFilter = new QFilter("name", "=", (Object)"\u53ef\u7528");
        QFilter enableFilter = new QFilter("enable", "=", (Object)"1");
        QFilter ispresetFilter = new QFilter("ispreset", "=", (Object)"1");
        DynamicObject[] result = BusinessDataServiceHelper.load((String)"ocic_stockstatus", (String)"id", (QFilter[])new QFilter[]{nameFilter, enableFilter, ispresetFilter});
        if (result != null && result.length > 0) {
            this.getView().getModel().setValue("stockstatus", (Object)result[0].getLong("id"), rowIndex);
        }
    }

    private void setDefaultStockType(int rowIndex) {
        QFilter nameFilter = new QFilter("name", "=", (Object)"\u666e\u901a");
        QFilter enableFilter = new QFilter("enable", "=", (Object)"1");
        QFilter ispresetFilter = new QFilter("ispreset", "=", (Object)"1");
        DynamicObject[] result = BusinessDataServiceHelper.load((String)"ocic_stocktype", (String)"id", (QFilter[])new QFilter[]{nameFilter, enableFilter, ispresetFilter});
        if (result != null && result.length > 0) {
            this.getView().getModel().setValue("stocktype", (Object)result[0].getLong("id"), rowIndex);
        }
    }

    private boolean whetherItemChoose() {
        boolean status = false;
        int entryCurrentRowIndex = this.getModel().getEntryCurrentRowIndex("billentry");
        String itemid = this.getItemIdFormEntryRow(entryCurrentRowIndex);
        if (!StringUtils.isEmpty((CharSequence)itemid)) {
            status = true;
        }
        return status;
    }

    private List<Long> getIdsFromOcicWareHouse() {
        QFilter enableFilter;
        QFilter statusFilter;
        DynamicObject[] result;
        ArrayList<Long> ids = new ArrayList<Long>();
        Long channelId = (Long)this.getInChannelIdNumber();
        QFilter customerFilter = null;
        if (channelId != null) {
            customerFilter = new QFilter("ownerchannelid", "=", (Object)channelId);
        }
        if ((result = BusinessDataServiceHelper.load((String)"ocic_warehouse", (String)"id", (QFilter[])new QFilter[]{customerFilter, statusFilter = new QFilter("status", "=", (Object)"C"), enableFilter = new QFilter("enable", "=", (Object)"1")})) != null && result.length > 0) {
            for (DynamicObject dynamicobject : result) {
                ids.add(dynamicobject.getLong("id"));
            }
        }
        return ids;
    }

    private void setDefaultWareHouseID(int rowIndex) {
        QFilter enableFilter;
        QFilter statusFilter;
        QFilter defaultFilter;
        DynamicObject[] result;
        this.getView().getModel().setValue("warehouse", null, rowIndex);
        Long channelId = (Long)this.getInChannelIdNumber();
        QFilter customerFilter = null;
        if (channelId != null && (result = BusinessDataServiceHelper.load((String)"ocic_warehouse", (String)"id", (QFilter[])new QFilter[]{customerFilter = new QFilter("ownerchannelid", "=", (Object)channelId), defaultFilter = new QFilter("isdefault", "=", (Object)"1"), statusFilter = new QFilter("status", "=", (Object)"C"), enableFilter = new QFilter("enable", "=", (Object)"1")})) != null && result.length > 0) {
            this.getView().getModel().setValue("warehouse", result[0].getPkValue(), rowIndex);
        }
    }

    private List<QFilter> getinChannelFilters() {
        ArrayList<QFilter> qFilters = new ArrayList<QFilter>();
        QFilter qFilter1 = new QFilter("isinnerorg", "=", (Object)Boolean.FALSE);
        QFilter qFilter2 = new QFilter("status", "=", (Object)"C");
        QFilter qFilter3 = new QFilter("enable", "=", (Object)Boolean.TRUE);
        QFilter qFilter4 = new QFilter("customerfunctions.fbasedataid.number", "=", (Object)"003");
        qFilters.add(qFilter1);
        qFilters.add(qFilter2);
        qFilters.add(qFilter3);
        qFilters.add(qFilter4);
        qFilters.add(UserUtil.getCommonUserOwnersFilter());
        return qFilters;
    }

    private List<Long> getIdsFromMdrCustomerAuthorize() {
        DynamicObject[] result;
        ArrayList<Long> ids = new ArrayList<Long>();
        Long channelId = (Long)this.getInChannelIdNumber();
        QFilter customerFilter = null;
        if (channelId != null) {
            customerFilter = new QFilter("customer", "=", (Object)channelId);
        }
        if ((result = BusinessDataServiceHelper.load((String)"mdr_customer_authorize", (String)"authowner", (QFilter[])new QFilter[]{customerFilter})) != null && result.length > 0) {
            for (DynamicObject dynamicobject : result) {
                ids.add(dynamicobject.getLong("authowner_id"));
            }
        }
        return ids;
    }

    private List<Long> getUnitFilterRange(int currentRowIndex, BeforeF7SelectEvent e) {
        QFilter conversionTypeFilter;
        ArrayList<Long> filterIds = new ArrayList<Long>();
        DynamicObject rowEntity = this.getModel().getEntryRowEntity("billentry", currentRowIndex);
        DynamicObject materialObj = (DynamicObject)rowEntity.get("materialid");
        DynamicObject item = (DynamicObject)rowEntity.get("itemid");
        if (null == item) {
            this.getView().showMessage("\u8bf7\u5148\u9009\u62e9\u5546\u54c1~");
            return filterIds;
        }
        DynamicObject baseunit = rowEntity.getDynamicObject("baseunitid");
        if (null == baseunit) {
            this.getView().showMessage("\u57fa\u672c\u8ba1\u91cf\u5355\u4f4d\u4e3a\u7a7a\uff0c\u8bf7\u68c0\u67e5\u5546\u54c1~");
            return filterIds;
        }
        Long groupId = (Long)baseunit.getDynamicObject("group").getPkValue();
        DynamicObject[] ids = BusinessDataServiceHelper.load((String)"bd_measureunits", (String)"id", (QFilter[])new QFilter[]{new QFilter("group", "=", (Object)groupId)});
        if (ids != null && ids.length > 0) {
            for (DynamicObject id : ids) {
                filterIds.add((Long)id.getPkValue());
            }
        }
        if (null == materialObj) {
            return filterIds;
        }
        Object pkValue = materialObj.getPkValue();
        QFilter materialIdFilter = new QFilter("materialid", "=", pkValue);
        DynamicObject[] result = BusinessDataServiceHelper.load((String)"bd_multimeasureunit", (String)"measureunitid", (QFilter[])new QFilter[]{materialIdFilter, conversionTypeFilter = new QFilter("converttype", "=", (Object)1)});
        if (null != result && result.length > 0) {
            for (DynamicObject rObj : result) {
                filterIds.add((Long)((DynamicObject)rObj.get("measureunitid")).getPkValue());
            }
        }
        return filterIds;
    }

    private void setDefaultInchannelId() {
        int entryRowCount;
        QFilter qFilterIsinNerOrg = new QFilter("isinnerorg", "=", (Object)Boolean.FALSE);
        QFilter enableFilter = new QFilter("enable", "=", (Object)"1");
        QFilter statusFilter = new QFilter("status", "=", (Object)"C");
        QFilter qFilterCustomerAuthorize = CustomerUtil.getAuthorisedCustomerFilter();
        DynamicObject[] result = BusinessDataServiceHelper.load((String)"mdr_customer", (String)"id", (QFilter[])new QFilter[]{qFilterCustomerAuthorize, qFilterIsinNerOrg, enableFilter, statusFilter});
        if (result != null && result.length > 0) {
            this.getView().getModel().setValue("inchannelid", (Object)result[0].getLong("id"));
        }
        if (0 < (entryRowCount = this.getModel().getEntryRowCount("billentry"))) {
            this.setOwnerAndKeeper(0);
        }
    }

    protected Object getInChannelIdObject() {
        return this.getView().getModel().getValue("inchannelid");
    }

    protected Object getInChannelIdNumber() {
        return this.getF7PKValue("inchannelid");
    }

    protected List<QFilter> getItemFilter() {
        ArrayList<QFilter> fs = new ArrayList<QFilter>(10);
        fs.add(ItemSaleControlUtil.getItemFilterUsePageCache((Object)this.getSupplyChannelId(), (Object)this.getInChannelId(), (IPageCache)this.getPageCache()));
        fs.add(new QFilter("isonsell", "=", (Object)"1"));
        fs.add(new QFilter("nonsingle", "=", (Object)"0"));
        return fs;
    }

    protected Object getSaleOrgChannelPKValue() {
        return this.getF7PKValue("sellorgchannel");
    }

    protected Object getInWayValue() {
        return this.getF7PKValue("inway");
    }

    protected Object getInChannelId() {
        return this.getF7PKValue("inchannelid");
    }

    protected Object getSupplyChannelId() {
        return this.getF7PKValue("supplychannelid");
    }

    private Object getInChannel() {
        return this.getF7Value("inchannelid");
    }

    private DynamicObject getSupplyChannel() {
        DynamicObject supplychannelid = (DynamicObject)this.getModel().getValue("supplychannelid");
        return supplychannelid;
    }

    protected String getItemIdFormEntryRow(int rowIndex) {
        DynamicObject itemEntity = (DynamicObject)this.getModel().getEntryRowEntity("billentry", rowIndex).get("itemid");
        String itemId = null;
        if (null != itemEntity) {
            itemId = itemEntity.getPkValue().toString();
        }
        return itemId;
    }

    public void afterDoOperation(AfterDoOperationEventArgs ae) {
        OperationResult opResult;
        super.afterDoOperation(ae);
        if (!StringUtils.equals((CharSequence)"bar_save", (CharSequence)ae.getOperateKey()) || (opResult = ae.getOperationResult()) == null || opResult.isSuccess()) {
            // empty if block
        }
    }

    public void afterAddRow(AfterAddRowEventArgs e) {
        super.afterAddRow(e);
        String entryName = e.getEntryProp().getName();
        if ("billentry".equals(entryName)) {
            int rowIndex = e.getRowDataEntities()[0].getRowIndex();
            this.setOwnerAndKeeper(rowIndex);
            this.setDefaultWareHouseID(rowIndex);
            this.setStockStatusAndStockType(rowIndex);
        }
    }

    private void setOwnerAndKeeper(int rowIndex) {
        Object inChannel = this.getInChannel();
        if (null != inChannel) {
            IDataEntityType type = ((DynamicObject)inChannel).getDataEntityType();
            this.getModel().setValue("ownertype", (Object)type.getName(), rowIndex);
            this.getView().setEnable(Boolean.FALSE, rowIndex, new String[]{"ownertype"});
            this.getModel().setValue("ownerid", inChannel, rowIndex);
            this.getView().setEnable(Boolean.FALSE, rowIndex, new String[]{"ownerid"});
            this.getModel().setValue("keepertype", (Object)type.getName(), rowIndex);
            this.getView().setEnable(Boolean.FALSE, rowIndex, new String[]{"keepertype"});
            this.getModel().setValue("keeperid", inChannel, rowIndex);
            this.getView().setEnable(Boolean.FALSE, rowIndex, new String[]{"keeperid"});
        }
    }

    public void afterCreateNewData(EventObject e) {
        super.afterCreateNewData(e);
        this.setDefaultInchannelId();
        int entryRowCount = this.getModel().getEntryRowCount("billentry");
        if (0 < entryRowCount) {
            this.setOwnerAndKeeper(0);
        }
        this.clearSaleOrgAndChannel();
        this.setSaleOrgAndChannel();
        this.inStockWay();
        this.preSetSupplyChannelIdChange();
        this.changeIntypeValue();
        this.setCurrency();
    }

    public void afterBindData(EventObject e) {
        super.afterBindData(e);
        this.lockData();
        this.setAssistantProperty();
        this.checkStockLocationAfterBind();
    }

    private void setAssistantProperty() {
        int entryRowCount = this.getModel().getEntryRowCount("billentry");
        for (int i = 0; i < entryRowCount; ++i) {
            DynamicObject entryRowEntity = this.getModel().getEntryRowEntity("billentry", i);
            DynamicObject item = entryRowEntity.getDynamicObject("itemid");
            if (null == item) continue;
            this.setAuxpty(i, item);
        }
    }

    private void inStockWay() {
        if (this.whetherPositiveInWay()) {
            this.getModel().setValue("inway", (Object)"1");
        } else {
            this.getModel().setValue("inway", (Object)"2");
        }
    }

    private boolean whetherPositiveInWay() {
        DynamicObject billType = (DynamicObject)this.getModel().getValue("billtypeid");
        if (null != billType) {
            String billTypeNumber = billType.getString("number");
            return !billTypeNumber.equals("BBC_in_sys004");
        }
        return true;
    }

    private void lockData() {
        this.getView().setEnable(Boolean.FALSE, new String[]{"settlecurrencyid"});
        this.getView().setEnable(Boolean.FALSE, new String[]{"billno"});
        String billstatus = (String)this.getModel().getValue("billstatus");
        if (billstatus.equals("B") || billstatus.equals("C")) {
            this.getView().setEnable(Boolean.FALSE, new String[]{"billtypeid"});
        }
        this.lockLotNumber();
        this.ifDisableLockSerialNum();
        this.lockBaseUnit();
    }

    private void lockBaseUnit() {
        DynamicObjectCollection billentry = this.getModel().getEntryEntity("billentry");
        if (billentry.size() > 0) {
            for (int i = 0; i < billentry.size(); ++i) {
                this.getView().setEnable(Boolean.FALSE, i, new String[]{"baseunitid"});
            }
        }
    }

    private void lockLotNumber() {
        DynamicObjectCollection billentry = this.getModel().getEntryEntity("billentry");
        if (billentry.size() > 0) {
            for (int i = 0; i < billentry.size(); ++i) {
                DynamicObject itemObj = (DynamicObject)((DynamicObject)billentry.get(i)).get("itemid");
                if (itemObj == null) continue;
                boolean enableFlag = itemObj.getBoolean("enablelot");
                if (!enableFlag) {
                    this.getView().setEnable(Boolean.FALSE, i, new String[]{"lotnumber"});
                    continue;
                }
                this.getView().setEnable(Boolean.TRUE, i, new String[]{"lotnumber"});
            }
        }
    }

    private void setDefaultValues(int i) {
        this.getModel().setValue("materialid", null, i);
        this.getModel().setValue("unitid", null, i);
        this.getModel().setValue("baseunitid", null, i);
        this.getModel().setValue("assistunitid", null, i);
        this.getModel().setValue("qty", (Object)0, i);
        this.getModel().setValue("baseqty", (Object)0, i);
        this.getModel().setValue("assistqty", (Object)0, i);
        this.getModel().setValue("serialqty", (Object)0, i);
        this.getModel().setValue("serialunit", null, i);
        this.getModel().setValue("lotnumberid", null, i);
        this.getModel().setValue("lotnumber", (Object)"", i);
        this.getModel().setValue("serialunit", null, i);
        this.getModel().setValue("serialqty", (Object)0, i);
    }

    private void lockDataAfterReviseRowItemId(int rowNo, DynamicObject item) {
        if (item == null) {
            return;
        }
        this.changeMaterialColumn(rowNo, item);
        this.setAuxpty(rowNo, item);
        this.setUnit(rowNo, item);
        this.setLot(rowNo, item);
        this.getView().setEnable(Boolean.FALSE, rowNo, new String[]{"ownertype"});
        this.getView().setEnable(Boolean.FALSE, rowNo, new String[]{"keepertype"});
    }

    private void setLot(int rowNo, DynamicObject item) {
        if (item != null) {
            Boolean enablelot = (Boolean)item.get("enablelot");
            if (!enablelot.booleanValue()) {
                this.getView().setEnable(Boolean.FALSE, rowNo, new String[]{"lotnumber"});
            } else {
                this.getView().setEnable(Boolean.TRUE, rowNo, new String[]{"lotnumber"});
            }
        }
    }

    private void setUnit(int rowNo, DynamicObject item) {
        if (null != item) {
            DynamicObject stockUnit = (DynamicObject)item.get("stockunit");
            this.setItemUnits(item, rowNo, stockUnit);
        }
    }

    private void setItemUnits(DynamicObject currentItem, int rowIndex, DynamicObject stockUnit) {
        if (null != stockUnit && null != currentItem) {
            DynamicObject stockunit4Item = stockUnit;
            DynamicObject baseunit4Item = (DynamicObject)currentItem.get("baseunit");
            DynamicObject assistantunit4Item = (DynamicObject)currentItem.get("assistunit");
            this.getView().setEnable(Boolean.TRUE, rowIndex, new String[]{"unitid"});
            Long stockunit4ItemPKValue = stockunit4Item.getPkValue() != null ? (Long)stockunit4Item.getPkValue() : 0L;
            this.getModel().setValue("unitid", (Object)stockunit4ItemPKValue, rowIndex);
            if (null == baseunit4Item) {
                this.getView().setEnable(Boolean.TRUE, rowIndex, new String[]{"baseunitid"});
            } else {
                Long baseunit4ItemPkValue = baseunit4Item.getPkValue() != null ? (Long)baseunit4Item.getPkValue() : 0L;
                this.getModel().setValue("baseunitid", (Object)baseunit4ItemPkValue, rowIndex);
                this.getView().setEnable(Boolean.FALSE, rowIndex, new String[]{"baseunitid"});
            }
            if (null == assistantunit4Item) {
                this.getView().setEnable(Boolean.TRUE, rowIndex, new String[]{"assistunitid"});
            } else {
                Long assisunit4ItemPkValue = assistantunit4Item.getPkValue() != null ? (Long)assistantunit4Item.getPkValue() : 0L;
                this.getModel().setValue("assistunitid", (Object)assisunit4ItemPkValue, rowIndex);
                this.getView().setEnable(Boolean.FALSE, rowIndex, new String[]{"assistunitid"});
            }
        }
    }

    private void setAuxpty(int rowNo, DynamicObject currentItem) {
        if (currentItem != null) {
            Boolean assistunit = (Boolean)currentItem.get("hasattr");
            if (!assistunit.booleanValue()) {
                this.getView().setEnable(Boolean.FALSE, rowNo, new String[]{"auxptyid"});
            } else {
                this.getView().setEnable(Boolean.TRUE, rowNo, new String[]{"auxptyid"});
            }
        }
    }

    private void changeMaterialColumn(int i, DynamicObject currentItem) {
        if (null != currentItem) {
            DynamicObject material4Item = (DynamicObject)currentItem.get("material");
            if (null == material4Item) {
                this.getModel().setValue("materialid", null, i);
                this.getView().setEnable(Boolean.TRUE, i, new String[]{"materialid"});
            } else {
                this.getModel().setValue("materialid", (Object)material4Item.getLong("id"), i);
                this.getView().setEnable(Boolean.FALSE, i, new String[]{"materialid"});
            }
        }
    }

    private void setSaleOrgAndChannel() {
        DynamicObject inChannel = (DynamicObject)this.getModel().getValue("inchannelid");
        if (null != inChannel) {
            this.setSaleOrgAndChannel(inChannel);
        }
    }

    private void setSaleOrgAndChannel(DynamicObject inChannel) {
        QFilter enable;
        QFilter innerOrg;
        QFilter status;
        QFilter bizgroup;
        DynamicObject[] result;
        String typeid;
        DynamicObject[] customerTypes;
        DynamicObject customertype;
        DynamicObject saleOrg = null;
        if (null != inChannel) {
            DynamicObject[] ids;
            DynamicObject bizgroup2 = (DynamicObject)inChannel.get("bizgroup");
            if (null != bizgroup2 && null != (ids = BusinessDataServiceHelper.load((String)"bos_org", (String)"id", (QFilter[])new QFilter[]{new QFilter("bos_org.id", "=", bizgroup2.getPkValue())})) && ids.length > 0) {
                saleOrg = ids[0];
            }
            this.getModel().setValue("org", saleOrg);
        }
        if (null != inChannel && null != (customertype = (DynamicObject)inChannel.get("customertype")) && (customerTypes = BusinessDataServiceHelper.load((String)"mdr_customer_type", (String)"id,typeid", (QFilter[])new QFilter[]{new QFilter("id", "=", customertype.getPkValue())})).length > 0 && ("D".equals(typeid = customerTypes[0].getString("typeid")) || "F".equals(typeid))) {
            this.getModel().setValue("sellorgchannel", (Object)inChannel);
            return;
        }
        DynamicObject saleOrgChannel = null;
        if (null != saleOrg && null != (result = BusinessDataServiceHelper.load((String)"mdr_customer", (String)"FID", (QFilter[])new QFilter[]{bizgroup = new QFilter("bizgroup", "=", saleOrg.getPkValue()), status = new QFilter("status", "=", (Object)"C"), innerOrg = new QFilter("isinnerorg", "=", (Object)Boolean.TRUE), enable = new QFilter("enable", "=", (Object)Boolean.TRUE)})) && 0 < result.length) {
            saleOrgChannel = result[0];
        }
        this.getModel().setValue("sellorgchannel", saleOrgChannel);
    }

    private void clearSaleOrgAndChannel() {
        this.getModel().setValue("org", null);
        this.getModel().setValue("sellorgchannel", null);
    }

    public void beforeItemClick(BeforeItemClickEvent evt) {
        DynamicObject lot_number_id;
        if (!StringUtils.equals((CharSequence)"bar_save", (CharSequence)evt.getItemKey()) || (lot_number_id = (DynamicObject)this.getModel().getValue("lotnumberid")) == null) {
            // empty if block
        }
    }

    public void propertyChanged(PropertyChangedArgs e) {
        String name;
        super.propertyChanged(e);
        switch (name = e.getProperty().getName()) {
            case "billtypeid": {
                this.inStockWay();
                break;
            }
            case "warehouse": {
                int rowIndex = e.getChangeSet()[0].getRowIndex();
                this.clearLocationId(rowIndex);
                this.checkStockLocation(e);
                break;
            }
            case "inchannelid": {
                this.changeAllRowOwnerAndSetter();
                this.changeAllDefaultWareHouse();
                this.preSetSupplyChannelIdChange();
                this.clearSaleOrgAndChannel();
                this.setSaleOrgAndChannel();
                this.setCurrency();
                this.changeChannelIdConfirm();
                break;
            }
            case "itemid": {
                DynamicObject newItem = (DynamicObject)e.getChangeSet()[0].getNewValue();
                int rowNo = this.getRowIndex(e);
                this.clearAllSubEntryRows(rowNo);
                this.setDefaultValues(rowNo);
                this.lockDataAfterReviseRowItemId(rowNo, newItem);
                this.ifDisableLockSerialNum();
                this.setOwnerAndKeeper(rowNo);
                this.setDefaultWareHouseID(rowNo);
                this.setStockStatusAndStockType(rowNo);
                this.setSerialNumberUnitAndQty(rowNo, newItem);
                break;
            }
            case "qty": {
                this.afterQtyChange(e);
                int i = this.getRowIndex(e);
                DynamicObject item = (DynamicObject)this.getModel().getEntryRowEntity("billentry", i).get("itemid");
                if (item != null) {
                    this.afterQtyChange(e);
                    this.setSerialNumberUnitAndQty(i, item);
                    break;
                }
                this.getView().showMessage("\u8bf7\u5148\u9009\u62e9\u5546\u54c1");
                return;
            }
            case "unitid": {
                this.afterQtyChange(e);
                int i_unit = this.getRowIndex(e);
                DynamicObject item_unit = (DynamicObject)this.getModel().getEntryRowEntity("billentry", i_unit).get("itemid");
                if (item_unit != null) {
                    this.afterQtyChange(e);
                    this.setSerialNumberUnitAndQty(i_unit, item_unit);
                    break;
                }
                this.getView().showMessage("\u8bf7\u5148\u9009\u62e9\u5546\u54c1");
                return;
            }
            case "lotnumberid": {
                Object obj = this.getValue("lotnumberid");
                if (null == obj) break;
                int ilot = this.getRowIndex(e);
                this.getView().getModel().setValue("lotnumber", (Object)((DynamicObject)obj).getString("number"), ilot);
                break;
            }
            case "serialid": {
                Object serialObj = this.getValue("serialid");
                if (null == serialObj) break;
                int irow = this.getRowIndex(e);
                this.getView().getModel().setValue("serialnumber", (Object)((DynamicObject)serialObj).getString("number"), irow);
                break;
            }
            case "lotnumber": {
                int i_row = this.getRowIndex(e);
                this.reloadLotId(i_row);
                this.relLotNumberSpace(this.getRowIndex(e));
                break;
            }
            case "serialnumber": {
                this.relSnNumberSpace(this.getRowIndex(e));
            }
        }
    }

    private void reloadLotId(int row) {
        QFilter idFilter;
        QFilter itemidFilter;
        DynamicObject[] result;
        String number;
        this.getView().getModel().setItemValueByID("lotnumberid", null, row);
        Long rs = null;
        Long itemid = 0L;
        DynamicObject item = (DynamicObject)this.getModel().getEntryRowEntity("billentry", row).get("itemid");
        if (item == null) {
            return;
        }
        itemid = item.getLong("id");
        DynamicObject auxpty = (DynamicObject)this.getModel().getEntryRowEntity("billentry", row).get("auxptyid");
        QFilter auxptyFilter = null;
        if (null != auxpty) {
            Long auxptyId = (Long)auxpty.getPkValue();
            auxptyFilter = new QFilter("auxptyid", "=", (Object)auxptyId);
        }
        if ((number = (String)this.getModel().getEntryRowEntity("billentry", row).get("lotnumber")) != null && null != (result = BusinessDataServiceHelper.load((String)"ocic_lot", (String)"id,enable", (QFilter[])new QFilter[]{itemidFilter = new QFilter("itemid", "=", (Object)itemid), auxptyFilter, idFilter = new QFilter("number", "=", (Object)number)})) && result.length > 0) {
            if (result[0].getString("enable").equals("0")) {
                this.getView().showMessage("\u5546\u54c1" + item.getString("number") + "\u7684\u6279\u53f7" + number + "\u88ab\u7981\u7528,\u8bf7\u5148\u542f\u7528\u6b64\u6279\u53f7");
                return;
            }
            rs = result[0].getLong("id");
        }
        this.getView().getModel().setItemValueByID("lotnumberid", rs, row);
    }

    private void relLotNumberSpace(int row) {
        DynamicObject dynamicObject = this.getModel().getEntryRowEntity("billentry", row);
        String lotNumber = dynamicObject.getString("lotnumber");
        if (lotNumber != null) {
            lotNumber = lotNumber.replaceAll("\u3000", " ").trim();
            this.setValue("lotnumber", lotNumber, row, false);
        }
    }

    private void relSnNumberSpace(int row) {
        DynamicObject dynamicObject = this.getModel().getEntryRowEntity("subentryentity", row);
        String fieldValue = dynamicObject.getString("serialnumber");
        if (fieldValue != null) {
            fieldValue = fieldValue.replaceAll("\u3000", " ").trim();
            this.setValue("serialnumber", fieldValue, row, false);
        }
    }

    private void clearAllSubEntryRows(int i) {
        DynamicObject entryRowEntity = this.getModel().getEntryRowEntity("billentry", i);
        DynamicObjectCollection subEntries = entryRowEntity.getDynamicObjectCollection("subentryentity");
        int rowCount = subEntries.getRowCount();
        if (rowCount > 0) {
            int[] rows = new int[rowCount];
            for (int j = 0; j < rowCount; ++j) {
                rows[j] = j;
            }
            this.getModel().deleteEntryRows("subentryentity", rows);
        }
    }

    private void setSerialNumberUnitAndQty(int i, DynamicObject itemObject) {
        DynamicObject entryRowEntity = this.getModel().getEntryRowEntity("billentry", i);
        if (itemObject == null) {
            return;
        }
        if (itemObject.getBoolean("enableserial")) {
            DynamicObject serialUnit = (DynamicObject)itemObject.get("serialunit");
            if (null != serialUnit) {
                DynamicObject baseUnit;
                Long baseUnitId;
                BigDecimal serialQty;
                this.getModel().setValue("serialunit", serialUnit.getPkValue(), i);
                Long serialUnitId = (Long)serialUnit.getPkValue();
                DynamicObject material = entryRowEntity.getDynamicObject("materialid");
                Long materialId = material != null ? (Long)material.getPkValue() : 0L;
                BigDecimal baseQty = entryRowEntity.getBigDecimal("baseqty");
                if (baseQty != null && this.MAX_QTY.compareTo(baseQty) < 0) {
                    this.getView().showMessage("\u6570\u91cf\u8d85\u51fa\u7cbe\u5ea6\u9650\u5236\uff0c\u8bf7\u786e\u8ba4");
                    return;
                }
                if (null == baseQty) {
                    baseQty = BigDecimal.ZERO;
                }
                if (this.MAX_QTY.compareTo(serialQty = UnitConvertHelper.calculateDestQty((BigDecimal)baseQty, (Long)materialId, (Long)(baseUnitId = Long.valueOf((baseUnit = entryRowEntity.getDynamicObject("baseunitid")) != null ? (Long)baseUnit.getPkValue() : 0L)), (Long)serialUnitId)) < 0) {
                    this.getView().showMessage("\u5e8f\u5217\u53f7\u6570\u91cf\u8d85\u51fa\u7cbe\u5ea6\u9650\u5236\uff0c\u8bf7\u786e\u8ba4");
                    return;
                }
                this.setRowValue("serialqty", serialQty, i);
            } else {
                this.getModel().setValue("serialunit", null, i);
                this.getModel().setValue("serialqty", (Object)0, i);
                this.setUnEnable(i, new String[]{"serialunit", "serialqty"});
            }
        }
    }

    private void checkStockLocationAfterBind() {
        int entryRowCount = this.getModel().getEntryRowCount("billentry");
        for (int i = 0; i < entryRowCount; ++i) {
            DynamicObject newStock = (DynamicObject)this.getModel().getEntryRowEntity("billentry", i).get("warehouse");
            boolean enablelocation = newStock.getBoolean("enablelocation");
            if (enablelocation) {
                this.getView().setEnable(Boolean.TRUE, i, new String[]{"locationid"});
                continue;
            }
            this.getView().setEnable(Boolean.FALSE, i, new String[]{"locationid"});
        }
    }

    private void checkStockLocation(PropertyChangedArgs e) {
        int rowIndex = e.getChangeSet()[0].getRowIndex();
        DynamicObject newStock = (DynamicObject)e.getChangeSet()[0].getNewValue();
        if (null != newStock) {
            DynamicObject[] dynamicObjects;
            boolean enablelocation = newStock.getBoolean("enablelocation");
            this.getView().setEnable(Boolean.valueOf(enablelocation), rowIndex, new String[]{"locationid"});
            if (enablelocation && null != (dynamicObjects = BusinessDataServiceHelper.load((String)"ocic_location", (String)"id", (QFilter[])new QFilter[]{new QFilter("warehouseid", "=", newStock.getPkValue()), new QFilter("isdefault", "=", (Object)Boolean.TRUE)})) && dynamicObjects.length > 0) {
                this.getModel().setItemValueByID("locationid", dynamicObjects[0].getPkValue(), rowIndex);
            }
        }
    }

    private void setCurrency() {
        Object inChannel = this.getInChannel();
        if (inChannel != null) {
            DynamicObject currency = ((DynamicObject)inChannel).getDynamicObject("currency");
            this.getModel().setValue("settlecurrencyid", currency.getPkValue());
            this.getView().setEnable(Boolean.FALSE, new String[]{"settlecurrencyid"});
        } else {
            this.getModel().setValue("settlecurrencyid", null);
        }
    }

    private void clearLocationId(int rowIndex) {
        this.getModel().setValue("locationid", null, rowIndex);
    }

    private void changeIntypeValue() {
        this.getModel().setValue("intype", (Object)"1");
    }

    private void preSetSupplyChannelIdChange() {
        this.getModel().setValue("supplychannelid", null);
        if (this.getInChannelIdObject() == null) {
            return;
        }
        List<Long> ids = this.getIdsFromMdrCustomerAuthorize();
        if (ids.size() == 0) {
            return;
        }
        QFilter idFilter = new QFilter("id", "in", ids);
        QFilter enableFilter = new QFilter("enable", "=", (Object)"1");
        DynamicObject[] result = BusinessDataServiceHelper.load((String)"mdr_customer", (String)"id", (QFilter[])new QFilter[]{idFilter, enableFilter});
        if (null != result && 0 < result.length) {
            this.getModel().setValue("supplychannelid", (Object)result[0].getLong("id"));
        }
    }

    private void afterQtyChange(PropertyChangedArgs e) {
        DynamicObject serialUnit;
        DynamicObject auxunitIdObj;
        int rowIndex = this.getRowIndex(e);
        DynamicObject itemObj = this.getCurrentRowInfo("billentry");
        if (itemObj == null) {
            return;
        }
        this.setALLQTYZERO(rowIndex);
        BigDecimal qty = BigDecimal.ZERO;
        if (itemObj.get("qty") != null) {
            qty = (BigDecimal)itemObj.get("qty");
        }
        DynamicObject materielObj = (DynamicObject)itemObj.get("materialid");
        Long materielId = 0L;
        if (materielObj != null && materielObj.getPkValue() != null) {
            materielId = (Long)materielObj.getPkValue();
        } else {
            this.setRowValue("qty", null, rowIndex);
        }
        Long srcUnitId = 0L;
        if (itemObj.get("unitid") != null) {
            srcUnitId = (Long)((DynamicObject)itemObj.get("unitid")).getPkValue();
        }
        DynamicObject unitIdObj = (DynamicObject)itemObj.get("baseunitid");
        Long baseUnitId = 0L;
        BigDecimal baseQty = BigDecimal.ZERO;
        if (null != unitIdObj) {
            baseUnitId = (Long)unitIdObj.getPkValue();
            baseQty = UnitConvertHelper.calculateDestQty((BigDecimal)qty, (Long)materielId, (Long)srcUnitId, (Long)baseUnitId);
            if (this.MAX_QTY.compareTo(baseQty) < 0) {
                this.getView().showMessage("\u6570\u91cf\u8d85\u51fa\u7cbe\u5ea6\u9650\u5236\uff0c\u8bf7\u786e\u8ba4");
                return;
            }
            this.setRowValue("baseqty", baseQty, rowIndex);
        }
        if (null != (auxunitIdObj = (DynamicObject)itemObj.get("assistunitid"))) {
            Long assistantUnitId = auxunitIdObj.getPkValue() != null ? (Long)auxunitIdObj.getPkValue() : 0L;
            BigDecimal assistantQty = UnitConvertHelper.calculateDestQty((BigDecimal)qty, (Long)materielId, (Long)srcUnitId, (Long)assistantUnitId);
            if (this.MAX_QTY.compareTo(assistantQty) < 0) {
                this.getView().showMessage("\u8f85\u52a9\u6570\u91cf\u8d85\u51fa\u7cbe\u5ea6\u9650\u5236\uff0c\u8bf7\u786e\u8ba4");
                return;
            }
            this.setRowValue("assistqty", assistantQty, rowIndex);
        }
        if (null != (serialUnit = (DynamicObject)itemObj.get("serialunit"))) {
            Long serialUnitId = serialUnit.getPkValue() != null ? (Long)serialUnit.getPkValue() : 0L;
            BigDecimal serialQty = UnitConvertHelper.calculateDestQty((BigDecimal)baseQty, (Long)materielId, (Long)baseUnitId, (Long)serialUnitId);
            if (this.MAX_QTY.compareTo(serialQty) < 0) {
                this.getView().showMessage("\u5e8f\u5217\u53f7\u6570\u91cf\u8d85\u51fa\u7cbe\u5ea6\u9650\u5236\uff0c\u8bf7\u786e\u8ba4");
                return;
            }
            this.setRowValue("serialqty", serialQty, rowIndex);
        }
    }

    private void setALLQTYZERO(int rowIndex) {
        this.setRowValue("baseqty", 0, rowIndex);
        this.setRowValue("assistqty", 0, rowIndex);
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs ea) {
        String opKey;
        super.beforeDoOperation(ea);
        switch (opKey = ((AbstractOperate)ea.getSource()).getOperateKey()) {
            case "newentry": {
                if (null == this.getInChannel()) {
                    ea.setCancel(true);
                    this.getView().showMessage("\u8bf7\u5148\u9009\u62e9\u5165\u5e93\u6e20\u9053");
                }
                if (null != this.getSupplyChannel()) break;
                ea.setCancel(true);
                this.getView().showMessage("\u8bf7\u5148\u7ef4\u62a4\u4f9b\u8d27\u6e20\u9053\u3002");
                break;
            }
            case "newsubentry": {
                if (this.isEmptyEntry()) {
                    ea.setCancel(true);
                    this.getView().showMessage("\u8bf7\u5148\u6dfb\u52a0\u5206\u5f55\uff01");
                    return;
                }
                this.ifDisableLockSerialNumberColumn(ea);
                break;
            }
            case "deleteentry": {
                break;
            }
            case "save": 
            case "submit": {
                String msg = this.checkItemIsSaleable();
                if (!kd.bos.orm.util.StringUtils.hasText((String)msg)) break;
                ea.setCancel(true);
                this.getView().showMessage("\u7b2c" + msg + "\u884c\uff0c\u5546\u54c1\u4e0d\u5728\u6b64\u6e20\u9053\u53ef\u9500\u8303\u56f4\u5185\uff0c\u8bf7\u68c0\u67e5\u3002");
            }
        }
    }

    private String checkItemIsSaleable() {
        int i;
        StringBuilder sb = new StringBuilder();
        List<QFilter> itemFilters = this.getItemFilter();
        DynamicObject[] validItems = BusinessDataServiceHelper.load((String)"mdr_item_info", (String)"id", (QFilter[])itemFilters.toArray(new QFilter[0]));
        ArrayList<Long> validIds = new ArrayList<Long>(8);
        for (DynamicObject validItem : validItems) {
            validIds.add(validItem.getLong("id"));
        }
        int entryRowCount = this.getModel().getEntryRowCount("billentry");
        DynamicObjectCollection entries = this.getModel().getEntryEntity("billentry");
        DynamicObject item = null;
        for (i = 0; i < entryRowCount; ++i) {
            item = ((DynamicObject)entries.get(i)).getDynamicObject("itemid");
            if (null == item || validIds.contains(item.getPkValue())) continue;
            sb.append(i + 1);
            sb.append(',');
        }
        i = sb.lastIndexOf(",");
        if (0 < i) {
            sb.deleteCharAt(i);
        }
        return sb.toString();
    }

    private void ifDisableLockSerialNumberColumn(BeforeDoOperationEventArgs ea) {
        if (1 > this.getModel().getEntryRowCount("billentry")) {
            this.getView().showMessage("\u8bf7\u5148\u6dfb\u52a0\u5546\u54c1\u4fe1\u606f\u3002");
            return;
        }
        int entryCurrentRowIndex = this.getModel().getEntryCurrentRowIndex("billentry");
        DynamicObject entryRowEntity = this.getModel().getEntryRowEntity("billentry", entryCurrentRowIndex);
        DynamicObject item = entryRowEntity.getDynamicObject("itemid");
        if (null != item) {
            boolean enableserial = item.getBoolean("enableserial");
            if (!enableserial) {
                ea.setCancel(true);
                this.getView().showMessage("\u5546\u54c1\u672a\u542f\u7528\u5e8f\u5217\u53f7\u7ba1\u7406\uff0c\u4e0d\u5141\u8bb8\u5f55\u5165\u5e8f\u5217\u53f7\u3002");
            }
        } else {
            ea.setCancel(true);
            this.getView().showMessage("\u8bf7\u5148\u9009\u62e9\u5546\u54c1\u3002");
        }
    }

    private boolean isEmptyEntry() {
        return 1 > this.getModel().getEntryRowCount("billentry");
    }

    private void ifDisableLockSerialNum() {
        boolean enableserial;
        DynamicObject item;
        int entryCurrentRowIndex = this.getModel().getEntryCurrentRowIndex("billentry");
        DynamicObject entryRowEntity = this.getModel().getEntryRowEntity("billentry", entryCurrentRowIndex);
        if (null != entryRowEntity && null != (item = entryRowEntity.getDynamicObject("itemid")) && (enableserial = item.getBoolean("enableserial"))) {
            this.getView().setEnable(Boolean.TRUE, new String[]{"sn_addrow"});
            this.getView().setEnable(Boolean.TRUE, new String[]{"sn_deleterow"});
        }
    }

    private void changeAllRowOwnerAndSetter() {
        int entryRowCount = this.getModel().getEntryRowCount("billentry");
        for (int i = 0; i < entryRowCount; ++i) {
            this.setOwnerAndKeeper(i);
        }
    }

    private void changeAllDefaultWareHouse() {
        int entryRowCount = this.getModel().getEntryRowCount("billentry");
        for (int i = 0; i < entryRowCount; ++i) {
            this.setDefaultWareHouseID(i);
        }
    }
}

