/*
 * Decompiled with CFR 0.152.
 */
package kd.drp.ocic.formplugin.stockoutPlugins;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.EventObject;
import java.util.List;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.IDataEntityType;
import kd.bos.entity.datamodel.events.AfterAddRowEventArgs;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.form.ConfirmCallBackListener;
import kd.bos.form.ConfirmTypes;
import kd.bos.form.IPageCache;
import kd.bos.form.MessageBoxOptions;
import kd.bos.form.MessageBoxResult;
import kd.bos.form.control.Control;
import kd.bos.form.events.BeforeClosedEvent;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.events.MessageBoxClosedEvent;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.form.field.events.BeforeF7SelectListener;
import kd.bos.form.operate.AbstractOperate;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.list.ListShowParameter;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.orm.util.StringUtils;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.drp.mdr.common.f7.F7Utils;
import kd.drp.mdr.common.itemcontrol.ItemSaleControlUtil;
import kd.drp.mdr.common.util.UserUtil;
import kd.drp.mdr.formplugin.MdrFormPlugin;
import kd.drp.ocic.business.helper.UnitConvertHelper;
import kd.drp.ocic.enums.SnStatusEnum;

public class StockOutBillEdit
extends MdrFormPlugin
implements BeforeF7SelectListener {
    private BigDecimal MAX_QTY = new BigDecimal("999999999999.999999999");
    private static final String OUT_CHANNEL_CHANGED_CALLBACK_KEY = "changeOutChannelCallBack";
    private static final String ORDER_CHANNEL_CHANGED_CALLBACK_KEY = "changeOrderChannelCallBack";

    public void beforeClosed(BeforeClosedEvent e) {
    }

    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.addClickListeners(new String[]{"lotnumber"});
        this.addClickListeners(new String[]{"serialnumber"});
        this.addF7Listener(this, new String[]{"outchannelid", "orderchannelid", "stockid", "stockaddrid", "unitid", "serialid", "itemid", "materielid", "lotid"});
    }

    public void afterBindData(EventObject e) {
        super.afterBindData(e);
        this.getView().setEnable(Boolean.FALSE, new String[]{"org"});
        this.getView().setEnable(Boolean.FALSE, new String[]{"saleorgchannelid"});
        this.getView().setEnable(Boolean.FALSE, new String[]{"currencyid"});
        this.setRowLockProperties();
    }

    private void setRowLockProperties() {
        int entryRowCount = this.getModel().getEntryRowCount("billentry");
        for (int i = 0; i < entryRowCount; ++i) {
            DynamicObject entryRowEntity = this.getModel().getEntryRowEntity("billentry", i);
            DynamicObject item = entryRowEntity.getDynamicObject("itemid");
            if (null == item) continue;
            this.setAssistantProperty(i, item);
            this.setLotPropertyLockStatus(i, item);
            this.setStockLocationLockStatus(i, entryRowEntity);
        }
    }

    private void setStockLocationLockStatus(int i, DynamicObject entryRowEntity) {
        Object stock;
        if (null != entryRowEntity && null != (stock = entryRowEntity.get("stockid"))) {
            boolean enablelocation = ((DynamicObject)stock).getBoolean("enablelocation");
            this.getView().setEnable(Boolean.valueOf(enablelocation), i, new String[]{"stockaddrid"});
        }
    }

    private void setLotPropertyLockStatus(int i, DynamicObject item) {
        if (null != item) {
            boolean enablelot = item.getBoolean("enablelot");
            this.getView().setEnable(Boolean.valueOf(enablelot), i, new String[]{"lotnumber"});
        }
    }

    public void afterCreateNewData(EventObject e) {
        super.afterCreateNewData(e);
        this.setDefaultOutChannel();
        this.setDefaultEntryRowValue();
    }

    private void setDefaultEntryRowValue() {
        int entryRowCount = this.getModel().getEntryRowCount("billentry");
        if (0 < entryRowCount) {
            this.setOwnerAndKeeper(0);
            this.setDefaultStock(0);
        }
    }

    private List<QFilter> getFilters4LotByItemId() {
        ArrayList<QFilter> filters = new ArrayList<QFilter>(10);
        DynamicObject rowObj = this.getCurrentRowInfo("billentry");
        if (null == rowObj) {
            return filters;
        }
        Object itemObj = rowObj.get("itemid");
        if (null == itemObj) {
            return filters;
        }
        Long itemId = (Long)((DynamicObject)itemObj).getPkValue();
        QFilter itemIdFilter = new QFilter("itemid", "=", (Object)itemId);
        filters.add(itemIdFilter);
        QFilter enableFilter = new QFilter("enable", "=", (Object)"1");
        filters.add(enableFilter);
        QFilter auxptyFilter = null;
        Object auxpty = rowObj.get("auxptyid");
        if (auxpty instanceof DynamicObject) {
            Long auxptyId = (Long)((DynamicObject)auxpty).getPkValue();
            auxptyFilter = new QFilter("auxptyid", "=", (Object)auxptyId);
            filters.add(auxptyFilter);
        }
        return filters;
    }

    private List<QFilter> getFilters4SNByItemId() {
        Object keeperType;
        Object keeperId;
        Object ownerType;
        Object ownerId;
        Object stockType;
        Object stockStatus;
        Object locationId;
        Object stockId;
        Object productionDate;
        int currentRowIndex;
        Object lotId;
        Long auxptyId;
        ArrayList<QFilter> filters = new ArrayList<QFilter>(16);
        DynamicObject rowObj = this.getCurrentRowInfo("billentry");
        if (null == rowObj) {
            return filters;
        }
        Object itemObj = rowObj.get("itemid");
        if (null == itemObj) {
            return filters;
        }
        Long itemId = (Long)((DynamicObject)itemObj).getPkValue();
        QFilter itemIdFilter = new QFilter("itemid", "=", (Object)itemId);
        filters.add(itemIdFilter);
        QFilter auxptyFilter = null;
        DynamicObject auxpty = (DynamicObject)rowObj.get("auxptyid");
        if (null != auxpty && 0L < (auxptyId = Long.valueOf(auxpty.getLong("id")))) {
            auxptyFilter = new QFilter("auxptyid", "=", (Object)auxptyId);
            filters.add(auxptyFilter);
        }
        if (!this.isOppositeDirection()) {
            QFilter snStatusInStock = new QFilter("snstatus", "=", (Object)SnStatusEnum.INSTOCK.getValue());
            filters.add(snStatusInStock);
        }
        if (this.isOppositeDirection()) {
            QFilter snStatusOnWay = new QFilter("snstatus", "=", (Object)SnStatusEnum.RETURNOUTSTOCK.getValue());
            filters.add(snStatusOnWay);
        }
        filters.add(new QFilter("lockstatus", "=", (Object)Character.valueOf('0')));
        Object outChannelId = this.getF7PKValue("outchannelid");
        if (null != outChannelId) {
            filters.add(new QFilter("channelid", "=", outChannelId));
        }
        if (null != (lotId = this.getValue("lotid", currentRowIndex = this.getCurrentRowIndex("billentry"))) && lotId instanceof DynamicObject) {
            QFilter lotIdFilter = new QFilter("lotid", "=", ((DynamicObject)lotId).getPkValue());
            filters.add(lotIdFilter);
        }
        if (null != (productionDate = this.getValue("productdate", currentRowIndex))) {
            filters.add(new QFilter("productdate", "=", productionDate));
        }
        Object validToDate = this.getValue("expiredate", currentRowIndex);
        if (null != productionDate) {
            filters.add(new QFilter("effectivedate", "=", validToDate));
        }
        if (null != (stockId = this.getEntryF7PKValue("billentry", "stockid", currentRowIndex))) {
            filters.add(new QFilter("channelstockid", "=", stockId));
        }
        if (null != (locationId = this.getEntryF7PKValue("billentry", "stockaddrid", currentRowIndex))) {
            filters.add(new QFilter("channellocationid", "=", locationId));
        }
        if (null != (stockStatus = this.getEntryF7PKValue("billentry", "stockstatusid", currentRowIndex))) {
            filters.add(new QFilter("channelstockstatusid", "=", stockStatus));
        }
        if (null != (stockType = this.getEntryF7PKValue("billentry", "stocktypeid", currentRowIndex))) {
            filters.add(new QFilter("channelstocktypeid", "=", stockType));
        }
        if (null != (ownerId = this.getEntryF7PKValue("billentry", "ownerid", currentRowIndex))) {
            filters.add(new QFilter("ownerid", "=", ownerId));
        }
        if (null != (ownerType = this.getValue("ownertype", currentRowIndex))) {
            filters.add(new QFilter("ownertype", "=", ownerType));
        }
        if (null != (keeperId = this.getEntryF7PKValue("billentry", "keeperid", currentRowIndex))) {
            filters.add(new QFilter("keeperid", "=", keeperId));
        }
        if (null != (keeperType = this.getValue("keepertype", currentRowIndex))) {
            filters.add(new QFilter("keepertype", "=", keeperType));
        }
        return filters;
    }

    public void click(EventObject e) {
        String key;
        super.click(e);
        switch (key = ((Control)e.getSource()).getKey()) {
            case "lotnumber": {
                BasedataEdit lotIdBaseEdit = (BasedataEdit)this.getControl("lotid");
                lotIdBaseEdit.setQFilters(this.getFilters4LotByItemId());
                lotIdBaseEdit.setF7MultipleSelect(false);
                lotIdBaseEdit.click();
                break;
            }
            case "serialnumber": {
                BasedataEdit snIdBaseEdit = (BasedataEdit)this.getControl("serialid");
                snIdBaseEdit.setQFilters(this.getFilters4SNByItemId());
                snIdBaseEdit.setF7MultipleSelect(false);
                snIdBaseEdit.click();
            }
        }
    }

    public void beforeF7Select(BeforeF7SelectEvent e) {
        String propName = e.getProperty().getName();
        int currentRowIndex = e.getRow();
        ListShowParameter showParameter = (ListShowParameter)e.getFormShowParameter();
        ArrayList<QFilter> qFilters = new ArrayList<QFilter>();
        switch (propName) {
            case "outchannelid": {
                showParameter.getListFilterParameter().setQFilters(this.getOutChannelFilters());
                break;
            }
            case "orderchannelid": {
                Object outchannel = this.getModel().getValue("outchannelid");
                if (null == outchannel) {
                    this.getView().showMessage("\u8bf7\u5148\u9009\u62e9\u51fa\u5e93\u6e20\u9053\u3002");
                    e.setCancel(true);
                    break;
                }
                showParameter.getListFilterParameter().setQFilters(this.getOrderChannelFilters());
                break;
            }
            case "itemid": {
                F7Utils.addF7Filter((BeforeF7SelectEvent)e, this.getItemFilter());
                break;
            }
            case "unitid": {
                qFilters.add(new QFilter("id", "in", this.getUnitFilterRange(currentRowIndex, e)));
                showParameter.getListFilterParameter().setQFilters(qFilters);
                showParameter.setMultiSelect(false);
                break;
            }
            case "stockid": {
                Long channelId = (Long)this.getOutStockChannelPKValue();
                ArrayList<QFilter> filters = new ArrayList<QFilter>();
                QFilter qf1 = new QFilter("ownerchannelid", "=", (Object)channelId);
                QFilter status = new QFilter("status", "=", (Object)"C");
                QFilter enable = new QFilter("enable", "=", (Object)Boolean.TRUE);
                filters.add(qf1);
                filters.add(status);
                filters.add(enable);
                showParameter.getListFilterParameter().setQFilters(filters);
                showParameter.setMultiSelect(false);
                break;
            }
            case "stockaddrid": {
                if (null == this.getModel().getValue("stockid", currentRowIndex)) {
                    e.setCancel(true);
                    this.getView().showMessage("\u8bf7\u9009\u62e9\u4ed3\u5e93\u3002");
                    break;
                }
                long wid = ((DynamicObject)this.getModel().getEntryRowEntity("billentry", currentRowIndex).get("stockid")).getLong("id");
                QFilter qf2 = new QFilter("warehouseid", "=", (Object)wid);
                showParameter.getListFilterParameter().setFilter(qf2);
                showParameter.setMultiSelect(false);
                break;
            }
            case "materielid": {
                this.checkItemExistsWhenChooseMaterial(e);
                break;
            }
            case "lotid": {
                Object item = this.getModel().getValue("itemid", currentRowIndex);
                if (null == item) {
                    e.setCancel(true);
                    this.getView().showMessage("\u8bf7\u5148\u9009\u62e9\u5546\u54c1\uff01");
                    break;
                }
                Object pkValue = ((DynamicObject)item).getPkValue();
                QFilter filterByItemId = new QFilter("itemid", "=", pkValue);
                showParameter.getListFilterParameter().setFilter(filterByItemId);
                break;
            }
            case "serialid": {
                DynamicObject nowItem;
                int row = e.getRow();
                DynamicObject parent = (DynamicObject)this.getModel().getEntryRowEntity("chnloutbill_sn", row).getParent();
                if (null == parent || null == (nowItem = parent.getDynamicObject("itemid"))) break;
                QFilter filter = new QFilter("itemid", "=", nowItem.getPkValue());
                showParameter.getListFilterParameter().setFilter(filter);
            }
        }
    }

    public void afterAddRow(AfterAddRowEventArgs e) {
        super.afterAddRow(e);
        String entryName = e.getEntryProp().getName();
        int rowIndex = e.getRowDataEntities()[0].getRowIndex();
        switch (entryName) {
            case "billentry": {
                this.setOwnerAndKeeper(rowIndex);
                this.setDefaultStock(rowIndex);
                this.checkStockStatusDefaultValueIsEnable(rowIndex);
                this.checkStockTypeDefaultValueIsEnable(rowIndex);
            }
        }
    }

    private void checkStockTypeDefaultValueIsEnable(int i) {
        boolean enable;
        Object stockStatus = this.getValue("stocktypeid", i);
        if (stockStatus instanceof DynamicObject && !(enable = ((DynamicObject)stockStatus).getBoolean("enable"))) {
            this.setValue("stocktypeid", null, i, false);
        }
    }

    private void checkStockStatusDefaultValueIsEnable(int i) {
        boolean enable;
        Object stockStatus = this.getValue("stockstatusid", i);
        if (stockStatus instanceof DynamicObject && !(enable = ((DynamicObject)stockStatus).getBoolean("enable"))) {
            this.setValue("stockstatusid", null, i, false);
        }
    }

    public void propertyChanged(PropertyChangedArgs e) {
        String propName;
        if (!this.triggerChangeEvent) {
            return;
        }
        switch (propName = e.getProperty().getName()) {
            case "outchannelid": {
                this.changeChannelIdConfirm(e);
                this.setSaleOrgAndChannel(e);
                this.setCurrencyByOutChannel(e);
                this.setValue("orderchannelid", null, false);
                break;
            }
            case "orderchannelid": {
                this.changeChannelIdConfirm(e);
                break;
            }
            case "billtypeid": {
                this.setOutDirectionByBillType(e);
                break;
            }
            case "itemid": {
                this.initEntryRowEntity(e);
                break;
            }
            case "quantity": {
                this.setMultiQuantities(e);
                break;
            }
            case "unitid": {
                this.resetQuantities(e);
                break;
            }
            case "stockid": {
                this.checkStockLocation(e);
                break;
            }
            case "lotid": {
                this.setLotNumberByLotId(e);
                break;
            }
            case "lotnumber": {
                int i_row = this.getRowIndex(e);
                this.reloadLotId(i_row);
                this.relLotNumberSpace(this.getRowIndex(e));
                break;
            }
            case "serialid": {
                this.setSerialNumberBySerialId(e);
                break;
            }
            case "serialnumber": {
                this.relSnNumberSpace(this.getRowIndex(e));
            }
        }
    }

    private void reloadLotId(int row) {
        this.getView().getModel().setItemValueByID("lotid", null, row);
        Long rs = 0L;
        Long itemid = 0L;
        DynamicObject item = (DynamicObject)this.getModel().getEntryRowEntity("billentry", row).get("itemid");
        if (item == null) {
            return;
        }
        itemid = item.getLong("id");
        String number = (String)this.getModel().getEntryRowEntity("billentry", row).get("lotnumber");
        if (number != null) {
            DynamicObject[] result;
            QFilter itemidFilter = new QFilter("itemid", "=", (Object)itemid);
            QFilter idFilter = new QFilter("number", "=", (Object)number);
            QFilter auxptyFilter = null;
            DynamicObject auxpty = (DynamicObject)this.getView().getModel().getEntryRowEntity("billentry", row).get("auxptyid");
            if (null != auxpty) {
                Long auxptyId = (Long)auxpty.getPkValue();
                auxptyFilter = new QFilter("auxptyid", "=", (Object)auxptyId);
            }
            if (null != (result = BusinessDataServiceHelper.load((String)"ocic_lot", (String)"id", (QFilter[])new QFilter[]{itemidFilter, idFilter, auxptyFilter})) && result.length > 0) {
                rs = result[0].getLong("id");
                this.getView().getModel().setItemValueByID("lotid", (Object)rs, row);
            } else {
                this.getView().getModel().setItemValueByID("lotid", null, row);
            }
        }
    }

    private void relLotNumberSpace(int row) {
        DynamicObject dynamicObject = this.getModel().getEntryRowEntity("billentry", row);
        String lotNumber = dynamicObject.getString("lotnumber");
        if (lotNumber != null) {
            lotNumber = lotNumber.replaceAll("\u3000", " ").trim();
            this.setValue("lotnumber", lotNumber, row, false);
        }
    }

    private void relSnNumberSpace(int row) {
        DynamicObject dynamicObject = this.getModel().getEntryRowEntity("chnloutbill_sn", row);
        String fieldValue = dynamicObject.getString("serialnumber");
        if (fieldValue != null) {
            fieldValue = fieldValue.replaceAll("\u3000", " ").trim();
            this.setValue("serialnumber", fieldValue, row, false);
        }
    }

    private void setStockStock4AllRows() {
        Object outChannel = this.getModel().getValue("outchannelid");
        if (outChannel instanceof DynamicObject) {
            this.setStockStock4AllRows((DynamicObject)outChannel);
        }
    }

    private void setStockStock4AllRows(DynamicObject outChannel) {
        QFilter ownerchannelid = new QFilter("ownerchannelid", "=", outChannel.getPkValue());
        QFilter isdelivery = new QFilter("isdelivery", "=", (Object)Boolean.TRUE);
        QFilter isreturn = new QFilter("isreturn", "=", (Object)Boolean.TRUE);
        QFilter status = new QFilter("status", "=", (Object)"C");
        QFilter enable = new QFilter("enable", "=", (Object)Boolean.TRUE);
        ArrayList<QFilter> filters = new ArrayList<QFilter>();
        filters.add(ownerchannelid);
        filters.add(status);
        filters.add(enable);
        if (this.isOppositeDirection()) {
            filters.add(isreturn);
        } else {
            filters.add(isdelivery);
        }
        DynamicObject tempStock = null;
        DynamicObject[] stocks = BusinessDataServiceHelper.load((String)"ocic_warehouse", (String)"id, enablelocation", (QFilter[])filters.toArray(new QFilter[0]));
        if (null != stocks && stocks.length > 0) {
            tempStock = stocks[0];
        }
        int entryRowCount = this.getModel().getEntryRowCount("billentry");
        for (int i = 0; i < entryRowCount; ++i) {
            if (null != tempStock) {
                this.getModel().setItemValueByID("stockid", tempStock.getPkValue(), i);
                this.setStockLocationByStock(i, tempStock);
                continue;
            }
            this.getModel().setValue("stockid", null, i);
            this.setStockLocationByStock(i, null);
        }
    }

    public void changeChannelIdConfirm(PropertyChangedArgs e) {
        int entryRowCount = this.getModel().getEntryRowCount("billentry");
        if (entryRowCount > 0) {
            ConfirmCallBackListener changeOutChannelListener = new ConfirmCallBackListener(OUT_CHANNEL_CHANGED_CALLBACK_KEY, (IFormPlugin)this);
            ConfirmCallBackListener changeOrderChannelListener = new ConfirmCallBackListener(ORDER_CHANNEL_CHANGED_CALLBACK_KEY, (IFormPlugin)this);
            switch (e.getProperty().getName()) {
                case "outchannelid": {
                    this.getView().showConfirm("\u51fa\u5e93\u6e20\u9053\u53d1\u751f\u53d8\u66f4\uff0c\u662f\u5426\u5220\u9664\u5206\u5f55\uff1f", MessageBoxOptions.YesNo, ConfirmTypes.Default, changeOutChannelListener);
                    break;
                }
                case "orderchannelid": {
                    this.getView().showConfirm("\u8981\u8d27\u6e20\u9053\u53d1\u751f\u53d8\u66f4\uff0c\u662f\u5426\u5220\u9664\u5206\u5f55\uff1f", MessageBoxOptions.YesNo, ConfirmTypes.Default, changeOrderChannelListener);
                }
            }
        }
    }

    public void confirmCallBack(MessageBoxClosedEvent e) {
        if (e.getResult().equals((Object)MessageBoxResult.Yes)) {
            this.getModel().deleteEntryData("billentry");
            this.getModel().deleteEntryData("chnloutbill_sn");
            return;
        }
        switch (e.getCallBackId()) {
            case "changeOutChannelCallBack": {
                this.setStockStock4AllRows();
                this.setOwnerAndKeeper4AllRows();
                break;
            }
        }
    }

    private void setOwnerAndKeeper4AllRows() {
        Object outChannel = this.getModel().getValue("outchannelid");
        if (outChannel instanceof DynamicObject) {
            int entryRowCount = this.getModel().getEntryRowCount("billentry");
            for (int i = 0; i < entryRowCount; ++i) {
                this.setOwnerAndKeeper(i);
            }
        }
    }

    private void setSerialNumberBySerialId(PropertyChangedArgs e) {
        int i = e.getChangeSet()[0].getRowIndex();
        this.getModel().setValue("serialnumber", (Object)"", i);
        DynamicObject snId = (DynamicObject)e.getChangeSet()[0].getNewValue();
        if (null != snId) {
            this.getModel().setValue("serialnumber", snId.get("number"), i);
        }
    }

    private void checkItemExistsWhenChooseMaterial(BeforeF7SelectEvent e) {
        int rowIndex = e.getRow();
        DynamicObject entryRowEntity = this.getModel().getEntryRowEntity("billentry", rowIndex);
        if (null == entryRowEntity.getDynamicObject("itemid")) {
            e.setCancel(true);
            this.getView().showMessage("\u8bf7\u5148\u9009\u62e9\u5546\u54c1\u3002");
        }
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs ea) {
        String opKey;
        super.beforeDoOperation(ea);
        switch (opKey = ((AbstractOperate)ea.getSource()).getOperateKey()) {
            case "newentry": {
                if (this.getOutStockChannelPKValue() == null) {
                    ea.setCancel(true);
                    this.getView().showMessage("\u8bf7\u5148\u9009\u62e9\u51fa\u5e93\u6e20\u9053\uff01");
                }
                if (this.getOrderChannelId() != null) break;
                ea.setCancel(true);
                this.getView().showMessage("\u8bf7\u5148\u9009\u62e9\u8981\u8d27\u6e20\u9053\uff01");
                break;
            }
            case "newsubentry": {
                if (this.isEmptyEntry()) {
                    ea.setCancel(true);
                    this.getView().showMessage("\u8bf7\u5148\u6dfb\u52a0\u5206\u5f55\uff01");
                }
                this.ifDisableLockSerialNumberColumn(ea);
                break;
            }
            case "save": 
            case "submit": {
                String msg;
                if (this.isEmptyEntry()) {
                    ea.setCancel(true);
                    this.getView().showMessage("\u81f3\u5c11\u8981\u6709\u4e00\u6761\u5206\u5f55\uff01");
                }
                if (!StringUtils.hasText((String)(msg = this.checkItemIsSaleable()))) break;
                ea.setCancel(true);
                this.getView().showMessage("\u7b2c" + msg + "\u884c\uff0c\u5546\u54c1\u4e0d\u5728\u6b64\u6e20\u9053\u53ef\u9500\u8303\u56f4\u5185\uff0c\u8bf7\u68c0\u67e5\u3002");
                break;
            }
            case "audit": {
                String billStatus = (String)this.getModel().getValue("billstatus");
                if ("B".equals(billStatus)) break;
                ea.setCancel(true);
                this.getView().showMessage("\u53ea\u5141\u8bb8\u5bf9\u63d0\u4ea4\u72b6\u6001\u7684\u5355\u636e\u8fdb\u884c\u5ba1\u6838\uff01");
            }
        }
    }

    private String checkItemIsSaleable() {
        int i;
        StringBuilder sb = new StringBuilder();
        List<QFilter> itemFilters = this.getItemFilter();
        DynamicObject[] validItems = BusinessDataServiceHelper.load((String)"mdr_item_info", (String)"id", (QFilter[])itemFilters.toArray(new QFilter[0]));
        ArrayList<Long> validIds = new ArrayList<Long>(8);
        for (DynamicObject validItem : validItems) {
            validIds.add(validItem.getLong("id"));
        }
        int entryRowCount = this.getModel().getEntryRowCount("billentry");
        DynamicObjectCollection entries = this.getModel().getEntryEntity("billentry");
        for (i = 0; i < entryRowCount; ++i) {
            DynamicObject item = ((DynamicObject)entries.get(i)).getDynamicObject("itemid");
            if (null == item || validIds.contains(item.getPkValue())) continue;
            sb.append(i + 1);
            sb.append(',');
        }
        i = sb.lastIndexOf(",");
        if (0 < i) {
            sb.deleteCharAt(i);
        }
        return sb.toString();
    }

    private boolean isEmptyEntry() {
        return 1 > this.getModel().getEntryRowCount("billentry");
    }

    private void setOutDirectionByBillType(PropertyChangedArgs e) {
        DynamicObject billType = (DynamicObject)e.getChangeSet()[0].getNewValue();
        if (null != billType) {
            String billTypeNumber = billType.getString("number");
            if (billTypeNumber.equals("BBC_out_sys004")) {
                this.getModel().setValue("outdirection", (Object)"2");
                int rowIndex = e.getChangeSet()[0].getRowIndex();
                this.getView().setEnable(Boolean.FALSE, rowIndex, new String[]{"chnloutbill_sn"});
            } else {
                this.getModel().setValue("outdirection", (Object)"1");
            }
        }
    }

    private List<QFilter> getOrderChannelFilters() {
        DynamicObject outchannel = (DynamicObject)this.getModel().getValue("outchannelid");
        if (null == outchannel) {
            this.getView().showMessage("\u8bf7\u5148\u9009\u62e9\u51fa\u5e93\u6e20\u9053\u3002");
            return null;
        }
        Long outChannelId = (Long)outchannel.getPkValue();
        ArrayList<QFilter> qFilters = new ArrayList<QFilter>();
        DynamicObject[] relations = BusinessDataServiceHelper.load((String)"mdr_customer_authorize", (String)"customer", (QFilter[])new QFilter[]{new QFilter("authowner", "=", (Object)outChannelId).and(new QFilter("enable", "=", (Object)Boolean.TRUE))});
        ArrayList<Long> ids = new ArrayList<Long>(16);
        for (DynamicObject relation : relations) {
            ids.add((Long)relation.getDynamicObject("customer").getPkValue());
        }
        QFilter qFilter1 = new QFilter("id", "in", ids);
        qFilters.add(qFilter1);
        return qFilters;
    }

    private List<QFilter> getOutChannelFilters() {
        ArrayList<QFilter> qFilters = new ArrayList<QFilter>();
        QFilter qFilter1 = new QFilter("isinnerorg", "=", (Object)Boolean.FALSE);
        QFilter qFilter2 = new QFilter("status", "=", (Object)"C");
        QFilter qFilter3 = new QFilter("enable", "=", (Object)Boolean.TRUE);
        QFilter qFilter4 = new QFilter("customertype.isinsideorg", "=", (Object)Boolean.FALSE);
        QFilter qFilter5 = new QFilter("customerfunctions.fbasedataid.number", "=", (Object)"003");
        qFilters.add(qFilter1);
        qFilters.add(qFilter2);
        qFilters.add(qFilter3);
        qFilters.add(qFilter4);
        qFilters.add(qFilter5);
        qFilters.add(UserUtil.getCommonUserOwnersFilter());
        return qFilters;
    }

    private void setDefaultOutChannel() {
        List<QFilter> outChannelFilters = this.getOutChannelFilters();
        int size = outChannelFilters.size();
        QFilter[] qFilters = new QFilter[size];
        for (int i = 0; i < size; ++i) {
            qFilters[i] = outChannelFilters.get(i);
        }
        DynamicObject[] outChannels = BusinessDataServiceHelper.load((String)"mdr_customer", (String)"id", (QFilter[])qFilters);
        if (null != outChannels && outChannels.length > 0) {
            this.getModel().setValue("outchannelid", outChannels[0].getPkValue());
            this.setCurrencyByOutChannel();
            this.setSaleOrgAndChannel();
        }
    }

    protected List<QFilter> getItemFilter() {
        ArrayList<QFilter> fs = new ArrayList<QFilter>();
        fs.add(ItemSaleControlUtil.getItemFilterUsePageCache((Object)this.getOutStockChannelPKValue(), (Object)this.getOrderChannelPKValue(), (IPageCache)this.getPageCache()));
        fs.add(new QFilter("isonsell", "=", (Object)"1"));
        fs.add(new QFilter("nonsingle", "=", (Object)"0"));
        return fs;
    }

    private List<Long> getUnitFilterRange(int currentRowIndex, BeforeF7SelectEvent e) {
        DynamicObject[] result;
        DynamicObject[] ids;
        ArrayList<Long> filterIds = new ArrayList<Long>(8);
        DynamicObject rowEntity = this.getModel().getEntryRowEntity("billentry", currentRowIndex);
        DynamicObject materialObj = (DynamicObject)rowEntity.get("materielid");
        DynamicObject item = (DynamicObject)rowEntity.get("itemid");
        if (null == item) {
            e.setCancel(true);
            this.getView().showMessage("\u8bf7\u5148\u9009\u62e9\u5546\u54c1~");
            return filterIds;
        }
        DynamicObject baseunit = rowEntity.getDynamicObject("baseunitid");
        if (null == baseunit) {
            e.setCancel(true);
            this.getView().showMessage("\u57fa\u672c\u8ba1\u91cf\u5355\u4f4d\u4e3a\u7a7a\uff0c\u8bf7\u68c0\u67e5\u5546\u54c1~");
            return filterIds;
        }
        Long groupId = (Long)baseunit.getDynamicObject("group").getPkValue();
        for (DynamicObject id : ids = BusinessDataServiceHelper.load((String)"bd_measureunits", (String)"id", (QFilter[])new QFilter[]{new QFilter("group", "=", (Object)groupId)})) {
            filterIds.add((Long)id.getPkValue());
        }
        if (null == materialObj) {
            return filterIds;
        }
        Object pkValue = materialObj.getPkValue();
        QFilter materialIdFilter = new QFilter("materialid", "=", pkValue);
        QFilter conversionTypeFilter = new QFilter("converttype", "=", (Object)1);
        for (DynamicObject rObj : result = BusinessDataServiceHelper.load((String)"bd_multimeasureunit", (String)"measureunitid", (QFilter[])new QFilter[]{materialIdFilter, conversionTypeFilter})) {
            filterIds.add((Long)((DynamicObject)rObj.get("measureunitid")).getPkValue());
        }
        return filterIds;
    }

    private void setLotNumberByLotId(PropertyChangedArgs e) {
        int i = e.getChangeSet()[0].getRowIndex();
        DynamicObject lotId = (DynamicObject)e.getChangeSet()[0].getNewValue();
        if (null != lotId) {
            this.setValue("lotnumber", lotId.get("number"), i, false);
        }
    }

    private void checkStockLocation(PropertyChangedArgs e) {
        int rowIndex = e.getChangeSet()[0].getRowIndex();
        DynamicObject newStock = (DynamicObject)e.getChangeSet()[0].getNewValue();
        this.setStockLocationByStock(rowIndex, newStock);
    }

    private void setStockLocationByStock(int rowIndex, DynamicObject newStock) {
        this.getModel().setValue("stockaddrid", null, rowIndex);
        if (null != newStock) {
            DynamicObject[] dynamicObjects;
            boolean enablelocation = newStock.getBoolean("enablelocation");
            this.getView().setEnable(Boolean.valueOf(enablelocation), rowIndex, new String[]{"stockaddrid"});
            if (enablelocation && null != (dynamicObjects = BusinessDataServiceHelper.load((String)"ocic_location", (String)"id", (QFilter[])new QFilter[]{new QFilter("ocic_location.warehouseid", "=", newStock.getPkValue()), new QFilter("ocic_location.isdefault", "=", (Object)Boolean.TRUE)})) && dynamicObjects.length > 0) {
                this.getModel().setValue("stockaddrid", (Object)dynamicObjects[0], rowIndex);
            }
        }
    }

    private void ifDisableLockSerialNumberColumn(BeforeDoOperationEventArgs ea) {
        if (1 > this.getModel().getEntryRowCount("billentry")) {
            this.getView().showMessage("\u8bf7\u5148\u6dfb\u52a0\u5546\u54c1\u4fe1\u606f\u3002");
            return;
        }
        int entryCurrentRowIndex = this.getModel().getEntryCurrentRowIndex("billentry");
        DynamicObject entryRowEntity = this.getModel().getEntryRowEntity("billentry", entryCurrentRowIndex);
        DynamicObject item = entryRowEntity.getDynamicObject("itemid");
        if (null != item) {
            boolean enableserial = item.getBoolean("enableserial");
            if (!enableserial) {
                ea.setCancel(true);
                this.getView().showMessage("\u5546\u54c1\u672a\u542f\u7528\u5e8f\u5217\u53f7\u7ba1\u7406\uff0c\u4e0d\u5141\u8bb8\u5f55\u5165\u5e8f\u5217\u53f7\u3002");
            }
        } else {
            ea.setCancel(true);
            this.getView().showMessage("\u8bf7\u5148\u9009\u62e9\u5546\u54c1\u3002");
        }
    }

    private void initEntryRowEntity(PropertyChangedArgs e) {
        Object newValue = e.getChangeSet()[0].getNewValue();
        int i = e.getChangeSet()[0].getRowIndex();
        if (null == newValue) {
            this.setDefaultValues(i);
            return;
        }
        this.setOwnerAndKeeper(i);
        this.setDefaultStock(i);
        DynamicObject newItem = (DynamicObject)e.getChangeSet()[0].getNewValue();
        if (null != newItem) {
            this.setDefaultValues(i);
            this.setDefaultStock(i);
            this.initLotNumberColumn(i, newItem);
            this.initMaterialColumn(i, newItem);
            this.initItemUnit(i, newItem);
            this.setAssistantProperty(i, newItem);
            this.setSerialNumberUnitAndQty(i, newItem);
            this.clearAllSubEntryRows(i);
        }
    }

    private void clearAllSubEntryRows(int i) {
        int rowCount;
        DynamicObject entryRowEntity = this.getModel().getEntryRowEntity("billentry", i);
        DynamicObjectCollection subEntries = entryRowEntity.getDynamicObjectCollection("chnloutbill_sn");
        if (!CollectionUtils.isEmpty((Collection)subEntries) && (rowCount = subEntries.getRowCount()) > 0) {
            int[] rows = new int[rowCount];
            for (int j = 0; j < rowCount; ++j) {
                rows[j] = j;
            }
            this.getModel().deleteEntryRows("chnloutbill_sn", rows);
        }
    }

    private void initLotNumberColumn(int i, DynamicObject item) {
        boolean enablelot = item.getBoolean("enablelot");
        this.getView().setEnable(Boolean.valueOf(enablelot), i, new String[]{"lotnumber"});
        this.setRowValue("lotid", 0, i);
        this.setRowValue("lotnumber", null, i);
    }

    private void setDefaultValues(int i) {
        this.getModel().setValue("auxptyid", null, i);
        this.getModel().setValue("materielid", null, i);
        this.getModel().setValue("unitid", null, i);
        this.getModel().setValue("baseunitid", null, i);
        this.getModel().setValue("auxptyunitid", null, i);
        this.getModel().setValue("quantity", (Object)0, i);
        this.getModel().setValue("basequantity", (Object)0, i);
        this.getModel().setValue("auxquantity", (Object)0, i);
        this.getModel().setValue("snquantity", (Object)0, i);
        this.getModel().setValue("snunit", null, i);
        this.getModel().setValue("lotid", null, i);
        this.getModel().setValue("lotnumber", (Object)"", i);
        this.getModel().setValue("snunit", null, i);
        this.getModel().setValue("snquantity", (Object)0, i);
    }

    private void setSerialNumberUnitAndQty(int i, DynamicObject item) {
        DynamicObject entryRowEntity = this.getModel().getEntryRowEntity("billentry", i);
        if (item.getBoolean("enableserial")) {
            DynamicObject serialUnit = (DynamicObject)item.get("serialunit");
            if (null != serialUnit) {
                BigDecimal baseQty;
                this.getModel().setValue("snunit", serialUnit.getPkValue(), i);
                Long serialUnitId = (Long)serialUnit.getPkValue();
                DynamicObject material = entryRowEntity.getDynamicObject("materielid");
                Long materialId = 0L;
                if (null != material) {
                    materialId = (Long)material.getPkValue();
                }
                if (null == (baseQty = entryRowEntity.getBigDecimal("basequantity"))) {
                    baseQty = BigDecimal.ZERO;
                }
                DynamicObject baseUnit = entryRowEntity.getDynamicObject("baseunitid");
                Long baseUnitId = 0L;
                if (null != baseUnit) {
                    baseUnitId = (Long)baseUnit.getPkValue();
                }
                BigDecimal serialQty = UnitConvertHelper.calculateDestQty((BigDecimal)baseQty, (Long)materialId, (Long)baseUnitId, (Long)serialUnitId);
                this.setRowValue("snquantity", serialQty, i);
            } else {
                this.getModel().setValue("snunit", null, i);
                this.getModel().setValue("snquantity", (Object)0, i);
                this.setUnEnable(i, new String[]{"snunit", "snquantity"});
            }
        }
    }

    private void setAssistantProperty(int i, DynamicObject item) {
        if (null != item) {
            if (Boolean.FALSE.equals(item.get("hasattr"))) {
                this.getView().setEnable(Boolean.FALSE, i, new String[]{"auxptyid"});
            } else {
                this.getView().setEnable(Boolean.TRUE, i, new String[]{"auxptyid"});
            }
        }
    }

    private void initItemUnit(int rowIndex, DynamicObject currentItem) {
        if (null != currentItem) {
            DynamicObject stockUnit = currentItem.getDynamicObject("stockunit");
            this.setItemUnits(currentItem, rowIndex, stockUnit);
        }
    }

    private void setItemUnits(DynamicObject currentItem, int rowIndex, DynamicObject stockUnit) {
        if (null != stockUnit && null != currentItem) {
            DynamicObject stockunit4Item = stockUnit;
            DynamicObject baseunit4Item = currentItem.getDynamicObject("baseunit");
            DynamicObject assistantunit4Item = currentItem.getDynamicObject("assistunit");
            this.getModel().setValue("unitid", (Object)stockunit4Item, rowIndex);
            if (null == baseunit4Item) {
                this.getView().setEnable(Boolean.TRUE, rowIndex, new String[]{"baseunitid"});
            } else {
                this.getModel().setValue("baseunitid", (Object)baseunit4Item, rowIndex);
                this.getView().setEnable(Boolean.FALSE, rowIndex, new String[]{"baseunitid"});
            }
            if (null == assistantunit4Item) {
                this.getView().setEnable(Boolean.TRUE, rowIndex, new String[]{"auxptyunitid"});
            } else {
                this.getModel().setValue("auxptyunitid", (Object)assistantunit4Item, rowIndex);
                this.getView().setEnable(Boolean.FALSE, rowIndex, new String[]{"auxptyunitid"});
            }
        }
    }

    private void initMaterialColumn(int i, DynamicObject currentItem) {
        if (null != currentItem) {
            DynamicObject material4Item = currentItem.getDynamicObject("material");
            if (null == material4Item) {
                this.getModel().setValue("materielid", null, i);
                this.getView().setEnable(Boolean.TRUE, i, new String[]{"materielid"});
            } else {
                this.getModel().setValue("materielid", (Object)material4Item, i);
                this.getView().setEnable(Boolean.FALSE, i, new String[]{"materielid"});
            }
        }
    }

    private void resetQuantities(PropertyChangedArgs e) {
        Object newValue = e.getChangeSet()[0].getNewValue();
        if (null == newValue) {
            return;
        }
        int rowIndex = e.getChangeSet()[0].getRowIndex();
        DynamicObject currentRowInfo = this.getCurrentRowInfo("billentry");
        BigDecimal qty = currentRowInfo.getBigDecimal("quantity");
        if (null != qty && BigDecimal.ZERO.compareTo(qty) < 0) {
            DynamicObject currentItem = currentRowInfo.getDynamicObject("itemid");
            DynamicObject currentUnit = currentRowInfo.getDynamicObject("unitid");
            if (null == currentUnit) {
                this.getView().setEnable(Boolean.FALSE, rowIndex, new String[]{"quantity"});
                return;
            }
            if (null != currentUnit) {
                this.getView().setEnable(Boolean.TRUE, rowIndex, new String[]{"quantity"});
                this.setItemUnits(currentItem, rowIndex, currentUnit);
                this.setMultiQuantities(e);
            }
        }
    }

    private void setMultiQuantities(PropertyChangedArgs e) {
        DynamicObject serialUnit;
        DynamicObject auxunitIdObj;
        DynamicObject srcUnit;
        Object newValue = e.getChangeSet()[0].getNewValue();
        if (null == newValue) {
            return;
        }
        if ("quantity".equals(e.getProperty().getName())) {
            if (BigDecimal.ZERO.compareTo((BigDecimal)newValue) == 0) {
                return;
            }
            if (BigDecimal.ZERO.compareTo((BigDecimal)newValue) > 0) {
                this.getView().showMessage("\u5546\u54c1\u6570\u91cf\u4e0d\u80fd\u4e3a\u8d1f\u6570,\u8bf7\u68c0\u67e5.");
            }
        }
        int rowIndex = this.getRowIndex(e);
        DynamicObject currentRowInfo = this.getCurrentRowInfo("billentry");
        BigDecimal qty = currentRowInfo.getBigDecimal("quantity");
        DynamicObject materielObj = currentRowInfo.getDynamicObject("materielid");
        Long materielId = 0L;
        if (null != materielObj) {
            materielId = (Long)materielObj.getPkValue();
        }
        if (null == (srcUnit = currentRowInfo.getDynamicObject("unitid"))) {
            return;
        }
        Long srcUnitId = (Long)srcUnit.getPkValue();
        DynamicObject baseUnit = currentRowInfo.getDynamicObject("baseunitid");
        if (null == baseUnit) {
            this.getView().showMessage("\u57fa\u672c\u5355\u4f4d\u4e3a\u7a7a\uff0c\u8bf7\u68c0\u67e5\u5546\u54c1\u662f\u5426\u6b63\u786e\u3002");
            return;
        }
        Long baseUnitId = (Long)baseUnit.getPkValue();
        BigDecimal baseQty = BigDecimal.ZERO;
        if (null != baseUnit) {
            baseQty = UnitConvertHelper.calculateDestQty((BigDecimal)qty, (Long)materielId, (Long)srcUnitId, (Long)baseUnitId);
            if (this.MAX_QTY.compareTo(baseQty) < 0) {
                this.getView().showMessage("\u6570\u91cf\u8d85\u51fa\u7cbe\u5ea6\u9650\u5236\uff0c\u8bf7\u786e\u8ba4\u6570\u91cf");
                return;
            }
            this.setRowValue("basequantity", baseQty, rowIndex);
        }
        if (null != (auxunitIdObj = currentRowInfo.getDynamicObject("auxptyunitid"))) {
            Long assistantUnitId = (Long)auxunitIdObj.getPkValue();
            BigDecimal assistantQty = UnitConvertHelper.calculateDestQty((BigDecimal)baseQty, (Long)materielId, (Long)baseUnitId, (Long)assistantUnitId);
            if (this.MAX_QTY.compareTo(baseQty) < 0) {
                this.getView().showMessage("\u6570\u91cf\u8d85\u51fa\u7cbe\u5ea6\u9650\u5236\uff0c\u8bf7\u786e\u8ba4\u6570\u91cf");
                return;
            }
            this.setRowValue("auxquantity", assistantQty, rowIndex);
        }
        if (null != (serialUnit = currentRowInfo.getDynamicObject("snunit"))) {
            Long serialUnitId = (Long)serialUnit.getPkValue();
            BigDecimal serialQty = UnitConvertHelper.calculateDestQty((BigDecimal)baseQty, (Long)materielId, (Long)baseUnitId, (Long)serialUnitId);
            if (this.MAX_QTY.compareTo(baseQty) < 0) {
                this.getView().showMessage("\u6570\u91cf\u8d85\u51fa\u7cbe\u5ea6\u9650\u5236\uff0c\u8bf7\u786e\u8ba4\u6570\u91cf");
                return;
            }
            this.setRowValue("snquantity", serialQty, rowIndex);
        }
    }

    private Object getOutChannel() {
        return this.getModel().getValue("outchannelid");
    }

    private void setOwnerAndKeeper(int rowIndex) {
        Object outChannel = this.getOutChannel();
        if (null != outChannel) {
            IDataEntityType type = ((DynamicObject)outChannel).getDataEntityType();
            this.getModel().setValue("ownertype", (Object)type.getName(), rowIndex);
            this.getView().setEnable(Boolean.FALSE, rowIndex, new String[]{"ownertype"});
            this.getModel().setValue("ownerid", outChannel, rowIndex);
            this.getView().setEnable(Boolean.FALSE, rowIndex, new String[]{"ownerid"});
            this.getModel().setValue("keepertype", (Object)type.getName(), rowIndex);
            this.getView().setEnable(Boolean.FALSE, rowIndex, new String[]{"keepertype"});
            this.getModel().setValue("keeperid", outChannel, rowIndex);
            this.getView().setEnable(Boolean.FALSE, rowIndex, new String[]{"keeperid"});
        }
    }

    private void setDefaultStock(int rowIndx) {
        Object outChannel = this.getOutChannel();
        if (null == outChannel) {
            return;
        }
        QFilter ownerchannelid = new QFilter("ownerchannelid", "=", ((DynamicObject)outChannel).getPkValue());
        QFilter isdelivery = new QFilter("isdelivery", "=", (Object)Boolean.TRUE);
        QFilter isreturn = new QFilter("isreturn", "=", (Object)Boolean.TRUE);
        QFilter status = new QFilter("status", "=", (Object)"C");
        QFilter enable = new QFilter("enable", "=", (Object)Boolean.TRUE);
        ArrayList<QFilter> filters = new ArrayList<QFilter>();
        filters.add(ownerchannelid);
        filters.add(status);
        filters.add(enable);
        if (this.isOppositeDirection()) {
            filters.add(isreturn);
        } else {
            filters.add(isdelivery);
        }
        DynamicObject[] stocks = BusinessDataServiceHelper.load((String)"ocic_warehouse", (String)"id, enablelocation", (QFilter[])filters.toArray(new QFilter[0]));
        if (null != stocks && stocks.length > 0) {
            this.getModel().setValue("stockid", (Object)stocks[0], rowIndx);
            this.setStockLocationByStock(rowIndx, stocks[0]);
        }
    }

    private void setSaleOrgAndChannel(PropertyChangedArgs e) {
        DynamicObject outChannel = (DynamicObject)e.getChangeSet()[0].getNewValue();
        this.setSaleOrgAndChannel(outChannel);
    }

    private void setSaleOrgAndChannel() {
        Object outChannel = this.getModel().getValue("outchannelid");
        if (null != outChannel) {
            this.setSaleOrgAndChannel((DynamicObject)outChannel);
        } else {
            this.getModel().setValue("org", null);
        }
    }

    private void setSaleOrgAndChannel(DynamicObject outChannel) {
        QFilter enable;
        QFilter innerOrg;
        QFilter status;
        QFilter bizgroup;
        DynamicObject[] result;
        String typeid;
        DynamicObject[] customerTypes;
        DynamicObject customertype;
        DynamicObject saleOrg = null;
        if (null == outChannel) {
            this.getModel().setValue("org", null);
        }
        if (null != outChannel) {
            DynamicObject[] ids;
            DynamicObject bizgroup2 = outChannel.getDynamicObject("bizgroup");
            if (null != bizgroup2 && null != (ids = BusinessDataServiceHelper.load((String)"bos_org", (String)"id", (QFilter[])new QFilter[]{new QFilter("bos_org.id", "=", bizgroup2.getPkValue())})) && ids.length > 0) {
                saleOrg = ids[0];
            }
            this.getModel().setValue("org", saleOrg);
        }
        if (null != outChannel && null != (customertype = outChannel.getDynamicObject("customertype")) && (customerTypes = BusinessDataServiceHelper.load((String)"mdr_customer_type", (String)"id,typeid", (QFilter[])new QFilter[]{new QFilter("id", "=", customertype.getPkValue())})).length > 0 && ("D".equals(typeid = customerTypes[0].getString("typeid")) || "F".equals(typeid))) {
            this.getModel().setValue("saleorgchannelid", (Object)outChannel);
            return;
        }
        DynamicObject saleOrgChannel = null;
        if (null != saleOrg && null != (result = BusinessDataServiceHelper.load((String)"mdr_customer", (String)"FID", (QFilter[])new QFilter[]{bizgroup = new QFilter("bizgroup", "=", saleOrg.getPkValue()), status = new QFilter("status", "=", (Object)"C"), innerOrg = new QFilter("isinnerorg", "=", (Object)Boolean.TRUE), enable = new QFilter("enable", "=", (Object)Boolean.TRUE)})) && 0 < result.length) {
            saleOrgChannel = result[0];
        }
        this.getModel().setValue("saleorgchannelid", saleOrgChannel);
    }

    private void setCurrencyByOutChannel(PropertyChangedArgs e) {
        DynamicObject outChannel = (DynamicObject)e.getChangeSet()[0].getNewValue();
        this.setCurrencyByOutChannel(outChannel);
    }

    private void setCurrencyByOutChannel() {
        Object value = this.getModel().getValue("outchannelid");
        if (null != value) {
            this.setCurrencyByOutChannel((DynamicObject)value);
        }
    }

    private void setCurrencyByOutChannel(DynamicObject outChannel) {
        DynamicObject currency;
        if (null != outChannel && null != (currency = outChannel.getDynamicObject("currency"))) {
            this.getModel().setValue("currencyid", currency.getPkValue());
        }
    }

    private boolean isOppositeDirection() {
        String outDirection = (String)this.getModel().getValue("outdirection");
        return null != outDirection && "2".equals(outDirection);
    }

    private Object getSaleOrgChannelPKValue() {
        return this.getF7PKValue("saleorgchannelid");
    }

    private Object getOrderChannelPKValue() {
        return this.getF7PKValue("orderchannelid");
    }

    private Object getOutStockChannelPKValue() {
        return this.getF7PKValue("outchannelid");
    }

    private DynamicObject getOrderChannelId() {
        DynamicObject orderchannelid = (DynamicObject)this.getModel().getValue("orderchannelid");
        return orderchannelid;
    }

    private void clearAllEntryRows() {
        this.getModel().deleteEntryData("billentry");
    }
}

