/*
 * Decompiled with CFR 0.152.
 */
package kd.drp.ocic.formplugin.warehouse;

import java.util.ArrayList;
import java.util.EventObject;
import java.util.List;
import kd.bos.base.AbstractBasePlugIn;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.entity.datamodel.events.AfterAddRowEventArgs;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.form.field.events.BeforeF7SelectListener;
import kd.bos.list.ListShowParameter;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.drp.mdr.common.enums.customer.CustomerTypeId;
import kd.drp.ocic.util.CommonUtils;
import kd.drp.ocic.util.StringUtils;

public class WarehouseEdit
extends AbstractBasePlugIn
implements BeforeF7SelectListener {
    public static final String CUSTOMERTYPE_ID = "customertype_id";

    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.addF7Listener(this, "erplocationid", "erpwarehouseid");
    }

    public void afterBindData(EventObject e) {
        super.afterBindData(e);
        Object warehouseType = this.getModel().getValue("warehousetype");
        boolean isNotChannelHouse = "2".equals(warehouseType);
        this.setFieldByWarehouseType(isNotChannelHouse);
    }

    public void afterAddRow(AfterAddRowEventArgs e) {
        super.afterAddRow(e);
        Object warehouseType = this.getModel().getValue("warehousetype");
        boolean isNotChannelHouse = "2".equals(warehouseType);
        DynamicObject channelDynObj = this.getModel().getValue("ownerchannelid") == null ? null : (DynamicObject)this.getModel().getValue("ownerchannelid");
        boolean isEnterpriseStores = this.isEnterpriseStores(channelDynObj);
        boolean isEnable = isNotChannelHouse || isEnterpriseStores;
        int entryRowCount = this.getModel().getEntryRowCount("entryentity");
        for (int i = 0; i < entryRowCount; ++i) {
            this.getView().setEnable(Boolean.valueOf(isEnable), i, new String[]{"erplocationid"});
        }
        if (entryRowCount == 1) {
            this.getModel().setValue("defaultlocation", (Object)Boolean.TRUE, 0);
        }
    }

    public void propertyChanged(PropertyChangedArgs e) {
        String key;
        switch (key = e.getProperty().getName()) {
            case "enablelocation": {
                this.getModel().deleteEntryData("entryentity");
                break;
            }
            case "ownerchannelid": 
            case "warehousetype": {
                Object warehouseType = this.getModel().getValue("warehousetype");
                boolean isNotChannelHouse = "2".equals(warehouseType);
                this.setFieldByWarehouseType(isNotChannelHouse);
                Object channelObj = this.getModel().getValue("ownerchannelid");
                long bizGroupId = 0L;
                long channelId = 0L;
                if (channelObj instanceof DynamicObject) {
                    DynamicObject channelDynObj = (DynamicObject)channelObj;
                    boolean isEnterpriseStores = this.isEnterpriseStores(channelDynObj);
                    if (isEnterpriseStores || isNotChannelHouse) {
                        bizGroupId = channelDynObj.getLong("bizgroup_id");
                    }
                    channelId = channelDynObj.getLong("id");
                }
                this.getModel().setItemValueByID("erpstockorgid", (Object)bizGroupId, 0);
                if (!"ownerchannelid".equals(key)) break;
                this.setDefaultWarehouse(channelId);
                break;
            }
            case "erpwarehouseid": {
                Object erpWarehouseDynObj = this.getModel().getValue("erpwarehouseid");
                if (!(erpWarehouseDynObj instanceof DynamicObject) || !StringUtils.isEmpty((String)this.getModel().getValue("name").toString())) break;
                this.getModel().setValue("name", ((DynamicObject)erpWarehouseDynObj).get("name"));
                break;
            }
        }
    }

    public void beforeF7Select(BeforeF7SelectEvent e) {
        String propName = e.getProperty().getName();
        ListShowParameter showParameter = (ListShowParameter)e.getFormShowParameter();
        switch (propName) {
            case "erplocationid": {
                Object erpWarehouseDynObj = this.getModel().getValue("erpwarehouseid");
                if (erpWarehouseDynObj instanceof DynamicObject) {
                    DynamicObjectCollection locationCol = ((DynamicObject)erpWarehouseDynObj).getDynamicObjectCollection("entryentity");
                    List<Long> ids = this.getLoactionIds(locationCol);
                    QFilter qFilter1 = new QFilter("id", "in", ids);
                    showParameter.getListFilterParameter().setFilter(qFilter1);
                    break;
                }
                this.getView().showTipNotification("\u8bf7\u5f55\u5165ERP\u4ed3\u5e93");
                e.setCancel(true);
                break;
            }
            case "erpwarehouseid": {
                DynamicObject org = (DynamicObject)this.getModel().getValue("erpstockorgid");
                if (org == null) {
                    this.getView().showTipNotification("\u8bf7\u5148\u9009\u62e9ERP\u5e93\u5b58\u7ec4\u7ec7");
                    e.setCancel(true);
                    return;
                }
                showParameter.getListFilterParameter().setFilter(this.getWarehouseFilter(org.getPkValue()));
            }
        }
    }

    private void setDefaultWarehouse(long channelId) {
        if (channelId <= 0L) {
            return;
        }
        QFilter defaultFilters = new QFilter("isdefault", "=", (Object)Boolean.TRUE);
        defaultFilters.or(new QFilter("isdelivery", "=", (Object)Boolean.TRUE));
        defaultFilters.or(new QFilter("isreturn", "=", (Object)Boolean.TRUE));
        QFilter channelIdFilters = new QFilter("ownerchannelid", "=", (Object)channelId);
        String selectors = String.join((CharSequence)",", "isdefault", "isdelivery", "isreturn");
        QFilter[] qFilters = new QFilter[]{defaultFilters, channelIdFilters};
        DynamicObjectCollection warehouseDynColl = QueryServiceHelper.query((String)"ocic_warehouse", (String)selectors, (QFilter[])qFilters);
        if (CommonUtils.isNull((Object)warehouseDynColl)) {
            this.getModel().setValue("isdefault", (Object)Boolean.TRUE);
            this.getModel().setValue("isdelivery", (Object)Boolean.TRUE);
            this.getModel().setValue("isreturn", (Object)Boolean.TRUE);
        } else {
            List isDefaultList = CommonUtils.collectionListBoolean((String)"isdefault", (List)warehouseDynColl);
            this.getModel().setValue("isdefault", (Object)(!isDefaultList.contains(Boolean.TRUE) ? 1 : 0));
            isDefaultList = CommonUtils.collectionListBoolean((String)"isdelivery", (List)warehouseDynColl);
            this.getModel().setValue("isdelivery", (Object)(!isDefaultList.contains(Boolean.TRUE) ? 1 : 0));
            isDefaultList = CommonUtils.collectionListBoolean((String)"isreturn", (List)warehouseDynColl);
            this.getModel().setValue("isreturn", (Object)(!isDefaultList.contains(Boolean.TRUE) ? 1 : 0));
        }
    }

    private QFilter getWarehouseFilter(Object orgId) {
        QFilter orgf = new QFilter("org", "=", orgId);
        orgf.and(new QFilter("startstatus", "=", (Object)"B"));
        String selects = "warehouse.id";
        DynamicObjectCollection warehouseDynColl = QueryServiceHelper.query((String)"im_warehousesetup", (String)selects, (QFilter[])orgf.toArray());
        List result = CommonUtils.collectionList((String)selects, (List)warehouseDynColl);
        return new QFilter("id", "in", (Object)result);
    }

    private List<Long> getLoactionIds(DynamicObjectCollection locationCol) {
        ArrayList<Long> ids = new ArrayList<Long>();
        if (locationCol == null || locationCol.size() == 0) {
            return ids;
        }
        for (DynamicObject locDym : locationCol) {
            DynamicObject location = locDym.getDynamicObject("location");
            ids.add(Long.valueOf(location.getPkValue().toString()));
        }
        return ids;
    }

    private void setFieldByWarehouseType(boolean isNotChannelHouse) {
        if (!isNotChannelHouse) {
            DynamicObject channelDynObj = this.getModel().getValue("ownerchannelid") == null ? null : (DynamicObject)this.getModel().getValue("ownerchannelid");
            this.setFieldMustInputByChannel(channelDynObj);
            boolean isEnterpriseStores = this.isEnterpriseStores(channelDynObj);
            this.setFieldEnable(isEnterpriseStores);
        } else {
            this.setFieldMustInput(isNotChannelHouse);
            this.setFieldEnable(isNotChannelHouse);
        }
    }

    private void setFieldMustInputByChannel(DynamicObject channelDynObj) {
        boolean isEnterpriseStores = this.isEnterpriseStores(channelDynObj);
        this.setFieldMustInput(isEnterpriseStores);
        this.setFieldEnable(isEnterpriseStores);
    }

    private boolean isEnterpriseStores(DynamicObject channelDynObj) {
        boolean isEnterpriseStores = false;
        if (!CommonUtils.isNull((Object)channelDynObj)) {
            String customerTypeid;
            Object customerTypePkId = channelDynObj.get(CUSTOMERTYPE_ID);
            DynamicObject customertypeDynObj = QueryServiceHelper.queryOne((String)"mdr_customer_type", (String)"typeid", (QFilter[])new QFilter("id", "=", customerTypePkId).toArray());
            String string = customerTypeid = customertypeDynObj != null ? customertypeDynObj.getString("typeid") : "";
            if (CustomerTypeId.ZHIYINGMENDIAN_DULIHESUAN.toString().equalsIgnoreCase(customerTypeid) || CustomerTypeId.ZHIYINGMENDIAN_FEIDULIHESUAN.toString().equalsIgnoreCase(customerTypeid) || CustomerTypeId.JIAMENGMENDIAN_DULIHESUAN.toString().equalsIgnoreCase(customerTypeid) || CustomerTypeId.JIAMENGMENDIAN_FEIDULIHESUAN.toString().equalsIgnoreCase(customerTypeid)) {
                isEnterpriseStores = true;
            }
        }
        return isEnterpriseStores;
    }

    private void setFieldMustInput(boolean mustInput) {
        BasedataEdit erpstockorgidCtrl = (BasedataEdit)this.getView().getControl("erpstockorgid");
        erpstockorgidCtrl.setMustInput(mustInput);
        BasedataEdit erpwarehouseidCtrl = (BasedataEdit)this.getView().getControl("erpwarehouseid");
        erpwarehouseidCtrl.setMustInput(mustInput);
    }

    private void setFieldEnable(boolean isEnable) {
        this.getView().setEnable(Boolean.valueOf(isEnable), new String[]{"erpstockorgid", "erpwarehouseid"});
        int entryRowCount = this.getModel().getEntryRowCount("entryentity");
        for (int i = 0; i < entryRowCount; ++i) {
            this.getView().setEnable(Boolean.valueOf(isEnable), i, new String[]{"erplocationid"});
        }
    }

    private void addF7Listener(BeforeF7SelectListener form, String ... f7Name) {
        BasedataEdit f7 = null;
        int len = f7Name.length;
        for (int i = 0; i < len; ++i) {
            f7 = (BasedataEdit)this.getControl(f7Name[i]);
            if (f7 == null) continue;
            f7.addBeforeF7SelectListener(form);
        }
    }
}

