/*
 * Decompiled with CFR 0.152.
 */
package kd.drp.ococ.opplugin.order;

import java.math.BigDecimal;
import java.util.HashMap;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.entity.plugin.AbstractOperationServicePlugIn;
import kd.bos.entity.plugin.args.EndOperationTransactionArgs;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;

public class Save
extends AbstractOperationServicePlugIn {
    private static final String P_NAME = "ococ_orderbill";
    private static final String POS_SALESORDER = "pos_salesorder";
    private static String F_PKID = "id";
    private static String EF_SRCBILLENTRYID = "srcbillentryid";
    public static final String F_ISINVOICE = "isinvoice";
    private static String F_BIZTYPE = "biztype";
    private static String E_ENTRYENTITY = "entryentity";
    private static String EF_SOURCEBILLNO = "sourcebillno";
    private static String F_BILLNO = "billno";
    private static String F_SOURCEBILLID = "sourcebillid";
    private static final String E_GOODSENTRYENTITY = "goodsentryentity";
    private static final String EF_LASTBILLID = "lastbillid";
    private static final String EF_LASTBILLENTRYID = "lastbillentryid";
    private static final String EF_LASTINISRCBILLID = "lastinisrcbillid";
    private static final String EF_LASTINISRCBILLENTRYID = "lastinisrcbillentryid";
    private static final String EF_ISBOOK = "isbook";
    private static final String EF_SALEQTY = "saleqty";
    private static final String EF_TOSALESQTY = "tosalesqty";
    private static final String EF_RETQTY = "retqty";
    private static final String EF_MUSTRETQTY = "mustretqty";
    private static final String EF_ROWCLOSESTATUS = "rowclosestatus";
    private static final String EF_QTY = "qty";
    private static final String EF_CLOSESTATUS = "closestatus";

    public void endOperationTransaction(EndOperationTransactionArgs e) {
        int i;
        DynamicObject[] saveObjects;
        super.endOperationTransaction(e);
        DynamicObject[] dataEntities = e.getDataEntities();
        if (dataEntities == null || dataEntities.length <= 0) {
            return;
        }
        DynamicObjectCollection saveSaleOrderDoc = new DynamicObjectCollection();
        DynamicObjectCollection saveOrderDoc = new DynamicObjectCollection();
        for (DynamicObject dataEntity : dataEntities) {
            DynamicObject orderBill;
            BigDecimal qty;
            Object sourcebillid;
            DynamicObject srcSaleOrder;
            String sourcebillno;
            DynamicObjectCollection orderGoodsEntry;
            long id = dataEntity.getLong(F_PKID);
            String bizType = dataEntity.getString(F_BIZTYPE);
            BigDecimal sumnoinvoiceamount = BigDecimal.ZERO;
            DynamicObjectCollection orderFinEntrys = dataEntity.getDynamicObjectCollection("ffinentity");
            if (orderFinEntrys.size() > 0) {
                for (DynamicObject orderFin : orderFinEntrys) {
                    DynamicObject settle = orderFin.getDynamicObject("settleid");
                    if (settle.getBoolean(F_ISINVOICE)) continue;
                    sumnoinvoiceamount = sumnoinvoiceamount.add(orderFin.getBigDecimal("settleamount"));
                }
            }
            if ((orderGoodsEntry = dataEntity.getDynamicObjectCollection(E_ENTRYENTITY)).size() <= 0 || (sourcebillno = ((DynamicObject)orderGoodsEntry.get(0)).getString(EF_SOURCEBILLNO)).isEmpty()) continue;
            int entrySize = orderGoodsEntry.size();
            HashMap<Long, DynamicObject> orderGoodsMap = new HashMap<Long, DynamicObject>(entrySize);
            for (DynamicObject entry : orderGoodsEntry) {
                Long srcbillentryid = entry.getLong(EF_SRCBILLENTRYID);
                orderGoodsMap.put(srcbillentryid, entry);
            }
            QFilter filter = new QFilter(F_BILLNO, "=", (Object)sourcebillno);
            QFilter[] allFilters = new QFilter[]{filter};
            DynamicObject saleOrder = BusinessDataServiceHelper.loadSingle((String)POS_SALESORDER, (String)"", (QFilter[])allFilters);
            if ((saleOrder = BusinessDataServiceHelper.loadSingle((Object)saleOrder.getPkValue(), (String)POS_SALESORDER)) == null) continue;
            HashMap<Long, BigDecimal> billIdMap = new HashMap<Long, BigDecimal>(entrySize);
            DynamicObjectCollection saleOrderGoodsEntry = saleOrder.getDynamicObjectCollection(E_GOODSENTRYENTITY);
            for (DynamicObject saleOrderGoods : saleOrderGoodsEntry) {
                Object entryId = saleOrderGoods.getPkValue();
                DynamicObject retailGoods = (DynamicObject)orderGoodsMap.get(entryId);
                if (retailGoods == null) continue;
                Object retailGoodsEntryId = retailGoods.getPkValue();
                BigDecimal saleqty = saleOrderGoods.getBigDecimal(EF_SALEQTY);
                saleOrderGoods.set(EF_LASTBILLID, (Object)id);
                saleOrderGoods.set(EF_LASTBILLENTRYID, retailGoodsEntryId);
                if (bizType.equals("B")) {
                    Long srcBillId = saleOrderGoods.getLong(EF_SRCBILLENTRYID);
                    billIdMap.put(srcBillId, saleqty);
                    continue;
                }
                saleOrderGoods.set(EF_LASTINISRCBILLID, (Object)id);
                saleOrderGoods.set(EF_LASTINISRCBILLENTRYID, retailGoodsEntryId);
            }
            saveSaleOrderDoc.add((Object)saleOrder);
            DynamicObject sourceBill = saleOrder.getDynamicObject(F_SOURCEBILLID);
            if (sourceBill == null || (srcSaleOrder = BusinessDataServiceHelper.loadSingle((Object)(sourcebillid = sourceBill.getPkValue()), (String)POS_SALESORDER)) == null) continue;
            HashMap<Object, BigDecimal> srcBillMap = new HashMap<Object, BigDecimal>(entrySize);
            Long orderBillId = 0L;
            Boolean closeBill = Boolean.TRUE;
            BigDecimal sumretqty = BigDecimal.ZERO;
            BigDecimal sumtosalesqty = BigDecimal.ZERO;
            DynamicObjectCollection srcSaleOrderGoodsEntry = srcSaleOrder.getDynamicObjectCollection(E_GOODSENTRYENTITY);
            for (DynamicObject srcSaleOrderGoods : srcSaleOrderGoodsEntry) {
                Boolean isbook;
                BigDecimal retqty = srcSaleOrderGoods.getBigDecimal(EF_RETQTY);
                BigDecimal tosalesqty = srcSaleOrderGoods.getBigDecimal(EF_TOSALESQTY);
                sumretqty = sumretqty.add(retqty);
                sumtosalesqty = sumtosalesqty.add(tosalesqty);
                String closeStatus = srcSaleOrderGoods.getString(EF_ROWCLOSESTATUS);
                qty = (BigDecimal)billIdMap.get(srcSaleOrderGoods.getPkValue());
                if (qty == null || qty.compareTo(BigDecimal.ZERO) == 0) {
                    if (!closeBill.booleanValue() || closeStatus.equals("B")) continue;
                    closeBill = Boolean.FALSE;
                    continue;
                }
                BigDecimal saleqty = srcSaleOrderGoods.getBigDecimal(EF_SALEQTY);
                BigDecimal mustretqty = saleqty.subtract(tosalesqty).subtract(retqty).subtract(qty.abs());
                srcSaleOrderGoods.set(EF_MUSTRETQTY, (Object)mustretqty);
                srcSaleOrderGoods.set(EF_RETQTY, (Object)retqty.add(qty.abs()));
                sumretqty = sumretqty.add(qty.abs());
                if (mustretqty.compareTo(BigDecimal.ZERO) <= 0) {
                    srcSaleOrderGoods.set(EF_ROWCLOSESTATUS, (Object)"B");
                } else if (closeBill.booleanValue()) {
                    closeBill = Boolean.FALSE;
                }
                if (!(isbook = Boolean.valueOf(srcSaleOrderGoods.getBoolean(EF_ISBOOK))).booleanValue()) continue;
                srcBillMap.put(srcSaleOrderGoods.getPkValue(), qty.abs());
                if (orderBillId != 0L) continue;
                orderBillId = srcSaleOrderGoods.getLong(EF_LASTBILLID);
            }
            srcSaleOrder.set("SUMRETQTY", (Object)sumretqty);
            srcSaleOrder.set("SUMTOSALESQTY", (Object)sumtosalesqty);
            if (closeBill.booleanValue()) {
                srcSaleOrder.set(EF_CLOSESTATUS, (Object)"B");
            }
            saveSaleOrderDoc.add((Object)srcSaleOrder);
            if (orderBillId == 0L || (orderBill = BusinessDataServiceHelper.loadSingle((Object)orderBillId, (String)P_NAME)) == null) continue;
            DynamicObjectCollection orderBillGoodsEntry = orderBill.getDynamicObjectCollection(E_ENTRYENTITY);
            for (DynamicObject orderBillGoods : orderBillGoodsEntry) {
                Long orderSrcEntryId = orderBillGoods.getLong(EF_SRCBILLENTRYID);
                qty = (BigDecimal)srcBillMap.get(orderSrcEntryId);
                if (qty == null || qty.compareTo(BigDecimal.ZERO) == 0) continue;
                BigDecimal orderQty = orderBillGoods.getBigDecimal(EF_QTY);
                BigDecimal tosalesqty = orderBillGoods.getBigDecimal(EF_TOSALESQTY);
                BigDecimal retqty = orderBillGoods.getBigDecimal(EF_RETQTY);
                orderBillGoods.set(EF_RETQTY, (Object)retqty.add(qty.abs()));
                BigDecimal mustQty = orderQty.subtract(tosalesqty).subtract(retqty).subtract(qty.abs());
                if (mustQty.compareTo(BigDecimal.ZERO) != 0) continue;
                orderBillGoods.set(EF_CLOSESTATUS, (Object)"B");
            }
            saveOrderDoc.add((Object)orderBill);
        }
        if (saveSaleOrderDoc != null && saveSaleOrderDoc.size() > 0) {
            saveObjects = new DynamicObject[saveSaleOrderDoc.size()];
            i = 0;
            for (DynamicObject bill : saveSaleOrderDoc) {
                saveObjects[i++] = bill;
            }
            SaveServiceHelper.update((DynamicObject[])saveObjects);
        }
        if (saveOrderDoc != null && saveOrderDoc.size() > 0) {
            saveObjects = new DynamicObject[saveOrderDoc.size()];
            i = 0;
            for (DynamicObject bill : saveOrderDoc) {
                saveObjects[i++] = bill;
            }
            SaveServiceHelper.update((DynamicObject[])saveObjects);
        }
    }
}

