/*
 * Decompiled with CFR 0.152.
 */
package kd.drp.pos.common;

import java.math.BigDecimal;
import java.util.List;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.drp.pos.common.util.DynamicObjectUtil;
import kd.drp.pos.common.util.F7Util;

public class CommonUtils {
    private static String[] paymentCols = new String[]{"number", "name", "isinvoice", "noenternumber", "rewardpoints", "iscoupon", "isintegratedfnc", "creator", "createtime", "modifier", "modifytime", "audittime", "reviewer", "id", "issyspreset", "enable", "paywaytype", "service"};

    public static BigDecimal getCurrencyRate(long payCurrencyId, long targetCurrencyId) {
        BigDecimal exChangeRate = BigDecimal.ZERO;
        if (payCurrencyId == targetCurrencyId) {
            return BigDecimal.ONE;
        }
        QFilter exOrgCurfilter = new QFilter("orgcur", "=", (Object)payCurrencyId);
        QFilter exCurfilter = new QFilter("cur", "=", (Object)targetCurrencyId);
        QFilter[] exFilters = new QFilter[]{exOrgCurfilter, exCurfilter};
        DynamicObject exchangeRate = BusinessDataServiceHelper.loadSingle((String)"bd_exrate_tree", (String)"excval", (QFilter[])exFilters);
        if (exchangeRate != null) {
            exChangeRate = exchangeRate.getBigDecimal("excval");
        } else {
            QFilter orgCurfilter = new QFilter("orgcur", "=", (Object)targetCurrencyId);
            QFilter curfilter = new QFilter("cur", "=", (Object)payCurrencyId);
            QFilter[] filters = new QFilter[]{orgCurfilter, curfilter};
            DynamicObject changeRate = BusinessDataServiceHelper.loadSingle((String)"bd_exrate_tree", (String)"indirectexrate", (QFilter[])filters);
            if (changeRate != null) {
                exChangeRate = changeRate.getBigDecimal("indirectexrate");
            }
        }
        return exChangeRate;
    }

    public static List<DynamicObject> getPaymentModeList() {
        QFilter filter = new QFilter("issyspreset", "=", (Object)"1");
        return QueryServiceHelper.query((String)"dbd_paymode", (String)CommonUtils.getQuerySelectColNames(paymentCols), (QFilter[])filter.toArray());
    }

    private static String getQuerySelectColNames(String[] colNames) {
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < colNames.length; ++i) {
            sb.append(colNames[i]).append(',');
        }
        String result = "";
        if (sb.length() > 0) {
            result = sb.substring(0, sb.length() - 1);
        }
        return result;
    }

    public static long getDefaultDeliveryStock(DynamicObject branch) {
        QFilter filter = F7Util.getStockIdFilter(branch);
        filter.and("isdelivery", "=", (Object)Boolean.TRUE);
        DynamicObject stock = QueryServiceHelper.queryOne((String)"ocic_warehouse", (String)"Id", (QFilter[])filter.toArray());
        return DynamicObjectUtil.getPkValue(stock);
    }
}

