/*
 * Decompiled with CFR 0.152.
 */
package kd.drp.pos.common;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.drp.dbd.common.util.F7Utils;
import kd.drp.pos.common.util.CommonUtil;
import kd.drp.pos.common.util.DynamicObjectUtil;

public class OwnerUtils {
    public static long getDefaultOwnerId() {
        List<Long> ownerIds = OwnerUtils.getOwnerIds();
        if (ownerIds == null || ownerIds.isEmpty()) {
            return 0L;
        }
        return ownerIds.get(0);
    }

    public static List<Long> getOwnerIds() {
        QFilter filter = new QFilter("sysuser", "=", (Object)RequestContext.get().getUserId());
        filter.and("enable", "=", (Object)"1");
        Map userInfos = BusinessDataServiceHelper.loadFromCache((String)"dbd_drp_user", (QFilter[])filter.toArray());
        ArrayList<Long> owners = new ArrayList<Long>(userInfos.size());
        if (userInfos.isEmpty()) {
            return owners;
        }
        long defaultOwnerId = 0L;
        for (DynamicObject userInfo : userInfos.values()) {
            DynamicObject owner = userInfo.getDynamicObject("owner");
            if (owner == null) continue;
            long ownerId = CommonUtil.formatObejctToLong(owner.getPkValue());
            if (defaultOwnerId == 0L && userInfo.getBoolean("isdefault")) {
                defaultOwnerId = ownerId;
            }
            owners.add(ownerId);
        }
        filter = F7Utils.getCommonStatusFilter();
        filter.and("Id", "in", owners);
        filter.and("isstore", "=", (Object)Boolean.TRUE);
        ArrayList<Long> ownerIds = new ArrayList<Long>();
        DynamicObjectCollection datas = QueryServiceHelper.query((String)"mdr_customer", (String)"Id", (QFilter[])filter.toArray());
        if (datas == null || datas.isEmpty()) {
            return null;
        }
        for (DynamicObject item : datas) {
            long itemId = DynamicObjectUtil.getPkValue(item);
            if (defaultOwnerId == itemId) {
                ownerIds.add(0, itemId);
                continue;
            }
            ownerIds.add(itemId);
        }
        return ownerIds;
    }
}

