/*
 * Decompiled with CFR 0.152.
 */
package kd.drp.pos.common.util;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.basedata.BaseDataServiceHelper;
import kd.drp.mdr.common.f7.F7Utils;
import kd.drp.pos.common.OwnerUtils;
import kd.drp.pos.common.saleorder.BizTypeEnum;
import kd.drp.pos.common.util.DynamicObjectUtil;

public class F7Util {
    public static QFilter getSourceBillFilter(boolean isRedRush, String bizType, DynamicObject branch) {
        QFilter qFilter = new QFilter("salebranchid", "=", (Object)DynamicObjectUtil.getPkValue(branch));
        qFilter.and("goodsentryentity.ROWCLOSESTATUS", "=", (Object)"A");
        if (StringUtils.equals((CharSequence)bizType, (CharSequence)BizTypeEnum.ORDERCONVERTSALE.getValue())) {
            qFilter.and("goodsentryentity.isbook", "=", (Object)"1");
        } else if (isRedRush && StringUtils.equals((CharSequence)bizType, (CharSequence)BizTypeEnum.SALERETURN.getValue())) {
            qFilter.and("sumretqty", "=", (Object)BigDecimal.ZERO);
            qFilter.and("sumtosalesqty", "=", (Object)BigDecimal.ZERO);
        }
        DynamicObjectCollection data = QueryServiceHelper.query((String)"pos_salesorderbaseinfo", (String)"Id", (QFilter[])qFilter.toArray());
        if (data != null && !data.isEmpty()) {
            ArrayList lstSrcBillId = new ArrayList();
            data.forEach(x -> lstSrcBillId.add(DynamicObjectUtil.getPkValue(x)));
            qFilter = new QFilter("Id", "in", (Object)lstSrcBillId.stream().distinct().toArray());
        }
        return qFilter;
    }

    public static QFilter getGoodsIdFilter(long branchId, long currencyId) {
        QFilter qFilter = F7Utils.getCommonStatusFilter();
        List<Long> lstGoodsId = F7Util.getGoodsInfoList(branchId, currencyId, true);
        qFilter.and("Id", "in", (Object)lstGoodsId.stream().distinct().toArray());
        return qFilter;
    }

    public static QFilter getBarCodeIdFilter(long branchId, long currencyId) {
        QFilter qFilter = new QFilter("status", "=", (Object)"C");
        List<Long> lstBarCodeId = F7Util.getGoodsInfoList(branchId, currencyId, false);
        qFilter.and("Id", "in", (Object)lstBarCodeId.stream().distinct().toArray());
        return qFilter;
    }

    public static QFilter getBarCodeIdFilter(long branchId, long goodsId, long currencyId) {
        QFilter qFilter = F7Util.getBarCodeIdFilter(branchId, currencyId);
        qFilter.and("item.Id", "=", (Object)goodsId);
        return qFilter;
    }

    public static QFilter getGoodsInfoFilter(long goodsId, long branchId, long barcodeId, long currencyId) {
        QFilter filter = new QFilter("customer.Id", "=", (Object)branchId);
        filter.and("barcode.Id", "=", (Object)barcodeId);
        filter.and("item.Id", "=", (Object)goodsId);
        filter.and("currency.Id", "=", (Object)currencyId);
        return filter;
    }

    public static QFilter getStockIdFilter(DynamicObject saleBrach) {
        QFilter qFilter = F7Utils.getCommonStatusFilter();
        Long branchId = DynamicObjectUtil.getPkValue(saleBrach);
        qFilter.and("ownerchannelid.Id", "=", (Object)branchId);
        return qFilter;
    }

    public static QFilter getBranchIdFilter() {
        QFilter qFilter = F7Utils.getEnableFilter();
        List<Long> brachIdList = OwnerUtils.getOwnerIds();
        qFilter.and("Id", "in", brachIdList);
        qFilter.and("status", "=", (Object)"C");
        return qFilter;
    }

    public static QFilter getStockPositionidFilter(long warehouseid) {
        QFilter qFilter = F7Utils.getEnableFilter();
        qFilter.and("warehouseid.Id", "=", (Object)warehouseid);
        return qFilter;
    }

    public static QFilter getErpStockPositionidFilter(long erpStokId) {
        QFilter filter = F7Utils.getEnableFilter();
        QFilter qFilter = F7Utils.getCommonStatusFilter();
        qFilter.and("id", "=", (Object)erpStokId);
        DynamicObject erpStock = BusinessDataServiceHelper.loadSingleFromCache((String)"bd_warehouse", (QFilter[])qFilter.toArray());
        DynamicObjectCollection erpStockPositions = DynamicObjectUtil.getDynamicObjectCollection(erpStock, "entryentity");
        if (erpStockPositions != null && erpStockPositions.size() > 0) {
            filter.and("id", "in", (Object)erpStockPositions.stream().map(x -> DynamicObjectUtil.getPkValue(x, "location")).toArray());
        }
        return filter;
    }

    public static QFilter getSalerFilter(DynamicObject bizOrg) {
        QFilter filter = BaseDataServiceHelper.getBaseDataFilter((String)"bd_operatorgroup", (Long)DynamicObjectUtil.getPkValue(bizOrg));
        filter.and(kd.drp.dbd.common.util.F7Utils.getEnableStatus());
        filter.and("operatorgrouptype", "=", (Object)"XSZ");
        Map operatorGroup = BusinessDataServiceHelper.loadFromCache((String)"bd_operatorgroup", (String)"id", (QFilter[])filter.toArray());
        if (operatorGroup != null && !operatorGroup.isEmpty()) {
            HashSet keySet = new HashSet(operatorGroup.keySet());
            return new QFilter("operatorgrpid", "in", new ArrayList(keySet));
        }
        return new QFilter("operatorgrpid", "in", null);
    }

    public static QFilter getDistributionModeFilter(DynamicObject goods) {
        String operationModel = DynamicObjectUtil.getString(goods, "operationmodel");
        long[] jointModes = new long[]{926600963786061824L, 926601157210585088L};
        QFilter filter = null;
        if (StringUtils.equals((CharSequence)operationModel, (CharSequence)"0")) {
            filter = new QFilter("id", "in", (Object)jointModes);
        } else if (StringUtils.equals((CharSequence)operationModel, (CharSequence)"1")) {
            filter = new QFilter("id", "not in", (Object)jointModes);
        }
        return filter;
    }

    private static List<Map<String, Long>> getSaleItemContent(long branchId, long currencyId) {
        QFilter filter = F7Utils.getEnableFilter();
        filter.and("customer.Id", "=", (Object)branchId);
        filter.and("retailprice", "!=", (Object)BigDecimal.ZERO);
        filter.and("currency.Id", "=", (Object)currencyId);
        DynamicObjectCollection data = QueryServiceHelper.query((String)"dbd_itemsale_content", (String)"Id,barcode.Id,item.Id", (QFilter[])filter.toArray());
        if (data == null || data.isEmpty()) {
            return new ArrayList<Map<String, Long>>();
        }
        ArrayList<Map<String, Long>> result = new ArrayList<Map<String, Long>>();
        for (DynamicObject item : data) {
            HashMap<String, Long> map = new HashMap<String, Long>(2);
            map.put("goodsid", DynamicObjectUtil.getLong(item, "item.Id"));
            map.put("barcode", DynamicObjectUtil.getLong(item, "barcode.Id"));
            result.add(map);
        }
        return result;
    }

    private static List<Long> getGoodsInfoList(long branchId, long currenctId, boolean type) {
        List<Map<String, Long>> data = F7Util.getSaleItemContent(branchId, currenctId);
        if (data.isEmpty()) {
            return new ArrayList<Long>();
        }
        ArrayList<Long> result = new ArrayList<Long>();
        if (type) {
            result.clear();
            data.forEach(p -> result.add((Long)p.get("goodsid")));
        } else {
            result.clear();
            data.forEach(p -> result.add((Long)p.get("barcode")));
        }
        return result;
    }
}

