/*
 * Decompiled with CFR 0.152.
 */
package kd.drp.pos.common.util;

public class StringJoin {
    private final String prefix;
    private final String delimiter;
    private final String suffix;
    private StringBuilder value;
    private String emptyValue;

    public StringJoin(CharSequence var1) {
        this(var1, "", "");
    }

    public StringJoin(CharSequence var1, CharSequence var2, CharSequence var3) {
        this.prefix = var2.toString();
        this.delimiter = var1.toString();
        this.suffix = var3.toString();
        this.emptyValue = this.prefix + this.suffix;
    }

    public StringJoin setEmptyValue(CharSequence var1) {
        return this;
    }

    public String toString() {
        if (this.value == null) {
            return this.emptyValue;
        }
        if (this.suffix.equals("")) {
            return this.value.toString();
        }
        int var1 = this.value.length();
        String var2 = this.value.append(this.suffix).toString();
        this.value.setLength(var1);
        return var2;
    }

    public StringJoin add(CharSequence var1) {
        this.prepareBuilder().append(var1);
        return this;
    }

    public StringJoin merge(StringJoin var1) {
        if (var1.value != null) {
            int var2 = var1.value.length();
            StringBuilder var3 = this.prepareBuilder();
            var3.append(var1.value, var1.prefix.length(), var2);
        }
        return this;
    }

    private StringBuilder prepareBuilder() {
        if (this.value != null) {
            this.value.append(this.delimiter);
        } else {
            this.value = new StringBuilder().append(this.prefix);
        }
        return this.value;
    }

    public int length() {
        return this.value != null ? this.value.length() + this.suffix.length() : this.emptyValue.length();
    }
}

