/*
 * Decompiled with CFR 0.152.
 */
package kd.drp.pos.opplugin.saleorder;

import java.math.BigDecimal;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.plugin.AbstractOperationServicePlugIn;
import kd.bos.entity.plugin.AddValidatorsEventArgs;
import kd.bos.entity.plugin.PreparePropertysEventArgs;
import kd.bos.entity.plugin.args.EndOperationTransactionArgs;
import kd.bos.entity.validate.AbstractValidator;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.drp.pos.business.systemparam.SystemParamHelper;
import kd.drp.pos.common.enums.CollectModeEnum;
import kd.drp.pos.common.saleorder.BizTypeEnum;
import kd.drp.pos.common.util.CommonUtil;
import kd.drp.pos.common.util.DynamicObjectUtil;
import kd.drp.pos.opplugin.saleorder.SaveValidator;

public class CommonOp
extends AbstractOperationServicePlugIn {
    private static final String KEY_INVSTATUS = "bd_invstatus";
    private static final String KEY_BOSUSER = "bos_user";
    private static final String KEY_AMTPRECISION = "amtprecision";
    private static final String OP_SETTLE = "settle";

    public void onPreparePropertys(PreparePropertysEventArgs e) {
        super.onPreparePropertys(e);
        this.prepareField(e);
    }

    public void onAddValidators(AddValidatorsEventArgs e) {
        super.onAddValidators(e);
        e.addValidator((AbstractValidator)new SaveValidator());
    }

    public void endOperationTransaction(EndOperationTransactionArgs e) {
        super.endOperationTransaction(e);
        DynamicObject[] dataEntities = e.getDataEntities();
        if (dataEntities == null || dataEntities.length <= 0) {
            return;
        }
        this.updateField(dataEntities);
    }

    private void prepareField(PreparePropertysEventArgs e) {
        e.getFieldKeys().add("biztype");
        e.getFieldKeys().add("bizorgid");
        e.getFieldKeys().add("salebranchid");
        e.getFieldKeys().add("openquotype");
        e.getFieldKeys().add("name");
        e.getFieldKeys().add("email");
        e.getFieldKeys().add("enterprisename");
        e.getFieldKeys().add("taxnumber");
        e.getFieldKeys().add("returntype");
        e.getFieldKeys().add("isticketreturn");
        e.getFieldKeys().add("isredrush");
        e.getFieldKeys().add("sourcebillid");
        e.getFieldKeys().add("collectmode");
        e.getFieldKeys().add("enterpriseemail");
        e.getFieldKeys().add("locurrencyid");
        e.getFieldKeys().add("currencyid");
        e.getFieldKeys().add("financeexchangerate");
        e.getFieldKeys().add("exratetable");
        e.getFieldKeys().add("goodsentryentity");
        e.getFieldKeys().add("goodsentryentity.Seq");
        e.getFieldKeys().add("goodsentryentity.goodsid");
        e.getFieldKeys().add("goodsentryentity.isbook");
        e.getFieldKeys().add("goodsentryentity.deposit");
        e.getFieldKeys().add("goodsentryentity.stockid");
        e.getFieldKeys().add("goodsentryentity.stockposition");
        e.getFieldKeys().add("goodsentryentity.auxattrid");
        e.getFieldKeys().add("goodsentryentity.serialid");
        e.getFieldKeys().add("goodsentryentity.materielid");
        e.getFieldKeys().add("goodsentryentity.saleqty");
        e.getFieldKeys().add("goodsentryentity.baseunit");
        e.getFieldKeys().add("goodsentryentity.srcbillentryid");
        e.getFieldKeys().add("goodsentryentity.unit");
        e.getFieldKeys().add("goodsentryentity.deliverytime");
        e.getFieldKeys().add("goodsentryentity.supplier");
        e.getFieldKeys().add("goodsentryentity.distributionmode");
        e.getFieldKeys().add("goodsentryentity.erpstock");
        e.getFieldKeys().add("goodsentryentity.erpstockposition");
    }

    private void updateField(DynamicObject[] dataEntities) {
        for (DynamicObject dataEntity : dataEntities) {
            String bizType = DynamicObjectUtil.getString((DynamicObject)dataEntity, (String)"biztype");
            DynamicObject org = dataEntity.getDynamicObject("bizorgid");
            long orgId = DynamicObjectUtil.getPkValue((DynamicObject)org);
            DynamicObject stockStatus = null;
            if (orgId > 0L) {
                stockStatus = BusinessDataServiceHelper.loadSingle((Object)SystemParamHelper.getInvStatus((long)orgId), (String)KEY_INVSTATUS);
            }
            DynamicObjectCollection entryData = dataEntity.getDynamicObjectCollection("goodsentryentity");
            int isBookCount = 0;
            int noBookCount = 0;
            BigDecimal preAmount = BigDecimal.ZERO;
            BigDecimal amount = BigDecimal.ZERO;
            for (DynamicObject item : entryData) {
                if (DynamicObjectUtil.getBoolean((DynamicObject)item, (String)"isbook")) {
                    preAmount = preAmount.add(DynamicObjectUtil.getBigDecimal((DynamicObject)item, (String)"deposit"));
                    ++isBookCount;
                } else if (StringUtils.equals((CharSequence)bizType, (CharSequence)BizTypeEnum.ORDERCONVERTSALE.getValue())) {
                    BigDecimal balAmount = DynamicObjectUtil.getBigDecimal((DynamicObject)item, (String)"balamount");
                    BigDecimal deposit = DynamicObjectUtil.getBigDecimal((DynamicObject)item, (String)"deposit");
                    amount = amount.add(balAmount.subtract(deposit));
                    ++noBookCount;
                } else {
                    amount = amount.add(DynamicObjectUtil.getBigDecimal((DynamicObject)item, (String)"balamount"));
                    ++noBookCount;
                }
                if (!StringUtils.equals((CharSequence)bizType, (CharSequence)BizTypeEnum.SALERETURN.getValue())) continue;
                item.set("channelstockstatusid", (Object)stockStatus);
            }
            this.setAmount(dataEntity, amount, preAmount);
            this.setBillNo(dataEntity);
            this.setCollectMode(dataEntity, bizType);
            this.setUser(dataEntity, bizType);
            this.setOther(dataEntity, isBookCount, noBookCount);
            SaveServiceHelper.update((DynamicObject)dataEntity);
        }
    }

    private void setAmount(DynamicObject dataEntity, BigDecimal amount, BigDecimal preAmount) {
        BigDecimal receivableAmount = amount.add(preAmount);
        DynamicObject currency = DynamicObjectUtil.getDynamicObject((DynamicObject)dataEntity, (String)"currencyid");
        BigDecimal totalRealAmount = DynamicObjectUtil.getBigDecimal((DynamicObject)dataEntity, (String)"totalrealamount");
        BigDecimal stillNeedToPay = receivableAmount.subtract(totalRealAmount);
        receivableAmount = receivableAmount.setScale(DynamicObjectUtil.getInt((DynamicObject)currency, (String)KEY_AMTPRECISION), 6);
        stillNeedToPay = stillNeedToPay.setScale(DynamicObjectUtil.getInt((DynamicObject)currency, (String)KEY_AMTPRECISION), 6);
        dataEntity.set("payableamount", (Object)receivableAmount);
        dataEntity.set("stillneedtopay", (Object)stillNeedToPay);
    }

    private void setBillNo(DynamicObject dataEntity) {
        String billNo = DynamicObjectUtil.getString((DynamicObject)dataEntity, (String)"billno");
        String initialBillNo = DynamicObjectUtil.getString((DynamicObject)dataEntity, (String)"initialbillno");
        if (StringUtils.isBlank((CharSequence)initialBillNo)) {
            dataEntity.set("initialbillno", (Object)billNo);
        }
    }

    private void setCollectMode(DynamicObject dataEntity, String bizType) {
        switch (bizType) {
            case "A": {
                dataEntity.set("collectmode", (Object)CollectModeEnum.ENUMS_NORMALRETAIL.getValue());
                break;
            }
            case "B": {
                this.setReturnCollectMode(dataEntity);
                break;
            }
            case "C": {
                dataEntity.set("collectmode", (Object)CollectModeEnum.ENUMS_ORDERCONVSALE.getValue());
                break;
            }
            case "D": {
                dataEntity.set("collectmode", (Object)CollectModeEnum.ENUMS_BOOKINGORDER.getValue());
                break;
            }
        }
    }

    private void setReturnCollectMode(DynamicObject dataEntity) {
        boolean isTicketReturn = DynamicObjectUtil.getBoolean((DynamicObject)dataEntity, (String)"isticketreturn");
        boolean isRedRush = DynamicObjectUtil.getBoolean((DynamicObject)dataEntity, (String)"isredrush");
        DynamicObject sourceBill = DynamicObjectUtil.getDynamicObject((DynamicObject)dataEntity, (String)"sourcebillid");
        String srcBizType = DynamicObjectUtil.getString((DynamicObject)sourceBill, (String)"biztype");
        if (StringUtils.equals((CharSequence)srcBizType, (CharSequence)BizTypeEnum.ORDERCONVERTSALE.getValue())) {
            dataEntity.set("collectmode", (Object)CollectModeEnum.ENUMS_SALESRETURNFROMBOOKING.getValue());
        } else if (isRedRush) {
            dataEntity.set("collectmode", (Object)CollectModeEnum.ENUMS_REDRUSH.getValue());
        } else if (isTicketReturn) {
            dataEntity.set("collectmode", (Object)CollectModeEnum.ENUMS_RETURNBYSMALLTICKET.getValue());
        } else {
            dataEntity.set("collectmode", (Object)CollectModeEnum.ENUMS_SALERETURN.getValue());
        }
    }

    private void setOther(DynamicObject dataEntity, int isBookCount, int noBookCount) {
        if (isBookCount > 0 && noBookCount > 0) {
            dataEntity.set("ismergebill", (Object)"2");
        } else if (isBookCount > 0 && noBookCount == 0) {
            dataEntity.set("ismergebill", (Object)"0");
        } else if (isBookCount == 0 && noBookCount > 0) {
            dataEntity.set("ismergebill", (Object)"1");
        }
    }

    private void setUser(DynamicObject dataEntity, String bizType) {
        long userId = CommonUtil.formatStringToLong((String)RequestContext.get().getUserId());
        if (userId > 0L) {
            BigDecimal discountAmount;
            DynamicObject user = BusinessDataServiceHelper.loadSingle((Object)userId, (String)KEY_BOSUSER);
            if (StringUtils.equals((CharSequence)bizType, (CharSequence)BizTypeEnum.SALERETURN.getValue())) {
                dataEntity.set("returnopr", (Object)user);
            }
            if ((discountAmount = DynamicObjectUtil.getBigDecimal((DynamicObject)dataEntity, (String)"sumdiscount")).compareTo(BigDecimal.ZERO) > 0) {
                dataEntity.set("discountopr", (Object)user);
            }
        }
    }
}

