/*
 * Decompiled with CFR 0.152.
 */
package kd.drp.pos.opplugin.saleorder;

import java.util.ArrayList;
import java.util.List;
import kd.bos.dataentity.entity.CloneUtils;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.metadata.IDataEntityType;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.metadata.dynamicobject.DynamicSimpleProperty;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.plugin.AbstractPrintServicePlugin;
import kd.bos.entity.plugin.args.CustomPrintDataEntitiesArgs;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.drp.pos.business.systemparam.SystemParamHelper;

public class SaleOrderReceiptPrintOp
extends AbstractPrintServicePlugin {
    private static final int NAME_LENGTH = 5;
    private static final String isPay = "S";
    private static final String PRINTCONFIG = "printconfig";

    public void customPrintDataEntities(CustomPrintDataEntitiesArgs e) {
        List sysDataEntities = e.getDataEntities();
        String ds = e.getDataSourceName();
        if ("pos_salesorder".equalsIgnoreCase(ds)) {
            List<DynamicObject> newDataEntities = this.dealPosSales(sysDataEntities);
            e.setDataEntities(newDataEntities);
        } else if ("goodsentryentity".equalsIgnoreCase(ds)) {
            this.dealGoods(sysDataEntities);
        } else if ("finentity".equalsIgnoreCase(ds) && (sysDataEntities == null || sysDataEntities.size() < 1)) {
            e.setDataEntities(new ArrayList(0));
        }
    }

    private List<DynamicObject> dealPosSales(List<DynamicObject> sysDataEntities) {
        ArrayList<DynamicObject> newDataEntities = new ArrayList<DynamicObject>(sysDataEntities.size());
        DynamicObject dynEntity = sysDataEntities.get(0);
        DynamicObject dyn = BusinessDataServiceHelper.loadSingle((Object)dynEntity.getPkValue(), (String)"pos_salesorder");
        if (dyn == null) {
            throw new RuntimeException("\u6570\u636e\u5f02\u5e38\uff0c\u8bf7\u7a0d\u540e\u518d\u8bd5");
        }
        if (!isPay.equals(dyn.getString("salestatus"))) {
            throw new RuntimeException("\u5f53\u524d\u5355\u636e\u672a\u7ed3\u7b97\u4e0d\u80fd\u6253\u5370\u5c0f\u7968\uff0c\u8bf7\u5148\u7ed3\u7b97\u3002");
        }
        long orgId = dynEntity.getLong("bizorgid");
        if (orgId < 1L) {
            orgId = dyn.getLong("bizorgid_id");
        }
        try {
            String config = SystemParamHelper.getSaleOrderPrintConfig((long)orgId);
            DynamicObjectType dynEntityType = (DynamicObjectType)dynEntity.getDataEntityType();
            DynamicObjectType cloneEntityType = (DynamicObjectType)dynEntityType.clone();
            DynamicSimpleProperty property = new DynamicSimpleProperty(PRINTCONFIG, String.class, (Object)"");
            cloneEntityType.registerSimpleProperty(property);
            DynamicObject saler = dynEntity.getDynamicObject("saler");
            DynamicObject cashier = dynEntity.getDynamicObject("cashier");
            DynamicObject newObj = (DynamicObject)new CloneUtils(false, false).clone((IDataEntityType)cloneEntityType, (Object)dynEntity);
            newObj.set(PRINTCONFIG, (Object)config);
            newObj.set("saler", (Object)saler);
            newObj.set("cashier", (Object)cashier);
            newDataEntities.add(newObj);
        }
        catch (Exception e1) {
            throw new RuntimeException(e1);
        }
        return newDataEntities;
    }

    public void dealGoods(List<DynamicObject> sysDataEntities) {
        for (DynamicObject temp : sysDataEntities) {
            DynamicObject goods;
            if (temp.getDynamicObject("goodsid") == null || !StringUtils.isNotBlank((CharSequence)(goods = temp.getDynamicObject("goodsid")).getString("name")) || goods.getString("name").length() <= 5) continue;
            goods.set("name", (Object)(goods.getString("name").substring(0, 5) + "..."));
        }
    }
}

