/*
 * Decompiled with CFR 0.152.
 */
package kd.drp.pos.opplugin.saleorder;

import java.math.BigDecimal;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.entity.earlywarn.kit.StringUtil;
import kd.bos.entity.validate.AbstractValidator;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.drp.pos.common.saleorder.BizTypeEnum;
import kd.drp.pos.common.util.DynamicObjectUtil;

public class SaveValidator
extends AbstractValidator {
    private static final String KEY_CHINESEPHONE = "+86";

    public void validate() {
        ExtendedDataEntity[] dataEntities = this.getDataEntities();
        if (dataEntities == null || dataEntities.length <= 0) {
            return;
        }
        for (ExtendedDataEntity dataEntity : dataEntities) {
            DynamicObjectCollection entry;
            DynamicObject billData = dataEntity.getDataEntity();
            this.checkExchangeRate(dataEntity, billData);
            String bizType = DynamicObjectUtil.getString((DynamicObject)billData, (String)"biztype");
            Date billDate = billData.getDate("bizdate");
            DynamicObject sourcebill = DynamicObjectUtil.getDynamicObject((DynamicObject)billData, (String)"sourcebillid");
            if (sourcebill != null) {
                String billno = DynamicObjectUtil.getString((DynamicObject)billData, (String)"billno");
                String initialbillno = DynamicObjectUtil.getString((DynamicObject)billData, (String)"initialbillno");
                if (StringUtils.isNotEmpty((CharSequence)initialbillno)) {
                    this.checkInitialBillNo(dataEntity, billno, initialbillno);
                }
            }
            if ((entry = billData.getDynamicObjectCollection("goodsentryentity")) == null || entry.isEmpty()) continue;
            List<Long> lstSrcEntryId = entry.stream().map(x -> DynamicObjectUtil.getLong((DynamicObject)x, (String)"srcbillentryid")).collect(Collectors.toList());
            Map<Long, BigDecimal> map = this.getMustRetQty(lstSrcEntryId);
            for (DynamicObject entryItem : entry) {
                int seq = DynamicObjectUtil.getInt((DynamicObject)entryItem, (String)"Seq");
                this.checkGoods(dataEntity, entryItem, seq);
                this.checkDeliveryInfo(dataEntity, billDate, bizType, entryItem, seq);
                if (sourcebill == null) continue;
                long srcEntryId = DynamicObjectUtil.getLong((DynamicObject)entryItem, (String)"srcbillentryid");
                BigDecimal saleQty = DynamicObjectUtil.getBigDecimal((DynamicObject)entryItem, (String)"saleqty");
                BigDecimal mustRetQty = map.get(srcEntryId);
                if (mustRetQty == null) {
                    mustRetQty = BigDecimal.ZERO;
                }
                this.checkSaleQty(dataEntity, bizType, saleQty, mustRetQty, seq);
            }
            String openQuoType = DynamicObjectUtil.getString((DynamicObject)billData, (String)"openquotype");
            this.checkInvoicePhone(dataEntity, billData, openQuoType);
        }
    }

    private void checkInitialBillNo(ExtendedDataEntity dataEntity, String billno, String initialbillno) {
        DynamicObject noPushBill = QueryServiceHelper.queryOne((String)"pos_salesorder", (String)"billno", (QFilter[])new QFilter[]{new QFilter("initialbillno", "=", (Object)initialbillno), new QFilter("billno", "!=", (Object)billno), new QFilter("goodsentryentity.ispushdown", "=", (Object)"0")});
        if (noPushBill != null) {
            this.addErrorMessage(dataEntity, String.format("\u5355\u53f7\u4e3a\u3010%s\u3011\u7684\u8ba2\u5355\u672a\u4e0b\u63a8\u5b8c\u6210\uff0c\u8bf7\u5148\u4e0b\u63a8\u5b8c\u6210\u3002", noPushBill.getString("billno")));
        }
    }

    private void checkInvoicePhone(ExtendedDataEntity dataEntity, DynamicObject billData, String openQuoType) {
        if (StringUtils.equals((CharSequence)openQuoType, (CharSequence)"1")) {
            this.isPhoneLegal(dataEntity, DynamicObjectUtil.getString((DynamicObject)billData, (String)"phonenumber"));
        } else if (StringUtils.equals((CharSequence)openQuoType, (CharSequence)"2")) {
            this.isPhoneLegal(dataEntity, DynamicObjectUtil.getString((DynamicObject)billData, (String)"enterprisephone"));
        }
    }

    private void checkDeliveryInfo(ExtendedDataEntity dataEntity, Date billDate, String bizType, DynamicObject entryItem, int seq) {
        boolean isBook = DynamicObjectUtil.getBoolean((DynamicObject)entryItem, (String)"isbook");
        if (!isBook) {
            String comment;
            boolean isDelivery;
            String strErrMsg;
            long distributionModeId = DynamicObjectUtil.getPkValue((DynamicObject)entryItem, (String)"distributionmode");
            if (distributionModeId == 0L) {
                strErrMsg = String.format("\u5546\u54c1\u660e\u7ec6\u7b2c%d\u884c\u4e3a\u975e\u9884\u8ba2\u5546\u54c1\uff0c\u8bf7\u586b\u5199\u914d\u9001\u6a21\u5f0f\u3002", seq);
                this.addErrorMessage(dataEntity, strErrMsg);
            }
            boolean isJoint = distributionModeId == 926600963786061824L || distributionModeId == 926601157210585088L;
            DynamicObject supplier = DynamicObjectUtil.getDynamicObject((DynamicObject)entryItem, (String)"supplier");
            if (isJoint && supplier == null) {
                strErrMsg = String.format("\u5546\u54c1\u660e\u7ec6\u7b2c%d\u884c\u914d\u9001\u6a21\u5f0f\u4e3a\u8054\u8425\u5373\u63d0\u6216\u8054\u8425\u914d\u9001\uff0c\u8bf7\u586b\u5199\u4f9b\u5e94\u5546\u3002", seq);
                this.addErrorMessage(dataEntity, strErrMsg);
            }
            Date deliveryTime = entryItem.getDate("deliverytime");
            boolean bl = isDelivery = distributionModeId == 926596489101228032L || distributionModeId == 926596971228197888L || distributionModeId == 926600838443594752L || distributionModeId == 926600963786061824L;
            if (isDelivery) {
                if (deliveryTime == null) {
                    strErrMsg = String.format("\u5546\u54c1\u660e\u7ec6\u7b2c%d\u884c\u914d\u9001\u6a21\u5f0f\u4e3a\u95e8\u5e97\u914d\u9001\u3001\u96c6\u4e2d\u914d\u9001\u3001\u4e8c\u7ea7\u914d\u9001\u6216\u8054\u8425\u914d\u9001\uff0c\u8bf7\u586b\u5199\u914d\u9001\u65f6\u95f4\u3002", seq);
                    this.addErrorMessage(dataEntity, strErrMsg);
                } else if (deliveryTime.compareTo(billDate) < 0) {
                    strErrMsg = String.format("\u5546\u54c1\u660e\u7ec6\u7b2c%d\u884c\u914d\u9001\u65f6\u95f4\u4e0d\u5f97\u5c0f\u4e8e\u5355\u636e\u65e5\u671f\u3002", seq);
                    this.addErrorMessage(dataEntity, strErrMsg);
                }
            }
            DynamicObject stock = DynamicObjectUtil.getDynamicObject((DynamicObject)entryItem, (String)"stockid");
            String string = comment = StringUtils.equals((CharSequence)bizType, (CharSequence)BizTypeEnum.SALERETURN.getValue()) ? "\u9009\u62e9\u9000\u56de\u7684\u95e8\u5e97\u4ed3\u5e93" : "\u586b\u5199\u95e8\u5e97\u4ed3\u5e93";
            if (distributionModeId == 926596489101228032L || distributionModeId == 926601071999218688L) {
                if (stock == null) {
                    strErrMsg = String.format("\u5546\u54c1\u660e\u7ec6\u7b2c%d\u884c\u914d\u9001\u6a21\u5f0f\u4e3a\u95e8\u5e97\u914d\u9001\u6216\u95e8\u5e97\u5373\u63d0\uff0c\u8bf7%s\u3002", seq, comment);
                    this.addErrorMessage(dataEntity, strErrMsg);
                } else {
                    DynamicObject stockPosition = DynamicObjectUtil.getDynamicObject((DynamicObject)entryItem, (String)"stockposition");
                    if (DynamicObjectUtil.getBoolean((DynamicObject)stock, (String)"enablelocation") && stockPosition == null) {
                        strErrMsg = String.format("\u5546\u54c1\u660e\u7ec6\u7b2c%d\u884c\u5546\u54c1\u7684\u95e8\u5e97\u4ed3\u5e93\u542f\u7528\u4e86\u4ed3\u4f4d\u7ba1\u7406\uff0c\u8bf7\u9009\u62e9\u95e8\u5e97\u4ed3\u4f4d\u3002", seq);
                        this.addErrorMessage(dataEntity, strErrMsg);
                    }
                }
            }
            DynamicObject erpStock = DynamicObjectUtil.getDynamicObject((DynamicObject)entryItem, (String)"erpstock");
            String string2 = comment = StringUtils.equals((CharSequence)bizType, (CharSequence)BizTypeEnum.SALERETURN.getValue()) ? "\u9009\u62e9\u9000\u56de\u4ed3\u5e93" : "\u586b\u5199\u4ed3\u5e93";
            if (distributionModeId == 926596971228197888L || distributionModeId == 926600838443594752L) {
                if (erpStock == null) {
                    strErrMsg = String.format("\u5546\u54c1\u660e\u7ec6\u7b2c%d\u884c\u914d\u9001\u6a21\u5f0f\u4e3a\u96c6\u4e2d\u914d\u9001\u6216\u4e8c\u7ea7\u914d\u9001\uff0c\u8bf7%s\u3002", seq, comment);
                    this.addErrorMessage(dataEntity, strErrMsg);
                } else {
                    DynamicObject erpStockPosition = DynamicObjectUtil.getDynamicObject((DynamicObject)entryItem, (String)"erpstockposition");
                    if (DynamicObjectUtil.getBoolean((DynamicObject)erpStock, (String)"isopenlocation") && erpStockPosition == null) {
                        strErrMsg = String.format("\u5546\u54c1\u660e\u7ec6\u7b2c%d\u884c\u5546\u54c1\u7684\u4ed3\u5e93\u542f\u7528\u4e86\u4ed3\u4f4d\u7ba1\u7406\uff0c\u8bf7\u9009\u62e9\u4ed3\u4f4d\u3002", seq);
                        this.addErrorMessage(dataEntity, strErrMsg);
                    }
                }
            }
        }
    }

    private void checkGoods(ExtendedDataEntity dataEntity, DynamicObject entryItem, int seq) {
        String strErrMsg;
        DynamicObject goods = DynamicObjectUtil.getDynamicObject((DynamicObject)entryItem, (String)"goodsid");
        DynamicObject auxttr = DynamicObjectUtil.getDynamicObject((DynamicObject)entryItem, (String)"auxattrid");
        if (DynamicObjectUtil.getBoolean((DynamicObject)goods, (String)"hasattr") && auxttr == null) {
            strErrMsg = String.format("\u5546\u54c1\u660e\u7ec6\u7b2c%d\u884c\u5546\u54c1\u542f\u7528\u4e86\u8f85\u52a9\u5c5e\u6027\uff0c\u8bf7\u9009\u62e9\u8f85\u52a9\u5c5e\u6027\u3002", seq);
            this.addErrorMessage(dataEntity, strErrMsg);
        }
        String serialIdStr = DynamicObjectUtil.getString((DynamicObject)entryItem, (String)"serialid");
        if (!DynamicObjectUtil.getBoolean((DynamicObject)entryItem, (String)"isbook") && DynamicObjectUtil.getBoolean((DynamicObject)goods, (String)"enableserial") && StringUtils.isBlank((CharSequence)serialIdStr)) {
            strErrMsg = String.format("\u5546\u54c1\u660e\u7ec6\u7b2c%d\u884c\u5546\u54c1\u542f\u7528\u4e86\u5e8f\u5217\u53f7\u7ba1\u7406\uff0c\u8bf7\u5f55\u5165\u5e8f\u5217\u53f7\u3002", seq);
            this.addErrorMessage(dataEntity, strErrMsg);
        }
    }

    private void checkSaleQty(ExtendedDataEntity dataEntity, String bizType, BigDecimal saleQty, BigDecimal mustRetQty, int seq) {
        if (mustRetQty.compareTo(saleQty.abs()) < 0) {
            String strMustQty = mustRetQty.stripTrailingZeros().toPlainString();
            String strErrMsg = null;
            if (StringUtils.equals((CharSequence)bizType, (CharSequence)BizTypeEnum.SALERETURN.getValue())) {
                strErrMsg = String.format("\u5546\u54c1\u660e\u7ec6\u7b2c%d\u884c\u5546\u54c1\u5269\u4f59\u9000\u8d27\u6570\u91cf%s\uff0c\u8bf7\u91cd\u65b0\u8c03\u6574\u3002", seq, strMustQty);
            } else if (StringUtils.equals((CharSequence)bizType, (CharSequence)BizTypeEnum.ORDERCONVERTSALE.getValue())) {
                strErrMsg = String.format("\u5546\u54c1\u660e\u7ec6\u7b2c%d\u884c\u5546\u54c1\u5269\u4f59\u8f6c\u9500\u6570\u91cf%s\uff0c\u8bf7\u91cd\u65b0\u8c03\u6574\u3002", seq, strMustQty);
            }
            if (!StringUtils.isBlank(strErrMsg)) {
                this.addErrorMessage(dataEntity, strErrMsg);
            }
        }
    }

    private void checkExchangeRate(ExtendedDataEntity dataEntity, DynamicObject billData) {
        DynamicObject exrateTable = DynamicObjectUtil.getDynamicObject((DynamicObject)billData, (String)"exratetable");
        BigDecimal exchangeRate = DynamicObjectUtil.getBigDecimal((DynamicObject)billData, (String)"financeexchangerate");
        if (exrateTable == null || exchangeRate.compareTo(BigDecimal.ZERO) == 0) {
            DynamicObject loCurrency = DynamicObjectUtil.getDynamicObject((DynamicObject)billData, (String)"locurrencyid");
            DynamicObject currency = DynamicObjectUtil.getDynamicObject((DynamicObject)billData, (String)"currencyid");
            String loCurName = DynamicObjectUtil.getString((DynamicObject)loCurrency, (String)"name");
            String curName = DynamicObjectUtil.getString((DynamicObject)currency, (String)"name");
            String strErrMsg = String.format("\u95e8\u5e97\u7ed3\u7b97\u5e01\u522b\u3010%s\u3011\u4e0e\u672c\u4f4d\u5e01\u3010%s\u3011\u4e4b\u95f4\u6362\u7b97\u5173\u7cfb\u4e0d\u5b58\u5728\uff0c\u8bf7\u5148\u7ef4\u62a4\u3002", curName, loCurName);
            this.addErrorMessage(dataEntity, strErrMsg);
        }
    }

    private void isPhoneLegal(ExtendedDataEntity dataEntity, String phone) {
        if (StringUtil.isNotEmpty((CharSequence)phone) && !KEY_CHINESEPHONE.equals(phone.substring(0, 3))) {
            this.addErrorMessage(dataEntity, "\u5f00\u7968\u60c5\u51b5\u4e0b\uff0c\u4ec5\u652f\u6301\u8f93\u5165\u4e2d\u56fd\u5927\u9646\u7684\u624b\u673a\u53f7\u3002");
        }
    }

    private Map<Long, BigDecimal> getMustRetQty(List<Long> lstSrcEntryId) {
        QFilter filter = new QFilter("goodsentryentity.Id", "in", lstSrcEntryId);
        String selectFields = "Id,goodsentryentity.Id,goodsentryentity.mustretqty";
        DynamicObjectCollection data = QueryServiceHelper.query((String)"pos_salesorder", (String)selectFields, (QFilter[])filter.toArray());
        HashMap<Long, BigDecimal> map = new HashMap<Long, BigDecimal>(data.size());
        if (data.size() > 0) {
            for (DynamicObject item : data) {
                long entryId = item.getLong("goodsentryentity.Id");
                BigDecimal mustRetQty = item.getBigDecimal("goodsentryentity.mustretqty");
                map.put(entryId, mustRetQty);
            }
        }
        return map;
    }
}

