/*
 * Decompiled with CFR 0.152.
 */
package kd.drp.pos.formplugin.saleorder;

import java.math.BigDecimal;
import java.util.Date;
import java.util.EventObject;
import java.util.HashMap;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.form.FormShowParameter;
import kd.bos.form.control.Control;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.TimeServiceHelper;
import kd.drp.dbd.enums.PaymentModeEnum;
import kd.drp.mdr.formplugin.MdrFormPlugin;
import kd.drp.pos.business.commonhelper.AmountHelper;
import kd.drp.pos.business.commonhelper.CurrencyHelper;
import kd.drp.pos.common.saleorder.BizTypeEnum;
import kd.drp.pos.common.util.CalculateUtil;
import kd.drp.pos.common.util.CommonUtil;
import kd.drp.pos.common.util.DynamicObjectUtil;
import kd.drp.pos.common.util.JsonUtil;

public class SaleOrderCashPayPlugin
extends MdrFormPlugin {
    private static final String AMOUNT = "amount";
    private static final String CURRENCY = "currency";
    private static final String PAYCURRENCY = "paycurrency";
    private static final String NEEDPAYAMOUNT = "needpayamount";
    private static final String AMTPRECISION = "amtprecision";
    private static final String recordJson = "recordStr";
    private int precision = 2;

    public void afterCreateNewData(EventObject e) {
        super.beforeBindData(e);
        FormShowParameter formShowParameter = this.getView().getFormShowParameter();
        DynamicObject saleOrder = BusinessDataServiceHelper.loadSingle((Object)formShowParameter.getCustomParam("Id"), (String)"pos_salesorder");
        long currencyId = DynamicObjectUtil.getPkValue((DynamicObject)saleOrder, (String)"currencyid");
        this.getModel().setValue(CURRENCY, (Object)currencyId);
        this.getModel().setValue(PAYCURRENCY, (Object)currencyId);
        String bizType = saleOrder.getString("biztype");
        BigDecimal amount = this.getNeedPayAmount(saleOrder, (String)formShowParameter.getCustomParam(recordJson));
        this.getModel().setValue(NEEDPAYAMOUNT, (Object)amount);
        long orgId = DynamicObjectUtil.getPkValue((DynamicObject)saleOrder, (String)"bizorgid");
        if (bizType.equalsIgnoreCase(BizTypeEnum.SALERETURN.getValue())) {
            this.getModel().setValue(AMOUNT, (Object)amount);
        } else {
            this.getModel().setValue(AMOUNT, (Object)AmountHelper.getAmountAfterWipeZeroMode((long)orgId, (BigDecimal)amount));
        }
    }

    public void propertyChanged(PropertyChangedArgs e) {
        String changeName;
        super.propertyChanged(e);
        switch (changeName = e.getProperty().getName()) {
            case "paycurrency": {
                this.updatePayAmount();
                break;
            }
        }
    }

    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.addClickListeners(new String[]{"btnok"});
    }

    public void click(EventObject e) {
        super.click(e);
        Control source = (Control)e.getSource();
        if (StringUtils.equals((CharSequence)source.getKey(), (CharSequence)"btnok")) {
            BigDecimal exAmount;
            BigDecimal payAmount = CommonUtil.formatObjectToDecimal((Object)this.getModel().getValue(AMOUNT));
            if (payAmount.compareTo(BigDecimal.ZERO) == 0) {
                this.getView().showErrorNotification("\u652f\u4ed8\u91d1\u989d\u4e0d\u80fd\u4e3a0\u3002");
                return;
            }
            FormShowParameter formShowParameter = this.getView().getFormShowParameter();
            Object saleOrderId = formShowParameter.getCustomParam("Id");
            DynamicObject saleOrder = BusinessDataServiceHelper.loadSingle((Object)saleOrderId, (String)"pos_salesorder");
            String orderType = saleOrder.getString("biztype");
            if ("B".equalsIgnoreCase(orderType)) {
                if (payAmount.compareTo(BigDecimal.ZERO) > 0) {
                    this.getView().showErrorNotification("\u5355\u636e\u4e1a\u52a1\u7c7b\u578b\u4e3a\u201c\u9500\u552e\u9000\u8d27\u201d\u65f6\uff0c\u8f93\u5165\u73b0\u91d1\u91d1\u989d\u5e94\u5c0f\u4e8e0\u3002");
                    return;
                }
            } else if (payAmount.compareTo(BigDecimal.ZERO) < 0) {
                this.getView().showErrorNotification("\u5355\u636e\u4e1a\u52a1\u7c7b\u578b\u4e0d\u4e3a\u201c\u9500\u552e\u9000\u8d27\u201d\u65f6\uff0c\u8f93\u5165\u73b0\u91d1\u91d1\u989d\u5e94\u5927\u4e8e0\u3002");
                return;
            }
            long locurrencyId = DynamicObjectUtil.getPkValue((DynamicObject)saleOrder, (String)"locurrencyid");
            DynamicObject paycurrency = (DynamicObject)this.getModel().getValue(PAYCURRENCY);
            long rateTableId = DynamicObjectUtil.getPkValue((DynamicObject)saleOrder, (String)"exratetable");
            Date payDate = new Date();
            BigDecimal rate = CurrencyHelper.getExChangeRate((Long)paycurrency.getLong("Id"), (Long)locurrencyId, (Long)rateTableId, (Date)payDate);
            if (rate == null || rate.compareTo(BigDecimal.ZERO) == 0) {
                this.getView().showErrorNotification("\u652f\u4ed8\u5e01\u522b\u4e0e\u95e8\u5e97\u672c\u4f4d\u5e01\u522b\u627e\u4e0d\u5230\u5bf9\u5e94\u7684\u6362\u7b97\u5173\u7cfb\u3002");
                return;
            }
            BigDecimal needPayAmount = this.getNeedPayAmount(saleOrder, (String)formShowParameter.getCustomParam(recordJson));
            BigDecimal financeExchangeRate = saleOrder.getBigDecimal("financeexchangerate");
            BigDecimal wipeExAmount = exAmount = needPayAmount.multiply(financeExchangeRate).divide(rate, this.precision);
            BigDecimal finalWipeAmount = BigDecimal.ZERO;
            long orgId = DynamicObjectUtil.getPkValue((DynamicObject)saleOrder, (String)"bizorgid");
            String billType = saleOrder.getString("biztype");
            if (!billType.equalsIgnoreCase(BizTypeEnum.SALERETURN.getValue())) {
                wipeExAmount = AmountHelper.getAmountAfterWipeZeroMode((long)orgId, (BigDecimal)exAmount);
                BigDecimal actualWipeAmount = exAmount.subtract(wipeExAmount);
                finalWipeAmount = CalculateUtil.divideSetScale((BigDecimal)actualWipeAmount.multiply(rate), (BigDecimal)financeExchangeRate, (int)this.precision);
            }
            if (needPayAmount.compareTo(BigDecimal.ZERO) == 0) {
                this.getView().showErrorNotification("\u8fd8\u9700\u652f\u4ed8\u91d1\u989d\u4e3a0\uff0c\u65e0\u9700\u53d1\u8d77\u652f\u4ed8\u3002");
                return;
            }
            if ("B".equalsIgnoreCase(orderType) && payAmount.abs().compareTo(needPayAmount.abs()) > 0) {
                this.getView().showErrorNotification("\u8f93\u5165\u91d1\u989d\u4e0d\u5141\u8bb8\u5927\u4e8e\u8fd8\u9700\u652f\u4ed8\u91d1\u989d\u3002");
                return;
            }
            HashMap<String, Object> map = new HashMap<String, Object>();
            if (finalWipeAmount.abs().compareTo(BigDecimal.ZERO) > 0) {
                map.put("wipeamount", finalWipeAmount);
            }
            if (payAmount.abs().compareTo(wipeExAmount.abs()) >= 0) {
                BigDecimal paybackAmount = payAmount.subtract(wipeExAmount);
                map.put("paybackamount", CalculateUtil.divideSetScale((BigDecimal)paybackAmount.multiply(rate), (BigDecimal)financeExchangeRate, (int)this.precision));
                map.put("showamount", wipeExAmount);
                BigDecimal actualAmount = CalculateUtil.divideSetScale((BigDecimal)wipeExAmount.multiply(rate), (BigDecimal)financeExchangeRate, (int)this.precision);
                map.put("actualamount", actualAmount);
            } else {
                map.put("showamount", payAmount);
                map.put("actualamount", CalculateUtil.divideSetScale((BigDecimal)payAmount.multiply(rate), (BigDecimal)financeExchangeRate, (int)this.precision));
            }
            map.put(PAYCURRENCY, paycurrency.getPkValue());
            map.put("payway", PaymentModeEnum.getKey((String)"cashpay"));
            map.put("paytime", TimeServiceHelper.now());
            map.put("exchangerate", rate);
            this.getView().returnDataToParent(map);
            this.getView().close();
            return;
        }
    }

    private BigDecimal getNeedPayAmount(DynamicObject saleOrder, String recordJson) {
        DynamicObject paycurrency = (DynamicObject)this.getModel().getValue(PAYCURRENCY);
        String payKey = PaymentModeEnum.getKey((String)"cashpay") + "_" + paycurrency.getPkValue();
        DynamicObject currency = saleOrder.getDynamicObject("currencyid");
        String wipeKey = PaymentModeEnum.getKey((String)"clearprice") + "_" + currency.getPkValue();
        BigDecimal wipeAmount = BigDecimal.ZERO;
        Map payMap = (Map)JsonUtil.fromJson((String)recordJson, Map.class);
        BigDecimal hasPayAmount = BigDecimal.ZERO;
        if (payMap.size() > 0) {
            for (Map.Entry m : payMap.entrySet()) {
                if (((String)m.getKey()).equalsIgnoreCase(wipeKey)) {
                    wipeAmount = (BigDecimal)m.getValue();
                    continue;
                }
                if (((String)m.getKey()).equalsIgnoreCase(payKey)) continue;
                hasPayAmount = hasPayAmount.add((BigDecimal)m.getValue());
            }
        }
        BigDecimal needPayAmount = saleOrder.getBigDecimal("payableamount").subtract(saleOrder.getBigDecimal("totalrealamount"));
        String bizType = saleOrder.getString("biztype");
        if ("B".equalsIgnoreCase(bizType)) {
            needPayAmount = needPayAmount.subtract(wipeAmount);
        }
        return needPayAmount.subtract(hasPayAmount);
    }

    private void updatePayAmount() {
        DynamicObject paycurrency = (DynamicObject)this.getModel().getValue(PAYCURRENCY);
        if (paycurrency == null) {
            return;
        }
        FormShowParameter formShowParameter = this.getView().getFormShowParameter();
        DynamicObject saleOrder = BusinessDataServiceHelper.loadSingle((Object)formShowParameter.getCustomParam("Id"), (String)"pos_salesorder");
        BigDecimal amount = this.getNeedPayAmount(saleOrder, (String)formShowParameter.getCustomParam(recordJson));
        BigDecimal showAmount = BigDecimal.ZERO;
        try {
            showAmount = this.getExchangeAmount(saleOrder, paycurrency, amount);
        }
        catch (Exception e) {
            this.getModel().setValue(AMOUNT, (Object)BigDecimal.ZERO);
            this.getView().showErrorNotification("\u652f\u4ed8\u5e01\u522b\u627e\u4e0d\u5230\u4e0e\u672c\u4f4d\u5e01\u522b\u5bf9\u5e94\u7684\u6362\u7b97\u5173\u7cfb\u3002");
            return;
        }
        long orgId = DynamicObjectUtil.getPkValue((DynamicObject)saleOrder, (String)"bizorgid");
        String bizType = saleOrder.getString("biztype");
        if (!bizType.equalsIgnoreCase(BizTypeEnum.SALERETURN.getValue())) {
            showAmount = AmountHelper.getAmountAfterWipeZeroMode((long)orgId, (BigDecimal)showAmount);
        }
        this.getModel().setValue(AMOUNT, (Object)showAmount);
    }

    private BigDecimal getExchangeAmount(DynamicObject saleOrder, DynamicObject payCurrency, BigDecimal exchangeAmount) throws Exception {
        long payCurrencyId;
        long currencyId = DynamicObjectUtil.getPkValue((DynamicObject)saleOrder, (String)"currencyid");
        if (currencyId == (payCurrencyId = Long.parseLong(payCurrency.getPkValue().toString()))) {
            return exchangeAmount;
        }
        long locurrencyId = DynamicObjectUtil.getPkValue((DynamicObject)saleOrder, (String)"locurrencyid");
        BigDecimal loAmount = exchangeAmount;
        if (locurrencyId != currencyId) {
            loAmount = exchangeAmount.multiply(saleOrder.getBigDecimal("financeexchangerate"));
        }
        if (payCurrencyId == locurrencyId) {
            return loAmount.setScale(payCurrency.getInt(AMTPRECISION), 1);
        }
        long taxTableId = DynamicObjectUtil.getPkValue((DynamicObject)saleOrder, (String)"exratetable");
        BigDecimal rate = CurrencyHelper.getExChangeRate((Long)payCurrencyId, (Long)locurrencyId, (Long)taxTableId, (Date)new Date());
        if (rate == null || rate.compareTo(BigDecimal.ZERO) == 0) {
            throw new Exception("\u652f\u4ed8\u5e01\u522b\u4e0e\u95e8\u5e97\u672c\u4f4d\u5e01\u522b\u627e\u4e0d\u5230\u5bf9\u5e94\u7684\u6362\u7b97\u5173\u7cfb\u3002");
        }
        return loAmount.divide(rate, payCurrency.getInt(AMTPRECISION), 1);
    }
}

