/*
 * Decompiled with CFR 0.152.
 */
package kd.drp.pos.formplugin.saleorder;

import java.math.BigDecimal;
import java.util.Collection;
import java.util.List;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicProperty;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.entity.ExtendedDataEntitySet;
import kd.bos.entity.botp.plugin.AbstractConvertPlugIn;
import kd.bos.entity.botp.plugin.args.AfterBuildQueryParemeterEventArgs;
import kd.bos.entity.botp.plugin.args.AfterCreateLinkEventArgs;
import kd.drp.dbd.enums.PaymentModeEnum;
import kd.drp.pos.common.util.CalculateUtil;
import kd.drp.pos.common.util.DynamicObjectUtil;

public class SaleOrderConvertPlugin
extends AbstractConvertPlugIn {
    public static final String F_isinvoice = "isinvoice";
    public static final String F_totalrealamount = "totalrealamount";
    public static final String F_exchangerate = "exchangerate";
    public static final String F_noinvoiceamount = "noinvoiceamount";
    public static final String E_ffinentity = "ffinentity";
    public static final String EF_settleamount = "settleamount";
    public static final String EF_locsettleamount = "locsettleamount";
    public static final String EF_settleid = "settleid";
    public static final String EF_rate = "rate";
    public static final String F_priceprecision = "priceprecision";
    public static final String F_ignoredecimalamt = "ignoredecimalamt";

    public void afterBuildQueryParemeter(AfterBuildQueryParemeterEventArgs e) {
        e.addSrcField("ismergebill");
        e.addSrcField("sourcebillid");
    }

    public void afterCreateLink(AfterCreateLinkEventArgs e) {
        ExtendedDataEntity[] billDataEntitys;
        ExtendedDataEntitySet entitySet = e.getTargetExtDataEntitySet();
        for (ExtendedDataEntity billDataEntity : billDataEntitys = entitySet.FindByEntityKey(this.getTgtMainType().toString())) {
            DynamicObject bill = billDataEntity.getDataEntity();
            DynamicObjectCollection finEntrys = bill.getDynamicObjectCollection(E_ffinentity);
            List srcRows = (List)billDataEntity.getValue("ConvertSource");
            if (srcRows == null || srcRows.size() == 0) continue;
            DynamicObject srcRow = (DynamicObject)srcRows.get(0);
            Object srcRowObj = ((DynamicProperty)e.getFldProperties().get("ismergebill")).getValue((Object)srcRow);
            if (srcRowObj == null) continue;
            String ismergebill = (String)srcRowObj;
            DynamicObject locurrency = DynamicObjectUtil.getDynamicObject((DynamicObject)bill, (String)"locurrencyid");
            int locPrecision = locurrency != null ? DynamicObjectUtil.getInt((DynamicObject)locurrency, (String)F_priceprecision) : 2;
            DynamicObject currency = DynamicObjectUtil.getDynamicObject((DynamicObject)bill, (String)"currencyid");
            int stcPrecision = currency != null ? DynamicObjectUtil.getInt((DynamicObject)currency, (String)F_priceprecision) : 2;
            BigDecimal exchangeRate = bill.getBigDecimal(F_exchangerate);
            BigDecimal totalrealLocAmount = CalculateUtil.setPrecision((BigDecimal)bill.getBigDecimal(F_totalrealamount).multiply(exchangeRate), (int)locPrecision);
            BigDecimal sumSettleLocAmount = finEntrys.stream().map(x -> CalculateUtil.setPrecision((BigDecimal)x.getBigDecimal(EF_settleamount).multiply(x.getBigDecimal(EF_rate)), (int)stcPrecision)).reduce(BigDecimal.ZERO, BigDecimal::add);
            int row = 0;
            int finRow = finEntrys.getRowCount();
            String billName = this.getTgtMainType().getName();
            BigDecimal sumRowAmt = BigDecimal.ZERO;
            BigDecimal sumRowLocAmt = BigDecimal.ZERO;
            BigDecimal sumnoinvoiceamount = BigDecimal.ZERO;
            if (!ismergebill.equals("2")) {
                row = 0;
                for (DynamicObject entry : finEntrys) {
                    if (++row < finRow) {
                        BigDecimal rate = entry.getBigDecimal(EF_rate);
                        BigDecimal rowSettleLocAmt = CalculateUtil.setPrecision((BigDecimal)entry.getBigDecimal(EF_settleamount).multiply(rate), (int)locPrecision);
                        sumRowLocAmt = sumRowLocAmt.add(rowSettleLocAmt);
                        entry.set(EF_locsettleamount, (Object)rowSettleLocAmt);
                        if (BigDecimal.ZERO.compareTo(rowSettleLocAmt) == 0) {
                            continue;
                        }
                    } else {
                        entry.set(EF_locsettleamount, (Object)sumSettleLocAmount.subtract(sumRowLocAmt));
                    }
                    if (entry.getDynamicObject(EF_settleid).getBoolean(F_isinvoice) || !billName.equals("ococ_retailbill")) continue;
                    sumnoinvoiceamount = sumnoinvoiceamount.add(entry.getBigDecimal(EF_settleamount));
                }
                if (!billName.equals("ococ_retailbill")) continue;
                bill.set(F_noinvoiceamount, (Object)sumnoinvoiceamount);
                continue;
            }
            long clearprice = PaymentModeEnum.getKey((String)"clearprice");
            BigDecimal ignoreDecimalAmt = BigDecimal.ZERO;
            BigDecimal ignoreDecimalLocAmt = BigDecimal.ZERO;
            if (billName.equals("ococ_retailbill") && (ignoreDecimalAmt = bill.getBigDecimal(F_ignoredecimalamt)).compareTo(BigDecimal.ZERO) != 0) {
                ignoreDecimalLocAmt = CalculateUtil.setPrecision((BigDecimal)ignoreDecimalAmt.multiply(exchangeRate), (int)locPrecision);
            }
            sumRowLocAmt = BigDecimal.ZERO;
            if (BigDecimal.ZERO.compareTo(ignoreDecimalLocAmt) != 0) {
                sumSettleLocAmount = sumSettleLocAmount.subtract(ignoreDecimalLocAmt);
            }
            row = 0;
            DynamicObjectCollection newFinEntrys = new DynamicObjectCollection();
            for (DynamicObject entry : finEntrys) {
                ++row;
                BigDecimal rate = entry.getBigDecimal(EF_rate);
                BigDecimal settleAmount = entry.getBigDecimal(EF_settleamount);
                BigDecimal settleLocAmount = CalculateUtil.setPrecision((BigDecimal)entry.getBigDecimal(EF_settleamount).multiply(rate), (int)locPrecision);
                if (rate.compareTo(BigDecimal.ZERO) == 0 || sumSettleLocAmount.compareTo(BigDecimal.ZERO) == 0) continue;
                if (!entry.getDynamicObject(EF_settleid).getBoolean(F_isinvoice)) {
                    sumnoinvoiceamount = sumnoinvoiceamount.add(entry.getBigDecimal(EF_settleamount));
                }
                BigDecimal rowAmtRate = CalculateUtil.divideSetScale((BigDecimal)settleLocAmount, (BigDecimal)sumSettleLocAmount, (int)10);
                if (billName.equals("ococ_retailbill")) {
                    if (entry.getDynamicObject(EF_settleid).getLong("id") == clearprice) {
                        entry.set(EF_locsettleamount, (Object)CalculateUtil.divideSetScale((BigDecimal)ignoreDecimalLocAmt, (BigDecimal)rate, (int)locPrecision));
                        continue;
                    }
                    BigDecimal orderLocAmount = sumSettleLocAmount.subtract(totalrealLocAmount);
                    if (row < finRow) {
                        BigDecimal rowRetailAmt = settleAmount.subtract(CalculateUtil.divideSetScale((BigDecimal)orderLocAmount.multiply(rowAmtRate), (BigDecimal)rate, (int)stcPrecision));
                        BigDecimal rowRetailLocAmt = settleLocAmount.subtract(CalculateUtil.setPrecision((BigDecimal)orderLocAmount.multiply(rowAmtRate), (int)locPrecision));
                        sumRowAmt = sumRowAmt.add(rowRetailAmt);
                        sumRowLocAmt = sumRowLocAmt.add(rowRetailLocAmt);
                        entry.set(EF_settleamount, (Object)rowRetailAmt);
                        entry.set(EF_locsettleamount, (Object)rowRetailLocAmt);
                        continue;
                    }
                    entry.set(EF_settleamount, (Object)totalrealLocAmount.subtract(CalculateUtil.divideSetScale((BigDecimal)sumRowLocAmt, (BigDecimal)rate, (int)stcPrecision)));
                    entry.set(EF_locsettleamount, (Object)totalrealLocAmount.subtract(sumRowLocAmt));
                    continue;
                }
                if (!billName.equals("ococ_orderbill") || entry.getDynamicObject(EF_settleid).getLong("id") == clearprice) continue;
                if (row < finRow) {
                    BigDecimal rowOrderAmt = CalculateUtil.divideSetScale((BigDecimal)totalrealLocAmount.multiply(rowAmtRate), (BigDecimal)rate, (int)stcPrecision);
                    BigDecimal rowOrderLocAmt = CalculateUtil.setPrecision((BigDecimal)totalrealLocAmount.multiply(rowAmtRate), (int)locPrecision);
                    sumRowAmt = sumRowAmt.add(rowOrderAmt);
                    sumRowLocAmt = sumRowLocAmt.add(rowOrderLocAmt);
                    entry.set(EF_settleamount, (Object)rowOrderAmt);
                    entry.set(EF_locsettleamount, (Object)rowOrderLocAmt);
                } else {
                    entry.set(EF_settleamount, (Object)CalculateUtil.divideSetScale((BigDecimal)totalrealLocAmount.subtract(sumRowLocAmt), (BigDecimal)rate, (int)stcPrecision));
                    entry.set(EF_locsettleamount, (Object)totalrealLocAmount.subtract(sumRowLocAmt));
                }
                newFinEntrys.add((Object)entry);
            }
            if (billName.equals("ococ_retailbill")) {
                bill.set(F_noinvoiceamount, (Object)sumnoinvoiceamount);
                continue;
            }
            if (!billName.equals("ococ_orderbill")) continue;
            finEntrys.clear();
            if (newFinEntrys.size() <= 0) continue;
            finEntrys.addAll((Collection)newFinEntrys);
        }
    }
}

