/*
 * Decompiled with CFR 0.152.
 */
package kd.drp.pos.formplugin.saleorder;

import java.math.BigDecimal;
import java.util.EventObject;
import java.util.HashMap;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.form.FormShowParameter;
import kd.bos.form.control.Control;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.TimeServiceHelper;
import kd.drp.dbd.enums.PaymentModeEnum;
import kd.drp.mdr.formplugin.MdrFormPlugin;
import kd.drp.pos.business.commonhelper.AmountHelper;
import kd.drp.pos.common.saleorder.BizTypeEnum;
import kd.drp.pos.common.util.CommonUtil;
import kd.drp.pos.common.util.JsonUtil;

public class SaleOrderCreditPayPlugin
extends MdrFormPlugin {
    private static String AMOUNT = "creditamount";
    private static final String CURRENCY = "currency";
    private static final String BUTTON_OK = "btnok";

    public void afterCreateNewData(EventObject e) {
        super.beforeBindData(e);
        FormShowParameter formShowParameter = this.getView().getFormShowParameter();
        DynamicObject saleOrder = BusinessDataServiceHelper.loadSingle((Object)formShowParameter.getCustomParam("Id"), (String)"pos_salesorder");
        DynamicObject currency = saleOrder.getDynamicObject("currencyid");
        this.getModel().setValue(CURRENCY, (Object)currency.getLong("Id"));
        BigDecimal amount = this.getNeedPayAmount(saleOrder, (String)formShowParameter.getCustomParam("recordStr"));
        DynamicObject org = saleOrder.getDynamicObject("bizorgid");
        this.getModel().setValue("org", org.getPkValue());
        this.getModel().setValue("needpayamount", (Object)amount);
        this.getModel().setValue(AMOUNT, (Object)amount);
        String billType = saleOrder.getString("biztype");
        if (billType.equalsIgnoreCase(BizTypeEnum.SALERETURN.getValue())) {
            this.getModel().setValue(AMOUNT, (Object)amount);
        } else {
            this.getModel().setValue(AMOUNT, (Object)AmountHelper.getAmountAfterWipeZeroMode((long)CommonUtil.formatObejctToLong((Object)org.getPkValue()), (BigDecimal)amount));
        }
    }

    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.addClickListeners(new String[]{BUTTON_OK});
    }

    public void click(EventObject e) {
        super.click(e);
        Control source = (Control)e.getSource();
        switch (source.getKey()) {
            case "btnok": {
                BigDecimal needPayAmount = new BigDecimal(this.getModel().getValue("needpayamount").toString());
                if (needPayAmount.compareTo(BigDecimal.ZERO) == 0) {
                    this.getView().showErrorNotification("\u8fd8\u9700\u652f\u4ed8\u91d1\u989d\u5df2\u4e3a0\uff0c\u65e0\u9700\u8d4a\u8d26\u3002");
                    return;
                }
                BigDecimal creditAmount = new BigDecimal(this.getModel().getValue(AMOUNT).toString());
                HashMap<String, Object> map = new HashMap<String, Object>();
                DynamicObject org = (DynamicObject)this.getModel().getValue("org");
                long orgId = CommonUtil.formatObejctToLong((Object)org.getPkValue());
                BigDecimal wipeAmount = AmountHelper.getAmountAfterWipeZeroMode((long)orgId, (BigDecimal)needPayAmount);
                if (creditAmount.abs().compareTo(wipeAmount.abs()) > 0) {
                    this.getView().showErrorNotification("\u8d4a\u8d26\u91d1\u989d\u4e0d\u5141\u8bb8\u5927\u4e8e\u8fd8\u9700\u652f\u4ed8\u91d1\u989d\u3002");
                    return;
                }
                BigDecimal lastAmount = needPayAmount.subtract(creditAmount);
                if (creditAmount.compareTo(wipeAmount) == 0 && lastAmount.compareTo(BigDecimal.ZERO) != 0) {
                    map.put("wipeamount", lastAmount);
                }
                map.put("showamount", this.getModel().getValue(AMOUNT));
                DynamicObject paycurrency = (DynamicObject)this.getModel().getValue(CURRENCY);
                map.put("paycurrency", paycurrency.getPkValue());
                map.put("payway", PaymentModeEnum.getKey((String)"tosettleaccounts"));
                map.put("paytime", TimeServiceHelper.now());
                map.put("actualamount", this.getModel().getValue(AMOUNT));
                map.put("exchangerate", BigDecimal.ONE);
                this.getView().returnDataToParent(map);
                this.getView().close();
                break;
            }
        }
    }

    private BigDecimal getNeedPayAmount(DynamicObject saleOrder, String recordJson) {
        DynamicObject paycurrency = (DynamicObject)this.getModel().getValue(CURRENCY);
        String payKey = PaymentModeEnum.getKey((String)"tosettleaccounts") + "_" + paycurrency.getPkValue();
        DynamicObject currency = saleOrder.getDynamicObject("currencyid");
        String wipeKey = PaymentModeEnum.getKey((String)"clearprice") + "_" + currency.getPkValue();
        BigDecimal wipeAmount = BigDecimal.ZERO;
        Map payMap = (Map)JsonUtil.fromJson((String)recordJson, Map.class);
        BigDecimal hasPayAmount = BigDecimal.ZERO;
        if (payMap.size() > 0) {
            for (Map.Entry m : payMap.entrySet()) {
                if (((String)m.getKey()).equalsIgnoreCase(wipeKey)) {
                    wipeAmount = (BigDecimal)m.getValue();
                    continue;
                }
                if (((String)m.getKey()).equalsIgnoreCase(payKey)) continue;
                hasPayAmount = hasPayAmount.add((BigDecimal)m.getValue());
            }
        }
        BigDecimal needPayAmount = saleOrder.getBigDecimal("payableamount").subtract(saleOrder.getBigDecimal("totalrealamount"));
        String bizType = saleOrder.getString("biztype");
        if ("B".equalsIgnoreCase(bizType)) {
            needPayAmount = needPayAmount.subtract(wipeAmount);
        }
        return needPayAmount.subtract(hasPayAmount);
    }

    public static <T> T fromJson(String json, Class<T> clzz) {
        return (T)SerializationUtils.fromJsonString((String)json, clzz);
    }
}

