/*
 * Decompiled with CFR 0.152.
 */
package kd.drp.pos.formplugin.saleorder;

import java.math.BigDecimal;
import java.util.Date;
import java.util.EventObject;
import java.util.HashMap;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.form.FormShowParameter;
import kd.bos.form.MessageBoxOptions;
import kd.bos.form.control.Control;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.TimeServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.drp.dbd.business.payhelper.PayTradeHelper;
import kd.drp.dbd.common.pay.config.CheckOutCounterInfo;
import kd.drp.dbd.common.pay.config.PayResult;
import kd.drp.dbd.common.pay.config.RefundInfo;
import kd.drp.dbd.common.pay.config.RefundResult;
import kd.drp.dbd.common.pay.config.TradeStatus;
import kd.drp.dbd.enums.PaymentModeEnum;
import kd.drp.mdr.common.util.BigDecimalUtil;
import kd.drp.mdr.formplugin.MdrFormPlugin;
import kd.drp.pos.business.commonhelper.AmountHelper;
import kd.drp.pos.business.saleorder.SaleOrderHelper;
import kd.drp.pos.common.saleorder.BizTypeEnum;
import kd.drp.pos.common.util.CommonUtil;
import kd.drp.pos.common.vo.PaymentRecord;

public class SaleOrderElectronicPayPlugin
extends MdrFormPlugin {
    private static final String AMOUNT = "amount";
    private static final String PAYABLEAMOUNT = "payableamount";
    private static final String AUTHCODE = "authcode";

    public void beforeBindData(EventObject e) {
        boolean isTicketReturn;
        super.beforeBindData(e);
        FormShowParameter formShowParameter = this.getView().getFormShowParameter();
        DynamicObject saleOrder = BusinessDataServiceHelper.loadSingle((Object)formShowParameter.getCustomParam("Id"), (String)"pos_salesorder");
        String hasPayAmountStr = formShowParameter.getCustomParam("hasPayAmount").toString();
        String payWayKey = formShowParameter.getCustomParam("payWayKey").toString();
        long payChannelId = PaymentModeEnum.getKey((String)payWayKey);
        BigDecimal hasPayAmount = new BigDecimal(hasPayAmountStr);
        BigDecimal payAbleAmount = saleOrder.getBigDecimal(PAYABLEAMOUNT).subtract(saleOrder.getBigDecimal("totalrealamount")).subtract(hasPayAmount);
        DynamicObject org = saleOrder.getDynamicObject("bizorgid");
        long orgId = CommonUtil.formatObejctToLong((Object)org.getPkValue());
        String billType = saleOrder.getString("biztype");
        if (!billType.equalsIgnoreCase(BizTypeEnum.SALERETURN.getValue())) {
            payAbleAmount = AmountHelper.getAmountAfterWipeZeroMode((long)orgId, (BigDecimal)payAbleAmount);
        }
        this.getModel().setValue(AMOUNT, (Object)payAbleAmount);
        this.getModel().setValue(PAYABLEAMOUNT, (Object)payAbleAmount);
        if ("B".equalsIgnoreCase(billType) && (isTicketReturn = saleOrder.getBoolean("isticketreturn"))) {
            long bookOrderbillId;
            DynamicObject bookOrderSaleOrder;
            DynamicObjectCollection bookPayCollection;
            boolean isCurrentPay = false;
            boolean isRefundAll = true;
            long sourcebillId = saleOrder.getDynamicObject("sourcebillid").getLong("Id");
            DynamicObject sourceSaleOrder = BusinessDataServiceHelper.loadSingle((Object)sourcebillId, (String)"pos_salesorder");
            DynamicObjectCollection payCollection = sourceSaleOrder.getDynamicObjectCollection("finentity");
            String sourceBillType = sourceSaleOrder.getString("biztype");
            if ("C".equalsIgnoreCase(sourceBillType) && (bookPayCollection = (bookOrderSaleOrder = BusinessDataServiceHelper.loadSingle((Object)(bookOrderbillId = sourceSaleOrder.getDynamicObject("sourcebillid").getLong("Id")), (String)"pos_salesorder")).getDynamicObjectCollection("finentity")) != null && bookPayCollection.size() > 0) {
                for (DynamicObject bookPayInfo : bookPayCollection) {
                    long bookPayId = bookPayInfo.getDynamicObject("setllementid").getLong("Id");
                    if (payChannelId != bookPayId) continue;
                    payCollection.add((Object)bookPayInfo);
                }
            }
            if (payCollection != null && payCollection.size() > 0) {
                for (DynamicObject payInfo : payCollection) {
                    long payId = payInfo.getDynamicObject("setllementid").getLong("Id");
                    if (payChannelId != payId) continue;
                    isCurrentPay = true;
                    BigDecimal stmAmount = payInfo.getBigDecimal("stmamount");
                    BigDecimal refundAmount = payInfo.getBigDecimal("refundamount");
                    String authCode = payInfo.getString("orderno");
                    BigDecimal needRefundAmount = stmAmount.subtract(refundAmount);
                    if (needRefundAmount.compareTo(BigDecimal.ZERO) == 0) continue;
                    isRefundAll = false;
                    this.getModel().setValue(AUTHCODE, (Object)authCode);
                    this.getView().setEnable(Boolean.FALSE, new String[]{AUTHCODE});
                    if (payAbleAmount.abs().compareTo(needRefundAmount) > 0) {
                        this.getModel().setValue(AMOUNT, (Object)needRefundAmount.negate());
                        this.getModel().setValue(PAYABLEAMOUNT, (Object)needRefundAmount.negate());
                        break;
                    }
                    this.getModel().setValue(AMOUNT, (Object)payAbleAmount);
                    this.getModel().setValue(PAYABLEAMOUNT, (Object)payAbleAmount);
                    break;
                }
            }
            if (!isCurrentPay) {
                this.getModel().setValue(AMOUNT, (Object)BigDecimal.ZERO);
                this.getModel().setValue(PAYABLEAMOUNT, (Object)BigDecimal.ZERO);
                this.getView().setEnable(Boolean.FALSE, new String[]{AUTHCODE});
                this.getView().showErrorNotification("\u672a\u4f7f\u7528\u8be5\u652f\u4ed8\u65b9\u5f0f\uff0c\u4e0d\u652f\u6301\u9000\u6b3e\uff01");
                return;
            }
            if (isRefundAll) {
                this.getModel().setValue(AMOUNT, (Object)BigDecimal.ZERO);
                this.getModel().setValue(PAYABLEAMOUNT, (Object)BigDecimal.ZERO);
                this.getView().setEnable(Boolean.FALSE, new String[]{AUTHCODE});
                this.getView().showErrorNotification("\u5df2\u5168\u989d\u9000\u6b3e\uff01");
            }
        }
    }

    public void propertyChanged(PropertyChangedArgs e) {
        String changeName;
        super.propertyChanged(e);
        switch (changeName = e.getProperty().getName()) {
            case "authcode": {
                this.callPayOrRefund();
                break;
            }
        }
    }

    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.addClickListeners(new String[]{"btnok"});
    }

    public void click(EventObject e) {
        super.click(e);
        Control source = (Control)e.getSource();
        if ("btnok".equals(source.getKey())) {
            this.callPayOrRefund();
        }
    }

    protected void callPayOrRefund() {
        String orderType;
        DynamicObject goodsInfo;
        BigDecimal totalAmount = BigDecimalUtil.toBigDecimal((Object)this.getModel().getValue(AMOUNT));
        String authCode = this.getModel().getValue(AUTHCODE).toString();
        FormShowParameter formShowParameter = this.getView().getFormShowParameter();
        Object saleOrderId = formShowParameter.getCustomParam("Id");
        String payWayKey = formShowParameter.getCustomParam("payWayKey").toString();
        long payChannelId = PaymentModeEnum.getKey((String)payWayKey);
        DynamicObject saleOrder = BusinessDataServiceHelper.loadSingle((Object)saleOrderId, (String)"pos_salesorder");
        String hasPayAmountStr = formShowParameter.getCustomParam("hasPayAmount").toString();
        BigDecimal hasPayAmount = new BigDecimal(hasPayAmountStr);
        BigDecimal payAbleAmount = saleOrder.getBigDecimal(PAYABLEAMOUNT).subtract(saleOrder.getBigDecimal("totalrealamount")).subtract(hasPayAmount);
        DynamicObject org = saleOrder.getDynamicObject("bizorgid");
        long orgId = CommonUtil.formatObejctToLong((Object)org.getPkValue());
        String billType = saleOrder.getString("biztype");
        BigDecimal needPayAmount = payAbleAmount;
        BigDecimal finalWipeAmount = BigDecimal.ZERO;
        if (!billType.equalsIgnoreCase(BizTypeEnum.SALERETURN.getValue())) {
            needPayAmount = AmountHelper.getAmountAfterWipeZeroMode((long)orgId, (BigDecimal)payAbleAmount);
            finalWipeAmount = payAbleAmount.subtract(needPayAmount);
        }
        if (needPayAmount.compareTo(BigDecimal.ZERO) == 0) {
            this.getView().showErrorNotification("\u8fd8\u9700\u652f\u4ed8\u91d1\u989d\u4e3a0\uff0c\u65e0\u9700\u53d1\u8d77\u652f\u4ed8\u3002");
            return;
        }
        if (totalAmount.abs().compareTo(needPayAmount.abs()) > 0) {
            this.getView().showErrorNotification("\u652f\u4ed8\u91d1\u989d\u4e0d\u5141\u8bb8\u5927\u4e8e\u8fd8\u9700\u652f\u4ed8\u91d1\u989d\u3002");
            return;
        }
        String billNo = saleOrder.getString("billno");
        long operatorId = 0L;
        DynamicObject creatorInfo = saleOrder.getDynamicObject("creator");
        if (creatorInfo != null) {
            operatorId = creatorInfo.getLong("Id");
        }
        Date operaTime = TimeServiceHelper.now();
        long storeId = 0L;
        String goodsNumber = "";
        DynamicObject saleBranchInfo = saleOrder.getDynamicObject("salebranchid");
        if (saleBranchInfo != null) {
            storeId = saleBranchInfo.getLong("Id");
        }
        DynamicObject payCurrency = saleOrder.getDynamicObject("currencyid");
        long payCurrencyId = payCurrency.getLong("Id");
        DynamicObjectCollection goodsList = saleOrder.getDynamicObjectCollection("goodsentryentity");
        if (goodsList != null && goodsList.size() > 0 && (goodsInfo = ((DynamicObject)goodsList.get(0)).getDynamicObject("goodsid")) != null) {
            goodsNumber = goodsInfo.getString("number");
        }
        if ("B".equalsIgnoreCase(orderType = saleOrder.getString("biztype"))) {
            if (totalAmount.compareTo(BigDecimal.ZERO) >= 0) {
                this.getView().showErrorNotification("\u5355\u636e\u4e1a\u52a1\u7c7b\u578b\u4e3a\u201c\u9500\u552e\u9000\u8d27\u201d\u65f6\uff0c\u8f93\u5165\u652f\u4ed8\u91d1\u989d\u5e94\u5c0f\u4e8e0\u3002");
                return;
            }
            LocaleString paramLocaleString = new LocaleString("\u9000\u6b3e\u4e2d...");
            this.getView().showLoading(paramLocaleString);
            this.callRefund(totalAmount, authCode, saleOrder, billNo, operatorId, operaTime, storeId, payCurrency, payCurrencyId, payChannelId);
        } else {
            if (totalAmount.compareTo(BigDecimal.ZERO) <= 0) {
                this.getView().showErrorNotification("\u5355\u636e\u4e1a\u52a1\u7c7b\u578b\u4e0d\u4e3a\u201c\u9500\u552e\u9000\u8d27\u201d\u65f6\uff0c\u8f93\u5165\u652f\u4ed8\u91d1\u989d\u5e94\u5927\u4e8e0\u3002");
                return;
            }
            LocaleString paramLocaleString = new LocaleString("\u652f\u4ed8\u4e2d...");
            this.getView().showLoading(paramLocaleString);
            this.callPay(totalAmount, authCode, saleOrder, billNo, operatorId, operaTime, storeId, goodsNumber, payCurrency, payCurrencyId, finalWipeAmount, payChannelId);
        }
        this.getView().hideLoading();
    }

    protected void callRefund(BigDecimal totalAmount, String authCode, DynamicObject saleOrder, String billNo, long operatorId, Date operaTime, long storeId, DynamicObject payCurrency, long payCurrencyId, long payChannelId) {
        RefundInfo refundData = new RefundInfo();
        refundData.setBillNo(billNo);
        refundData.setOperatorId(operatorId);
        refundData.setOperaTime(operaTime);
        refundData.setStoreId(storeId);
        RefundResult refundResult = PayTradeHelper.getRefundData((RefundInfo)refundData, (long)payChannelId, (String)"", (String)authCode, (BigDecimal)totalAmount.abs());
        TradeStatus paystatus = refundResult.getTradeStatus();
        StringBuilder errorMessage = this.getRefundErrorMsg(refundResult);
        if (TradeStatus.SUCCESS.equals((Object)paystatus)) {
            String outTradeNo = refundResult.getRefundResponse().getString("out_trade_no");
            String tradeNo = refundResult.getRefundResponse().getString("trade_no");
            Map<String, Object> map = this.afterPaySuccess(saleOrder, totalAmount, payCurrency, payCurrencyId, outTradeNo, tradeNo, BigDecimal.ZERO, payChannelId);
            DynamicObject sourcebillIdInfo = saleOrder.getDynamicObject("sourcebillid");
            if (sourcebillIdInfo != null) {
                DynamicObjectCollection payCollection;
                long bookOrderbillId;
                DynamicObject bookOrderSaleOrder;
                DynamicObjectCollection bookPayCollection;
                long sourcebillId = sourcebillIdInfo.getLong("Id");
                DynamicObject sourceSaleOrder = BusinessDataServiceHelper.loadSingle((Object)sourcebillId, (String)"pos_salesorder");
                String sourceBillType = sourceSaleOrder.getString("biztype");
                if ("C".equalsIgnoreCase(sourceBillType) && (bookPayCollection = (bookOrderSaleOrder = BusinessDataServiceHelper.loadSingle((Object)(bookOrderbillId = sourceSaleOrder.getDynamicObject("sourcebillid").getLong("Id")), (String)"pos_salesorder")).getDynamicObjectCollection("finentity")) != null && bookPayCollection.size() > 0) {
                    for (DynamicObject bookPayInfo : bookPayCollection) {
                        String bookSourceOutTradeNo = bookPayInfo.getString("orderno");
                        if (!outTradeNo.equals(bookSourceOutTradeNo)) continue;
                        BigDecimal refundAmount = bookPayInfo.getBigDecimal("refundamount");
                        refundAmount = refundAmount.add(totalAmount.negate());
                        bookPayInfo.set("refundamount", (Object)refundAmount);
                        BigDecimal stmAmount = bookPayInfo.getBigDecimal("stmamount");
                        if (stmAmount.compareTo(refundAmount) != 0) continue;
                        bookPayInfo.set("refundstatus", (Object)Character.valueOf('1'));
                    }
                    SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{bookOrderSaleOrder});
                }
                if ((payCollection = sourceSaleOrder.getDynamicObjectCollection("finentity")) != null && payCollection.size() > 0) {
                    for (DynamicObject payInfo : payCollection) {
                        String sourceOutTradeNo = payInfo.getString("orderno");
                        if (!outTradeNo.equals(sourceOutTradeNo)) continue;
                        BigDecimal refundAmount = payInfo.getBigDecimal("refundamount");
                        refundAmount = refundAmount.add(totalAmount.negate());
                        payInfo.set("refundamount", (Object)refundAmount);
                        BigDecimal stmAmount = payInfo.getBigDecimal("stmamount");
                        if (stmAmount.compareTo(refundAmount) != 0) continue;
                        payInfo.set("refundstatus", (Object)Character.valueOf('1'));
                    }
                    SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{sourceSaleOrder});
                }
            }
            this.getView().showConfirm("\u9000\u6b3e\u6210\u529f", MessageBoxOptions.OK);
            this.getView().returnDataToParent(map);
            this.getView().close();
        } else if (TradeStatus.FAILED.equals((Object)paystatus)) {
            this.getView().showErrorNotification(errorMessage.append(":\u9000\u6b3e\u5931\u8d25").toString());
        } else if (TradeStatus.UNKNOWN.equals((Object)paystatus)) {
            this.getView().showErrorNotification(errorMessage.append(":\u7cfb\u7edf\u5f02\u5e38\uff0c\u8ba2\u5355\u72b6\u6001\u672a\u77e5").toString());
        } else {
            this.getView().showErrorNotification(errorMessage.append(":\u4e0d\u652f\u6301\u7684\u4ea4\u6613\u72b6\u6001\uff0c\u4ea4\u6613\u8fd4\u56de\u5f02\u5e38").toString());
        }
    }

    protected StringBuilder getRefundErrorMsg(RefundResult refundResult) {
        return new StringBuilder();
    }

    protected void callPay(BigDecimal totalAmount, String authCode, DynamicObject saleOrder, String billNo, long operatorId, Date operaTime, long storeId, String goodsNumber, DynamicObject payCurrency, long payCurrencyId, BigDecimal finalWipeAmount, long payChannelId) {
        CheckOutCounterInfo payDate = new CheckOutCounterInfo();
        payDate.setBillNo(billNo);
        payDate.setOperatorId(operatorId);
        payDate.setOperaTime(operaTime);
        payDate.setStoreId(storeId);
        payDate.setSubject(goodsNumber);
        if (PaymentModeEnum.getKey((String)"wechatpay") == payChannelId) {
            payDate.setBody(goodsNumber);
            payDate.setSpbillCreateIp("127.0.0.1");
        }
        PayResult payResult = PayTradeHelper.getPayData((CheckOutCounterInfo)payDate, (long)payChannelId, (String)authCode, (BigDecimal)totalAmount);
        TradeStatus paystatus = payResult.getTradeStatus();
        StringBuilder errorMessage = this.getPayErrorMsg(payResult);
        if (TradeStatus.SUCCESS.equals((Object)paystatus)) {
            String outTradeNo = payResult.getPayResponse().getString("out_trade_no");
            String tradeNo = payResult.getPayResponse().getString("trade_no");
            Map<String, Object> map = this.afterPaySuccess(saleOrder, totalAmount, payCurrency, payCurrencyId, outTradeNo, tradeNo, finalWipeAmount, payChannelId);
            this.getView().showConfirm("\u652f\u4ed8\u6210\u529f", MessageBoxOptions.OK);
            this.getView().returnDataToParent(map);
            this.getView().close();
        } else if (TradeStatus.FAILED.equals((Object)paystatus)) {
            this.getView().showErrorNotification(errorMessage.append(":\u652f\u4ed8\u5931\u8d25").toString());
        } else if (TradeStatus.UNKNOWN.equals((Object)paystatus)) {
            this.getView().showErrorNotification(errorMessage.append(":\u7cfb\u7edf\u5f02\u5e38\uff0c\u8ba2\u5355\u72b6\u6001\u672a\u77e5").toString());
        } else {
            this.getView().showErrorNotification(errorMessage.append(":\u4e0d\u652f\u6301\u7684\u4ea4\u6613\u72b6\u6001\uff0c\u4ea4\u6613\u8fd4\u56de\u5f02\u5e38").toString());
        }
    }

    protected StringBuilder getPayErrorMsg(PayResult payResult) {
        return new StringBuilder();
    }

    protected Map<String, Object> afterPaySuccess(DynamicObject saleOrder, BigDecimal payAmount, DynamicObject payCurrency, long payCurrencyId, String outTradeNo, String tradeNo, BigDecimal finalWipeAmount, long payChannelId) {
        PaymentRecord payRecord = new PaymentRecord();
        payRecord.setPayCurrencyId(payCurrencyId);
        payRecord.setPayCurrency(payCurrency);
        DynamicObject payWay = BusinessDataServiceHelper.loadSingle((Object)payChannelId, (String)"dbd_paymode");
        payRecord.setPayWayId(payChannelId);
        payRecord.setPayWay(payWay);
        Date paytime = TimeServiceHelper.now();
        payRecord.setPaytime(paytime);
        payRecord.setAmount(payAmount);
        payRecord.setOrderNo(outTradeNo);
        payRecord.setBankExchangeNo(tradeNo);
        SaleOrderHelper.updateSaleOrderAfterPayment((DynamicObject)saleOrder, (PaymentRecord)payRecord);
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("showamount", payAmount);
        map.put("paycurrency", payCurrencyId);
        map.put("payway", payChannelId);
        map.put("actualamount", payAmount);
        map.put("paytime", paytime);
        if (finalWipeAmount.compareTo(BigDecimal.ZERO) > 0) {
            map.put("wipeamount", finalWipeAmount);
        }
        return map;
    }
}

