/*
 * Decompiled with CFR 0.152.
 */
package kd.drp.pos.formplugin.saleorder;

import java.math.BigDecimal;
import java.util.Date;
import java.util.EventObject;
import java.util.Map;
import kd.bos.bill.AbstractBillPlugIn;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.earlywarn.kit.StringUtil;
import kd.bos.form.control.events.ItemClickEvent;
import kd.bos.form.events.ClientCallBackEvent;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.form.field.events.BeforeF7SelectListener;
import kd.bos.list.ListShowParameter;
import kd.bos.orm.query.QFilter;
import kd.drp.pos.business.commonhelper.CurrencyHelper;
import kd.drp.pos.business.invoice.InvoiceHelper;
import kd.drp.pos.business.saleorder.SaleOrderHelper;
import kd.drp.pos.common.OwnerUtils;
import kd.drp.pos.common.util.CommonUtil;
import kd.drp.pos.common.util.DynamicObjectUtil;
import kd.drp.pos.common.util.F7Util;
import kd.drp.pos.common.util.PermissionUtil;
import kd.drp.pos.common.vo.OperationResult;

public class SaleOrderFormPlugin
extends AbstractBillPlugIn
implements BeforeF7SelectListener {
    private static final String KEY_BASEDATAFIELD_TBMAIN = "tbmain";
    private static final String BTN_CREATEINVOICE = "createinvoice";
    private static final String PERM_CREATEINVOICE = "0QZL9T19HJYU";
    private static final String KEY_PUSHBILLANDCREATEINVOICE = "pushBillAndCreateInvoice";
    private static final String KEY_EDIT = "_edit";
    private static String[] f7FieldKeys = new String[]{"sourcebillid", "salebranchid", "saler", "goodsid", "barcode", "goodssaler", "stockid", "stockposition", "erpstockposition", "goodsid_edit", "barcode_edit", "distributionmode", "stockid_edit", "stockposition_edit", "erpstockposition_edit"};

    public void afterCreateNewData(EventObject e) {
        super.afterCreateNewData(e);
        long branchId = OwnerUtils.getDefaultOwnerId();
        this.getView().getModel().setValue("salebranchid", (Object)branchId);
        DynamicObject branch = (DynamicObject)this.getView().getModel().getValue("salebranchid");
        long orgId = DynamicObjectUtil.getPkValue((DynamicObject)branch, (String)"bizgroup");
        this.getView().getModel().setValue("bizorgid", (Object)orgId);
        this.initCurrency(branch, orgId);
        this.getModel().setValue("cashier", (Object)CommonUtil.formatStringToLong((String)RequestContext.get().getUserId()));
        DynamicObjectCollection entryData = this.getView().getModel().getEntryEntity("goodsentryentity");
        this.initEntry(entryData, branchId);
    }

    public void registerListener(EventObject e) {
        super.registerListener(e);
        for (String fieldKey : f7FieldKeys) {
            BasedataEdit basedataEdit = (BasedataEdit)this.getView().getControl(fieldKey);
            basedataEdit.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        }
        this.addItemClickListeners(new String[]{KEY_BASEDATAFIELD_TBMAIN});
    }

    public void beforeF7Select(BeforeF7SelectEvent arg) {
        String fieldKey = arg.getProperty().getName();
        QFilter qFilter = null;
        switch (fieldKey) {
            case "sourcebillid": {
                String bizType = CommonUtil.formatStringToEmpty((Object)this.getView().getModel().getValue("biztype"));
                DynamicObject saleBranch = (DynamicObject)this.getView().getModel().getValue("salebranchid");
                boolean isRedRush = CommonUtil.formatObjectToBoolean((Object)this.getView().getModel().getValue("isredrush"));
                if (this.checkBranchIsBlank(saleBranch)) {
                    arg.setCancel(true);
                    return;
                }
                qFilter = F7Util.getSourceBillFilter((boolean)isRedRush, (String)bizType, (DynamicObject)saleBranch);
                break;
            }
            case "stockid": {
                DynamicObject saleBranch = (DynamicObject)this.getView().getModel().getValue("salebranchid");
                if (this.chechBranchIsBlank(saleBranch)) {
                    arg.setCancel(true);
                    return;
                }
                qFilter = F7Util.getStockIdFilter((DynamicObject)saleBranch);
                break;
            }
            case "stockposition": {
                DynamicObject stock = (DynamicObject)this.getView().getModel().getValue("stockid");
                long stockId = DynamicObjectUtil.getPkValue((DynamicObject)stock);
                qFilter = F7Util.getStockPositionidFilter((long)stockId);
                break;
            }
            case "salebranchid": {
                qFilter = F7Util.getBranchIdFilter();
                break;
            }
            case "goodsid": {
                DynamicObject saleBranch = (DynamicObject)this.getView().getModel().getValue("salebranchid");
                if (this.chechBranchIsBlank(saleBranch)) {
                    arg.setCancel(true);
                    return;
                }
                qFilter = this.getGoodsInfoFilter(saleBranch, true);
                break;
            }
            case "barcode": {
                DynamicObject saleBranch = (DynamicObject)this.getView().getModel().getValue("salebranchid");
                if (this.chechBranchIsBlank(saleBranch)) {
                    arg.setCancel(true);
                    return;
                }
                DynamicObject goods = (DynamicObject)this.getView().getModel().getValue("goodsid", arg.getRow());
                if (goods == null) {
                    qFilter = this.getGoodsInfoFilter(saleBranch, false);
                    break;
                }
                long goodsId = DynamicObjectUtil.getPkValue((DynamicObject)goods);
                qFilter = this.getGoodsInfoFilter(saleBranch, goodsId);
                break;
            }
            case "saler": 
            case "goodssaler": {
                DynamicObject bizOrg = (DynamicObject)this.getView().getModel().getValue("bizorgid");
                if (!this.checkBizOrg(bizOrg)) {
                    arg.setCancel(true);
                    return;
                }
                qFilter = F7Util.getSalerFilter((DynamicObject)bizOrg);
                break;
            }
            case "distributionmode": {
                DynamicObject goods = (DynamicObject)this.getView().getModel().getValue("goodsid", arg.getRow());
                qFilter = F7Util.getDistributionModeFilter((DynamicObject)goods);
                break;
            }
            case "erpstockposition": {
                DynamicObject erpStock = (DynamicObject)this.getView().getModel().getValue("erpstock", arg.getRow());
                qFilter = F7Util.getErpStockPositionidFilter((long)DynamicObjectUtil.getPkValue((DynamicObject)erpStock));
                break;
            }
        }
        ListShowParameter showParameter = (ListShowParameter)arg.getFormShowParameter();
        if (StringUtils.equals((CharSequence)fieldKey, (CharSequence)"goodsid")) {
            showParameter.setFormId("bos_listf7");
            showParameter.setCustomParam("isFromPos", (Object)"1");
        }
        showParameter.getListFilterParameter().setFilter(qFilter);
    }

    public void itemClick(ItemClickEvent evt) {
        if (StringUtils.equals((CharSequence)evt.getItemKey(), (CharSequence)BTN_CREATEINVOICE)) {
            if (!PermissionUtil.checkPermission((String)"pos", (String)"pos_salesorder", (String)PERM_CREATEINVOICE)) {
                this.getView().showTipNotification("\u5f53\u524d\u8d26\u53f7\u65e0\u5f00\u53d1\u7968\u6743\u9650\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458\u6388\u6743\u3002");
                return;
            }
            long id = CommonUtil.formatObejctToLong((Object)this.getView().getModel().getValue("Id"));
            if (id == 0L) {
                this.getView().showErrorNotification("\u8bf7\u5148\u4fdd\u5b58\u5355\u636e\u3002");
                return;
            }
            String result = InvoiceHelper.reCreateInvoice((Object)this.getView().getModel().getValue("Id"));
            if (StringUtil.isNotEmpty((CharSequence)result)) {
                this.getView().showErrorNotification(result);
            } else {
                this.getView().showSuccessNotification("\u5f00\u53d1\u7968\u6210\u529f\u3002");
            }
        }
    }

    public void closedCallBack(ClosedCallBackEvent cvt) {
        super.closedCallBack(cvt);
    }

    public void clientCallBack(ClientCallBackEvent e) {
        if (KEY_PUSHBILLANDCREATEINVOICE.equals(e.getName())) {
            OperationResult pushAndInvoiceReuslt = SaleOrderHelper.pushBillAndCreateInvoice((Object)this.getView().getModel().getValue("Id"));
            if (pushAndInvoiceReuslt.getSuccess().booleanValue()) {
                this.getView().showSuccessNotification(pushAndInvoiceReuslt.getMessage());
            } else {
                this.getView().showErrorNotification(pushAndInvoiceReuslt.getMessage());
            }
        }
    }

    private boolean checkBranchIsBlank(DynamicObject saleBranch) {
        if (saleBranch == null) {
            this.getView().showTipNotification("\u8bf7\u5148\u9009\u62e9\u5f00\u5355\u95e8\u5e97\u3002");
            return true;
        }
        return false;
    }

    private void initEntry(DynamicObjectCollection entryData, long branchId) {
        for (DynamicObject item : entryData) {
            String owerType;
            String keepType;
            int index = DynamicObjectUtil.getInt((DynamicObject)item, (String)"Seq") - 1;
            if (index < 0) {
                index = 0;
            }
            if (StringUtils.equals((CharSequence)(keepType = DynamicObjectUtil.getString((DynamicObject)item, (String)"keepertype")), (CharSequence)"mdr_customer")) {
                this.getView().getModel().setValue("keeperid", (Object)branchId, index);
            }
            if (!StringUtils.equals((CharSequence)(owerType = DynamicObjectUtil.getString((DynamicObject)item, (String)"ownertype")), (CharSequence)"mdr_customer")) continue;
            this.getView().getModel().setValue("ownerid", (Object)branchId, index);
        }
    }

    private void initCurrency(DynamicObject branch, long orgId) {
        long itemCurrencyId = DynamicObjectUtil.getPkValue((DynamicObject)branch, (String)"currency");
        this.getModel().setItemValueByID("currencyid", (Object)itemCurrencyId);
        Map currencyAndExRateMap = CurrencyHelper.getCurrencyAndExRateTable((Long)orgId);
        if (currencyAndExRateMap != null) {
            Long baseCurrencyId = (Long)currencyAndExRateMap.get("baseCurrencyID");
            Long exchangeRateTableId = (Long)currencyAndExRateMap.get("exchangeRateTableID");
            this.getModel().setValue("locurrencyid", (Object)baseCurrencyId);
            this.getModel().setValue("exratetable", (Object)exchangeRateTableId);
            DynamicObject currency = (DynamicObject)this.getModel().getValue("currencyid");
            BigDecimal rate = CurrencyHelper.getExChangeRate((Long)Long.parseLong(currency.getPkValue().toString()), (Long)baseCurrencyId, (Long)exchangeRateTableId, (Date)new Date());
            this.getModel().setValue("financeexchangerate", (Object)rate);
        }
    }

    private QFilter getGoodsInfoFilter(DynamicObject saleBranch, boolean flag) {
        DynamicObject currency = (DynamicObject)this.getView().getModel().getValue("currencyid");
        long branchId = DynamicObjectUtil.getPkValue((DynamicObject)saleBranch);
        long currencyId = DynamicObjectUtil.getPkValue((DynamicObject)currency);
        if (flag) {
            return F7Util.getGoodsIdFilter((long)branchId, (long)currencyId);
        }
        return F7Util.getBarCodeIdFilter((long)branchId, (long)currencyId);
    }

    private QFilter getGoodsInfoFilter(DynamicObject saleBranch, long goodsId) {
        DynamicObject currency = (DynamicObject)this.getView().getModel().getValue("currencyid");
        long branchId = DynamicObjectUtil.getPkValue((DynamicObject)saleBranch);
        long currencyId = DynamicObjectUtil.getPkValue((DynamicObject)currency);
        return F7Util.getBarCodeIdFilter((long)branchId, (long)goodsId, (long)currencyId);
    }

    private boolean chechBranchIsBlank(DynamicObject saleBranch) {
        if (saleBranch == null) {
            this.getView().showTipNotification("\u8bf7\u5148\u9009\u62e9\u5f00\u5355\u95e8\u5e97\u3002");
            return true;
        }
        return false;
    }

    private boolean checkBizOrg(DynamicObject bizOrg) {
        if (bizOrg == null) {
            this.getView().showErrorNotification("\u8bf7\u5148\u9009\u62e9\u4e1a\u52a1\u7ec4\u7ec7\u3002");
            return false;
        }
        return true;
    }
}

