/*
 * Decompiled with CFR 0.152.
 */
package kd.drp.pos.formplugin.saleorder;

import java.math.BigDecimal;
import java.util.EventObject;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.earlywarn.kit.StringUtil;
import kd.bos.form.CloseCallBack;
import kd.bos.form.FormShowParameter;
import kd.bos.form.MessageBoxOptions;
import kd.bos.form.ShowType;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.BeforeClosedEvent;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.TimeServiceHelper;
import kd.drp.dbd.enums.PaymentModeEnum;
import kd.drp.mdr.formplugin.plugintemplate.MdrBillFormPlugin;
import kd.drp.pos.business.commonhelper.AmountHelper;
import kd.drp.pos.business.saleorder.SaleOrderHelper;
import kd.drp.pos.common.CommonUtils;
import kd.drp.pos.common.saleorder.BizTypeEnum;
import kd.drp.pos.common.util.CommonUtil;
import kd.drp.pos.common.util.DynamicObjectUtil;
import kd.drp.pos.common.util.JsonUtil;
import kd.drp.pos.common.vo.PaymentRecord;

public class SaleOrderPayInfoPlugin
extends MdrBillFormPlugin {
    private static final String PAYMENTCLOSE = "paymentclose";
    private static final String CREDITCLOSE = "creditclose";
    private static final String NO_ELECTRONIC_CLOSE = "noelectronicclose";
    private static final String KEY_SALE_STATUS = "A";
    private static final String RETURNSTATUS_CONSTS = "1";

    public void afterCreateNewData(EventObject e) {
        super.beforeBindData(e);
        FormShowParameter formShowParameter = this.getView().getFormShowParameter();
        Object saleOrderId = formShowParameter.getCustomParam("Id");
        DynamicObject saleOrder = BusinessDataServiceHelper.loadSingle((Object)saleOrderId, (String)"pos_salesorder");
        this.setValueBySaleOrder(saleOrder);
    }

    public void afterBindData(EventObject e) {
        super.afterBindData(e);
        this.setPaymentButtonVisible();
    }

    private void setValueBySaleOrder(DynamicObject saleOrder) {
        this.getModel().setValue("currency", (Object)DynamicObjectUtil.getPkValue((DynamicObject)saleOrder, (String)"currencyid"));
        this.getModel().setValue("actualprice", (Object)saleOrder.getBigDecimal("sumbalamount").toPlainString());
        this.getModel().setValue("totalprice", (Object)saleOrder.getBigDecimal("sumamount").toPlainString());
        this.getModel().setValue("discountamount", (Object)saleOrder.getBigDecimal("sumdiscount").toPlainString());
        this.getModel().setValue("locurrency", (Object)DynamicObjectUtil.getPkValue((DynamicObject)saleOrder, (String)"locurrencyid"));
        this.getModel().setValue("customer", (Object)DynamicObjectUtil.getPkValue((DynamicObject)saleOrder, (String)"customerid"));
        String orderType = saleOrder.getString("biztype");
        if ("B".equalsIgnoreCase(orderType)) {
            this.setPayRecordOfReturnBack(saleOrder);
        } else {
            this.setPayRecordOfSaleOrder(saleOrder);
        }
    }

    private void setPayRecordOfSaleOrder(DynamicObject saleOrder) {
        BigDecimal needPayAmount = saleOrder.getBigDecimal("payableamount").subtract(saleOrder.getBigDecimal("totalrealamount"));
        this.getModel().setValue("needpayamount", (Object)needPayAmount);
        DynamicObject org = saleOrder.getDynamicObject("bizorgid");
        DynamicObjectCollection payRecordList = this.getModel().getEntryEntity("payrecords");
        BigDecimal wipeAmount = needPayAmount.subtract(AmountHelper.getAmountAfterWipeZeroMode((long)CommonUtil.formatObejctToLong((Object)org.getPkValue()), (BigDecimal)needPayAmount));
        this.addWipeRecordEntry(wipeAmount);
        DynamicObjectCollection payList = saleOrder.getDynamicObjectCollection("finentity");
        if (payList.size() > 0) {
            for (DynamicObject pay : payList) {
                DynamicObject payRecord = payRecordList.addNew();
                payRecord.set("payway", (Object)pay.getDynamicObject("setllementid"));
                payRecord.set("showamount", pay.get("settleamount"));
                payRecord.set("paytime", pay.get("paytime"));
                payRecord.set("paycurrency", (Object)pay.getDynamicObject("settlecurrid"));
                payRecord.set("actualamount", (Object)pay.getBigDecimal("stmamount"));
                payRecord.set("exchangerate", (Object)pay.getBigDecimal("settlementrate"));
            }
        }
    }

    private void setPayRecordOfReturnBack(DynamicObject saleOrder) {
        DynamicObject sourceBill = saleOrder.getDynamicObject("sourcebillid");
        boolean isRedrush = saleOrder.getBoolean("isredrush");
        BigDecimal clearAmount = BigDecimal.ZERO;
        if (sourceBill != null) {
            DynamicObjectCollection orderPayList;
            Object sourceBillId = sourceBill.getPkValue();
            DynamicObject sourceSaleOrder = BusinessDataServiceHelper.loadSingle((Object)sourceBillId, (String)"pos_salesorder");
            DynamicObject sourceOrderView = BusinessDataServiceHelper.loadSingle((Object)sourceBillId, (String)"pos_salesorderbaseinfo");
            boolean alreadyReturn = sourceOrderView.getBigDecimal("sumretqty").compareTo(BigDecimal.ZERO) > 0;
            DynamicObjectCollection payList = sourceSaleOrder.getDynamicObjectCollection("finentity");
            if (payList.size() > 0) {
                DynamicObjectCollection payRecordList = this.getModel().getEntryEntity("payrecords");
                DynamicObject payway = new DynamicObject();
                for (DynamicObject pay : payList) {
                    payway = pay.getDynamicObject("setllementid");
                    if (PaymentModeEnum.getKey((String)"clearprice") == CommonUtil.formatObejctToLong((Object)payway.getPkValue()) && alreadyReturn) continue;
                    DynamicObject payRecord = payRecordList.addNew();
                    payRecord.set("payway", (Object)pay.getDynamicObject("setllementid"));
                    payRecord.set("showamount", (Object)pay.getBigDecimal("settleamount"));
                    payRecord.set("paytime", pay.get("paytime"));
                    payRecord.set("paycurrency", (Object)pay.getDynamicObject("settlecurrid"));
                    payRecord.set("actualamount", (Object)pay.getBigDecimal("stmamount"));
                    payRecord.set("exchangerate", (Object)pay.getBigDecimal("settlementrate"));
                    payRecord.set("sourcebillno", (Object)pay.getString("orderno"));
                    if (PaymentModeEnum.getKey((String)"clearprice") != CommonUtil.formatObejctToLong((Object)payway.getPkValue()) || isRedrush) continue;
                    DynamicObjectCollection backRecordList = this.getModel().getEntryEntity("returnpayrecords");
                    DynamicObject backRecord = backRecordList.addNew();
                    backRecord.set("returnpayway", (Object)pay.getDynamicObject("setllementid"));
                    backRecord.set("hasreturnamount", (Object)pay.getBigDecimal("settleamount").negate());
                    backRecord.set("returntime", pay.get("paytime"));
                    backRecord.set("returncurrency", (Object)pay.getDynamicObject("settlecurrid"));
                    backRecord.set("returnactualamount", (Object)pay.getBigDecimal("stmamount").negate());
                    backRecord.set("returnexchangerate", (Object)pay.getBigDecimal("settlementrate"));
                    backRecord.set("returnstatus", (Object)RETURNSTATUS_CONSTS);
                    clearAmount = clearAmount.add(pay.getBigDecimal("stmamount").negate());
                }
            }
            if ((orderPayList = saleOrder.getDynamicObjectCollection("finentity")).size() > 0) {
                DynamicObjectCollection backRecordList = this.getModel().getEntryEntity("returnpayrecords");
                for (DynamicObject pay : orderPayList) {
                    DynamicObject backRecord = backRecordList.addNew();
                    backRecord.set("returnpayway", (Object)pay.getDynamicObject("setllementid"));
                    backRecord.set("hasreturnamount", (Object)pay.getBigDecimal("settleamount"));
                    backRecord.set("returntime", pay.get("paytime"));
                    backRecord.set("returncurrency", (Object)pay.getDynamicObject("settlecurrid"));
                    backRecord.set("returnactualamount", (Object)pay.getBigDecimal("stmamount"));
                    backRecord.set("returnexchangerate", (Object)pay.getBigDecimal("settlementrate"));
                    backRecord.set("returnstatus", (Object)RETURNSTATUS_CONSTS);
                    backRecord.set("returnenrtyid", pay.getPkValue());
                }
            }
        } else {
            this.getView().setVisible(Boolean.FALSE, new String[]{"payrecords"});
        }
        BigDecimal needPayAmount = saleOrder.getBigDecimal("payableamount").subtract(saleOrder.getBigDecimal("totalrealamount")).subtract(clearAmount);
        if (sourceBill != null) {
            long sourceBillId = DynamicObjectUtil.getPkValue((DynamicObject)saleOrder, (String)"sourcebillid");
            DynamicObject sourceSaleOrder = BusinessDataServiceHelper.loadSingle((Object)sourceBillId, (String)"pos_salesorder");
            BigDecimal totalAmount = saleOrder.getBigDecimal("payableamount");
            BigDecimal sourceTotalAmount = sourceSaleOrder.getBigDecimal("payableamount");
            if (DynamicObjectUtil.getBoolean((DynamicObject)saleOrder, (String)"isticketreturn") && totalAmount.abs().compareTo(sourceTotalAmount) == 0 || saleOrder.getBoolean("isredrush")) {
                BigDecimal totalPayAmount = sourceSaleOrder.getBigDecimal("totalrealamount").negate();
                needPayAmount = totalPayAmount.subtract(saleOrder.getBigDecimal("totalrealamount"));
            }
        }
        this.getModel().setValue("needpayamount", (Object)needPayAmount);
        if (isRedrush) {
            for (PaymentModeEnum paymentMode : PaymentModeEnum.values()) {
                if (this.getView().getControl(paymentMode.getPaymentType()) == null) continue;
                this.getView().setVisible(Boolean.FALSE, new String[]{paymentMode.getPaymentType()});
            }
            DynamicObjectCollection orderPayList = saleOrder.getDynamicObjectCollection("finentity");
            if (orderPayList.size() == 0) {
                this.getModel().deleteEntryData("returnpayrecords");
                this.getModel().setValue("needpayamount", (Object)BigDecimal.ZERO);
            } else {
                this.getView().setVisible(Boolean.TRUE, new String[]{"cashpay"});
            }
        }
    }

    public void afterDoOperation(AfterDoOperationEventArgs afterDoOperationEventArgs) {
        super.afterDoOperation(afterDoOperationEventArgs);
        String key = afterDoOperationEventArgs.getOperateKey();
        FormShowParameter formShowParameter = this.getView().getFormShowParameter();
        Object saleOrderId = formShowParameter.getCustomParam("Id");
        switch (key) {
            case "cashpay": {
                this.openNoElectronicPaymentPayView("pos_saleordercashpay", NO_ELECTRONIC_CLOSE);
                break;
            }
            case "paybill": {
                DynamicObjectCollection payList = this.getModel().getEntryEntity("payrecords");
                String errorMsg = this.checkBeforePayConfirm(saleOrderId, payList);
                if (StringUtils.isNotEmpty((CharSequence)errorMsg)) {
                    this.getView().showErrorNotification(errorMsg);
                    return;
                }
                SaleOrderHelper.saveNoElectricPayRecord((Object)saleOrderId, (DynamicObjectCollection)payList);
                BigDecimal payBackAmount = BigDecimal.ZERO;
                for (DynamicObject record : payList) {
                    payBackAmount = payBackAmount.add(record.getBigDecimal("paybackamount"));
                }
                if (payBackAmount.compareTo(BigDecimal.ZERO) > 0) {
                    this.getView().showConfirm(String.format("\u8fd8\u9700\u627e\u96f6%.2f\u5143\u3002", payBackAmount), MessageBoxOptions.OK);
                }
                this.getView().returnDataToParent((Object)"Success");
                this.getView().getParentView().getModel().setValue("salestatus", (Object)"S");
                this.getView().close();
                break;
            }
            case "returnpay": {
                DynamicObjectCollection returnPayList = this.getModel().getEntryEntity("returnpayrecords");
                String message = this.checkBeforeReturnPay(returnPayList);
                if (StringUtils.isNotEmpty((CharSequence)message)) {
                    this.getView().showErrorNotification(message);
                    return;
                }
                List result = SaleOrderHelper.getPayBackOperationResult((Object)saleOrderId, (DynamicObjectCollection)returnPayList);
                if (result.size() > 0) {
                    this.payBackfailureOperation(saleOrderId, returnPayList, result);
                    return;
                }
                this.getView().returnDataToParent((Object)"Success");
                this.getView().getParentView().getModel().setValue("salestatus", (Object)"S");
                this.getView().close();
                break;
            }
            case "alipay": {
                this.openPaymentPayView("pos_saleorderalipay", PAYMENTCLOSE, "alipay");
                break;
            }
            case "wechatpay": {
                this.openPaymentPayView("pos_saleorderwechatpay", PAYMENTCLOSE, "wechatpay");
                break;
            }
            case "tosettleaccounts": {
                if (this.getModel().getValue("customer") == null) {
                    this.openPaymentPayView("pos_creditpaycustomer", CREDITCLOSE, "");
                    break;
                }
                this.openNoElectronicPaymentPayView("pos_creditamount", NO_ELECTRONIC_CLOSE);
                break;
            }
            default: {
                this.getView().showMessage("\u5f53\u524d\u652f\u4ed8\u65b9\u5f0f\u6b63\u5728\u5f00\u53d1\u4e2d");
            }
        }
    }

    private void payBackfailureOperation(Object saleOrderId, DynamicObjectCollection returnPayList, List<PaymentRecord> result) {
        this.getModel().deleteEntryData("returnpayrecords");
        DynamicObject saveOrder = BusinessDataServiceHelper.loadSingle((Object)saleOrderId, (String)"pos_salesorder");
        DynamicObjectCollection savePayList = saveOrder.getDynamicObjectCollection("finentity");
        for (DynamicObject record : savePayList) {
            DynamicObject successRecord = returnPayList.addNew();
            successRecord.set("returnpayway", (Object)record.getDynamicObject("setllementid"));
            successRecord.set("hasreturnamount", (Object)record.getBigDecimal("settleamount"));
            successRecord.set("returntime", record.get("paytime"));
            successRecord.set("returnstatus", (Object)RETURNSTATUS_CONSTS);
            successRecord.set("returnexchangerate", (Object)record.getBigDecimal("settlementrate"));
            successRecord.set("returnactualamount", (Object)record.getBigDecimal("stmamount"));
            successRecord.set("returncurrency", (Object)record.getDynamicObject("settlecurrid"));
            successRecord.set("returnenrtyid", record.getPkValue());
        }
        BigDecimal needPayAmount = BigDecimal.ZERO;
        for (PaymentRecord record : result) {
            DynamicObject failureRecord = returnPayList.addNew();
            failureRecord.set("returnpayway", (Object)record.getPayWay());
            failureRecord.set("hasreturnamount", (Object)record.getAmount());
            failureRecord.set("returntime", (Object)record.getPaytime());
            failureRecord.set("returnstatus", (Object)record.getPayStatus());
            failureRecord.set("returncurrency", (Object)record.getPayCurrency());
            needPayAmount = needPayAmount.add(record.getAmount());
        }
        this.getView().updateView("returnpayrecords");
        this.getModel().setValue("needpayamount", (Object)needPayAmount);
        this.getView().setVisible(Boolean.TRUE, new String[]{"cashpay"});
    }

    private String checkBeforePayConfirm(Object saleOrderId, DynamicObjectCollection payList) {
        DynamicObject saleOrder = BusinessDataServiceHelper.loadSingle((Object)saleOrderId, (String)"pos_salesorder");
        String mergeBillType = saleOrder.getString("ismergebill");
        String bizType = saleOrder.getString("biztype");
        BigDecimal stillneedtopay = saleOrder.getBigDecimal("stillneedtopay");
        if (!("0".equalsIgnoreCase(mergeBillType) || bizType.equalsIgnoreCase("C") && stillneedtopay.compareTo(BigDecimal.ZERO) == 0 || payList.size() != 0)) {
            return "\u8bf7\u9009\u62e9\u4e00\u79cd\u652f\u4ed8\u65b9\u5f0f\u5e76\u652f\u4ed8\u3002";
        }
        BigDecimal needPayAmount = new BigDecimal(this.getModel().getValue("needpayamount").toString());
        if (needPayAmount.compareTo(BigDecimal.ZERO) != 0) {
            return "\u4ed8\u6b3e\u91d1\u989d\u4e0d\u8db3\uff0c\u65e0\u6cd5\u7ed3\u7b97\u3002";
        }
        return "";
    }

    private String checkBeforeReturnPay(DynamicObjectCollection returnPayList) {
        BigDecimal needPayAmount = new BigDecimal(this.getModel().getValue("needpayamount").toString());
        if (needPayAmount.compareTo(BigDecimal.ZERO) != 0) {
            return "\u9000\u6b3e\u91d1\u989d\u4e0d\u8db3\uff0c\u65e0\u6cd5\u7ed3\u7b97\u3002";
        }
        return null;
    }

    private void openPaymentPayView(String paymentform, String closeCallBack, String payWayKey) {
        FormShowParameter formShowParameter = this.getView().getFormShowParameter();
        FormShowParameter parameter = new FormShowParameter();
        parameter.setFormId(paymentform);
        Object saleOrderId = formShowParameter.getCustomParam("Id");
        DynamicObject saleOrder = BusinessDataServiceHelper.loadSingle((Object)saleOrderId, (String)"pos_salesorder");
        String orderType = saleOrder.getString("biztype");
        String payOrRefundRecoreds = "payrecords";
        String payOrRefundAmount = "actualamount";
        String payOrRefundWay = "payway";
        if ("B".equalsIgnoreCase(orderType)) {
            payOrRefundRecoreds = "returnpayrecords";
            payOrRefundAmount = "returnactualamount";
            payOrRefundWay = "returnpayway";
        }
        DynamicObjectCollection payOrRefundList = this.getModel().getEntryEntity(payOrRefundRecoreds);
        BigDecimal hasPayAmount = BigDecimal.ZERO;
        if (payOrRefundList.size() > 0) {
            DynamicObject payWay = new DynamicObject();
            for (DynamicObject record : payOrRefundList) {
                payWay = record.getDynamicObject(payOrRefundWay);
                if (!PaymentModeEnum.getNoElectricPayList().contains(CommonUtil.formatObejctToLong((Object)payWay.getPkValue()))) continue;
                hasPayAmount = hasPayAmount.add(record.getBigDecimal(payOrRefundAmount));
            }
        }
        parameter.setCustomParam("hasPayAmount", (Object)hasPayAmount);
        parameter.setCustomParam("payWayKey", (Object)payWayKey);
        parameter.setCustomParam("Id", formShowParameter.getCustomParam("Id"));
        parameter.getOpenStyle().setShowType(ShowType.Modal);
        parameter.setCloseCallBack(new CloseCallBack((IFormPlugin)this, closeCallBack));
        this.getView().showForm(parameter);
    }

    private void openNoElectronicPaymentPayView(String paymentform, String closeCallBack) {
        FormShowParameter formShowParameter = this.getView().getFormShowParameter();
        Object saleOrderId = formShowParameter.getCustomParam("Id");
        DynamicObject saleOrder = BusinessDataServiceHelper.loadSingle((Object)saleOrderId, (String)"pos_salesorder");
        String orderType = saleOrder.getString("biztype");
        HashMap<String, BigDecimal> recordMap = new HashMap<String, BigDecimal>();
        DynamicObject payWay = new DynamicObject();
        DynamicObject payCurrency = new DynamicObject();
        if ("B".equalsIgnoreCase(orderType)) {
            DynamicObjectCollection payReturnList = this.getModel().getEntryEntity("returnpayrecords");
            if (payReturnList.size() > 0) {
                for (DynamicObject record : payReturnList) {
                    payWay = record.getDynamicObject("returnpayway");
                    payCurrency = record.getDynamicObject("returncurrency");
                    if (!PaymentModeEnum.getNoElectricPayList().contains(CommonUtil.formatObejctToLong((Object)payWay.getPkValue())) || record.getLong("returnenrtyid") != 0L) continue;
                    recordMap.put(payWay.getPkValue() + "_" + payCurrency.getPkValue(), record.getBigDecimal("returnactualamount"));
                }
            }
        } else {
            DynamicObjectCollection payList = this.getModel().getEntryEntity("payrecords");
            if (payList.size() > 0) {
                for (DynamicObject record : payList) {
                    payWay = record.getDynamicObject("payway");
                    payCurrency = record.getDynamicObject("paycurrency");
                    if (!PaymentModeEnum.getNoElectricPayList().contains(CommonUtil.formatObejctToLong((Object)payWay.getPkValue()))) continue;
                    recordMap.put(payWay.getPkValue() + "_" + payCurrency.getPkValue(), record.getBigDecimal("actualamount"));
                }
            }
        }
        FormShowParameter parameter = new FormShowParameter();
        parameter.setFormId(paymentform);
        parameter.setCustomParam("recordStr", (Object)JsonUtil.toJson(recordMap));
        parameter.setCustomParam("needpayamount", this.getModel().getValue("needpayamount"));
        parameter.setCustomParam("Id", saleOrderId);
        parameter.getOpenStyle().setShowType(ShowType.Modal);
        parameter.setCloseCallBack(new CloseCallBack((IFormPlugin)this, closeCallBack));
        this.getView().showForm(parameter);
    }

    public void beforeClosed(BeforeClosedEvent e) {
        block5: {
            super.beforeClosed(e);
            Object saleStatus = this.getView().getParentView().getModel().getValue("salestatus");
            if (!KEY_SALE_STATUS.equals(saleStatus)) break block5;
            String bizType = this.getView().getParentView().getModel().getValue("biztype").toString();
            if (BizTypeEnum.SALERETURN.getValue().equals(bizType)) {
                DynamicObjectCollection returnPayRecords = this.getModel().getEntryEntity("returnpayrecords");
                if (returnPayRecords == null || returnPayRecords.isEmpty()) {
                    return;
                }
                for (DynamicObject doReturnPayRecord : returnPayRecords) {
                    String returnStatus;
                    DynamicObject doPayWay = doReturnPayRecord.getDynamicObject("returnpayway");
                    if (PaymentModeEnum.getNoElectricPayList().contains(CommonUtil.formatObejctToLong((Object)doPayWay.getPkValue())) || !RETURNSTATUS_CONSTS.equals(returnStatus = doReturnPayRecord.getString("returnstatus"))) continue;
                    e.setCancel(true);
                    this.getView().showMessage("\u7535\u5b50\u652f\u4ed8\u5df2\u9000\u6b3e\u6210\u529f\uff0c\u4e0d\u5141\u8bb8\u5173\u95ed");
                    break;
                }
            } else {
                DynamicObjectCollection docPayRecords = this.getView().getModel().getEntryEntity("payrecords");
                for (DynamicObject doPayRecord : docPayRecords) {
                    DynamicObject doPayWay = doPayRecord.getDynamicObject("payway");
                    if (PaymentModeEnum.getNoElectricPayList().contains(CommonUtil.formatObejctToLong((Object)doPayWay.getPkValue()))) continue;
                    e.setCancel(true);
                    this.getView().showMessage("\u5b58\u5728\u7535\u5b50\u652f\u4ed8\uff0c\u4e0d\u5141\u8bb8\u5173\u95ed");
                    break;
                }
            }
        }
    }

    public void closedCallBack(ClosedCallBackEvent closedCallBackEvent) {
        super.closedCallBack(closedCallBackEvent);
        if (closedCallBackEvent.getReturnData() == null) {
            return;
        }
        HashMap data = (HashMap)closedCallBackEvent.getReturnData();
        BigDecimal showNeedAmount = new BigDecimal(this.getModel().getValue("needpayamount").toString());
        FormShowParameter formShowParameter = this.getView().getFormShowParameter();
        Object saleOrderId = formShowParameter.getCustomParam("Id");
        DynamicObject saleOrder = BusinessDataServiceHelper.loadSingle((Object)saleOrderId, (String)"pos_salesorder");
        String orderType = saleOrder.getString("biztype");
        switch (closedCallBackEvent.getActionId()) {
            case "paymentclose": {
                if ("B".equalsIgnoreCase(orderType)) {
                    int index = this.getModel().createNewEntryRow("returnpayrecords");
                    this.payBackClosedBack(data, showNeedAmount, index);
                    break;
                }
                int index = this.getModel().createNewEntryRow("payrecords");
                this.closedCallBack((Map<String, Object>)data, showNeedAmount, index);
                break;
            }
            case "noelectronicclose": {
                if ("B".equalsIgnoreCase(orderType)) {
                    DynamicObjectCollection payBackList = this.getView().getModel().getDataEntity(true).getDynamicObjectCollection("returnpayrecords");
                    if (payBackList.size() == 0) {
                        int index = this.getModel().createNewEntryRow("returnpayrecords");
                        this.payBackClosedBack(data, showNeedAmount, index);
                        break;
                    }
                    this.refreshPayBackRecord(data, payBackList, showNeedAmount);
                    break;
                }
                DynamicObjectCollection payList = this.getView().getModel().getDataEntity(true).getDynamicObjectCollection("payrecords");
                if (payList.size() == 0) {
                    this.addPaymentRecordEntry(data);
                    break;
                }
                this.closedCallBack((Map<String, Object>)data, payList, showNeedAmount);
                break;
            }
            case "creditclose": {
                if (data.size() <= 0) break;
                this.setValue("customer", data.get("customer"));
                break;
            }
        }
    }

    private void refreshPayBackRecord(Map<String, Object> data, DynamicObjectCollection payBackList, BigDecimal showNeedAmount) {
        if (data.size() == 0) {
            return;
        }
        String currentkey = data.get("payway") + "_" + data.get("paycurrency");
        boolean addNew = true;
        for (int i = 0; i < payBackList.size(); ++i) {
            DynamicObject payWay = ((DynamicObject)payBackList.get(i)).getDynamicObject("returnpayway");
            DynamicObject payCurrency = ((DynamicObject)payBackList.get(i)).getDynamicObject("returncurrency");
            String recordKey = payWay.getPkValue() + "_" + payCurrency.getPkValue();
            if (!currentkey.equalsIgnoreCase(recordKey) || !StringUtil.isEmpty((CharSequence)((DynamicObject)payBackList.get(i)).getString("returnenrtyid"))) continue;
            addNew = false;
            this.getModel().setValue("needpayamount", (Object)showNeedAmount.add(((DynamicObject)payBackList.get(i)).getBigDecimal("returnactualamount")).subtract(CommonUtil.formatObjectToDecimal((Object)data.get("actualamount"))));
            ((DynamicObject)payBackList.get(i)).set("returnactualamount", data.get("actualamount"));
            ((DynamicObject)payBackList.get(i)).set("hasreturnamount", data.get("showamount"));
            ((DynamicObject)payBackList.get(i)).set("returntime", data.get("paytime"));
            ((DynamicObject)payBackList.get(i)).set("returnstatus", (Object)RETURNSTATUS_CONSTS);
            this.getView().updateView("returnpayrecords", i);
            break;
        }
        if (addNew) {
            this.payBackClosedBack(data, showNeedAmount, this.getModel().createNewEntryRow("returnpayrecords"));
        }
    }

    private void payBackClosedBack(Map<String, Object> data, BigDecimal showNeedAmount, int index) {
        BigDecimal actualAmount = BigDecimal.ZERO;
        if (data.size() > 0) {
            this.setValue("returnpayway", data.get("payway"), index);
            this.setValue("returntime", data.get("paytime"), index);
            this.setValue("hasreturnamount", data.get("showamount"), index);
            this.setValue("returncurrency", data.get("paycurrency"), index);
            actualAmount = CommonUtil.formatObjectToDecimal((Object)data.get("actualamount"));
            this.setValue("returnactualamount", actualAmount, index);
            this.setValue("returnexchangerate", data.get("exchangerate"), index);
            this.setValue("returnstatus", RETURNSTATUS_CONSTS, index);
        }
        this.getModel().setValue("needpayamount", (Object)showNeedAmount.subtract(actualAmount));
    }

    private void addPaymentRecordEntry(Map<String, Object> data) {
        int index = this.getModel().createNewEntryRow("payrecords");
        BigDecimal showNeedAmount = new BigDecimal(this.getModel().getValue("needpayamount").toString());
        this.setValue("payway", data.get("payway"), index);
        this.setValue("paytime", data.get("paytime"), index);
        this.setValue("showamount", data.get("showamount"), index);
        this.setValue("paycurrency", data.get("paycurrency"), index);
        BigDecimal actualAmount = CommonUtil.formatObjectToDecimal((Object)data.get("actualamount"));
        this.setValue("actualamount", actualAmount, index);
        this.setValue("paybackamount", data.get("paybackamount"), index);
        this.setValue("exchangerate", data.get("exchangerate"), index);
        this.getModel().setValue("needpayamount", (Object)showNeedAmount.subtract(actualAmount));
        this.addWipeRecordEntry(CommonUtil.formatObjectToDecimal((Object)data.get("wipeamount")));
    }

    private void setPaymentButtonVisible() {
        List paymentModelList = CommonUtils.getPaymentModeList();
        if (paymentModelList.size() == 0) {
            for (PaymentModeEnum paymentMode : PaymentModeEnum.values()) {
                if (this.getView().getControl(paymentMode.getPaymentType()) == null) continue;
                this.getView().setVisible(Boolean.FALSE, new String[]{paymentMode.getPaymentType()});
            }
        } else {
            String paymentModel = "";
            for (DynamicObject paymentMode : paymentModelList) {
                paymentModel = PaymentModeEnum.getName((long)paymentMode.getLong("id"));
                if (!StringUtil.isNotEmpty((CharSequence)paymentModel) || paymentMode.getBoolean("enable")) continue;
                this.getView().setVisible(Boolean.FALSE, new String[]{paymentModel});
            }
        }
    }

    private void closedCallBack(Map<String, Object> data, BigDecimal showNeedAmount, int index) {
        BigDecimal actualAmount = BigDecimal.ZERO;
        BigDecimal wipeAmount = BigDecimal.ZERO;
        BigDecimal addAmount = BigDecimal.ZERO;
        if (data.size() > 0) {
            this.setValue("payway", data.get("payway"), index);
            this.setValue("paytime", data.get("paytime"), index);
            this.setValue("showamount", data.get("showamount"), index);
            this.setValue("paycurrency", data.get("paycurrency"), index);
            actualAmount = CommonUtil.formatObjectToDecimal((Object)data.get("actualamount"));
            this.setValue("actualamount", actualAmount, index);
            this.setValue("paybackamount", data.get("paybackamount"), index);
            this.setValue("exchangerate", data.get("exchangerate"), index);
            wipeAmount = CommonUtil.formatObjectToDecimal((Object)data.get("wipeamount"));
            if (wipeAmount.abs().compareTo(BigDecimal.ZERO) > 0) {
                DynamicObjectCollection payList = this.getView().getModel().getDataEntity(true).getDynamicObjectCollection("payrecords");
                for (int i = 0; i < payList.size(); ++i) {
                    DynamicObject payWay = ((DynamicObject)payList.get(i)).getDynamicObject("payway");
                    if (CommonUtil.formatObejctToLong((Object)payWay.getPkValue()) != PaymentModeEnum.getKey((String)"clearprice")) continue;
                    addAmount = ((DynamicObject)payList.get(i)).getBigDecimal("actualamount");
                    this.getModel().deleteEntryRow("payrecords", i);
                    this.getView().updateView("payrecords");
                    break;
                }
                index = this.getModel().createNewEntryRow("payrecords");
                this.setValue("payway", PaymentModeEnum.getKey((String)"clearprice"), index);
                this.setValue("paytime", TimeServiceHelper.now(), index);
                this.setValue("showamount", wipeAmount, index);
                DynamicObject currency = (DynamicObject)this.getModel().getValue("currency");
                this.setValue("paycurrency", currency.getPkValue(), index);
                this.setValue("actualamount", wipeAmount, index);
                this.setValue("paybackamount", BigDecimal.ZERO, index);
                this.setValue("exchangerate", BigDecimal.ONE, index);
            }
        }
        actualAmount = actualAmount.add(wipeAmount);
        this.getModel().setValue("needpayamount", (Object)showNeedAmount.add(addAmount).subtract(actualAmount));
    }

    private void closedCallBack(Map<String, Object> data, DynamicObjectCollection payList, BigDecimal showNeedAmount) {
        DynamicObject payWay;
        int i;
        if (data == null || data.size() == 0) {
            return;
        }
        String currentkey = data.get("payway") + "_" + data.get("paycurrency");
        boolean addNew = true;
        BigDecimal addAmount = BigDecimal.ZERO;
        for (i = 0; i < payList.size(); ++i) {
            payWay = ((DynamicObject)payList.get(i)).getDynamicObject("payway");
            if (CommonUtil.formatObejctToLong((Object)payWay.getPkValue()) != PaymentModeEnum.getKey((String)"clearprice")) continue;
            addAmount = ((DynamicObject)payList.get(i)).getBigDecimal("actualamount");
            this.getModel().deleteEntryRow("payrecords", i);
            this.getView().updateView("payrecords");
            break;
        }
        for (i = 0; i < payList.size(); ++i) {
            payWay = ((DynamicObject)payList.get(i)).getDynamicObject("payway");
            DynamicObject payCurrency = ((DynamicObject)payList.get(i)).getDynamicObject("paycurrency");
            String recordKey = payWay.getPkValue() + "_" + payCurrency.getPkValue();
            if (!currentkey.equalsIgnoreCase(recordKey)) continue;
            addNew = false;
            this.getModel().setValue("needpayamount", (Object)showNeedAmount.add(((DynamicObject)payList.get(i)).getBigDecimal("actualamount")).subtract(CommonUtil.formatObjectToDecimal((Object)data.get("actualamount"))));
            ((DynamicObject)payList.get(i)).set("paybackamount", data.get("paybackamount"));
            ((DynamicObject)payList.get(i)).set("actualamount", data.get("actualamount"));
            ((DynamicObject)payList.get(i)).set("showamount", data.get("showamount"));
            ((DynamicObject)payList.get(i)).set("paytime", data.get("paytime"));
            this.getView().updateView("payrecords", i);
            break;
        }
        this.getModel().setValue("needpayamount", (Object)CommonUtil.formatObjectToDecimal((Object)this.getModel().getValue("needpayamount")).add(addAmount));
        if (addNew) {
            this.addPaymentRecordEntry(data);
        } else {
            this.addWipeRecordEntry(CommonUtil.formatObjectToDecimal((Object)data.get("wipeamount")));
        }
    }

    private void addWipeRecordEntry(BigDecimal wipeAmount) {
        if (wipeAmount.abs().compareTo(BigDecimal.ZERO) > 0) {
            int index = this.getModel().createNewEntryRow("payrecords");
            this.setValue("payway", PaymentModeEnum.getKey((String)"clearprice"), index);
            this.setValue("paytime", TimeServiceHelper.now(), index);
            this.setValue("showamount", wipeAmount, index);
            DynamicObject currency = (DynamicObject)this.getModel().getValue("currency");
            this.setValue("paycurrency", currency.getPkValue(), index);
            this.setValue("actualamount", wipeAmount, index);
            this.setValue("paybackamount", BigDecimal.ZERO, index);
            this.setValue("exchangerate", BigDecimal.ONE, index);
        }
        this.getModel().setValue("needpayamount", (Object)CommonUtil.formatObjectToDecimal((Object)this.getModel().getValue("needpayamount")).subtract(wipeAmount));
    }
}

