/*
 * Decompiled with CFR 0.152.
 */
package kd.drp.pos.formplugin.saleorder.edit;

import java.math.BigDecimal;
import java.util.Arrays;
import java.util.Date;
import java.util.EventObject;
import java.util.Map;
import kd.bos.bill.AbstractBillPlugIn;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.RowDataEntity;
import kd.bos.entity.datamodel.events.AfterAddRowEventArgs;
import kd.bos.entity.datamodel.events.AfterDeleteRowEventArgs;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.form.CloseCallBack;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.ShowType;
import kd.bos.form.control.events.RowClickEventListener;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.events.ClientCallBackEvent;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.field.TextEdit;
import kd.bos.form.operate.FormOperate;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.DispatchServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.TimeServiceHelper;
import kd.bos.servicehelper.operation.OperationServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.drp.dbd.business.handle.GetDistributionRulesHelper;
import kd.drp.dbd.common.util.DynamicObjectUtils;
import kd.drp.dpm.common.model.condition.PricePolicyCondition;
import kd.drp.dpm.common.model.result.PricePolicyResult;
import kd.drp.dpm.common.model.result.ResultMessage;
import kd.drp.ocic.business.helper.UnitConvertHelper;
import kd.drp.pos.business.commonhelper.CurrencyHelper;
import kd.drp.pos.business.saleorder.SaleOrderHelper;
import kd.drp.pos.business.systemparam.SystemParamHelper;
import kd.drp.pos.common.CommonUtils;
import kd.drp.pos.common.OwnerUtils;
import kd.drp.pos.common.saleorder.BizTypeEnum;
import kd.drp.pos.common.saleorder.CloseStatusEnum;
import kd.drp.pos.common.util.CommonUtil;
import kd.drp.pos.common.util.DynamicObjectUtil;
import kd.drp.pos.common.util.F7Util;
import kd.drp.pos.common.util.FormViewUtil;
import kd.drp.pos.common.util.JsonUtil;
import kd.drp.pos.common.util.PermissionUtil;

public class GoodsDetailEditPlugin
extends AbstractBillPlugIn
implements RowClickEventListener {
    private boolean fromBarcode = false;
    private boolean isReset = false;
    private static final String KEY_FILLSRCBILLDATA = "fillSrcBillData";
    private static final String KEY_ENABLESERIAL = "enableserial";
    private Log logger = LogFactory.getLog(GoodsDetailEditPlugin.class);
    private static String[] entryFieldEdit = new String[]{"goodsid", "barcode", "saleqty", "unit", "discountrate", "discountprice", "retailprice", "deposit", "stockid", "distributionmode", "erpstock", "inventoryorg"};
    private static String[] headFieldEdit = new String[]{"sourcebillid", "isticketreturn", "biztype", "isredrush", "saler", "salebranchid", "admindivisionid"};
    private static final String OP_REFRESH = "refresh";
    private static final String OP_SETTLE = "settle";
    private static final String OP_SAVE = "save";
    private static final String BTN_CALLBACKACTIONID = "btreceivables";
    private static final String KEY_PUSHBILLANDCREATEINVOICE = "pushBillAndCreateInvoice";
    private static final String PERM_SETTLEMENT = "0RYLT/3JS76I";

    public void propertyChanged(PropertyChangedArgs e) {
        super.propertyChanged(e);
        String key = e.getProperty().getName();
        if (e.getChangeSet() == null || e.getChangeSet().length <= 0) {
            return;
        }
        if (Arrays.asList(headFieldEdit).contains(key)) {
            this.headFieldPropertyChanged(e, key);
        } else if (Arrays.asList(entryFieldEdit).contains(key)) {
            this.entryFieldPropertyChanged(e, key);
        }
    }

    public void afterBindData(EventObject e) {
        super.afterBindData(e);
        this.getView().setEnable(Boolean.TRUE, new String[]{"salebranchid"});
        this.getView().setEnable(Boolean.TRUE, new String[]{"biztype"});
        String bizType = CommonUtil.formatStringToEmpty((Object)this.getView().getModel().getValue("biztype"));
        this.setCtrPropForReturn(bizType);
    }

    public void afterAddRow(AfterAddRowEventArgs e) {
        super.afterAddRow(e);
        String entryName = e.getEntryProp().getName();
        if (StringUtils.equals((CharSequence)entryName, (CharSequence)"goodsentryentity")) {
            DynamicObject branch = (DynamicObject)this.getView().getModel().getValue("salebranchid");
            DynamicObject saler = (DynamicObject)this.getView().getModel().getValue("saler");
            DynamicObject org = (DynamicObject)this.getView().getModel().getValue("bizorgid");
            RowDataEntity[] rowEntities = e.getRowDataEntities();
            long salerId = DynamicObjectUtil.getPkValue((DynamicObject)saler);
            long branchId = DynamicObjectUtil.getPkValue((DynamicObject)branch);
            long orgId = DynamicObjectUtil.getPkValue((DynamicObject)org);
            int index = 0;
            String bizType = this.getView().getModel().getValue("biztype").toString();
            for (RowDataEntity rowEntry : rowEntities) {
                index = rowEntry.getRowIndex();
                this.getView().getModel().setValue("goodssaler", (Object)salerId, index);
                String inventoryUpdate = DynamicObjectUtil.getString((DynamicObject)rowEntry.getDataEntity(), (String)"inventoryupdate");
                if (StringUtils.equals((CharSequence)inventoryUpdate, (CharSequence)"B")) {
                    this.getView().getModel().setValue("keeperid", (Object)branchId, index);
                    this.getView().getModel().setValue("ownerid", (Object)branchId, index);
                }
                if (!StringUtils.equals((CharSequence)bizType, (CharSequence)BizTypeEnum.SALERETURN.getValue())) continue;
                this.getView().getModel().setValue("channelstockstatusid", (Object)SystemParamHelper.getInvStatus((long)orgId), index);
            }
        }
    }

    public void afterDeleteRow(AfterDeleteRowEventArgs e) {
        super.afterDeleteRow(e);
        String entryName = e.getEntryProp().getName();
        if (StringUtils.equals((CharSequence)entryName, (CharSequence)"goodsentryentity")) {
            this.updateBaseInfoAmount();
        }
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs e) {
        long orgId;
        Map currencyAndExRateMap;
        DynamicObject saleOrder;
        FormOperate op = (FormOperate)e.getSource();
        if ((StringUtils.equals((CharSequence)OP_SETTLE, (CharSequence)op.getOperateKey()) || StringUtils.equals((CharSequence)OP_SAVE, (CharSequence)op.getOperateKey())) && (saleOrder = this.getView().getModel().getDataEntity()) != null && (saleOrder.getDynamicObject("exratetable") == null || saleOrder.getBigDecimal("financeexchangerate").compareTo(BigDecimal.ZERO) == 0) && (currencyAndExRateMap = CurrencyHelper.getCurrencyAndExRateTable((Long)(orgId = DynamicObjectUtil.getPkValue((DynamicObject)saleOrder, (String)"bizorgid")))) != null) {
            long baseCurrencyId = (Long)currencyAndExRateMap.get("baseCurrencyID");
            long exchangeRateTableId = (Long)currencyAndExRateMap.get("exchangeRateTableID");
            this.getModel().setValue("locurrencyid", (Object)baseCurrencyId);
            this.getModel().setValue("exratetable", (Object)exchangeRateTableId);
            DynamicObject currency = (DynamicObject)this.getModel().getValue("currencyid");
            BigDecimal rate = CurrencyHelper.getExChangeRate((Long)Long.parseLong(currency.getPkValue().toString()), (Long)baseCurrencyId, (Long)exchangeRateTableId, (Date)new Date());
            this.getModel().setValue("financeexchangerate", (Object)rate);
        }
        if (StringUtils.equals((CharSequence)OP_SETTLE, (CharSequence)op.getOperateKey()) && !PermissionUtil.checkPermission((String)"pos", (String)"pos_salesorder", (String)PERM_SETTLEMENT)) {
            this.getView().showTipNotification("\u5f53\u524d\u8d26\u53f7\u65e0\u7ed3\u7b97\u6743\u9650\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458\u6388\u6743\u3002");
            e.setCancel(true);
        }
    }

    public void afterDoOperation(AfterDoOperationEventArgs e) {
        FormOperate op = (FormOperate)e.getSource();
        if (StringUtils.equals((CharSequence)OP_SETTLE, (CharSequence)op.getOperateKey()) && e.getOperationResult() != null && e.getOperationResult().isSuccess()) {
            DynamicObject billData = this.getView().getModel().getDataEntity();
            OperationResult result = OperationServiceHelper.executeOperate((String)OP_SAVE, (String)"pos_salesorder", (DynamicObject[])new DynamicObject[]{billData}, (OperateOption)OperateOption.create());
            if (result != null && result.isSuccess()) {
                this.getView().setEnable(Boolean.FALSE, new String[]{"biztype"});
                this.openSaleOrderPayWindow();
            } else {
                this.getView().showOperationResult(result);
            }
        } else if (StringUtils.equals((CharSequence)OP_SAVE, (CharSequence)op.getOperateKey()) && e.getOperationResult() != null && e.getOperationResult().isSuccess()) {
            this.getView().setEnable(Boolean.FALSE, new String[]{"biztype"});
        }
    }

    public void clientCallBack(ClientCallBackEvent e) {
        super.clientCallBack(e);
        if (StringUtils.equals((CharSequence)KEY_FILLSRCBILLDATA, (CharSequence)e.getName())) {
            DynamicObject dbSourceBill = (DynamicObject)this.getView().getModel().getValue("sourcebillid");
            this.fillCurrentInfoFromSourceBill(dbSourceBill);
            this.updateBaseInfoAmount();
        }
    }

    public void closedCallBack(ClosedCallBackEvent cvt) {
        super.closedCallBack(cvt);
        String actionId = cvt.getActionId();
        if (BTN_CALLBACKACTIONID.equals(actionId)) {
            String returnData = CommonUtil.formatStringToEmpty((Object)cvt.getReturnData());
            DynamicObject user = BusinessDataServiceHelper.loadSingle((Object)RequestContext.get().getUserId(), (String)"bos_user");
            DynamicObject saleOrder = this.getView().getModel().getDataEntity(true);
            if (StringUtils.equals((CharSequence)returnData, (CharSequence)"Success")) {
                saleOrder.set("saleendtime", (Object)TimeServiceHelper.now());
                saleOrder.set("modifier", (Object)user);
                saleOrder.set("modifytime", (Object)TimeServiceHelper.now());
                saleOrder.set("salestatus", (Object)"S");
                SaveServiceHelper.update((DynamicObject)saleOrder);
                this.getView().invokeOperation(OP_REFRESH);
                this.getView().addClientCallBack(KEY_PUSHBILLANDCREATEINVOICE, Integer.valueOf(100));
            } else {
                saleOrder.set("modifier", (Object)user);
                saleOrder.set("modifytime", (Object)TimeServiceHelper.now());
                SaveServiceHelper.update((DynamicObject)saleOrder);
                this.getView().invokeOperation(OP_REFRESH);
            }
        }
    }

    private String checkSaleQty(BigDecimal newValue, int index) {
        String bizType = this.getView().getModel().getValue("biztype").toString();
        BigDecimal mustRetQty = (BigDecimal)this.getView().getModel().getValue("mustretqty", index);
        String tip = null;
        switch (bizType) {
            case "A": {
                if (newValue.compareTo(BigDecimal.ZERO) > 0) break;
                tip = "\u9500\u552e\u6570\u91cf\u5fc5\u987b\u5927\u4e8e0\u3002";
                break;
            }
            case "B": {
                if (newValue.compareTo(BigDecimal.ZERO) >= 0) {
                    tip = "\u9000\u8d27\u6570\u91cf\u5fc5\u987b\u5c0f\u4e8e0\u3002";
                    break;
                }
                if (mustRetQty.compareTo(BigDecimal.ZERO) <= 0 || newValue.abs().compareTo(mustRetQty) <= 0) break;
                String strMustQty = mustRetQty.stripTrailingZeros().toPlainString();
                tip = String.format("\u9000\u8d27\u6570\u91cf\u5e94\u4e3a\u8d1f\u6570, \u4e14\u6700\u591a\u53ef\u9000%s\u3002", strMustQty);
                break;
            }
            case "C": {
                if (newValue.compareTo(BigDecimal.ZERO) <= 0) {
                    tip = "\u8f6c\u9500\u6570\u91cf\u5fc5\u987b\u5927\u4e8e0\u3002";
                    break;
                }
                if (mustRetQty.compareTo(BigDecimal.ZERO) <= 0 || newValue.abs().compareTo(mustRetQty) <= 0) break;
                String strMustQty = mustRetQty.stripTrailingZeros().toPlainString();
                tip = String.format("\u8f6c\u9500\u6570\u91cf\u5e94\u4e3a\u6b63\u6570, \u4e14\u6700\u591a\u53ef\u8f6c\u9500%s\u3002", strMustQty);
                break;
            }
            case "D": {
                if (newValue.compareTo(BigDecimal.ZERO) > 0) break;
                tip = "\u9500\u552e\u6570\u91cf\u5fc5\u987b\u5927\u4e8e0\u3002";
                break;
            }
        }
        return tip;
    }

    private void updateSaleQty(PropertyChangedArgs e) {
        int rowIndex = e.getChangeSet()[0].getRowIndex();
        BigDecimal saleQty = CommonUtil.formatObjectToDecimal((Object)e.getChangeSet()[0].getNewValue());
        BigDecimal oldValue = CommonUtil.formatObjectToDecimal((Object)e.getChangeSet()[0].getOldValue());
        String tip = this.checkSaleQty(saleQty, rowIndex);
        if (!StringUtils.isBlank((CharSequence)tip)) {
            this.getView().showTipNotification(tip);
            this.isReset = true;
            BigDecimal discountPrice = CommonUtil.formatObjectToDecimal((Object)this.getModel().getValue("discountprice", rowIndex));
            BigDecimal depositPrice = CommonUtil.formatObjectToDecimal((Object)this.getModel().getValue("depositprice", rowIndex));
            BigDecimal retailPrice = CommonUtil.formatObjectToDecimal((Object)this.getModel().getValue("retailprice", rowIndex));
            BigDecimal balAmount = oldValue.multiply(discountPrice);
            BigDecimal deposit = oldValue.multiply(depositPrice);
            this.updateValue("amount", oldValue.multiply(retailPrice), rowIndex);
            this.updateValue("balamount", balAmount, rowIndex);
            this.updateValue("deposit", deposit, rowIndex);
            this.updateValue("saleqty", oldValue, rowIndex);
            this.updateBaseInfoAmount();
            return;
        }
        if (!this.isReset) {
            BigDecimal realPrice = CommonUtil.formatObjectToDecimal((Object)this.getModel().getValue("realprice", rowIndex));
            this.updateValue("realamount", saleQty.multiply(realPrice), rowIndex);
            this.updateMultiQuantities(saleQty, rowIndex);
            this.updateBaseInfoAmount();
            this.isReset = false;
        }
    }

    private void updateUnit(PropertyChangedArgs e) {
        int rowIndex = e.getChangeSet()[0].getRowIndex();
        DynamicObject unit = (DynamicObject)e.getChangeSet()[0].getNewValue();
        if (unit != null) {
            BigDecimal baseUnitQty = (BigDecimal)this.getView().getModel().getValue("baseunitqty", rowIndex);
            if (baseUnitQty.compareTo(BigDecimal.ZERO) != 0) {
                this.updateMultiQuantities(unit, rowIndex);
            } else {
                BigDecimal saleQty = (BigDecimal)this.getView().getModel().getValue("saleqty", rowIndex);
                if (saleQty.compareTo(BigDecimal.ZERO) != 0) {
                    this.updateMultiQuantities(saleQty, rowIndex);
                }
            }
            this.updateBaseInfoAmount();
        }
    }

    private void updateDeposit(PropertyChangedArgs e) {
        BigDecimal deposit = CommonUtil.formatObjectToDecimal((Object)e.getChangeSet()[0].getNewValue());
        String bizType = CommonUtil.formatStringToEmpty((Object)this.getView().getModel().getValue("biztype"));
        boolean isReturn = CommonUtil.formatObjectToBoolean((Object)this.getView().getModel().getValue("isticketreturn"));
        if (StringUtils.equals((CharSequence)bizType, (CharSequence)BizTypeEnum.SALERETURN.getValue()) && !isReturn && deposit.compareTo(BigDecimal.ZERO) > 0) {
            this.getView().showTipNotification("\u65e0\u6e90\u5355\u9000\u8d27\uff0c\u8ba2\u91d1\u4e0d\u80fd\u5927\u4e8e0\u3002");
            this.updateValue("deposit", BigDecimal.ZERO, e.getChangeSet()[0].getRowIndex());
        } else {
            this.updateBaseInfoAmount();
        }
    }

    private void updateRetailPrice(PropertyChangedArgs e) {
        BigDecimal retailPrice = CommonUtil.formatObjectToDecimal((Object)e.getChangeSet()[0].getNewValue());
        int index = e.getChangeSet()[0].getRowIndex();
        BigDecimal qty = (BigDecimal)this.getView().getModel().getValue("saleqty", index);
        BigDecimal balAmount = retailPrice.multiply(qty);
        this.updateValue("balamount", balAmount, index);
        BigDecimal rate = (BigDecimal)this.getView().getModel().getValue("discountrate", index);
        BigDecimal balPrice = retailPrice.multiply(rate).divide(BigDecimal.valueOf(100L), 4);
        this.getView().getModel().setValue("discountprice", (Object)balPrice, index);
    }

    private void updateMultiQuantities(BigDecimal saleQty, int index) {
        DynamicObject material = (DynamicObject)this.getView().getModel().getValue("materielid", index);
        DynamicObject unit = (DynamicObject)this.getView().getModel().getValue("unit", index);
        DynamicObject baseUnit = (DynamicObject)this.getView().getModel().getValue("baseunit", index);
        if (material == null || unit == null || baseUnit == null) {
            return;
        }
        long materialId = DynamicObjectUtil.getPkValue((DynamicObject)material);
        long unitId = DynamicObjectUtil.getPkValue((DynamicObject)unit);
        long baseUnitId = DynamicObjectUtil.getPkValue((DynamicObject)baseUnit);
        String baseUnitName = DynamicObjectUtil.getString((DynamicObject)baseUnit, (String)"name");
        BigDecimal baseUnitQty = this.convertUnitQty(saleQty, materialId, unitId, baseUnitId);
        if (baseUnitQty.compareTo(BigDecimal.ZERO) == 0) {
            String unitName = DynamicObjectUtil.getString((DynamicObject)unit, (String)"name");
            String tip = String.format("\u6362\u7b97\u5931\u8d25,\u627e\u4e0d\u5230\u8ba1\u91cf\u5355\u4f4d\u3010%s\u3011\u4e0e\u57fa\u672c\u5355\u4f4d\u3010%s\u3011\u7684\u6362\u7b97\u7387\uff0c\u8bf7\u68c0\u67e5\u5355\u4f4d\u6362\u7b97\u8868\u3002", unitName, baseUnitName);
            this.getView().showTipNotification(tip);
            return;
        }
        this.getView().getModel().setValue("baseunitqty", (Object)baseUnitQty, index);
        this.updateOtherQuantities(baseUnitQty, materialId, baseUnitId, baseUnitName, index);
    }

    private void updateMultiQuantities(DynamicObject unit, int index) {
        DynamicObject material = (DynamicObject)this.getView().getModel().getValue("materielid", index);
        DynamicObject baseUnit = (DynamicObject)this.getView().getModel().getValue("baseunit", index);
        if (material == null || baseUnit == null) {
            return;
        }
        long materialId = DynamicObjectUtil.getPkValue((DynamicObject)material);
        long unitId = DynamicObjectUtil.getPkValue((DynamicObject)unit);
        long baseUnitId = DynamicObjectUtil.getPkValue((DynamicObject)baseUnit);
        BigDecimal baseUnitQty = (BigDecimal)this.getView().getModel().getValue("baseunitqty", index);
        BigDecimal saleQty = this.convertUnitQty(baseUnitQty, materialId, baseUnitId, unitId);
        String baseUnitName = DynamicObjectUtil.getString((DynamicObject)baseUnit, (String)"name");
        if (saleQty.compareTo(BigDecimal.ZERO) == 0) {
            String unitName = DynamicObjectUtil.getString((DynamicObject)unit, (String)"name");
            String tip = String.format("\u6362\u7b97\u5931\u8d25,\u627e\u4e0d\u5230\u8ba1\u91cf\u5355\u4f4d\u3010%s\u3011\u4e0e\u57fa\u672c\u5355\u4f4d\u3010%s\u3011\u7684\u6362\u7b97\u7387\uff0c\u8bf7\u68c0\u67e5\u5355\u4f4d\u6362\u7b97\u8868\u3002", unitName, baseUnitName);
            this.getView().showTipNotification(tip);
            return;
        }
        this.getView().getModel().setValue("saleqty", (Object)saleQty, index);
        this.updateOtherQuantities(baseUnitQty, materialId, baseUnitId, baseUnitName, index);
    }

    private void updateBaseInfoAmount() {
        DynamicObjectCollection entryData = this.getView().getModel().getEntryEntity("goodsentryentity");
        BigDecimal sumAmount = BigDecimal.ZERO;
        BigDecimal sumBalAmount = BigDecimal.ZERO;
        BigDecimal sumPreAmount = BigDecimal.ZERO;
        for (DynamicObject entryItem : entryData) {
            BigDecimal amount = DynamicObjectUtil.getBigDecimal((DynamicObject)entryItem, (String)"amount");
            sumAmount = sumAmount.add(amount);
            BigDecimal balAmount = DynamicObjectUtil.getBigDecimal((DynamicObject)entryItem, (String)"balamount");
            sumBalAmount = sumBalAmount.add(balAmount);
            BigDecimal preAmount = DynamicObjectUtil.getBigDecimal((DynamicObject)entryItem, (String)"deposit");
            sumPreAmount = sumPreAmount.add(preAmount);
        }
        BigDecimal sumdiscount = sumAmount.subtract(sumBalAmount);
        this.getView().getModel().setValue("sumamount", (Object)sumAmount);
        this.getView().getModel().setValue("sumbalamount", (Object)sumBalAmount);
        this.getView().getModel().setValue("sumdiscount", (Object)sumdiscount);
        this.getView().getModel().setValue("preamount", (Object)sumPreAmount);
    }

    private void updateOtherQuantities(BigDecimal baseUnitQty, long materialId, long baseUnitId, String baseUnitName, int index) {
        DynamicObject auxUnit = (DynamicObject)this.getView().getModel().getValue("auxunit", index);
        long auxUnitId = DynamicObjectUtil.getPkValue((DynamicObject)auxUnit);
        DynamicObject stockUnit = (DynamicObject)this.getView().getModel().getValue("stockunit", index);
        long stockUnitId = DynamicObjectUtil.getPkValue((DynamicObject)stockUnit);
        if (auxUnitId != 0L) {
            BigDecimal auxUnitQty = this.convertUnitQty(baseUnitQty, materialId, baseUnitId, auxUnitId);
            this.getView().getModel().setValue("auxunitqty", (Object)auxUnitQty, index);
        }
        if (stockUnitId != 0L) {
            BigDecimal stockUnitQty = this.convertUnitQty(baseUnitQty, materialId, baseUnitId, stockUnitId);
            if (stockUnitQty.compareTo(BigDecimal.ZERO) == 0) {
                String stockUnitName = DynamicObjectUtil.getString((DynamicObject)stockUnit, (String)"name");
                String tip = String.format("\u6362\u7b97\u5931\u8d25\uff0c\u627e\u4e0d\u5230\u5e93\u5b58\u5355\u4f4d\u3010%s\u3011\u4e0e\u57fa\u672c\u5355\u4f4d\u3010%s\u3011\u7684\u6362\u7b97\u7387\uff0c\u8bf7\u68c0\u67e5\u5355\u4f4d\u6362\u7b97\u8868\u3002", stockUnitName, baseUnitName);
                this.getView().showTipNotification(tip);
                return;
            }
            this.getView().getModel().setValue("stockunitqty", (Object)stockUnitQty, index);
        }
    }

    private BigDecimal convertUnitQty(BigDecimal qty, long materielId, long srcUnitId, long desUnitId) {
        return UnitConvertHelper.calculateDestQty((BigDecimal)qty, (Long)materielId, (Long)srcUnitId, (Long)desUnitId);
    }

    private void setGoodsIdByBarCode(DynamicObject barCode, int index) {
        if (barCode != null) {
            DynamicObject goods = DynamicObjectUtil.getDynamicObject((DynamicObject)barCode, (String)"item");
            long goodsId = DynamicObjectUtil.getPkValue((DynamicObject)goods);
            if (goodsId != 0L) {
                this.fromBarcode = true;
                this.getView().getModel().setValue("goodsid", (Object)goodsId, index);
            } else {
                this.getView().getModel().setValue("goodsid", null, index);
            }
            this.initSaleQty(index);
            this.setRetailPrice(goods, index);
            this.setAuxAttrIdByBarCode(DynamicObjectUtil.getPkValue((DynamicObject)barCode), index);
        } else {
            this.getView().getModel().setValue("goodsid", null, index);
        }
    }

    private void setAuxAttrIdByBarCode(long barCodeId, int index) {
        if (barCodeId != 0L) {
            DynamicObject fullBarCode = BusinessDataServiceHelper.loadSingle((Object)barCodeId, (String)"mdr_item_barcode");
            DynamicObject auxAttr = DynamicObjectUtil.getDynamicObject((DynamicObject)fullBarCode, (String)"auxpty");
            long auxAttrId = DynamicObjectUtil.getPkValue((DynamicObject)auxAttr);
            this.getView().getModel().setValue("auxattrid", (Object)auxAttrId, index);
        } else {
            this.getView().getModel().setValue("auxattrid", null, index);
        }
    }

    private void setRetailPrice(DynamicObject goods, int index) {
        PricePolicyCondition pricePolicyCondition = new PricePolicyCondition();
        DynamicObject barCode = (DynamicObject)this.getView().getModel().getValue("barcode", index);
        String date = CommonUtil.format((Date)TimeServiceHelper.now(), (String)TimeServiceHelper.getDateTimeFormatString());
        DynamicObject channel = (DynamicObject)this.getView().getModel().getValue("salebranchid");
        DynamicObject priceUnit = (DynamicObject)this.getView().getModel().getValue("unit", index);
        pricePolicyCondition.setItemId(String.valueOf(DynamicObjectUtil.getPkValue((DynamicObject)goods)));
        pricePolicyCondition.setBarcode(String.valueOf(DynamicObjectUtil.getPkValue((DynamicObject)barCode)));
        pricePolicyCondition.setBizDate(date);
        pricePolicyCondition.setChannel(String.valueOf(DynamicObjectUtil.getPkValue((DynamicObject)channel)));
        pricePolicyCondition.setPriceUnit(String.valueOf(DynamicObjectUtil.getPkValue((DynamicObject)priceUnit)));
        pricePolicyCondition.setUseTerminal("B,C");
        this.logger.error("\u5f00\u5355\u53d6\u4ef7\u4f20\u53c2\uff1as" + JsonUtil.toJson((Object)pricePolicyCondition));
        ResultMessage result = (ResultMessage)DispatchServiceHelper.invokeBizService((String)"drp", (String)"dpm", (String)"PricePolicyService", (String)"matchPricePolicy", (Object[])new Object[]{pricePolicyCondition});
        if (result != null) {
            PricePolicyResult pricePolicyResult = (PricePolicyResult)result.getData();
            this.logger.error("\u5f00\u5355\u53d6\u4ef7\u8fd4\u53c2\uff1a" + JsonUtil.toJson((Object)pricePolicyResult));
            if (pricePolicyResult != null) {
                BigDecimal retailPrice = pricePolicyResult.getPrice();
                if (retailPrice == null || retailPrice.compareTo(BigDecimal.ZERO) <= 0) {
                    retailPrice = this.getRetailPrice(goods, index);
                }
                this.getView().getModel().setValue("retailprice", (Object)retailPrice, index);
                boolean isControlPrice = pricePolicyResult.getControllerPrice();
                this.getView().setEnable(Boolean.valueOf(!isControlPrice), index, new String[]{"discountprice"});
            } else {
                BigDecimal retailPrice = this.getRetailPrice(goods, index);
                this.getView().getModel().setValue("retailprice", (Object)retailPrice, index);
                this.getView().setEnable(Boolean.TRUE, index, new String[]{"discountprice"});
            }
        }
    }

    private BigDecimal getRetailPrice(DynamicObject goods, int index) {
        DynamicObject branch = (DynamicObject)this.getView().getModel().getValue("salebranchid");
        DynamicObject currency = (DynamicObject)this.getView().getModel().getValue("currencyid");
        DynamicObject barCode = (DynamicObject)this.getView().getModel().getValue("barcode", index);
        long goodsId = DynamicObjectUtil.getPkValue((DynamicObject)goods);
        long barCodeId = DynamicObjectUtil.getPkValue((DynamicObject)barCode);
        long branchId = DynamicObjectUtil.getPkValue((DynamicObject)branch);
        long currencyId = DynamicObjectUtil.getPkValue((DynamicObject)currency);
        QFilter filter = F7Util.getGoodsInfoFilter((long)goodsId, (long)branchId, (long)barCodeId, (long)currencyId);
        DynamicObject salItem = QueryServiceHelper.queryOne((String)"dbd_itemsale_content", (String)"Id, retailprice", (QFilter[])filter.toArray());
        return DynamicObjectUtil.getBigDecimal((DynamicObject)salItem, (String)"retailprice");
    }

    private void setBarcodeByGoodsId(DynamicObject goods, int index) {
        if (goods == null) {
            this.updateValue("barcode", null, index);
            this.getView().getModel().setValue("retailprice", (Object)BigDecimal.ZERO, index);
            this.initSaleQty(index);
            this.updateValue("discountrate", 100, index);
            this.setAuxAttrIdByBarCode(0L, index);
            return;
        }
        DynamicObjectCollection data = this.getBarCodeByGoodsId(goods);
        if (data.size() == 1 && !this.fromBarcode) {
            long barCodeId = ((DynamicObject)data.get(0)).getLong("Id");
            this.updateValue("barcode", barCodeId, index);
            this.initSaleQty(index);
            this.setRetailPrice(goods, index);
            this.setAuxAttrIdByBarCode(barCodeId, index);
            this.fromBarcode = false;
        }
    }

    private void setEnableSerial(DynamicObject goods, int index) {
        boolean enableSerial = DynamicObjectUtil.getBoolean((DynamicObject)goods, (String)KEY_ENABLESERIAL);
        if (enableSerial) {
            FormViewUtil.setUnEnable((IFormView)this.getView(), (int)index, (String[])new String[]{"saleqty"});
        } else {
            FormViewUtil.setEnable((IFormView)this.getView(), (int)index, (String[])new String[]{"saleqty"});
        }
    }

    private DynamicObjectCollection getBarCodeByGoodsId(DynamicObject goods) {
        DynamicObject branch = (DynamicObject)this.getView().getModel().getValue("salebranchid");
        DynamicObject currency = (DynamicObject)this.getView().getModel().getValue("currencyid");
        long goodsId = DynamicObjectUtil.getPkValue((DynamicObject)goods);
        long branchId = DynamicObjectUtil.getPkValue((DynamicObject)branch);
        long currencyId = DynamicObjectUtil.getPkValue((DynamicObject)currency);
        QFilter filter = F7Util.getBarCodeIdFilter((long)branchId, (long)goodsId, (long)currencyId);
        return QueryServiceHelper.query((String)"mdr_item_barcode", (String)"Id", (QFilter[])filter.toArray());
    }

    private void updateValue(String key, Object value, int index) {
        this.getView().getModel().beginInit();
        this.getView().getModel().setValue(key, value, index);
        this.getView().updateView(key, index);
        this.getView().getModel().endInit();
    }

    private void updateValue(String key, Object value) {
        this.getView().getModel().beginInit();
        this.getView().getModel().setValue(key, value);
        this.getView().updateView(key);
        this.getView().getModel().endInit();
    }

    private void updatePriceByRate(PropertyChangedArgs e) {
        BigDecimal value = (BigDecimal)e.getChangeSet()[0].getNewValue();
        int rowIndex = e.getChangeSet()[0].getRowIndex();
        BigDecimal retailPrice = (BigDecimal)this.getView().getModel().getValue("retailprice", rowIndex);
        BigDecimal newBalPrice = retailPrice.multiply(value).divide(BigDecimal.valueOf(100L), 4);
        this.getView().getModel().setValue("discountprice", (Object)newBalPrice, rowIndex);
    }

    private void updateRateByPrice(PropertyChangedArgs e) {
        BigDecimal value = (BigDecimal)e.getChangeSet()[0].getNewValue();
        int rowIndex = e.getChangeSet()[0].getRowIndex();
        BigDecimal retailPrice = (BigDecimal)this.getView().getModel().getValue("retailprice", rowIndex);
        BigDecimal newRate = BigDecimal.ZERO;
        if (retailPrice.compareTo(BigDecimal.ZERO) != 0) {
            newRate = value.multiply(BigDecimal.valueOf(100L)).divide(retailPrice, 4);
        }
        this.updateValue("discountrate", newRate, rowIndex);
        BigDecimal saleQty = (BigDecimal)this.getView().getModel().getValue("saleqty", rowIndex);
        BigDecimal balAmount = value.multiply(saleQty);
        this.updateValue("balamount", balAmount, rowIndex);
        this.updateBaseInfoAmount();
    }

    private void fillCurrentInfoFromSourceBill(DynamicObject dbSourceBill) {
        this.getModel().deleteEntryData("goodsentryentity");
        DynamicObject sourceBill = this.getSourceBill(dbSourceBill);
        if (sourceBill == null) {
            SaleOrderHelper.initData((IDataModel)this.getModel());
            return;
        }
        this.fillHeadData(dbSourceBill, sourceBill);
        DynamicObjectCollection sourceEntities = sourceBill.getDynamicObjectCollection("goodsentryentity");
        DynamicObject currentBill = this.getView().getModel().getDataEntity(true);
        String bizType = currentBill.getString("biztype");
        boolean isConvert = StringUtils.equals((CharSequence)bizType, (CharSequence)BizTypeEnum.ORDERCONVERTSALE.getValue());
        String srcBizType = dbSourceBill.getString("biztype");
        this.fillEntryData(currentBill, sourceEntities, srcBizType, isConvert);
        this.getView().updateView();
    }

    private DynamicObject getSourceBill(DynamicObject dbSourceBill) {
        long sourceBillId = DynamicObjectUtil.getPkValue((DynamicObject)dbSourceBill);
        if (sourceBillId > 0L) {
            return BusinessDataServiceHelper.loadSingle((Object)sourceBillId, (String)"pos_salesorder");
        }
        return null;
    }

    private void fillHeadData(DynamicObject dbSourceBill, DynamicObject sourceBill) {
        DynamicObject billData = this.getView().getModel().getDataEntity(true);
        billData.set("bizorgid", (Object)DynamicObjectUtil.getDynamicObject((DynamicObject)sourceBill, (String)"bizorgid"));
        billData.set("salebranchid", (Object)DynamicObjectUtil.getDynamicObject((DynamicObject)sourceBill, (String)"salebranchid"));
        billData.set("terminaltype", (Object)DynamicObjectUtil.getString((DynamicObject)sourceBill, (String)"terminaltype"));
        billData.set("customerid", (Object)DynamicObjectUtil.getDynamicObject((DynamicObject)sourceBill, (String)"customerid"));
        billData.set("saler", (Object)DynamicObjectUtil.getDynamicObject((DynamicObject)sourceBill, (String)"saler"));
        billData.set("creator", (Object)DynamicObjectUtil.getDynamicObject((DynamicObject)sourceBill, (String)"creator"));
        billData.set("cashier", (Object)DynamicObjectUtil.getDynamicObject((DynamicObject)sourceBill, (String)"cashier"));
        billData.set("locurrencyid", (Object)DynamicObjectUtil.getDynamicObject((DynamicObject)sourceBill, (String)"locurrencyid"));
        billData.set("currencyid", (Object)DynamicObjectUtil.getDynamicObject((DynamicObject)sourceBill, (String)"currencyid"));
        billData.set("customername", (Object)DynamicObjectUtil.getString((DynamicObject)sourceBill, (String)"customername"));
        billData.set("customerphone", (Object)DynamicObjectUtil.getString((DynamicObject)sourceBill, (String)"customerphone"));
        billData.set("customeraddress", (Object)DynamicObjectUtil.getString((DynamicObject)sourceBill, (String)"customeraddress"));
        billData.set("sourcebillno", (Object)DynamicObjectUtil.getString((DynamicObject)dbSourceBill, (String)"billno"));
        billData.set("initialbillno", (Object)DynamicObjectUtil.getString((DynamicObject)sourceBill, (String)"initialbillno"));
        billData.set("closestatus", (Object)"A");
        String openquotype = DynamicObjectUtil.getString((DynamicObject)sourceBill, (String)"openquotype");
        billData.set("openquotype", (Object)openquotype);
        if (StringUtils.equals((CharSequence)openquotype, (CharSequence)"1")) {
            billData.set("name", (Object)DynamicObjectUtil.getString((DynamicObject)sourceBill, (String)"name"));
            billData.set("phonenumber", (Object)DynamicObjectUtil.getString((DynamicObject)sourceBill, (String)"phonenumber"));
            billData.set("email", (Object)DynamicObjectUtil.getString((DynamicObject)sourceBill, (String)"email"));
        } else if (StringUtils.equals((CharSequence)openquotype, (CharSequence)"2")) {
            billData.set("enterprisename", (Object)DynamicObjectUtil.getString((DynamicObject)sourceBill, (String)"enterprisename"));
            billData.set("taxnumber", (Object)DynamicObjectUtil.getString((DynamicObject)sourceBill, (String)"taxnumber"));
            billData.set("enterpriseaddr", (Object)DynamicObjectUtil.getString((DynamicObject)sourceBill, (String)"enterpriseaddr"));
            billData.set("enterprisetel", (Object)DynamicObjectUtil.getString((DynamicObject)sourceBill, (String)"enterprisetel"));
            billData.set("bank", (Object)DynamicObjectUtil.getString((DynamicObject)sourceBill, (String)"bank"));
            billData.set("bankaccount", (Object)DynamicObjectUtil.getString((DynamicObject)sourceBill, (String)"bankaccount"));
            billData.set("enterprisephone", (Object)DynamicObjectUtil.getString((DynamicObject)sourceBill, (String)"enterprisephone"));
            billData.set("enterpriseemail", (Object)DynamicObjectUtil.getString((DynamicObject)sourceBill, (String)"enterpriseemail"));
        }
    }

    private void fillEntryData(DynamicObject currentBill, DynamicObjectCollection sourceEntities, String srcBizType, boolean isConvert) {
        DynamicObjectCollection currentEntities = currentBill.getDynamicObjectCollection("goodsentryentity");
        currentEntities.clear();
        int index = 0;
        for (DynamicObject sourceEntity : sourceEntities) {
            String rowCloseStatus = DynamicObjectUtil.getString((DynamicObject)sourceEntity, (String)"ROWCLOSESTATUS");
            boolean isBook = DynamicObjectUtil.getBoolean((DynamicObject)sourceEntity, (String)"isbook");
            if (StringUtils.equals((CharSequence)rowCloseStatus, (CharSequence)CloseStatusEnum.CLOSE.getValue()) || isConvert && !isBook) continue;
            DynamicObject currentEntity = currentEntities.addNew();
            this.setEntryValue(sourceEntity, currentEntity, srcBizType, isConvert, index);
            ++index;
        }
    }

    private void setEntryValue(DynamicObject sourceEntity, DynamicObject currentEntity, String srcBizType, boolean isConvert, int index) {
        DynamicObject goods = DynamicObjectUtil.getDynamicObject((DynamicObject)sourceEntity, (String)"goodsid");
        currentEntity.set("goodsid", (Object)goods);
        DynamicObject material = DynamicObjectUtil.getDynamicObject((DynamicObject)sourceEntity, (String)"materielid");
        currentEntity.set("materielid", (Object)material);
        currentEntity.set("barcode", (Object)DynamicObjectUtil.getDynamicObject((DynamicObject)sourceEntity, (String)"barcode"));
        DynamicObject unit = DynamicObjectUtil.getDynamicObject((DynamicObject)sourceEntity, (String)"unit");
        currentEntity.set("unit", (Object)unit);
        DynamicObject baseUnit = DynamicObjectUtil.getDynamicObject((DynamicObject)sourceEntity, (String)"baseunit");
        currentEntity.set("baseunit", (Object)baseUnit);
        DynamicObject auxUnit = DynamicObjectUtil.getDynamicObject((DynamicObject)sourceEntity, (String)"auxunit");
        currentEntity.set("auxunit", (Object)auxUnit);
        DynamicObject stockUnit = DynamicObjectUtil.getDynamicObject((DynamicObject)sourceEntity, (String)"stockunit");
        currentEntity.set("stockunit", (Object)stockUnit);
        currentEntity.set("discountrate", (Object)DynamicObjectUtil.getBigDecimal((DynamicObject)sourceEntity, (String)"discountrate"));
        BigDecimal retailprice = DynamicObjectUtil.getBigDecimal((DynamicObject)sourceEntity, (String)"retailprice");
        currentEntity.set("retailprice", (Object)retailprice);
        BigDecimal discountprice = DynamicObjectUtil.getBigDecimal((DynamicObject)sourceEntity, (String)"discountprice");
        currentEntity.set("discountprice", (Object)discountprice);
        currentEntity.set("serialid", (Object)DynamicObjectUtil.getDynamicObject((DynamicObject)sourceEntity, (String)"serialid"));
        currentEntity.set("discountreasonid", (Object)DynamicObjectUtil.getDynamicObject((DynamicObject)sourceEntity, (String)"discountreasonid"));
        currentEntity.set("auxattrid", DynamicObjectUtil.get((DynamicObject)sourceEntity, (String)"auxattrid"));
        currentEntity.set("goodssaler", (Object)DynamicObjectUtil.getDynamicObject((DynamicObject)sourceEntity, (String)"goodssaler"));
        currentEntity.set("deliverytime", DynamicObjectUtil.get((DynamicObject)sourceEntity, (String)"deliverytime"));
        currentEntity.set("supplier", (Object)DynamicObjectUtil.getDynamicObject((DynamicObject)sourceEntity, (String)"supplier"));
        currentEntity.set("inventoryupdate", (Object)DynamicObjectUtil.getString((DynamicObject)sourceEntity, (String)"inventoryupdate"));
        currentEntity.set("srcbillentryid", (Object)DynamicObjectUtil.getPkValue((DynamicObject)sourceEntity));
        currentEntity.set("srcbillbiztype", (Object)srcBizType);
        currentEntity.set("keepertype", DynamicObjectUtil.get((DynamicObject)sourceEntity, (String)"keepertype"));
        currentEntity.set("keeperid", (Object)DynamicObjectUtil.getDynamicObject((DynamicObject)sourceEntity, (String)"keeperid"));
        currentEntity.set("ownertype", DynamicObjectUtil.get((DynamicObject)sourceEntity, (String)"ownertype"));
        currentEntity.set("ownerid", (Object)DynamicObjectUtil.getDynamicObject((DynamicObject)sourceEntity, (String)"ownerid"));
        currentEntity.set("taxrateid", (Object)DynamicObjectUtil.getDynamicObject((DynamicObject)sourceEntity, (String)"taxrateid"));
        currentEntity.set("taxrate", (Object)DynamicObjectUtil.getBigDecimal((DynamicObject)sourceEntity, (String)"taxrate"));
        currentEntity.set("ROWCLOSESTATUS", (Object)"A");
        currentEntity.set("lastinisrcbillid", (Object)DynamicObjectUtil.getLong((DynamicObject)sourceEntity, (String)"lastinisrcbillid"));
        currentEntity.set("lastinisrcbillentryid", (Object)DynamicObjectUtil.getLong((DynamicObject)sourceEntity, (String)"lastinisrcbillentryid"));
        currentEntity.set("inisrcbilltype", (Object)DynamicObjectUtil.getString((DynamicObject)sourceEntity, (String)"inisrcbilltype"));
        BigDecimal mustRetQty = DynamicObjectUtil.getBigDecimal((DynamicObject)sourceEntity, (String)"mustretqty");
        if (mustRetQty.compareTo(BigDecimal.ZERO) == 0) {
            mustRetQty = DynamicObjectUtil.getBigDecimal((DynamicObject)sourceEntity, (String)"saleqty");
        }
        BigDecimal depositPrice = DynamicObjectUtil.getBigDecimal((DynamicObject)sourceEntity, (String)"depositprice");
        long materialId = DynamicObjectUtil.getPkValue((DynamicObject)material);
        long unitId = DynamicObjectUtil.getPkValue((DynamicObject)unit);
        long baseUnitId = DynamicObjectUtil.getPkValue((DynamicObject)baseUnit);
        long auxUnitId = DynamicObjectUtil.getPkValue((DynamicObject)auxUnit);
        long stockUnitId = DynamicObjectUtil.getPkValue((DynamicObject)stockUnit);
        if (isConvert) {
            currentEntity.set("depositprice", (Object)depositPrice);
            currentEntity.set("isbook", (Object)Boolean.FALSE);
            currentEntity.set("tosalesqty", (Object)BigDecimal.ZERO);
            currentEntity.set("retqty", (Object)BigDecimal.ZERO);
            currentEntity.set("mustretqty", (Object)mustRetQty);
            currentEntity.set("saleqty", (Object)mustRetQty);
            BigDecimal baseUnitQty = this.convertUnitQty(mustRetQty, materialId, unitId, baseUnitId);
            currentEntity.set("baseunitqty", (Object)baseUnitQty);
            BigDecimal auxQtyConvert = this.convertUnitQty(baseUnitQty, materialId, baseUnitId, auxUnitId);
            currentEntity.set("auxunitqty", (Object)auxQtyConvert);
            BigDecimal stockQtyConvert = this.convertUnitQty(baseUnitQty, materialId, baseUnitId, stockUnitId);
            currentEntity.set("stockunitqty", (Object)stockQtyConvert);
            currentEntity.set("amount", (Object)mustRetQty.multiply(retailprice));
            currentEntity.set("balamount", (Object)mustRetQty.multiply(discountprice));
            currentEntity.set("realprice", (Object)discountprice);
            currentEntity.set("realamount", (Object)mustRetQty.multiply(discountprice));
            currentEntity.set("deposit", (Object)mustRetQty.multiply(depositPrice));
            this.setModeAndStockByRules(goods, index);
        } else {
            currentEntity.set("depositprice", (Object)depositPrice);
            currentEntity.set("isbook", (Object)DynamicObjectUtil.getBoolean((DynamicObject)sourceEntity, (String)"isbook"));
            currentEntity.set("tosalesqty", (Object)BigDecimal.ZERO);
            currentEntity.set("retqty", (Object)BigDecimal.ZERO);
            currentEntity.set("mustretqty", (Object)mustRetQty);
            currentEntity.set("saleqty", (Object)mustRetQty.negate());
            BigDecimal baseUnitQty = this.convertUnitQty(mustRetQty, materialId, unitId, baseUnitId);
            currentEntity.set("baseunitqty", (Object)baseUnitQty.negate());
            BigDecimal auxQtyReturn = this.convertUnitQty(baseUnitQty, materialId, baseUnitId, auxUnitId);
            currentEntity.set("auxunitqty", (Object)auxQtyReturn.negate());
            BigDecimal stockQtyReturn = this.convertUnitQty(baseUnitQty, materialId, baseUnitId, stockUnitId);
            currentEntity.set("stockunitqty", (Object)stockQtyReturn.negate());
            currentEntity.set("amount", (Object)mustRetQty.multiply(retailprice).negate());
            currentEntity.set("balamount", (Object)mustRetQty.multiply(discountprice).negate());
            BigDecimal realPrice = DynamicObjectUtil.getBigDecimal((DynamicObject)sourceEntity, (String)"realprice");
            if (realPrice.compareTo(BigDecimal.ZERO) == 0) {
                realPrice = discountprice;
            }
            currentEntity.set("realprice", (Object)realPrice);
            BigDecimal retQty = DynamicObjectUtil.getBigDecimal((DynamicObject)sourceEntity, (String)"retqty");
            BigDecimal realAmount = DynamicObjectUtil.getBigDecimal((DynamicObject)sourceEntity, (String)"realamount");
            BigDecimal retRealAmount = retQty.compareTo(BigDecimal.ZERO) > 0 ? realPrice.multiply(retQty) : BigDecimal.ZERO;
            currentEntity.set("realamount", (Object)realAmount.subtract(retRealAmount).negate());
            currentEntity.set("deposit", (Object)mustRetQty.multiply(depositPrice).negate());
            currentEntity.set("distributionmode", (Object)DynamicObjectUtil.getDynamicObject((DynamicObject)sourceEntity, (String)"distributionmode"));
            currentEntity.set("modeenum", (Object)DynamicObjectUtil.getString((DynamicObject)sourceEntity, (String)"modeenum"));
            currentEntity.set("inventoryorg", (Object)DynamicObjectUtil.getDynamicObject((DynamicObject)sourceEntity, (String)"inventoryorg"));
            currentEntity.set("erpstock", (Object)DynamicObjectUtil.getDynamicObject((DynamicObject)sourceEntity, (String)"erpstock"));
            currentEntity.set("erpstockposition", (Object)DynamicObjectUtil.getDynamicObject((DynamicObject)sourceEntity, (String)"erpstockposition"));
            currentEntity.set("stockid", (Object)DynamicObjectUtil.getDynamicObject((DynamicObject)sourceEntity, (String)"stockid"));
            currentEntity.set("stockposition", (Object)DynamicObjectUtil.getDynamicObject((DynamicObject)sourceEntity, (String)"stockposition"));
        }
    }

    private void setCtrPropForReturn(String bizType) {
        if (StringUtils.equals((CharSequence)bizType, (CharSequence)BizTypeEnum.SALERETURN.getValue())) {
            TextEdit txtPhone = (TextEdit)this.getView().getControl("customerphone");
            txtPhone.setCaption(new LocaleString("\u8054\u7cfb\u7535\u8bdd"));
            TextEdit txtAddress = (TextEdit)this.getView().getControl("customeraddress");
            txtAddress.setCaption(new LocaleString("\u53d6\u8d27\u5730\u5740"));
        }
    }

    private void headFieldPropertyChanged(PropertyChangedArgs e, String key) {
        switch (key) {
            case "saler": {
                DynamicObject saler = (DynamicObject)e.getChangeSet()[0].getNewValue();
                this.updateGoodsSaler(saler);
                break;
            }
            case "salebranchid": {
                this.updateValue("sourcebillid", null);
                this.getView().getModel().deleteEntryData("goodsentryentity");
                this.getView().getModel().createNewEntryRow("goodsentryentity");
                break;
            }
            case "sourcebillid": {
                this.getView().addClientCallBack(KEY_FILLSRCBILLDATA);
                break;
            }
            case "isredrush": {
                this.updateValue("isticketreturn", Boolean.FALSE);
                this.getView().getModel().setValue("sourcebillid", null);
                break;
            }
            case "isticketreturn": {
                this.updateValue("isredrush", Boolean.FALSE);
                this.getView().getModel().setValue("sourcebillid", null);
                break;
            }
            case "biztype": {
                String bizType = CommonUtil.formatStringToEmpty((Object)e.getChangeSet()[0].getNewValue());
                long branchId = OwnerUtils.getDefaultOwnerId();
                this.updateValue("salebranchid", branchId);
                this.updateValue("isticketreturn", Boolean.FALSE);
                this.updateValue("isredrush", Boolean.FALSE);
                this.setCtrPropForReturn(bizType);
                DynamicObject sourceBill = (DynamicObject)this.getView().getModel().getValue("sourcebillid");
                if (sourceBill != null) {
                    this.getView().getModel().setValue("sourcebillid", null);
                    break;
                }
                SaleOrderHelper.initData((IDataModel)this.getModel());
                break;
            }
            case "admindivisionid": {
                long adminDivisionId = CommonUtil.formatObejctToLong((Object)e.getChangeSet()[0].getNewValue());
                if (adminDivisionId == 0L) break;
                DynamicObject adminDivision = BusinessDataServiceHelper.loadSingleFromCache((Object)adminDivisionId, (String)"bd_admindivision");
                long countryId = adminDivision != null ? DynamicObjectUtil.getPkValue((DynamicObject)adminDivision, (String)"country") : adminDivisionId;
                this.getView().getModel().setValue("country", (Object)countryId);
                DynamicObjectCollection entryData = this.getView().getModel().getEntryEntity("goodsentryentity");
                if (entryData == null || entryData.size() <= 0) break;
                for (DynamicObject entryItem : entryData) {
                    DynamicObject goods = DynamicObjectUtil.getDynamicObject((DynamicObject)entryItem, (String)"goodsid");
                    boolean isBook = DynamicObjectUtil.getBoolean((DynamicObject)entryItem, (String)"isbook");
                    if (goods == null || isBook) continue;
                    this.setModeAndStockByRules(goods, entryItem.getInt("Seq") - 1);
                }
                break;
            }
        }
    }

    private void entryFieldPropertyChanged(PropertyChangedArgs e, String key) {
        int rowIndex = e.getChangeSet()[0].getRowIndex();
        switch (key) {
            case "goodsid": {
                DynamicObject goods = (DynamicObject)e.getChangeSet()[0].getNewValue();
                this.setBarcodeByGoodsId(goods, rowIndex);
                boolean isBook = CommonUtil.formatObjectToBoolean((Object)this.getView().getModel().getValue("isbook", rowIndex));
                if (!isBook) {
                    this.setModeAndStockByRules(goods, rowIndex);
                }
                this.setEnableSerial(goods, rowIndex);
                break;
            }
            case "barcode": {
                DynamicObject barCode = (DynamicObject)e.getChangeSet()[0].getNewValue();
                this.setGoodsIdByBarCode(barCode, rowIndex);
                break;
            }
            case "saleqty": {
                this.updateSaleQty(e);
                break;
            }
            case "unit": {
                this.updateUnit(e);
                break;
            }
            case "discountrate": {
                this.updatePriceByRate(e);
                break;
            }
            case "discountprice": {
                this.updateRateByPrice(e);
                break;
            }
            case "retailprice": {
                this.updateRetailPrice(e);
                break;
            }
            case "deposit": {
                this.updateDeposit(e);
                break;
            }
            case "stockid": {
                DynamicObject stock = (DynamicObject)e.getChangeSet()[0].getNewValue();
                this.setStockPositionByStockId(stock, rowIndex);
                break;
            }
            case "distributionmode": {
                this.setDefaultDeliveryStock(e);
                break;
            }
            case "inventoryorg": {
                DynamicObject inventoryOrg = (DynamicObject)e.getChangeSet()[0].getNewValue();
                if (inventoryOrg == null) break;
                this.setStockByRules(inventoryOrg, rowIndex);
                break;
            }
            case "erpstock": {
                DynamicObject erpStock = (DynamicObject)e.getChangeSet()[0].getNewValue();
                this.setErpStockPositionByStockId(erpStock, rowIndex);
                break;
            }
        }
    }

    private DynamicObjectCollection getStockPositions(long stockId) {
        QFilter filter = F7Util.getStockPositionidFilter((long)stockId);
        return QueryServiceHelper.query((String)"ocic_location", (String)"Id,isdefault", (QFilter[])filter.toArray());
    }

    private void setStockPositionByStockId(DynamicObject stock, int index) {
        if (stock == null) {
            return;
        }
        DynamicObjectCollection stockPositions = this.getStockPositions(DynamicObjectUtil.getPkValue((DynamicObject)stock));
        long stockPositionId = 0L;
        int count = stockPositions.size();
        if (count == 1) {
            stockPositionId = DynamicObjectUtil.getLong((DynamicObject)((DynamicObject)stockPositions.get(0)), (String)"Id");
        } else if (count > 1) {
            DynamicObject stockPosition = stockPositions.stream().filter(x -> DynamicObjectUtil.getBoolean((DynamicObject)x, (String)"isdefault")).findFirst().orElse(null);
            stockPositionId = DynamicObjectUtil.getLong((DynamicObject)stockPosition, (String)"Id");
        }
        this.getView().getModel().setItemValueByID("stockposition", (Object)stockPositionId, index);
    }

    private DynamicObjectCollection getErpStockPositions(long erpStockId) {
        QFilter filter = F7Util.getErpStockPositionidFilter((long)erpStockId);
        return QueryServiceHelper.query((String)"bd_location", (String)"Id", (QFilter[])filter.toArray());
    }

    private void setErpStockPositionByStockId(DynamicObject erpStock, int index) {
        if (erpStock == null) {
            return;
        }
        DynamicObjectCollection erpStockPositions = this.getErpStockPositions(DynamicObjectUtil.getPkValue((DynamicObject)erpStock));
        long erpStockPositionId = 0L;
        if (erpStockPositions.size() == 1) {
            erpStockPositionId = DynamicObjectUtil.getLong((DynamicObject)((DynamicObject)erpStockPositions.get(0)), (String)"Id");
        }
        this.getView().getModel().setItemValueByID("erpstockposition", (Object)erpStockPositionId, index);
    }

    private void openSaleOrderPayWindow() {
        FormShowParameter formShowParameter = new FormShowParameter();
        String formId = this.getPayInfoFormId();
        formShowParameter.setFormId(formId);
        formShowParameter.setCaption("\u652f\u4ed8\u4fe1\u606f");
        formShowParameter.setCustomParam("Id", this.getView().getModel().getValue("Id"));
        formShowParameter.getOpenStyle().setShowType(ShowType.Modal);
        formShowParameter.setCloseCallBack(new CloseCallBack((IFormPlugin)this, BTN_CALLBACKACTIONID));
        this.getView().showForm(formShowParameter);
    }

    private void initSaleQty(int index) {
        String bizType = CommonUtil.formatStringToEmpty((Object)this.getView().getModel().getValue("biztype"));
        if (StringUtils.equals((CharSequence)bizType, (CharSequence)BizTypeEnum.SALERETURN.getValue())) {
            this.updateValue("saleqty", BigDecimal.ONE.negate(), index);
            this.updateMultiQuantities(BigDecimal.ONE.negate(), index);
        } else {
            this.updateValue("saleqty", BigDecimal.ONE, index);
            this.updateMultiQuantities(BigDecimal.ONE, index);
        }
        this.updateValue("discountrate", new BigDecimal(100), index);
    }

    private String getPayInfoFormId() {
        String bizType = CommonUtil.formatStringToEmpty((Object)this.getView().getModel().getValue("biztype"));
        boolean isTickReturn = CommonUtil.formatObjectToBoolean((Object)this.getView().getModel().getValue("isticketreturn"));
        boolean isRedRush = CommonUtil.formatObjectToBoolean((Object)this.getView().getModel().getValue("isredrush"));
        if (StringUtils.equals((CharSequence)bizType, (CharSequence)BizTypeEnum.SALERETURN.getValue())) {
            if (!isTickReturn && !isRedRush) {
                return "pos_nosrcreturnpay";
            }
            return "pos_srcreturnpay";
        }
        return "pos_salepay";
    }

    private void updateGoodsSaler(DynamicObject saler) {
        DynamicObjectCollection entryData = this.getView().getModel().getDataEntity(true).getDynamicObjectCollection("goodsentryentity");
        if (entryData == null || entryData.size() <= 0) {
            return;
        }
        for (DynamicObject entryItem : entryData) {
            entryItem.set("goodssaler", (Object)saler);
        }
        this.getView().updateView("goodsentryentity");
    }

    private void setModeAndStockByRules(DynamicObject goods, int index) {
        String operationModel = DynamicObjectUtil.getString((DynamicObject)goods, (String)"operationmodel");
        if (StringUtils.equals((CharSequence)operationModel, (CharSequence)"0")) {
            return;
        }
        DynamicObject branch = (DynamicObject)this.getView().getModel().getValue("salebranchid");
        DynamicObject org = (DynamicObject)this.getView().getModel().getValue("bizorgid");
        DynamicObject country = (DynamicObject)this.getView().getModel().getValue("country");
        long adminDivisionId = CommonUtil.formatObejctToLong((Object)this.getView().getModel().getValue("admindivisionid"));
        DynamicObject rule = GetDistributionRulesHelper.getRule((long)DynamicObjectUtil.getPkValue((DynamicObject)branch), (long)DynamicObjectUtil.getPkValue((DynamicObject)org), (DynamicObject)goods, (long)DynamicObjectUtil.getPkValue((DynamicObject)country), (long)adminDivisionId);
        this.getView().getModel().setItemValueByID("distributionmode", (Object)DynamicObjectUtil.getPkValue((DynamicObject)rule, (String)"mode"), index);
        this.getView().getModel().setItemValueByID("modeenum", (Object)DynamicObjectUtil.getString((DynamicObject)rule, (String)"modeenum"), index);
        this.setRulesValue(rule, index);
    }

    private void setStockByRules(DynamicObject inventoryOrg, int index) {
        DynamicObject branch = (DynamicObject)this.getView().getModel().getValue("salebranchid");
        DynamicObject org = (DynamicObject)this.getView().getModel().getValue("bizorgid");
        DynamicObject goods = (DynamicObject)this.getView().getModel().getValue("goodsid", index);
        DynamicObject country = (DynamicObject)this.getView().getModel().getValue("country");
        long adminDivisionId = CommonUtil.formatObejctToLong((Object)this.getView().getModel().getValue("admindivisionid"));
        DynamicObject mode = (DynamicObject)this.getView().getModel().getValue("distributionmode", index);
        DynamicObject rule = GetDistributionRulesHelper.getRuleByInventoryOrg((long)DynamicObjectUtil.getPkValue((DynamicObject)branch), (long)DynamicObjectUtil.getPkValue((DynamicObject)org), (DynamicObject)goods, (long)DynamicObjectUtil.getPkValue((DynamicObject)country), (long)adminDivisionId, (long)DynamicObjectUtil.getPkValue((DynamicObject)mode), (long)DynamicObjectUtil.getPkValue((DynamicObject)inventoryOrg));
        this.getView().getModel().setItemValueByID("erpstock", (Object)DynamicObjectUtils.getPkValue((DynamicObject)rule, (String)"erpstock"), index);
    }

    private void setDefaultDeliveryStock(PropertyChangedArgs e) {
        DynamicObject mode = (DynamicObject)e.getChangeSet()[0].getNewValue();
        int index = e.getChangeSet()[0].getRowIndex();
        long modeId = DynamicObjectUtil.getPkValue((DynamicObject)mode);
        if (modeId == 926601071999218688L) {
            DynamicObject branch = (DynamicObject)this.getView().getModel().getValue("salebranchid");
            long stockId = CommonUtils.getDefaultDeliveryStock((DynamicObject)branch);
            this.getView().getModel().setValue("stockid", (Object)stockId, index);
        } else if (modeId == 926596489101228032L || modeId == 926596971228197888L || modeId == 926600838443594752L) {
            DynamicObject branch = (DynamicObject)this.getView().getModel().getValue("salebranchid");
            DynamicObject org = (DynamicObject)this.getView().getModel().getValue("bizorgid");
            DynamicObject goods = (DynamicObject)this.getView().getModel().getValue("goodsid", index);
            DynamicObject country = (DynamicObject)this.getView().getModel().getValue("country");
            long adminDivisionId = CommonUtil.formatObejctToLong((Object)this.getView().getModel().getValue("admindivisionid"));
            DynamicObject rule = GetDistributionRulesHelper.getRuleByMode((long)DynamicObjectUtil.getPkValue((DynamicObject)branch), (long)DynamicObjectUtil.getPkValue((DynamicObject)org), (DynamicObject)goods, (long)DynamicObjectUtil.getPkValue((DynamicObject)country), (long)adminDivisionId, (long)modeId);
            this.setRulesValue(rule, index);
        }
    }

    private void setRulesValue(DynamicObject rule, int index) {
        this.getView().getModel().setItemValueByID("stockid", (Object)DynamicObjectUtils.getPkValue((DynamicObject)rule, (String)"stock"), index);
        this.getView().getModel().setItemValueByID("inventoryorg", (Object)DynamicObjectUtil.getPkValue((DynamicObject)rule, (String)"inventoryorg"), index);
        this.getView().getModel().setItemValueByID("erpstock", (Object)DynamicObjectUtils.getPkValue((DynamicObject)rule, (String)"erpstock"), index);
    }
}

