/*
 * Decompiled with CFR 0.152.
 */
package kd.drp.pos.business.converthelper;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.entity.botp.runtime.ConvertOperationResult;
import kd.bos.entity.botp.runtime.PushArgs;
import kd.bos.entity.datamodel.ListSelectedRow;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.botp.ConvertServiceHelper;
import kd.bos.servicehelper.operation.OperationServiceHelper;

public class SalesOrderConvertHelper {
    private static final String RETAIL_ID = "retailId";
    private static final String FAIL_MSG = "failMsg";

    public static Map<String, Object> push(Object pkValue, String targetEntityNumber) {
        HashMap<String, Object> resultMap = new HashMap<String, Object>(1);
        ArrayList<ListSelectedRow> list = new ArrayList<ListSelectedRow>();
        ListSelectedRow listSelectedRow = new ListSelectedRow(pkValue);
        list.add(listSelectedRow);
        PushArgs pushArgs = new PushArgs("pos_salesorder", targetEntityNumber, list);
        ConvertOperationResult convertResult = ConvertServiceHelper.pushAndSave((PushArgs)pushArgs);
        Set targetBillIds = convertResult.getTargetBillIds();
        if (targetBillIds.size() != 0) {
            OperationResult submitOperation;
            Object billId = targetBillIds.iterator().next();
            DynamicObject retailObj = BusinessDataServiceHelper.loadSingle(billId, (String)targetEntityNumber);
            if ("ococ_retailbill".equals(targetEntityNumber)) {
                resultMap.put(RETAIL_ID, billId);
            }
            if (!(submitOperation = OperationServiceHelper.executeOperate((String)"submit", (String)targetEntityNumber, (DynamicObject[])new DynamicObject[]{retailObj}, (OperateOption)OperateOption.create())).isSuccess()) {
                resultMap.put(FAIL_MSG, submitOperation.getMessage());
                return resultMap;
            }
            OperationResult auditOpertion = OperationServiceHelper.executeOperate((String)"audit", (String)targetEntityNumber, (DynamicObject[])new DynamicObject[]{retailObj}, (OperateOption)OperateOption.create());
            if (!auditOpertion.isSuccess()) {
                String message = auditOpertion.getMessage();
                resultMap.put(FAIL_MSG, message);
                return resultMap;
            }
        } else {
            String message = convertResult.getMessage();
            if (message != null) {
                resultMap.put(FAIL_MSG, message);
            } else {
                List billReports = convertResult.getBillReports();
                resultMap.put(FAIL_MSG, billReports.get(0));
            }
        }
        return resultMap;
    }
}

