/*
 * Decompiled with CFR 0.152.
 */
package kd.drp.pos.business.invoice;

import com.alibaba.fastjson.JSONObject;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.earlywarn.kit.StringUtil;
import kd.bos.orm.ORM;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.drp.pos.business.retailorder.RetailOrderHelper;
import kd.drp.pos.common.util.AESUtil;
import kd.drp.pos.common.util.CloneUtil;
import kd.drp.pos.common.util.MD5Util;
import kd.drp.pos.common.util.WebUtil;
import kd.drp.pos.common.vo.Invoice;
import kd.drp.pos.common.vo.InvoiceGoodDetail;
import kd.drp.pos.common.vo.InvoiceResult;

public class InvoiceCloudService {
    public static final String INVCLOUD_TOKEN_URL = "/base/oauth/token";
    public static final String CREATEINVO_URL = "/m5/bill/invoice/create";
    public static final String QUERYINVOICE_URL = "/m7/bill/invoice/code/query";
    public static final String REVERSEINVOICE_URL = "/m5/bill/invoice/code/invalid";
    public static final String RETURNCODE = "errcode";
    public static final String RETURNMESSAGE = "description";
    public static final String RETURNDATA = "data";
    public static final String TOKEN = "access_token";
    public static final String CLIENDID = "client_id";
    public static final String SECRET = "client_secret";
    public static final String SIGN = "sign";
    private static final String CODETYPE_MD5 = "utf-8";
    public static final String SUCCESS = "0000";
    public static final String TIMESTAMP = "timestamp";
    private static final String NAME = "name";
    private static final String UNIT = "baseunitid";
    private static final String MODELNUM = "modelnum";
    private static final String PERSONAL_INVOICETYPE = "1";

    public static Invoice buildInvoiceInfo(DynamicObject saleOrder, DynamicObject retailOrder, String invoiceCloudType) {
        Invoice invoiceInfo = new Invoice();
        Boolean isPersonalInvoice = PERSONAL_INVOICETYPE.equalsIgnoreCase(saleOrder.getString("openquotype"));
        if (isPersonalInvoice.booleanValue()) {
            invoiceInfo.setBuyerName(saleOrder.getString(NAME));
            invoiceInfo.setMobileNumber(saleOrder.getString("phonenumber"));
            invoiceInfo.setBuyerEmail(saleOrder.getString("email"));
        } else {
            invoiceInfo.setBuyerName(saleOrder.getString("enterprisename"));
            invoiceInfo.setMobileNumber(saleOrder.getString("enterprisephone"));
            invoiceInfo.setBuyerEmail(saleOrder.getString("enterpriseemail"));
            invoiceInfo.setTelephoneNumber(saleOrder.getString("enterprisetel"));
            invoiceInfo.setAddress(saleOrder.getString("enterpriseaddr"));
            invoiceInfo.setBuyerTaxNo(saleOrder.getString("taxnumber"));
            invoiceInfo.setBuyerAccount(saleOrder.getString("bankaccount"));
        }
        invoiceInfo.setSerialNo(saleOrder.getString("billno"));
        invoiceInfo.setType(invoiceCloudType);
        invoiceInfo.setDrawer(saleOrder.getDynamicObject("saler").getString("operatorname"));
        invoiceInfo.setTaxFlag(PERSONAL_INVOICETYPE);
        invoiceInfo.setInventoryFlag("0");
        invoiceInfo.setInventoryProjectName("");
        invoiceInfo.setReviewer("");
        invoiceInfo.setRemark("");
        invoiceInfo.setPayee("");
        DynamicObjectCollection goodsList = retailOrder.getDynamicObjectCollection("entryentity");
        ArrayList<InvoiceGoodDetail> itemList = null;
        BigDecimal taxRate = BigDecimal.ZERO;
        if (goodsList.size() > 0) {
            DynamicObject unit = new DynamicObject();
            DynamicObject goods = new DynamicObject();
            DynamicObject taxclasscode = new DynamicObject();
            ArrayList<Long> taxClassCodeList = new ArrayList<Long>(goodsList.size());
            BigDecimal noinvoiceamount = retailOrder.getBigDecimal("noinvoiceamount");
            BigDecimal receamount = retailOrder.getBigDecimal("receamount");
            BigDecimal totalrealamount = retailOrder.getBigDecimal("totalrealamount");
            BigDecimal totalamount = retailOrder.getBigDecimal("totalamount");
            BigDecimal discountamount = retailOrder.getBigDecimal("discountamount");
            BigDecimal invoiceAmount = totalamount.subtract(noinvoiceamount).subtract(discountamount);
            BigDecimal invoiceTaxAmount = BigDecimal.ZERO;
            BigDecimal subAmount = BigDecimal.ZERO;
            if (totalrealamount.compareTo(totalamount) >= 0) {
                subAmount = totalrealamount.subtract(totalamount);
            }
            if (noinvoiceamount.compareTo(BigDecimal.ZERO) == 0 && discountamount.compareTo(BigDecimal.ZERO) == 0 || subAmount.compareTo(BigDecimal.ZERO) >= 0) {
                itemList = new ArrayList<InvoiceGoodDetail>(goodsList.size());
                for (int i = 0; i < goodsList.size(); ++i) {
                    InvoiceGoodDetail item = new InvoiceGoodDetail();
                    item.setDiscountType("0");
                    goods = ((DynamicObject)goodsList.get(i)).getDynamicObject("goodsid");
                    item.setGoodsName(goods.getString(NAME));
                    unit = ((DynamicObject)goodsList.get(i)).getDynamicObject(UNIT);
                    item.setUnit(unit.getString(NAME));
                    item.setSpecModel(goods.getString(MODELNUM));
                    BigDecimal qty = ((DynamicObject)goodsList.get(i)).getBigDecimal("qty");
                    item.setNum(qty);
                    item.setUnitPrice(((DynamicObject)goodsList.get(i)).getBigDecimal("priceandtax"));
                    item.setDetailAmount(((DynamicObject)goodsList.get(i)).getBigDecimal("amount"));
                    if (i == 0 && subAmount.compareTo(BigDecimal.ZERO) > 0) {
                        BigDecimal amtAddSub = ((DynamicObject)goodsList.get(i)).getBigDecimal("amount").add(subAmount);
                        item.setUnitPrice(amtAddSub.divide(qty, 8, 6));
                        item.setDetailAmount(amtAddSub);
                    }
                    taxRate = ((DynamicObject)goodsList.get(i)).getBigDecimal("taxrate").divide(new BigDecimal("100"), 2);
                    item.setTaxRate(taxRate);
                    item.setTaxAmount(((DynamicObject)goodsList.get(i)).getBigDecimal("taxamount"));
                    taxclasscode = goods.getDynamicObject("taxclasscodeid");
                    if (taxclasscode != null) {
                        item.setTaxClassCodeId(taxclasscode.getLong("Id"));
                    }
                    taxClassCodeList.add(item.getTaxClassCodeId());
                    item.setPreferentialPolicy("0");
                    item.setVatException("");
                    if (taxRate.compareTo(BigDecimal.ZERO) == 0) {
                        item.setZeroTaxRateFlag("3");
                    } else {
                        item.setZeroTaxRateFlag("");
                    }
                    itemList.add(item);
                }
                invoiceInfo.setAmount(retailOrder.getBigDecimal("notaxamount"));
                invoiceInfo.setTaxAmount(totalamount);
                invoiceInfo.setTotalTaxAmount(retailOrder.getBigDecimal("totaltaxamount"));
            } else {
                BigDecimal sumRowDiscountAmt = BigDecimal.ZERO;
                itemList = new ArrayList(2 * goodsList.size());
                int row = 0;
                for (int i = 0; i < goodsList.size(); ++i) {
                    InvoiceGoodDetail discountItem;
                    ++row;
                    InvoiceGoodDetail item = new InvoiceGoodDetail();
                    item.setDiscountType("2");
                    goods = ((DynamicObject)goodsList.get(i)).getDynamicObject("goodsid");
                    BigDecimal amount = ((DynamicObject)goodsList.get(i)).getBigDecimal("amount");
                    item.setGoodsName(goods.getString(NAME));
                    unit = ((DynamicObject)goodsList.get(i)).getDynamicObject(UNIT);
                    item.setUnit(unit.getString(NAME));
                    item.setSpecModel(goods.getString(MODELNUM));
                    BigDecimal qty = ((DynamicObject)goodsList.get(i)).getBigDecimal("qty");
                    item.setNum(qty);
                    item.setUnitPrice(((DynamicObject)goodsList.get(i)).getBigDecimal("priceandtax"));
                    item.setDetailAmount(amount);
                    taxRate = ((DynamicObject)goodsList.get(i)).getBigDecimal("taxrate").divide(new BigDecimal("100"), 2);
                    item.setTaxRate(taxRate);
                    BigDecimal rowTaxAmt = amount.divide(taxRate.add(BigDecimal.ONE), 10, 6).multiply(taxRate).setScale(2, 6);
                    item.setTaxAmount(rowTaxAmt);
                    taxclasscode = goods.getDynamicObject("taxclasscodeid");
                    if (taxclasscode != null) {
                        item.setTaxClassCodeId(taxclasscode.getLong("Id"));
                    }
                    taxClassCodeList.add(item.getTaxClassCodeId());
                    item.setPreferentialPolicy("0");
                    item.setVatException("");
                    if (taxRate.compareTo(BigDecimal.ZERO) == 0) {
                        item.setZeroTaxRateFlag("3");
                    } else {
                        item.setZeroTaxRateFlag("");
                    }
                    itemList.add(item);
                    invoiceTaxAmount = invoiceTaxAmount.add(rowTaxAmt);
                    BigDecimal rowDiscountAmt = amount.subtract(((DynamicObject)goodsList.get(i)).getBigDecimal("realamount"));
                    if (noinvoiceamount.compareTo(BigDecimal.ZERO) != 0) {
                        discountItem = new InvoiceGoodDetail();
                        discountItem = (InvoiceGoodDetail)CloneUtil.deepClone((Object)item);
                        BigDecimal balamount = ((DynamicObject)goodsList.get(i)).getBigDecimal("balamount");
                        discountItem.setDiscountType(PERSONAL_INVOICETYPE);
                        if (receamount.compareTo(BigDecimal.ZERO) == 0 || qty.compareTo(BigDecimal.ZERO) == 0) continue;
                        if (row < goodsList.size()) {
                            BigDecimal rowAmtRate = balamount.divide(receamount, 10, 6);
                            BigDecimal rowRateDivideAmt = noinvoiceamount.multiply(rowAmtRate).setScale(2, 6);
                            BigDecimal rowDiscountAll = rowRateDivideAmt.add(rowDiscountAmt);
                            BigDecimal rowRateTaxAmt = rowDiscountAll.divide(taxRate.add(BigDecimal.ONE), 10, 6).multiply(taxRate).setScale(2, 6);
                            sumRowDiscountAmt = sumRowDiscountAmt.add(rowRateDivideAmt);
                            discountItem.setUnitPrice(rowDiscountAll.divide(qty, 8, 6));
                            discountItem.setNum(qty.negate());
                            discountItem.setDetailAmount(rowDiscountAll.negate());
                            discountItem.setTaxAmount(rowRateTaxAmt.negate());
                            invoiceTaxAmount = invoiceTaxAmount.subtract(rowRateTaxAmt);
                        } else {
                            BigDecimal lastRowDiscountAmt = noinvoiceamount.subtract(sumRowDiscountAmt);
                            BigDecimal lastRowDiscountAll = lastRowDiscountAmt.add(rowDiscountAmt);
                            discountItem.setUnitPrice(lastRowDiscountAll.divide(qty, 8, 6));
                            discountItem.setNum(qty.negate());
                            discountItem.setDetailAmount(lastRowDiscountAll.negate());
                            BigDecimal rowRateTaxAmt = lastRowDiscountAll.divide(taxRate.add(BigDecimal.ONE), 10, 6).multiply(taxRate).setScale(2, 6);
                            discountItem.setTaxAmount(rowRateTaxAmt.negate());
                            invoiceTaxAmount = invoiceTaxAmount.subtract(rowRateTaxAmt);
                        }
                        itemList.add(discountItem);
                        continue;
                    }
                    if (rowDiscountAmt.compareTo(BigDecimal.ZERO) <= 0) continue;
                    discountItem = (InvoiceGoodDetail)CloneUtil.deepClone((Object)item);
                    discountItem.setDiscountType(PERSONAL_INVOICETYPE);
                    discountItem.setUnitPrice(rowDiscountAmt.divide(qty, 8, 6));
                    discountItem.setNum(qty.negate());
                    discountItem.setDetailAmount(rowDiscountAmt.negate());
                    BigDecimal rowRateTaxAmt = rowDiscountAmt.divide(taxRate.add(BigDecimal.ONE), 10, 6).multiply(taxRate).setScale(2, 6);
                    discountItem.setTaxAmount(rowRateTaxAmt.negate());
                    invoiceTaxAmount = invoiceTaxAmount.subtract(rowRateTaxAmt);
                    itemList.add(discountItem);
                }
                invoiceInfo.setAmount(invoiceAmount.subtract(invoiceTaxAmount));
                invoiceInfo.setTaxAmount(invoiceAmount);
                invoiceInfo.setTotalTaxAmount(invoiceTaxAmount);
            }
            InvoiceCloudService.setItemGoodsTaxCode(taxClassCodeList, itemList);
            saleOrder.set("invoiceamount", (Object)invoiceAmount);
        }
        invoiceInfo.setItemList(itemList);
        return invoiceInfo;
    }

    public static Invoice buildRedInvoiceInfo(DynamicObject saleOrder, DynamicObject sourceSaleOrder, DynamicObject retailOrder, String invoiceCloudType) {
        DynamicObjectCollection itemList;
        Invoice invoiceInfo = new Invoice();
        Boolean isPersonalInvoice = PERSONAL_INVOICETYPE.equalsIgnoreCase(saleOrder.getString("openquotype"));
        if (isPersonalInvoice.booleanValue()) {
            invoiceInfo.setBuyerName(saleOrder.getString(NAME));
            invoiceInfo.setMobileNumber(saleOrder.getString("phonenumber"));
            invoiceInfo.setBuyerEmail(saleOrder.getString("email"));
        } else {
            invoiceInfo.setBuyerName(saleOrder.getString("enterprisename"));
            invoiceInfo.setMobileNumber(saleOrder.getString("enterprisephone"));
            invoiceInfo.setBuyerEmail(saleOrder.getString("enterpriseemail"));
            invoiceInfo.setTelephoneNumber(saleOrder.getString("enterprisetel"));
            invoiceInfo.setAddress(saleOrder.getString("enterpriseaddr"));
            invoiceInfo.setBuyerTaxNo(saleOrder.getString("taxnumber"));
            invoiceInfo.setBuyerAccount(saleOrder.getString("bankaccount"));
        }
        invoiceInfo.setSerialNo(saleOrder.getString("billno"));
        invoiceInfo.setType(invoiceCloudType);
        invoiceInfo.setDrawer(saleOrder.getDynamicObject("saler").getString("operatorname"));
        if (PERSONAL_INVOICETYPE.equalsIgnoreCase(invoiceCloudType) && (itemList = sourceSaleOrder.getDynamicObjectCollection("goodsentryentity")).size() > 0) {
            DynamicObject queryOrder;
            DynamicObject srcRetailOrder;
            DynamicObjectCollection invoiceList;
            String retailOrderNo = "";
            for (DynamicObject item : itemList) {
                if (item.getBoolean("isbook")) continue;
                retailOrderNo = item.getString("lastbillno");
                break;
            }
            if ((invoiceList = (srcRetailOrder = BusinessDataServiceHelper.loadSingle((Object)(queryOrder = RetailOrderHelper.getRetailOrderByBillNo(retailOrderNo)).getPkValue(), (String)"ococ_retailbill")).getDynamicObjectCollection("finvoiceentity")).size() > 0) {
                invoiceInfo.setOriginalInvoiceCode(((DynamicObject)invoiceList.get(0)).getString("code"));
                invoiceInfo.setOriginalInvoiceNo(((DynamicObject)invoiceList.get(0)).getString("number"));
            }
        }
        invoiceInfo.setTaxFlag(PERSONAL_INVOICETYPE);
        invoiceInfo.setInventoryFlag("0");
        invoiceInfo.setInventoryProjectName("");
        invoiceInfo.setReviewer("");
        invoiceInfo.setRemark("");
        invoiceInfo.setPayee("");
        DynamicObjectCollection goodsList = retailOrder.getDynamicObjectCollection("entryentity");
        ArrayList<InvoiceGoodDetail> itemList2 = null;
        BigDecimal taxRate = BigDecimal.ZERO;
        if (goodsList.size() > 0) {
            BigDecimal hasredinvoiceAmount;
            DynamicObject unit = new DynamicObject();
            DynamicObject goods = new DynamicObject();
            DynamicObject taxclasscode = new DynamicObject();
            ArrayList<Long> taxClassCodeList = new ArrayList<Long>(goodsList.size());
            BigDecimal noinvoiceamount = retailOrder.getBigDecimal("noinvoiceamount");
            BigDecimal receamount = retailOrder.getBigDecimal("receamount");
            BigDecimal ignoredecimalamt = retailOrder.getBigDecimal("ignoredecimalamt");
            BigDecimal totaltaxamount = retailOrder.getBigDecimal("totaltaxamount");
            BigDecimal invoiceAmount = BigDecimal.ZERO;
            BigDecimal invoiceTaxAmount = BigDecimal.ZERO;
            invoiceAmount = receamount.subtract(noinvoiceamount);
            BigDecimal hasinvoiceAmount = sourceSaleOrder.getBigDecimal("invoiceamount");
            BigDecimal subInvoiceAmt = hasinvoiceAmount.subtract(hasredinvoiceAmount = sourceSaleOrder.getBigDecimal("redinvoiceamount"));
            if (subInvoiceAmt.compareTo(BigDecimal.ZERO) > 0 && invoiceAmount.abs().compareTo(subInvoiceAmt) > 0) {
                invoiceAmount = subInvoiceAmt.negate();
                noinvoiceamount = receamount.subtract(invoiceAmount);
            }
            if (noinvoiceamount.compareTo(ignoredecimalamt) == 0) {
                invoiceTaxAmount = totaltaxamount;
            }
            int row = 0;
            BigDecimal sumRowRealAmount = BigDecimal.ZERO;
            itemList2 = new ArrayList<InvoiceGoodDetail>(goodsList.size());
            for (int i = 0; i < goodsList.size(); ++i) {
                InvoiceGoodDetail item = new InvoiceGoodDetail();
                item.setDiscountType("0");
                goods = ((DynamicObject)goodsList.get(i)).getDynamicObject("goodsid");
                item.setGoodsName(goods.getString(NAME));
                unit = ((DynamicObject)goodsList.get(i)).getDynamicObject(UNIT);
                item.setUnit(unit.getString(NAME));
                item.setSpecModel(goods.getString(MODELNUM));
                BigDecimal qty = ((DynamicObject)goodsList.get(i)).getBigDecimal("qty");
                if (qty.compareTo(BigDecimal.ZERO) == 0) {
                    qty = BigDecimal.ONE.negate();
                }
                item.setNum(qty);
                taxRate = ((DynamicObject)goodsList.get(i)).getBigDecimal("taxrate").divide(new BigDecimal("100"), 2);
                item.setTaxRate(taxRate);
                if (noinvoiceamount.compareTo(ignoredecimalamt) == 0) {
                    BigDecimal realamount = ((DynamicObject)goodsList.get(i)).getBigDecimal("balamount");
                    BigDecimal realprice = realamount.divide(qty, 6, 6);
                    BigDecimal taxamount = ((DynamicObject)goodsList.get(i)).getBigDecimal("taxamount");
                    item.setUnitPrice(realprice);
                    item.setDetailAmount(realamount);
                    item.setTaxAmount(taxamount);
                } else if (row < goodsList.size()) {
                    BigDecimal balamount = ((DynamicObject)goodsList.get(i)).getBigDecimal("balamount");
                    if (receamount.compareTo(BigDecimal.ZERO) == 0) continue;
                    BigDecimal rowAmtRate = balamount.divide(receamount, 10, 6);
                    BigDecimal rowRealAmount = invoiceAmount.multiply(rowAmtRate).setScale(2, 6);
                    BigDecimal rowRateTaxAmt = rowRealAmount.divide(taxRate.add(BigDecimal.ONE), 10, 6).multiply(taxRate).setScale(2, 6);
                    item.setUnitPrice(rowRealAmount.divide(qty, 2, 6));
                    item.setDetailAmount(rowRealAmount);
                    item.setTaxAmount(rowRateTaxAmt);
                    sumRowRealAmount = sumRowRealAmount.add(rowRealAmount);
                    invoiceTaxAmount = invoiceTaxAmount.add(rowRateTaxAmt);
                } else {
                    BigDecimal lastRowShareAmt = invoiceAmount.subtract(sumRowRealAmount);
                    item.setUnitPrice(lastRowShareAmt.divide(qty, 2, 6));
                    item.setDetailAmount(lastRowShareAmt);
                    BigDecimal LastRowTaxAmt = lastRowShareAmt.divide(taxRate.add(BigDecimal.ONE), 10, 6).multiply(taxRate).setScale(2, 6);
                    item.setTaxAmount(LastRowTaxAmt);
                    invoiceTaxAmount = invoiceTaxAmount.add(LastRowTaxAmt);
                }
                taxclasscode = goods.getDynamicObject("taxclasscodeid");
                if (taxclasscode != null) {
                    item.setTaxClassCodeId(taxclasscode.getLong("Id"));
                }
                taxClassCodeList.add(item.getTaxClassCodeId());
                item.setPreferentialPolicy("0");
                item.setVatException("");
                if (taxRate.compareTo(BigDecimal.ZERO) == 0) {
                    item.setZeroTaxRateFlag("3");
                } else {
                    item.setZeroTaxRateFlag("");
                }
                itemList2.add(item);
            }
            invoiceInfo.setAmount(invoiceAmount.subtract(invoiceTaxAmount));
            invoiceInfo.setTaxAmount(invoiceAmount);
            invoiceInfo.setTotalTaxAmount(invoiceTaxAmount);
            InvoiceCloudService.setItemGoodsTaxCode(taxClassCodeList, itemList2);
            sourceSaleOrder.set("redinvoiceamount", (Object)sourceSaleOrder.getBigDecimal("redinvoiceamount").add(invoiceAmount.abs()));
        }
        invoiceInfo.setItemList(itemList2);
        return invoiceInfo;
    }

    private static void setItemGoodsTaxCode(List<Long> taxClassCodeList, List<InvoiceGoodDetail> itemList) {
        QFilter filter;
        ORM orm = ORM.create();
        DynamicObjectCollection retailOrder = orm.query("er_taxclasscode", "Id,mergecode", (filter = new QFilter("Id", "in", taxClassCodeList)).toArray());
        if (retailOrder.size() > 0) {
            HashMap map = new HashMap(retailOrder.size());
            retailOrder.forEach(result -> map.put(result.getLong("Id"), result.getString("mergecode")));
            for (InvoiceGoodDetail detail : itemList) {
                detail.setGoodsCode((String)map.get(detail.getTaxClassCodeId()));
            }
        }
    }

    public static String getInvoiceToken(String clientId, String appSecret, long timestamp, String invoiceCloudUrl) throws Exception {
        String sign = MD5Util.MD5Encode((String)(clientId + appSecret + timestamp), (String)CODETYPE_MD5);
        JSONObject postParams = new JSONObject();
        postParams.put(CLIENDID, (Object)clientId);
        postParams.put(SIGN, (Object)sign);
        postParams.put(TIMESTAMP, (Object)timestamp);
        JSONObject returnMsg = JSONObject.parseObject((String)WebUtil.httpClientPost((String)(invoiceCloudUrl + INVCLOUD_TOKEN_URL), (String)"POST", (String)postParams.toString()));
        if (returnMsg == null) {
            throw new Exception("\u83b7\u53d6token\u8bf7\u6c42\u53d1\u9001\u5931\u8d25\u3002");
        }
        if (SUCCESS.equalsIgnoreCase(returnMsg.getString(RETURNCODE))) {
            return returnMsg.getString(TOKEN);
        }
        throw new Exception("\u83b7\u53d6token\u5931\u8d25\uff0c\u539f\u56e0\uff1a" + returnMsg.getString(RETURNMESSAGE));
    }

    public static InvoiceResult getCreateInvoiceResult(String token, String aesKey, Invoice invoiceInfo, String invoiceCloudUrl) {
        InvoiceResult result = new InvoiceResult();
        String getInvoiceUrl = invoiceCloudUrl + CREATEINVO_URL + "?access_token=" + token;
        JSONObject invoiceJson = new JSONObject();
        invoiceJson.put("serialNo", (Object)invoiceInfo.getSerialNo());
        invoiceJson.put("taxFlag", (Object)invoiceInfo.getTaxFlag());
        invoiceJson.put("inventoryFlag", (Object)invoiceInfo.getInventoryFlag());
        invoiceJson.put("inventoryProjectName", (Object)invoiceInfo.getInventoryProjectName());
        invoiceJson.put("buyerFixedTelephone", (Object)invoiceInfo.getTelephoneNumber());
        invoiceJson.put("buyerAddress", (Object)invoiceInfo.getAddress());
        invoiceJson.put("buyerName", (Object)invoiceInfo.getBuyerName());
        invoiceJson.put("buyerTaxNo", (Object)invoiceInfo.getBuyerTaxNo());
        invoiceJson.put("buyerAccount", (Object)invoiceInfo.getBuyerAccount());
        String mobileNumber = invoiceInfo.getMobileNumber();
        if (mobileNumber.length() > 11) {
            mobileNumber = mobileNumber.substring(3).replace("-", "");
        }
        invoiceJson.put("buyerMobilePhone", (Object)mobileNumber);
        invoiceJson.put("buyerEmail", (Object)invoiceInfo.getBuyerEmail());
        invoiceJson.put("invoiceAmount", (Object)invoiceInfo.getAmount().stripTrailingZeros().toPlainString());
        invoiceJson.put("totalAmount", (Object)invoiceInfo.getTaxAmount().stripTrailingZeros().toPlainString());
        invoiceJson.put("totalTaxAmount", (Object)invoiceInfo.getTotalTaxAmount().stripTrailingZeros().toPlainString());
        invoiceJson.put("type", (Object)invoiceInfo.getType());
        invoiceJson.put("drawer", (Object)invoiceInfo.getDrawer());
        invoiceJson.put("reviewer", (Object)invoiceInfo.getReviewer());
        invoiceJson.put("payee", (Object)invoiceInfo.getPayee());
        invoiceJson.put("originalInvoiceCode", (Object)invoiceInfo.getOriginalInvoiceCode());
        invoiceJson.put("originalInvoiceNo", (Object)invoiceInfo.getOriginalInvoiceNo());
        invoiceJson.put("remark", (Object)invoiceInfo.getRemark());
        invoiceJson.put("items", (Object)invoiceInfo.getItemList());
        try {
            String data = AESUtil.encrypt((String)invoiceJson.toString(), (String)aesKey);
            JSONObject createResult = JSONObject.parseObject((String)WebUtil.httpClientPost((String)getInvoiceUrl, (String)"POST", (String)data));
            if (createResult == null) {
                return new InvoiceResult(false, "\u8c03\u7528\u53d1\u7968\u4e91\u751f\u6210\u53d1\u7968\u63a5\u53e3\u5931\u8d25\u3002");
            }
            boolean isSuccess = SUCCESS.equalsIgnoreCase(createResult.getString(RETURNCODE));
            result.setSuccess(isSuccess);
            result.setErrorMessage(createResult.getString(RETURNMESSAGE));
            if (isSuccess) {
                JSONObject invoiceResult = createResult.getJSONObject(RETURNDATA);
                Invoice invoice = new Invoice();
                invoice.setInvoiceCode(invoiceResult.getString("invoiceCode"));
                invoice.setInvoiceNo(invoiceResult.getString("invoiceNo"));
                result.setToken(token);
                result.setInvoiceInfo(invoice);
            }
            return result;
        }
        catch (Exception e) {
            return new InvoiceResult(false, "\u53d1\u7968\u751f\u6210\u8bf7\u6c42\u53d1\u9001\u5931\u8d25\u3002");
        }
    }

    public static InvoiceResult getInvoiceInfo(String token, String aesKey, String invoiceCode, String invoiceNo, String invoiceCloudUrl) {
        String getInvoiceUrl = invoiceCloudUrl + QUERYINVOICE_URL + "?access_token=" + token;
        JSONObject invoiceMap = new JSONObject();
        invoiceMap.put("invoiceCode", (Object)invoiceCode);
        invoiceMap.put("invoiceNo", (Object)invoiceNo);
        try {
            String requestData = AESUtil.encrypt((String)invoiceMap.toString(), (String)aesKey);
            JSONObject result = JSONObject.parseObject((String)WebUtil.httpClientPost((String)getInvoiceUrl, (String)"POST", (String)requestData));
            if (result == null) {
                return new InvoiceResult(false, "\u53d1\u9001\u83b7\u53d6\u53d1\u7968\u4fe1\u606f\u8bf7\u6c42\u5931\u8d25\u3002");
            }
            boolean isSuccess = SUCCESS.equalsIgnoreCase(result.getString(RETURNCODE));
            InvoiceResult invoiceResult = new InvoiceResult();
            invoiceResult.setSuccess(isSuccess);
            if (isSuccess) {
                JSONObject queryInvoice = result.getJSONObject(RETURNDATA);
                Invoice invoiceInfo = new Invoice();
                invoiceInfo.setDataTime(queryInvoice.getDate("invoiceDate"));
                invoiceInfo.setBuyerName(queryInvoice.getString("buyerName"));
                invoiceInfo.setAmount(queryInvoice.getBigDecimal("invoiceAmount"));
                invoiceInfo.setInvoiceNo(queryInvoice.getString("invoiceNo"));
                invoiceInfo.setInvoiceCode(queryInvoice.getString("invoiceCode"));
                invoiceInfo.setBuyerTaxNo(queryInvoice.getString("buyerTaxNo"));
                invoiceInfo.setBuyerAccount(queryInvoice.getString("buyerAccount"));
                invoiceInfo.setAddress(queryInvoice.getString("salerAddressPhone"));
                invoiceResult.setInvoiceInfo(invoiceInfo);
            } else {
                invoiceResult.setErrorMessage("\u67e5\u8be2\u53d1\u7968\u4fe1\u606f\u5931\u8d25\uff0c\u5931\u8d25\u539f\u56e0\u662f\uff1a" + result.getString(RETURNMESSAGE));
            }
            return invoiceResult;
        }
        catch (Exception e) {
            return new InvoiceResult(false, "\u8c03\u7528\u67e5\u8be2\u53d1\u7968API\u5931\u8d25\u3002");
        }
    }

    public static String checkInvoiceInfo(Invoice invoiceInfo) {
        if (invoiceInfo == null) {
            return "\u53d1\u7968\u4fe1\u606f\u4f20\u8f93\u6709\u8bef\uff0c\u8bf7\u786e\u8ba4\u3002";
        }
        if (StringUtil.isEmpty((CharSequence)invoiceInfo.getTaxFlag())) {
            return "\u542b\u7a0e\u6807\u8bb0\u4e0d\u80fd\u4e3a\u7a7a\u3002";
        }
        if (StringUtil.isEmpty((CharSequence)invoiceInfo.getBuyerName())) {
            return "\u8d2d\u4e70\u65b9\u540d\u79f0\u4e0d\u80fd\u4e3a\u7a7a\u3002";
        }
        if (BigDecimal.ZERO.compareTo(invoiceInfo.getAmount()) == 0) {
            return "\u91d1\u989d\u5408\u8ba1(\u4e0d\u542b\u7a0e)\u4e0d\u80fd\u4e3a0\u3002";
        }
        if (BigDecimal.ZERO.compareTo(invoiceInfo.getTaxAmount()) == 0) {
            return "\u4ef7\u7a0e\u5408\u8ba1\u4e0d\u80fd\u4e3a0";
        }
        if (StringUtil.isEmpty((CharSequence)invoiceInfo.getType())) {
            return "\u5f00\u7968\u7c7b\u578b\u4e0d\u80fd\u4e3a\u7a7a";
        }
        if (StringUtil.isEmpty((CharSequence)invoiceInfo.getDrawer())) {
            return "\u5f00\u7968\u4eba\u4e0d\u80fd\u4e3a\u7a7a";
        }
        List itemList = invoiceInfo.getItemList();
        if (CollectionUtils.isEmpty((Collection)itemList)) {
            return "\u53d1\u7968\u660e\u7ec6\u4e0d\u80fd\u4e3a\u7a7a";
        }
        for (InvoiceGoodDetail item : itemList) {
            if (StringUtil.isEmpty((CharSequence)item.getDiscountType())) {
                return "\u6298\u6263\u7c7b\u578b\u4e0d\u80fd\u4e3a\u7a7a\u3002";
            }
            if (BigDecimal.ZERO.compareTo(item.getDetailAmount()) == 0) {
                return "\u5546\u54c1\u603b\u4ef7\u4e0d\u80fd\u4e3a0\u3002";
            }
            if (BigDecimal.ZERO.compareTo(item.getTaxRate()) > 0) {
                return "\u5546\u54c1\u7a0e\u7387\u4e0d\u80fd\u5c0f\u4e8e0\u3002";
            }
            if (!StringUtil.isEmpty((CharSequence)item.getGoodsCode()) && item.getGoodsCode().length() == 19) continue;
            return "\u5546\u54c1\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a\uff0c\u4e14\u957f\u5ea6\u5fc5\u987b\u4e3a19\u4f4d\u3002";
        }
        return "";
    }

    public static Invoice buildReverseInvoiceInfo(DynamicObject saleOrder, DynamicObject sourceSaleOrder) throws Exception {
        DynamicObjectCollection itemList = sourceSaleOrder.getDynamicObjectCollection("goodsentryentity");
        if (itemList.size() > 0) {
            String retailOrderNo = "";
            for (DynamicObject item : itemList) {
                if (item.getBoolean("isbook")) continue;
                retailOrderNo = item.getString("lastbillno");
                break;
            }
            if (StringUtils.isEmpty((CharSequence)retailOrderNo)) {
                throw new Exception(String.format("\u5355\u636e\u7f16\u53f7\u4e3a%s\u7684\u96f6\u552e\u5f00\u5355\u627e\u4e0d\u5230\u5bf9\u5e94\u7684\u96f6\u552e\u5355\uff0c\u65e0\u6cd5\u5f00\u53d1\u7968\uff0c\u8bf7\u5148\u4e0b\u63a8\u751f\u6210\u96f6\u552e\u5355\u3002", saleOrder.getString("sourcebillno")));
            }
            DynamicObject queryOrder = RetailOrderHelper.getRetailOrderByBillNo(retailOrderNo);
            DynamicObject retailOrder = BusinessDataServiceHelper.loadSingle((Object)queryOrder.getPkValue(), (String)"ococ_retailbill");
            DynamicObjectCollection invoiceList = retailOrder.getDynamicObjectCollection("finvoiceentity");
            String invoiceCode = null;
            String invoiceNo = null;
            if (invoiceList.size() > 0) {
                invoiceCode = ((DynamicObject)invoiceList.get(0)).getString("code");
                invoiceNo = ((DynamicObject)invoiceList.get(0)).getString("number");
                BigDecimal invoiceamount = ((DynamicObject)invoiceList.get(0)).getBigDecimal("invoiceamount");
                sourceSaleOrder.set("redinvoiceamount", (Object)sourceSaleOrder.getBigDecimal("redinvoiceamount").add(invoiceamount.abs()));
            }
            if (invoiceCode == null || invoiceNo == null) {
                throw new Exception(String.format("\u5355\u636e\u7f16\u53f7\u4e3a%s\u7684\u96f6\u552e\u5f00\u5355\u5bf9\u5e94\u7684\u96f6\u552e\u5355\u5f00\u7968\u5931\u8d25\uff0c\u65e0\u6cd5\u7ea2\u51b2\u53d1\u7968\u3002", saleOrder.getString("sourcebillno")));
            }
            Invoice invoiceInfo = new Invoice();
            invoiceInfo.setInvoiceCode(invoiceCode);
            invoiceInfo.setInvoiceNo(invoiceNo);
            return invoiceInfo;
        }
        throw new Exception(String.format("\u5355\u636e\u7f16\u53f7\u4e3a%s\u7684\u96f6\u552e\u5f00\u5355\u5bf9\u5e94\u7684\u96f6\u552e\u5355\u5546\u54c1\u4fe1\u606f\u6709\u8bef\uff0c\u65e0\u6cd5\u7ea2\u51b2\u53d1\u7968\u3002", saleOrder.getString("sourcebillno")));
    }

    public static InvoiceResult getReverseInvoiceResult(String token, String aesKey, Invoice invoiceInfo, String invoiceCloudUrl) {
        InvoiceResult reverseResult = new InvoiceResult();
        String getInvoiceUrl = invoiceCloudUrl + REVERSEINVOICE_URL + "?access_token=" + token;
        JSONObject invoiceMap = new JSONObject();
        invoiceMap.put("invoiceCode", (Object)invoiceInfo.getInvoiceCode());
        invoiceMap.put("invoiceNo", (Object)invoiceInfo.getInvoiceNo());
        try {
            String requestData = AESUtil.encrypt((String)invoiceMap.toString(), (String)aesKey);
            JSONObject result = JSONObject.parseObject((String)WebUtil.httpClientPost((String)getInvoiceUrl, (String)"POST", (String)requestData));
            if (result == null) {
                return new InvoiceResult(false, "\u8c03\u7528\u7ea2\u51b2\u53d1\u7968\u63a5\u53e3\u5931\u8d25\u3002");
            }
            boolean isSuccess = SUCCESS.equalsIgnoreCase(result.getString(RETURNCODE));
            reverseResult.setSuccess(isSuccess);
            reverseResult.setErrorMessage(result.getString(RETURNMESSAGE));
            if (isSuccess) {
                JSONObject invoiceResult = result.getJSONObject(RETURNDATA);
                Invoice invoice = new Invoice();
                invoice.setInvoiceCode(invoiceResult.getString("invoiceCode"));
                invoice.setInvoiceNo(invoiceResult.getString("invoiceNo"));
                reverseResult.setToken(token);
                reverseResult.setInvoiceInfo(invoice);
            }
            return reverseResult;
        }
        catch (Exception e) {
            return new InvoiceResult(false, "\u7ea2\u51b2\u53d1\u7968\u8bf7\u6c42\u53d1\u9001\u5931\u8d25\u3002");
        }
    }
}

