/*
 * Decompiled with CFR 0.152.
 */
package kd.drp.pos.business.invoice;

import java.math.BigDecimal;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.earlywarn.kit.StringUtil;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.drp.pos.business.invoice.InvoiceCloudCfgHelper;
import kd.drp.pos.business.invoice.InvoiceCloudService;
import kd.drp.pos.business.retailorder.RetailOrderHelper;
import kd.drp.pos.common.saleorder.BizTypeEnum;
import kd.drp.pos.common.vo.Invoice;
import kd.drp.pos.common.vo.InvoiceConfig;
import kd.drp.pos.common.vo.InvoiceResult;

public class InvoiceHelper {
    public static String reCreateInvoice(Object saleOrderId) {
        BigDecimal ignoredecimalamt;
        BigDecimal totalrealamount;
        DynamicObject saleOrder = BusinessDataServiceHelper.loadSingle((Object)saleOrderId, (String)"pos_salesorder");
        String needInvoice = saleOrder.getString("openquotype");
        if ("0".equalsIgnoreCase(needInvoice)) {
            return String.format("\u5355\u636e\u7f16\u53f7\u4e3a%s\u7684\u96f6\u552e\u5f00\u5355\u7684\u5f00\u7968\u4fe1\u606f\u4e3a\u201c\u4e0d\u5f00\u7968\u201d\uff0c\u65e0\u9700\u5f00\u53d1\u7968\u3002", saleOrder.getString("billno"));
        }
        String billType = saleOrder.getString("biztype");
        String invoiceCloudType = "0";
        if (billType.equalsIgnoreCase(BizTypeEnum.SALEORDER.getValue())) {
            return String.format("\u5355\u636e\u7f16\u53f7\u4e3a%s\u7684\u96f6\u552e\u5f00\u5355\u4e1a\u52a1\u7c7b\u578b\u4e3a\u201c\u9884\u8ba2\u5f00\u5355\u201d\uff0c\u65e0\u9700\u5f00\u53d1\u7968\u3002", saleOrder.getString("billno"));
        }
        if (billType.equalsIgnoreCase(BizTypeEnum.SALERETURN.getValue())) {
            invoiceCloudType = "1";
        }
        DynamicObjectCollection itemList = saleOrder.getDynamicObjectCollection("goodsentryentity");
        Object retailOrderId = null;
        if (itemList.size() > 0) {
            String retailOrderNo = "";
            for (DynamicObject item : itemList) {
                if (item.getBoolean("isbook")) continue;
                retailOrderNo = item.getString("lastbillno");
                break;
            }
            if (StringUtils.isEmpty((CharSequence)retailOrderNo)) {
                return String.format("\u5355\u636e\u7f16\u53f7\u4e3a%s\u7684\u96f6\u552e\u5f00\u5355\u627e\u4e0d\u5230\u5bf9\u5e94\u7684\u96f6\u552e\u5355\uff0c\u65e0\u6cd5\u5f00\u53d1\u7968\uff0c\u8bf7\u5148\u4e0b\u63a8\u751f\u6210\u96f6\u552e\u5355\u3002", saleOrder.getString("billno"));
            }
            DynamicObject retailOrder = RetailOrderHelper.getRetailOrderByBillNo(retailOrderNo);
            retailOrderId = retailOrder.getPkValue();
        }
        if (retailOrderId == null) {
            return String.format("\u5355\u636e\u7f16\u53f7\u4e3a%s\u7684\u96f6\u552e\u5f00\u5355\u672a\u4e0b\u63a8\u751f\u6210\u96f6\u552e\u5355\uff0c\u8bf7\u5148\u4e0b\u63a8\u3002", saleOrder.getString("billno"));
        }
        DynamicObject retailOrder = BusinessDataServiceHelper.loadSingle(retailOrderId, (String)"ococ_retailbill");
        BigDecimal noinvoiceamount = retailOrder.getBigDecimal("noinvoiceamount");
        if (noinvoiceamount.compareTo((totalrealamount = retailOrder.getBigDecimal("totalrealamount")).add(ignoredecimalamt = retailOrder.getBigDecimal("ignoredecimalamt"))) == 0) {
            return "\u5f00\u7968\u91d1\u989d\u4e0d\u80fd\u4e3a0\u3002";
        }
        return InvoiceHelper.createInvoice(saleOrder, retailOrder, invoiceCloudType);
    }

    public static String createInvoice(DynamicObject saleOrder, DynamicObject retailOrder, String invoiceCloudType) {
        DynamicObject org = saleOrder.getDynamicObject("bizorgid");
        DynamicObject branch = saleOrder.getDynamicObject("salebranchid");
        InvoiceConfig invoiceCfg = InvoiceCloudCfgHelper.getInvoiceConfig(org.getPkValue(), branch.getPkValue());
        if (invoiceCfg == null) {
            return "\u8bf7\u5148\u914d\u7f6e\u53d1\u7968\u4e91\u914d\u7f6e\u3002";
        }
        if (StringUtil.isEmpty((CharSequence)invoiceCfg.getInvoiceCloudUrl())) {
            return "\u8bf7\u5148\u914d\u7f6e\u53d1\u7968\u4e91\u5730\u5740\u3002";
        }
        String clientId = invoiceCfg.getClientId();
        String appSecret = invoiceCfg.getClientSecret();
        String aesKey = invoiceCfg.getAesKey();
        InvoiceResult invoiceResult = new InvoiceResult();
        Invoice invoiceInfo = new Invoice();
        if ("1".equalsIgnoreCase(invoiceCloudType)) {
            try {
                BigDecimal ignoredecimalamt;
                DynamicObject sourceBill = saleOrder.getDynamicObject("sourcebillid");
                Object sourceBillId = sourceBill.getPkValue();
                DynamicObject sourceSaleOrder = BusinessDataServiceHelper.loadSingle((Object)sourceBillId, (String)"pos_salesorder");
                BigDecimal hasinvoiceAmount = sourceSaleOrder.getBigDecimal("invoiceamount");
                BigDecimal hasredinvoiceAmount = sourceSaleOrder.getBigDecimal("redinvoiceamount");
                BigDecimal subInvoiceAmt = hasinvoiceAmount.subtract(hasredinvoiceAmount);
                if (subInvoiceAmt.compareTo(BigDecimal.ZERO) <= 0) {
                    return "\u53d1\u7968\u5df2\u5168\u90e8\u51b2\u7ea2\u3002";
                }
                BigDecimal noinvoiceamount = retailOrder.getBigDecimal("noinvoiceamount");
                if (noinvoiceamount.compareTo(ignoredecimalamt = retailOrder.getBigDecimal("ignoredecimalamt")) >= 0) {
                    invoiceInfo = InvoiceCloudService.buildRedInvoiceInfo(saleOrder, sourceSaleOrder, retailOrder, invoiceCloudType);
                    invoiceResult = InvoiceHelper.createInvoiceByInvoiceCloud(clientId, appSecret, aesKey, invoiceInfo, invoiceCfg.getInvoiceCloudUrl());
                }
                invoiceInfo = InvoiceCloudService.buildReverseInvoiceInfo(saleOrder, sourceSaleOrder);
                invoiceResult = InvoiceHelper.reverseInvoiceByInvoiceCloud(clientId, appSecret, aesKey, invoiceInfo, invoiceCfg.getInvoiceCloudUrl());
            }
            catch (Exception e) {
                return "\u6784\u9020\u7ea2\u51b2\u53d1\u7968\u4fe1\u606f\u5931\u8d25\uff0c\u539f\u56e0\u662f\uff1a" + e.getMessage();
            }
        } else {
            invoiceInfo = InvoiceCloudService.buildInvoiceInfo(saleOrder, retailOrder, invoiceCloudType);
            invoiceResult = InvoiceHelper.createInvoiceByInvoiceCloud(clientId, appSecret, aesKey, invoiceInfo, invoiceCfg.getInvoiceCloudUrl());
        }
        if (!invoiceResult.isSuccess()) {
            return "\u8c03\u7528\u53d1\u7968\u4e91API\u5931\u8d25\uff0c\u539f\u56e0\u662f\uff1a" + invoiceResult.getErrorMessage();
        }
        SaveServiceHelper.update((DynamicObject)saleOrder);
        String token = invoiceResult.getToken();
        String invoiceCode = invoiceResult.getInvoiceInfo().getInvoiceCode();
        String invoiceNo = invoiceResult.getInvoiceInfo().getInvoiceNo();
        InvoiceResult queryResult = InvoiceHelper.queryInvoiceByInvoiceCloud(token, aesKey, invoiceCode, invoiceNo, invoiceCfg.getInvoiceCloudUrl());
        if (!queryResult.isSuccess()) {
            return queryResult.getErrorMessage();
        }
        Invoice queryInvoice = queryResult.getInvoiceInfo();
        String invoiceType = saleOrder.getString("openquotype");
        RetailOrderHelper.createRetailOrderInvoiceInfo(retailOrder, invoiceType, queryInvoice);
        return "";
    }

    private static InvoiceResult reverseInvoiceByInvoiceCloud(String clientId, String appSecret, String aesKey, Invoice invoiceInfo, String invoiceCloudUrl) {
        try {
            String token = InvoiceCloudService.getInvoiceToken(clientId, appSecret, System.currentTimeMillis(), invoiceCloudUrl);
            return InvoiceCloudService.getReverseInvoiceResult(token, aesKey, invoiceInfo, invoiceCloudUrl);
        }
        catch (Exception e) {
            return new InvoiceResult(false, e.getMessage());
        }
    }

    public static InvoiceResult createInvoiceByInvoiceCloud(String clientId, String appSecret, String aesKey, Invoice invoiceInfo, String invoiceCloudUrl) {
        String checkResult = InvoiceCloudService.checkInvoiceInfo(invoiceInfo);
        if (StringUtil.isNotEmpty((CharSequence)checkResult)) {
            return new InvoiceResult(false, checkResult);
        }
        try {
            String token = InvoiceCloudService.getInvoiceToken(clientId, appSecret, System.currentTimeMillis(), invoiceCloudUrl);
            return InvoiceCloudService.getCreateInvoiceResult(token, aesKey, invoiceInfo, invoiceCloudUrl);
        }
        catch (Exception e) {
            return new InvoiceResult(false, e.getMessage() + invoiceInfo.getRemark());
        }
    }

    public static InvoiceResult queryInvoiceByInvoiceCloud(String clientId, String appSecret, String aesKey, String invoiceCode, String invoiceNo, String invoiceCloudUrl) {
        if (StringUtil.isEmpty((CharSequence)invoiceCode) || StringUtil.isEmpty((CharSequence)invoiceNo)) {
            return new InvoiceResult(false, "\u53d1\u7968\u53f7\u7801\u548c\u53d1\u7968\u4ee3\u53f7\u4e0d\u80fd\u4e3a\u7a7a\u3002");
        }
        try {
            String token = InvoiceCloudService.getInvoiceToken(clientId, appSecret, System.currentTimeMillis(), invoiceCloudUrl);
            return InvoiceCloudService.getInvoiceInfo(token, aesKey, invoiceCode, invoiceNo, invoiceCloudUrl);
        }
        catch (Exception e) {
            return new InvoiceResult(false, e.getMessage());
        }
    }

    public static InvoiceResult queryInvoiceByInvoiceCloud(String token, String aesKey, String invoiceCode, String invoiceNo, String invoiceCloudUrl) {
        if (StringUtil.isEmpty((CharSequence)invoiceCode) || StringUtil.isEmpty((CharSequence)invoiceNo) || StringUtil.isEmpty((CharSequence)invoiceCloudUrl)) {
            return new InvoiceResult(false, "\u53d1\u7968\u53f7\u7801\u548c\u53d1\u7968\u4ee3\u53f7\u4e0d\u80fd\u4e3a\u7a7a\u3002");
        }
        try {
            return InvoiceCloudService.getInvoiceInfo(token, aesKey, invoiceCode, invoiceNo, invoiceCloudUrl);
        }
        catch (Exception e) {
            return new InvoiceResult(false, e.getMessage());
        }
    }
}

