/*
 * Decompiled with CFR 0.152.
 */
package kd.drp.pos.business.saleorder;

import com.alibaba.fastjson.JSONObject;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.earlywarn.kit.StringUtil;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.TimeServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.drp.dbd.business.payhelper.PayTradeHelper;
import kd.drp.dbd.common.pay.config.RefundInfo;
import kd.drp.dbd.common.pay.config.RefundResult;
import kd.drp.dbd.common.pay.config.TradeStatus;
import kd.drp.dbd.enums.PaymentModeEnum;
import kd.drp.pos.business.commonhelper.CurrencyHelper;
import kd.drp.pos.business.converthelper.SalesOrderConvertHelper;
import kd.drp.pos.business.invoice.InvoiceHelper;
import kd.drp.pos.business.systemparam.SystemParamHelper;
import kd.drp.pos.common.saleorder.BizTypeEnum;
import kd.drp.pos.common.util.CommonUtil;
import kd.drp.pos.common.util.DynamicObjectUtil;
import kd.drp.pos.common.vo.OperationResult;
import kd.drp.pos.common.vo.PaymentRecord;

public class SaleOrderHelper {
    private static final String SEQ = "seq";
    private static final String OCOC_ORDER = "ococ_orderbill";
    private static final String ISREDRUSH = "true";
    private static final String NOTREDRUSH = "false";
    public static final String PAYSTATUS = "payStatus";
    public static final String REFUNDTIME = "refundTime";
    public static final String OUTTRADENO = "outTradeNo";
    public static final String REFUNDAMOUNT = "refundAmount";
    public static final String SETTLEAMOUNT = "settleamount";
    public static final String ERRORMSG = "errorMSg";
    public static final String REFUNDSTATUS = "refundstatus";

    public static void updateSaleOrderAfterPayment(DynamicObject saleOrder, PaymentRecord paymentRecord) {
        DynamicObjectCollection recordList = saleOrder.getDynamicObjectCollection("finentity");
        int seq = recordList.size() + 1;
        DynamicObject payRecord = recordList.addNew();
        payRecord.set("setllementid", (Object)paymentRecord.getPayWay());
        payRecord.set("settlecurrid", (Object)paymentRecord.getPayCurrency());
        DynamicObject loCurrency = saleOrder.getDynamicObject("locurrencyid");
        long taxTableId = DynamicObjectUtil.getPkValue((DynamicObject)saleOrder, (String)"exratetable");
        BigDecimal rate = CurrencyHelper.getExChangeRate(paymentRecord.getPayCurrencyId(), loCurrency.getLong("Id"), taxTableId, new Date());
        payRecord.set("exchangerate", (Object)rate);
        payRecord.set(SETTLEAMOUNT, (Object)paymentRecord.getAmount());
        payRecord.set("paytime", (Object)paymentRecord.getPaytime());
        payRecord.set("integralconsum", (Object)paymentRecord.getRewardPoint());
        payRecord.set("cardno", (Object)paymentRecord.getCardNo());
        payRecord.set("cardtypeid", (Object)paymentRecord.getBankType());
        payRecord.set("tradereference", (Object)paymentRecord.getBankExchangeNo());
        payRecord.set("bankaccountid", (Object)paymentRecord.getBankNo());
        payRecord.set("orderno", (Object)paymentRecord.getOrderNo());
        payRecord.set("stmamount", (Object)paymentRecord.getAmount());
        payRecord.set("settlementrate", (Object)rate);
        payRecord.set(SEQ, (Object)seq);
        DynamicObject currency = saleOrder.getDynamicObject("currencyid");
        BigDecimal actualPayAmount = paymentRecord.getAmount().multiply(rate).divide(saleOrder.getBigDecimal("financeexchangerate"), currency.getInt("amtprecision"), 6);
        BigDecimal totalPayAmount = saleOrder.getBigDecimal("totalrealamount").add(actualPayAmount);
        saleOrder.set("stillneedtopay", (Object)saleOrder.getBigDecimal("stillneedtopay").subtract(actualPayAmount));
        saleOrder.set("totalrealamount", (Object)totalPayAmount);
        saleOrder.set("finentity", (Object)recordList);
        SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{saleOrder});
    }

    public static OperationResult pushBillAndCreateInvoice(Object saleOrderId) {
        DynamicObject saleOrder = BusinessDataServiceHelper.loadSingle((Object)saleOrderId, (String)"pos_salesorder");
        OperationResult result = new OperationResult();
        String needInvoice = saleOrder.getString("openquotype");
        String isMergeBill = saleOrder.getString("ismergebill");
        String billType = saleOrder.getString("biztype");
        Map<String, Object> pushResult = null;
        Object retailId = null;
        Object failMsg = null;
        switch (String.valueOf(isMergeBill)) {
            case "0": {
                pushResult = SalesOrderConvertHelper.push(saleOrderId, OCOC_ORDER);
                failMsg = pushResult.get("failMsg");
                if (failMsg != null) {
                    return new OperationResult(false, String.format("\u5355\u636e\u7f16\u53f7\u4e3a%s\u7684\u96f6\u552e\u5f00\u5355\u4e0b\u63a8\u9884\u8ba2\u5355\u5931\u8d25\uff0c\u539f\u56e0\u662f\uff1a%s\u3002", saleOrder.getString("billno"), failMsg.toString()), null);
                }
                result.setSuccess(Boolean.TRUE);
                result.setMessage(String.format("\u5355\u636e\u7f16\u53f7\u4e3a%s\u7684\u96f6\u552e\u5f00\u5355\u4e0b\u63a8\u9884\u8ba2\u5355\u6210\u529f\u3002", saleOrder.getString("billno")));
                break;
            }
            case "1": {
                pushResult = SalesOrderConvertHelper.push(saleOrderId, "ococ_retailbill");
                failMsg = pushResult.get("failMsg");
                if (failMsg != null) {
                    return new OperationResult(false, String.format("\u5355\u636e\u7f16\u53f7\u4e3a%s\u7684\u96f6\u552e\u5f00\u5355\u4e0b\u63a8\u96f6\u552e\u5355\u5931\u8d25\uff0c\u539f\u56e0\u662f\uff1a%s\u3002", saleOrder.getString("billno"), failMsg.toString()), null);
                }
                StringBuilder msg = new StringBuilder();
                boolean invoiceError = false;
                msg.append(String.format("\u5355\u636e\u7f16\u53f7\u4e3a%s\u7684\u96f6\u552e\u5f00\u5355\u4e0b\u63a8\u96f6\u552e\u5355\u6210\u529f\u3002", saleOrder.getString("billno")));
                retailId = pushResult.get("retailId");
                if (SaleOrderHelper.isCreateInvoice(needInvoice, billType, "2").booleanValue()) {
                    String errorMsg = SaleOrderHelper.createSaleOrderInvoice(saleOrder, retailId);
                    invoiceError = StringUtils.isNotEmpty((CharSequence)errorMsg);
                    msg.append(errorMsg);
                }
                result.setSuccess(Boolean.valueOf(!invoiceError));
                result.setMessage(msg.toString());
                break;
            }
            case "2": {
                StringBuilder sb = new StringBuilder();
                Boolean retailSuccess = Boolean.FALSE;
                Boolean preOrderSuccess = Boolean.FALSE;
                Boolean invoiceFlag = Boolean.FALSE;
                sb.append(String.format("\u5355\u636e\u7f16\u53f7\u4e3a%s\u7684\u96f6\u552e\u5f00\u5355", saleOrder.getString("billno")));
                pushResult = SalesOrderConvertHelper.push(saleOrderId, OCOC_ORDER);
                failMsg = pushResult.get("failMsg");
                if (failMsg != null) {
                    sb.append(String.format("\u4e0b\u63a8\u9884\u8ba2\u5355\u5931\u8d25\uff0c\u539f\u56e0\u662f\uff1a%s\uff1b", failMsg.toString()));
                } else {
                    preOrderSuccess = Boolean.TRUE;
                    sb.append("\u4e0b\u63a8\u9884\u8ba2\u5355\u6210\u529f\uff1b");
                }
                pushResult = SalesOrderConvertHelper.push(saleOrderId, "ococ_retailbill");
                failMsg = pushResult.get("failMsg");
                if (failMsg != null) {
                    sb.append(String.format("\u4e0b\u63a8\u96f6\u552e\u5355\u5931\u8d25\uff0c\u539f\u56e0\u662f\uff1a%s\u3002", failMsg.toString()));
                } else {
                    retailSuccess = Boolean.TRUE;
                    sb.append("\u4e0b\u63a8\u96f6\u552e\u5355\u6210\u529f\u3002");
                    retailId = pushResult.get("retailId");
                    if (SaleOrderHelper.isCreateInvoice(needInvoice, billType, "2").booleanValue()) {
                        String errorMsg = SaleOrderHelper.createSaleOrderInvoice(saleOrder, retailId);
                        invoiceFlag = StringUtils.isNotEmpty((CharSequence)errorMsg);
                        sb.append(errorMsg);
                    }
                }
                result.setSuccess(Boolean.valueOf(retailSuccess != false && preOrderSuccess != false && invoiceFlag == false));
                result.setMessage(sb.toString());
                break;
            }
        }
        return result;
    }

    public static String createSaleOrderInvoice(DynamicObject saleOrder, Object retailOrderId) {
        String invoiceCloudType = "0";
        if (saleOrder.getString("biztype").equalsIgnoreCase(BizTypeEnum.SALERETURN.getValue())) {
            invoiceCloudType = "1";
        }
        DynamicObject retailOrder = BusinessDataServiceHelper.loadSingle((Object)retailOrderId, (String)"ococ_retailbill");
        return InvoiceHelper.createInvoice(saleOrder, retailOrder, invoiceCloudType);
    }

    private static Boolean isCreateInvoice(String needInvoice, String billType, String mergeBillType) {
        if (!"0".equalsIgnoreCase(needInvoice) && !billType.equalsIgnoreCase(BizTypeEnum.SALEORDER.getValue()) && ("1".equalsIgnoreCase(mergeBillType) || "2".equalsIgnoreCase(mergeBillType))) {
            return Boolean.TRUE;
        }
        return Boolean.FALSE;
    }

    public static void saveNoElectricPayRecord(Object saleOrderId, DynamicObjectCollection payList) {
        DynamicObject saleOrder = BusinessDataServiceHelper.loadSingle((Object)saleOrderId, (String)"pos_salesorder");
        String orderType = saleOrder.getString("biztype");
        BigDecimal payTotalAmount = BigDecimal.ZERO;
        Object wipeAmount = BigDecimal.ZERO;
        DynamicObject user = BusinessDataServiceHelper.loadSingle((Object)RequestContext.get().getUserId(), (String)"bos_user");
        if (payList.size() > 0) {
            BigDecimal preAmount;
            String billType;
            DynamicObject payWay;
            DynamicObjectCollection recordList = saleOrder.getDynamicObjectCollection("finentity");
            int seq = recordList.size() + 1;
            boolean isCashPay = false;
            boolean isCreditPay = false;
            if ("B".equalsIgnoreCase(orderType)) {
                Object backAmount = BigDecimal.ZERO;
                for (DynamicObject pay : payList) {
                    payWay = pay.getDynamicObject("returnpayway");
                    long payWayId = CommonUtil.formatObejctToLong((Object)payWay.getPkValue());
                    if (!PaymentModeEnum.getNoElectricPayList().contains(payWayId)) continue;
                    DynamicObject returnRecord = recordList.addNew();
                    returnRecord.set("setllementid", (Object)payWay);
                    DynamicObject payCurrency = pay.getDynamicObject("returncurrency");
                    long payCurrencyId = Long.parseLong(payCurrency.getPkValue().toString());
                    returnRecord.set("settlecurrid", (Object)payCurrency);
                    long currencyId = DynamicObjectUtil.getPkValue((DynamicObject)saleOrder, (String)"locurrencyid");
                    long rateTableId = DynamicObjectUtil.getPkValue((DynamicObject)saleOrder, (String)"exratetable");
                    BigDecimal rate = CurrencyHelper.getExChangeRate(payCurrencyId, currencyId, rateTableId, TimeServiceHelper.now());
                    returnRecord.set("exchangerate", (Object)rate);
                    backAmount = pay.getBigDecimal("returnactualamount");
                    returnRecord.set("stmamount", backAmount);
                    returnRecord.set("settlementrate", (Object)pay.getBigDecimal("returnexchangerate"));
                    returnRecord.set(SETTLEAMOUNT, (Object)pay.getBigDecimal("hasreturnamount"));
                    returnRecord.set("paytime", pay.get("returntime"));
                    returnRecord.set(SEQ, (Object)seq);
                    if (PaymentModeEnum.getKey((String)"clearprice") == payWayId) {
                        wipeAmount = backAmount;
                    } else {
                        payTotalAmount = payTotalAmount.add((BigDecimal)backAmount);
                    }
                    ++seq;
                }
            } else {
                for (DynamicObject pay : payList) {
                    BigDecimal stmAmount = BigDecimal.ZERO;
                    payWay = pay.getDynamicObject("payway");
                    long payWayId = CommonUtil.formatObejctToLong((Object)payWay.getPkValue());
                    if (PaymentModeEnum.getKey((String)"tosettleaccounts") == payWayId) {
                        isCreditPay = true;
                        stmAmount = pay.getBigDecimal("actualamount");
                    } else if (PaymentModeEnum.getKey((String)"cashpay") == payWayId) {
                        isCashPay = true;
                        stmAmount = pay.getBigDecimal("actualamount");
                    } else {
                        if (PaymentModeEnum.getKey((String)"clearprice") != payWayId) continue;
                        wipeAmount = pay.getBigDecimal("actualamount");
                    }
                    DynamicObject payRecord = recordList.addNew();
                    payRecord.set("setllementid", (Object)payWay);
                    DynamicObject payCurrency = pay.getDynamicObject("paycurrency");
                    payRecord.set("settlecurrid", (Object)payCurrency);
                    DynamicObject currency = saleOrder.getDynamicObject("locurrencyid");
                    DynamicObject rateTable = saleOrder.getDynamicObject("exratetable");
                    BigDecimal rate = CurrencyHelper.getExChangeRate(CommonUtil.formatObejctToLong((Object)payCurrency.getPkValue()), CommonUtil.formatObejctToLong((Object)currency.getPkValue()), CommonUtil.formatObejctToLong((Object)rateTable.getPkValue()), TimeServiceHelper.now());
                    payRecord.set("exchangerate", (Object)rate);
                    payRecord.set("stmamount", (Object)pay.getBigDecimal("actualamount"));
                    payRecord.set("settlementrate", (Object)pay.getBigDecimal("exchangerate"));
                    payRecord.set(SETTLEAMOUNT, (Object)pay.getBigDecimal("showamount"));
                    payRecord.set("paytime", pay.get("paytime"));
                    payRecord.set(SEQ, (Object)seq);
                    ++seq;
                    payTotalAmount = payTotalAmount.add(stmAmount);
                }
            }
            if ((billType = saleOrder.getString("biztype")).equalsIgnoreCase(BizTypeEnum.ORDERCONVERTSALE.getValue()) && (preAmount = saleOrder.getBigDecimal("preamount")).compareTo(BigDecimal.ZERO) > 0) {
                DynamicObject payRecord = recordList.addNew();
                payWay = BusinessDataServiceHelper.loadSingle((Object)PaymentModeEnum.getKey((String)"deposit"), (String)"dbd_paymode");
                payRecord.set("setllementid", (Object)payWay);
                payRecord.set("settlecurrid", (Object)saleOrder.getDynamicObject("currencyid"));
                payRecord.set("exchangerate", (Object)saleOrder.getBigDecimal("financeexchangerate"));
                payRecord.set("stmamount", (Object)preAmount);
                payRecord.set("settlementrate", (Object)BigDecimal.ONE);
                payRecord.set(SETTLEAMOUNT, (Object)preAmount);
                payRecord.set("paytime", (Object)TimeServiceHelper.now());
                payRecord.set(SEQ, (Object)seq);
                payTotalAmount = payTotalAmount.add(preAmount);
            }
            saleOrder.set("finentity", (Object)recordList);
            boolean isCombinePay = recordList.size() > 1;
            saleOrder.set("iscombinepay", (Object)isCombinePay);
            if (isCashPay) {
                saleOrder.set("cashreceiver", (Object)user);
            }
            if (isCreditPay) {
                saleOrder.set("debitopr", (Object)user);
            }
            if (((BigDecimal)wipeAmount).abs().compareTo(BigDecimal.ZERO) > 0) {
                saleOrder.set("ignoredecimalamt", wipeAmount);
            }
        }
        BigDecimal totalRealAmount = saleOrder.getBigDecimal("totalrealamount").add(payTotalAmount);
        saleOrder.set("totalrealamount", (Object)totalRealAmount);
        BigDecimal stillNeedToPay = BigDecimal.ZERO;
        boolean isFinished = false;
        if ("B".equalsIgnoreCase(orderType)) {
            stillNeedToPay = saleOrder.getBigDecimal("stillneedtopay").subtract(payTotalAmount).subtract((BigDecimal)wipeAmount);
            isFinished = stillNeedToPay.abs().compareTo(BigDecimal.ZERO) == 0;
        } else {
            stillNeedToPay = saleOrder.getBigDecimal("sumbalamount").subtract(totalRealAmount).subtract((BigDecimal)wipeAmount);
            isFinished = saleOrder.getBigDecimal("sumbalamount").subtract(totalRealAmount).subtract((BigDecimal)wipeAmount).subtract(stillNeedToPay).abs().compareTo(BigDecimal.ZERO) == 0;
        }
        saleOrder.set("stillneedtopay", (Object)stillNeedToPay);
        if (isFinished) {
            saleOrder.set("salestatus", (Object)"S");
            saleOrder.set("billstatus", (Object)"C");
            saleOrder.set("auditor", (Object)user);
            saleOrder.set("auditdate", (Object)TimeServiceHelper.now());
            SaleOrderHelper.wipeAmountShare((BigDecimal)wipeAmount, saleOrder);
        }
        SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{saleOrder});
    }

    private static void wipeAmountShare(BigDecimal wipeAmount, DynamicObject saleOrder) {
        DynamicObjectCollection entryData = DynamicObjectUtil.getDynamicObjectCollection((DynamicObject)saleOrder, (String)"goodsentryentity");
        if (entryData == null || entryData.size() <= 0) {
            return;
        }
        if (BigDecimal.ZERO.compareTo(wipeAmount) != 0) {
            BigDecimal sumRowIgnoreAmt = BigDecimal.ZERO;
            DynamicObject currency = DynamicObjectUtil.getDynamicObject((DynamicObject)saleOrder, (String)"currencyid");
            if (currency == null) {
                return;
            }
            List entryRows = entryData.stream().filter(p -> !DynamicObjectUtil.getBoolean((DynamicObject)p, (String)"isbook")).collect(Collectors.toList());
            if (entryRows.size() <= 0) {
                return;
            }
            int row = 0;
            BigDecimal sumReceAmount = entryData.stream().filter(p -> !DynamicObjectUtil.getBoolean((DynamicObject)p, (String)"isbook")).map(q -> DynamicObjectUtil.getBigDecimal((DynamicObject)q, (String)"balamount")).reduce(BigDecimal.ZERO, BigDecimal::add);
            for (DynamicObject entryRow : entryRows) {
                BigDecimal realAmount;
                int amountPrecision;
                BigDecimal qty = DynamicObjectUtil.getBigDecimal((DynamicObject)entryRow, (String)"saleqty");
                BigDecimal rowBalAmount = DynamicObjectUtil.getBigDecimal((DynamicObject)entryRow, (String)"balamount");
                int pricePrecision = DynamicObjectUtil.getInt((DynamicObject)currency, (String)"priceprecision") > 0 ? DynamicObjectUtil.getInt((DynamicObject)currency, (String)"priceprecision") : 2;
                int n = amountPrecision = DynamicObjectUtil.getInt((DynamicObject)currency, (String)"amtprecision") > 0 ? DynamicObjectUtil.getInt((DynamicObject)currency, (String)"amtprecision") : 2;
                if (++row < entryData.size()) {
                    BigDecimal rowAmtRate = BigDecimal.ZERO;
                    if (sumReceAmount.compareTo(BigDecimal.ZERO) > 0) {
                        rowAmtRate = rowBalAmount.divide(sumReceAmount, 10, 6);
                    }
                    BigDecimal rowIgnoreAmt = wipeAmount.multiply(rowAmtRate);
                    sumRowIgnoreAmt = sumRowIgnoreAmt.add(rowIgnoreAmt);
                    realAmount = rowBalAmount.subtract(rowIgnoreAmt);
                    entryRow.set("realamount", (Object)realAmount.setScale(amountPrecision, 6));
                } else {
                    realAmount = rowBalAmount.subtract(wipeAmount.subtract(sumRowIgnoreAmt));
                    entryRow.set("realamount", (Object)realAmount.setScale(amountPrecision, 6));
                }
                BigDecimal realPrice = BigDecimal.ZERO;
                if (qty.compareTo(BigDecimal.ZERO) > 0) {
                    realPrice = realAmount.divide(qty, pricePrecision, 6);
                }
                entryRow.set("realprice", (Object)realPrice);
            }
        } else {
            for (DynamicObject entryItem : entryData) {
                entryItem.set("realamount", (Object)DynamicObjectUtil.getBigDecimal((DynamicObject)entryItem, (String)"balamount"));
                entryItem.set("realprice", (Object)DynamicObjectUtil.getBigDecimal((DynamicObject)entryItem, (String)"discountprice"));
            }
        }
    }

    public static String callRefund(String outTradeNo, DynamicObject saleOrder, BigDecimal stmamount, DynamicObject payWay, Boolean isDeposit) {
        String refundResult = "";
        String billNo = saleOrder.getString("billno");
        long operatorId = 0L;
        DynamicObject creatorInfo = saleOrder.getDynamicObject("creator");
        if (creatorInfo != null) {
            operatorId = creatorInfo.getLong("Id");
        }
        Date operaTime = TimeServiceHelper.now();
        long storeId = 0L;
        DynamicObject saleBranchInfo = saleOrder.getDynamicObject("salebranchid");
        if (saleBranchInfo != null) {
            storeId = saleBranchInfo.getLong("Id");
        }
        DynamicObject payCurrency = saleOrder.getDynamicObject("currencyid");
        RefundInfo refundData = new RefundInfo();
        refundData.setBillNo(billNo);
        refundData.setOperatorId(operatorId);
        refundData.setOperaTime(operaTime);
        refundData.setStoreId(storeId);
        refundData.setIsDeposit(isDeposit);
        long payWayId = payWay.getLong("Id");
        if (PaymentModeEnum.getKey((String)"alipay") == payWayId) {
            JSONObject aliRefundResult = SaleOrderHelper.callAliRefund(stmamount, outTradeNo, saleOrder, payCurrency, refundData, payWay);
            refundResult = SerializationUtils.toJsonString((Object)aliRefundResult);
        } else if (PaymentModeEnum.getKey((String)"wechatpay") == payWayId) {
            JSONObject wxRefundResult = SaleOrderHelper.callWxRefund(stmamount, outTradeNo, saleOrder, payCurrency, refundData, payWay);
            refundResult = SerializationUtils.toJsonString((Object)wxRefundResult);
        }
        return refundResult;
    }

    protected static JSONObject callAliRefund(BigDecimal stmamount, String outTradeNo, DynamicObject saleOrder, DynamicObject payCurrency, RefundInfo refundData, DynamicObject payWay) {
        String subMsg;
        JSONObject refundInfo = new JSONObject();
        String payStatus = "FAIL";
        BigDecimal refundAmount = BigDecimal.ZERO;
        Date refundTime = TimeServiceHelper.now();
        RefundResult refundResult = PayTradeHelper.getRefundData((RefundInfo)refundData, (long)2L, (String)"", (String)outTradeNo, (BigDecimal)stmamount.abs());
        TradeStatus paystatus = refundResult.getTradeStatus();
        StringBuilder errorMessage = new StringBuilder();
        if (StringUtils.isNotEmpty((CharSequence)refundResult.getErrorMessage())) {
            errorMessage.append(refundResult.getErrorMessage());
        }
        if (refundResult.getRefundResponse() != null && StringUtils.isNotEmpty((CharSequence)(subMsg = refundResult.getRefundResponse().getString("sub_msg")))) {
            String subCode = refundResult.getRefundResponse().getString("sub_code");
            if ("ACQ.REASON_TRADE_REFUND_FEE_ERR".equals(subCode) || "ACQ.REFUND_AMT_NOT_EQUAL_TOTAL".equals(subCode)) {
                subMsg = "\u53ef\u9000\u91d1\u989d\u4e0d\u8db3";
            }
            errorMessage.append(subMsg);
        }
        if (TradeStatus.SUCCESS.equals((Object)paystatus)) {
            String tradeNo = refundResult.getRefundResponse().getString("trade_no");
            String refundFee = refundResult.getRefundResponse().getString("refund_fee");
            payStatus = "SUCCESS";
            refundAmount = new BigDecimal(refundFee);
            long payCurrencyId = payCurrency.getLong("Id");
            PaymentRecord payRecord = new PaymentRecord();
            payRecord.setPayCurrencyId(payCurrencyId);
            payRecord.setPayCurrency(payCurrency);
            payRecord.setPayWayId(payWay.getLong("Id"));
            payRecord.setPayWay(payWay);
            payRecord.setPaytime(refundTime);
            payRecord.setAmount(stmamount);
            payRecord.setOrderNo(outTradeNo);
            payRecord.setBankExchangeNo(tradeNo);
            payRecord.setIsDeposit(refundData.getIsDeposit());
            SaleOrderHelper.updateSaleOrderAfterPayment(saleOrder, payRecord);
            SaleOrderHelper.updateSaleOrderAfterRefund(saleOrder, payRecord);
        } else if (TradeStatus.FAILED.equals((Object)paystatus)) {
            errorMessage.append(":\u652f\u4ed8\u5b9d\u9000\u6b3e\u5931\u8d25");
        } else if (TradeStatus.UNKNOWN.equals((Object)paystatus)) {
            errorMessage.append(":\u7cfb\u7edf\u5f02\u5e38\uff0c\u8ba2\u5355\u72b6\u6001\u672a\u77e5");
        } else {
            errorMessage.append(":\u4e0d\u652f\u6301\u7684\u4ea4\u6613\u72b6\u6001\uff0c\u4ea4\u6613\u8fd4\u56de\u5f02\u5e38");
        }
        refundInfo.put(PAYSTATUS, (Object)payStatus);
        refundInfo.put(REFUNDTIME, (Object)refundTime);
        refundInfo.put(OUTTRADENO, (Object)outTradeNo);
        refundInfo.put(REFUNDAMOUNT, (Object)refundAmount);
        refundInfo.put(ERRORMSG, (Object)errorMessage.toString());
        return refundInfo;
    }

    public static void updateSaleOrderAfterRefund(DynamicObject saleOrder, PaymentRecord paymentRecord) {
        DynamicObject sourcebill = saleOrder.getDynamicObject("sourcebillid");
        if (sourcebill != null) {
            DynamicObject inisourcebill;
            Object iniSourceBillId;
            Object sourceBillId = sourcebill.getPkValue();
            DynamicObject srcSaleOrder = BusinessDataServiceHelper.loadSingle((Object)sourceBillId, (String)"pos_salesorder");
            SaleOrderHelper.updateSaleOrderFin(srcSaleOrder, paymentRecord);
            if (paymentRecord.getIsDeposit() == Boolean.TRUE && (iniSourceBillId = (inisourcebill = srcSaleOrder.getDynamicObject("sourcebillid")).getPkValue()) != null) {
                DynamicObject iniSaleOrder = BusinessDataServiceHelper.loadSingle((Object)iniSourceBillId, (String)"pos_salesorder");
                SaleOrderHelper.updateSaleOrderFin(iniSaleOrder, paymentRecord);
            }
        }
    }

    public static void updateSaleOrderFin(DynamicObject saleOrder, PaymentRecord paymentRecord) {
        DynamicObjectCollection finEntry = saleOrder.getDynamicObjectCollection("finentity");
        if (finEntry == null) {
            return;
        }
        BigDecimal paymentAmount = paymentRecord.getAmount();
        for (DynamicObject srcFin : finEntry) {
            String orderno = srcFin.getString("orderno");
            if (!orderno.equals(paymentRecord.getOrderNo())) continue;
            BigDecimal refundamount = srcFin.getBigDecimal("refundamount").add(paymentAmount.abs());
            BigDecimal stmamount = srcFin.getBigDecimal("stmamount");
            srcFin.set("refundamount", (Object)refundamount);
            if (refundamount.compareTo(stmamount) >= 0) {
                srcFin.set(REFUNDSTATUS, (Object)"1");
            }
            SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{saleOrder});
            return;
        }
    }

    protected static JSONObject callWxRefund(BigDecimal stmamount, String outTradeNo, DynamicObject saleOrder, DynamicObject payCurrency, RefundInfo refundData, DynamicObject payWay) {
        JSONObject refundInfo = new JSONObject();
        String payStatus = "FAIL";
        BigDecimal refundAmount = BigDecimal.ZERO;
        Date refundTime = TimeServiceHelper.now();
        RefundResult refundResult = PayTradeHelper.getRefundData((RefundInfo)refundData, (long)1L, (String)"", (String)outTradeNo, (BigDecimal)stmamount.abs());
        TradeStatus paystatus = refundResult.getTradeStatus();
        StringBuilder errorMessage = new StringBuilder();
        if (StringUtils.isNotEmpty((CharSequence)refundResult.getErrorMessage())) {
            errorMessage.append(refundResult.getErrorMessage());
        }
        if (refundResult.getRefundResponse() != null) {
            String returnMsg = refundResult.getRefundResponse().getString("return_msg");
            if (!"OK".equals(returnMsg)) {
                if ("invalid refund_fee".equals(returnMsg)) {
                    returnMsg = "\u53ef\u9000\u91d1\u989d\u4e0d\u8db3";
                }
                errorMessage.append(returnMsg);
            }
            if (StringUtils.isNotEmpty((CharSequence)refundResult.getRefundResponse().getString("err_code_des"))) {
                errorMessage.append(refundResult.getRefundResponse().getString("err_code_des"));
            }
        }
        if (TradeStatus.SUCCESS.equals((Object)paystatus)) {
            String refundId = refundResult.getRefundResponse().getString("refund_id");
            String refundFee = refundResult.getRefundResponse().getString("refund_fee");
            payStatus = "SUCCESS";
            refundAmount = new BigDecimal(refundFee);
            long payCurrencyId = payCurrency.getLong("Id");
            PaymentRecord payRecord = new PaymentRecord();
            payRecord.setPayCurrencyId(payCurrencyId);
            payRecord.setPayCurrency(payCurrency);
            payRecord.setPayWayId(payWay.getLong("Id"));
            payRecord.setPayWay(payWay);
            payRecord.setPaytime(refundTime);
            payRecord.setAmount(stmamount);
            payRecord.setOrderNo(outTradeNo);
            payRecord.setBankExchangeNo(refundId);
            payRecord.setIsDeposit(refundData.getIsDeposit());
            SaleOrderHelper.updateSaleOrderAfterPayment(saleOrder, payRecord);
            SaleOrderHelper.updateSaleOrderAfterRefund(saleOrder, payRecord);
        } else if (TradeStatus.FAILED.equals((Object)paystatus)) {
            errorMessage.append(":\u5fae\u4fe1\u9000\u6b3e\u5931\u8d25");
        } else if (TradeStatus.UNKNOWN.equals((Object)paystatus)) {
            errorMessage.append(":\u7cfb\u7edf\u5f02\u5e38\uff0c\u8ba2\u5355\u72b6\u6001\u672a\u77e5");
        } else {
            errorMessage.append(":\u4e0d\u652f\u6301\u7684\u4ea4\u6613\u72b6\u6001\uff0c\u4ea4\u6613\u8fd4\u56de\u5f02\u5e38");
        }
        refundInfo.put(PAYSTATUS, (Object)payStatus);
        refundInfo.put(REFUNDTIME, (Object)refundTime);
        refundInfo.put(OUTTRADENO, (Object)outTradeNo);
        refundInfo.put(REFUNDAMOUNT, (Object)refundAmount);
        refundInfo.put(ERRORMSG, (Object)errorMessage.toString());
        return refundInfo;
    }

    public static List<PaymentRecord> getPayBackOperationResult(Object saleOrderId, DynamicObjectCollection returnPayList) {
        if (saleOrderId == null) {
            return new ArrayList<PaymentRecord>();
        }
        ArrayList<PaymentRecord> returnList = new ArrayList<PaymentRecord>(returnPayList.size());
        DynamicObject saleOrder = BusinessDataServiceHelper.loadSingle((Object)saleOrderId, (String)"pos_salesorder");
        switch (saleOrder.getString("isredrush")) {
            case "true": {
                DynamicObject sourceBill = saleOrder.getDynamicObject("sourcebillid");
                Object sourceBillId = sourceBill.getPkValue();
                DynamicObject sourceSaleOrder = BusinessDataServiceHelper.loadSingle((Object)sourceBillId, (String)"pos_salesorder");
                DynamicObjectCollection sourceFinEntry = sourceSaleOrder.getDynamicObjectCollection("finentity");
                DynamicObjectCollection noElectricPayRecords = new DynamicObjectCollection();
                ArrayList<Map<String, Object>> electricPayMapList = new ArrayList<Map<String, Object>>();
                DynamicObject payway = new DynamicObject();
                DynamicObjectCollection hasReturnList = saleOrder.getDynamicObjectCollection("finentity");
                if (hasReturnList.size() == 0) {
                    String srcBizType = sourceBill.getString("biztype");
                    DynamicObject noteleObject = null;
                    for (DynamicObject sourceFin : sourceFinEntry) {
                        payway = sourceFin.getDynamicObject("setllementid");
                        BigDecimal settleAmount = sourceFin.getBigDecimal(SETTLEAMOUNT);
                        BigDecimal actualAmount = sourceFin.getBigDecimal("stmamount");
                        long payWayId = CommonUtil.formatObejctToLong((Object)payway.getPkValue());
                        if (payWayId == 14L && srcBizType.equalsIgnoreCase(BizTypeEnum.ORDERCONVERTSALE.getValue())) {
                            SaleOrderHelper.getOriginPayType(sourceSaleOrder, sourceFin, noElectricPayRecords, electricPayMapList, returnPayList);
                            continue;
                        }
                        if (PaymentModeEnum.getNoElectricPayList().contains(payWayId)) {
                            noteleObject = returnPayList.addNew();
                            noteleObject.set("returnpayway", (Object)payway);
                            noteleObject.set("returntime", sourceFin.get("paytime"));
                            noteleObject.set("returncurrency", (Object)sourceFin.getDynamicObject("settlecurrid"));
                            noteleObject.set("hasreturnamount", (Object)settleAmount.multiply(new BigDecimal("-1")));
                            noteleObject.set("returnactualamount", (Object)actualAmount.multiply(new BigDecimal("-1")));
                            noteleObject.set("returnexchangerate", (Object)sourceFin.getBigDecimal("settlementrate"));
                            noteleObject.set("isdeposit", (Object)Boolean.FALSE);
                            noElectricPayRecords.add((Object)noteleObject);
                            continue;
                        }
                        HashMap<String, Object> electricPayMap = new HashMap<String, Object>();
                        electricPayMap.put("setllementid", payway);
                        electricPayMap.put(SETTLEAMOUNT, sourceFin.getBigDecimal(SETTLEAMOUNT));
                        electricPayMap.put("stmamount", sourceFin.getBigDecimal("stmamount"));
                        electricPayMap.put("orderno", sourceFin.getString("orderno"));
                        electricPayMap.put("paytime", sourceFin.getDate("paytime"));
                        electricPayMap.put("settlecurrid", sourceFin.getDynamicObject("settlecurrid"));
                        electricPayMap.put("isdeposit", Boolean.FALSE);
                        electricPayMapList.add(electricPayMap);
                    }
                } else {
                    for (Object record : returnPayList) {
                        payway = record.getDynamicObject("returnpayway");
                        if (!PaymentModeEnum.getNoElectricPayList().contains(CommonUtil.formatObejctToLong((Object)payway.getPkValue())) || !StringUtil.isEmpty((CharSequence)record.getString("returnenrtyid"))) continue;
                        noElectricPayRecords.add(record);
                    }
                }
                if (electricPayMapList.size() > 0) {
                    JSONObject resultMsg = new JSONObject();
                    for (Map map : electricPayMapList) {
                        resultMsg = JSONObject.parseObject((String)SaleOrderHelper.callRefund((String)map.get("orderno"), saleOrder, ((BigDecimal)map.get(SETTLEAMOUNT)).multiply(new BigDecimal("-1")), (DynamicObject)map.get("setllementid"), (Boolean)map.get("isdeposit")));
                        if (!"FAIL".equalsIgnoreCase(resultMsg.getString(PAYSTATUS))) continue;
                        PaymentRecord failureRecord = new PaymentRecord();
                        failureRecord.setPayWay((DynamicObject)map.get("setllementid"));
                        failureRecord.setAmount(((BigDecimal)map.get(SETTLEAMOUNT)).multiply(new BigDecimal("-1")));
                        failureRecord.setPaytime((Date)map.get("paytime"));
                        failureRecord.setPayStatus("0");
                        failureRecord.setIsDeposit((Boolean)map.get("isdeposit"));
                        failureRecord.setPayCurrency((DynamicObject)map.get("settlecurrid"));
                        returnList.add(failureRecord);
                    }
                    if (returnList.size() == 0 && noElectricPayRecords.size() == 0) {
                        saleOrder.set("salestatus", (Object)"S");
                        saleOrder.set("billstatus", (Object)"C");
                        DynamicObject user = BusinessDataServiceHelper.loadSingle((Object)RequestContext.get().getUserId(), (String)"bos_user");
                        saleOrder.set("auditor", (Object)user);
                        saleOrder.set("auditdate", (Object)TimeServiceHelper.now());
                        SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{saleOrder});
                    }
                }
                SaleOrderHelper.saveNoElectricPayRecord(saleOrderId, noElectricPayRecords);
                break;
            }
            case "false": {
                SaleOrderHelper.saveNoElectricPayRecord(saleOrderId, returnPayList);
                break;
            }
        }
        return returnList;
    }

    public static void getOriginPayType(DynamicObject sourceSaleOrder, DynamicObject sourceFin, DynamicObjectCollection noElectricPayRecords, List<Map<String, Object>> electricPayMapList, DynamicObjectCollection returnPayList) {
        BigDecimal orderAmount;
        DynamicObject iniSourceBill = sourceSaleOrder.getDynamicObject("sourcebillid");
        Object iniBillId = iniSourceBill.getPkValue();
        BigDecimal mustRefundAmt = orderAmount = sourceFin.getBigDecimal("stmamount");
        BigDecimal refundAmt = BigDecimal.ZERO;
        if (iniBillId != null) {
            DynamicObject iniSaleOrder = BusinessDataServiceHelper.loadSingle((Object)iniBillId, (String)"pos_salesorder");
            if (iniSaleOrder == null) {
                return;
            }
            DynamicObjectCollection saleOrderFinEntry = iniSaleOrder.getDynamicObjectCollection("finentity");
            for (DynamicObject finEntry : saleOrderFinEntry) {
                BigDecimal refundamount;
                DynamicObject payway = finEntry.getDynamicObject("setllementid");
                BigDecimal stmamount = finEntry.getBigDecimal("stmamount");
                BigDecimal stillAmount = stmamount.subtract(refundamount = finEntry.getBigDecimal("refundamount"));
                if (stillAmount.compareTo(BigDecimal.ZERO) <= 0) continue;
                refundAmt = stillAmount.compareTo(mustRefundAmt) >= 0 ? mustRefundAmt : stillAmount;
                if (PaymentModeEnum.getNoElectricPayList().contains(CommonUtil.formatObejctToLong((Object)payway.getPkValue()))) {
                    DynamicObject noteleObject = returnPayList.addNew();
                    noteleObject.set("returnpayway", (Object)payway);
                    noteleObject.set("returntime", finEntry.get("paytime"));
                    noteleObject.set("returncurrency", (Object)finEntry.getDynamicObject("settlecurrid"));
                    noteleObject.set("hasreturnamount", (Object)refundAmt.multiply(new BigDecimal("-1")));
                    noteleObject.set("returnactualamount", (Object)refundAmt.multiply(new BigDecimal("-1")));
                    noteleObject.set("returnexchangerate", (Object)finEntry.getBigDecimal("settlementrate"));
                    noteleObject.set("isdeposit", (Object)Boolean.TRUE);
                    noElectricPayRecords.add((Object)noteleObject);
                } else {
                    HashMap<String, Object> electricPayMap = new HashMap<String, Object>();
                    electricPayMap.put("setllementid", payway);
                    electricPayMap.put(SETTLEAMOUNT, refundAmt);
                    electricPayMap.put("stmamount", refundAmt);
                    electricPayMap.put("orderno", finEntry.getString("orderno"));
                    electricPayMap.put("paytime", finEntry.getDate("paytime"));
                    electricPayMap.put("settlecurrid", finEntry.getDynamicObject("settlecurrid"));
                    electricPayMap.put("isdeposit", Boolean.TRUE);
                    electricPayMapList.add(electricPayMap);
                }
                if ((mustRefundAmt = mustRefundAmt.subtract(refundAmt)).compareTo(BigDecimal.ZERO) > 0) continue;
                break;
            }
        }
    }

    public static void initData(IDataModel model) {
        DynamicObject branch = (DynamicObject)model.getValue("salebranchid");
        long orgId = DynamicObjectUtil.getPkValue((DynamicObject)branch, (String)"bizgroup");
        model.setValue("bizorgid", (Object)orgId);
        model.setValue("terminaltype", (Object)"R");
        model.setValue("customerid", null);
        model.setValue("saler", null);
        model.setValue("creator", (Object)CommonUtil.formatStringToLong((String)RequestContext.get().getUserId()));
        model.setValue("cashier", (Object)CommonUtil.formatStringToLong((String)RequestContext.get().getUserId()));
        model.setValue("locurrencyid", (Object)CurrencyHelper.getCurrency(orgId));
        model.setValue("currencyid", (Object)SystemParamHelper.getItemCurrency(orgId));
        model.setValue("customername", (Object)"");
        model.setValue("customerphone", (Object)"");
        model.setValue("customeraddress", (Object)"");
        model.setValue("sourcebillno", (Object)"");
        model.setValue("returntype", (Object)"A");
        model.setValue("initialbillno", (Object)"");
        model.deleteEntryData("goodsentryentity");
        model.createNewEntryRow("goodsentryentity");
    }
}

