/*
 * Decompiled with CFR 0.152.
 */
package kd.ebg.aqap.banks.xtb.dc.utils;

import java.text.ParseException;
import java.util.Date;
import kd.ebg.egf.common.exception.EBExceiptionUtil;
import kd.ebg.egf.common.framework.bank.info.BankResponse;
import kd.ebg.egf.common.utils.datetime.DateTimeUtils;
import kd.ebg.egf.common.utils.string.StringUtils;
import org.jdom2.Element;
import org.jdom2.output.Format;
import org.jdom2.output.XMLOutputter;

public class GLBParser {
    public static String[][] parseMFS(String serial_record, int recordNum, int fieldNum) {
        String[] allrecord = StringUtils.split((String)serial_record, (String)"|");
        String[][] r2 = new String[recordNum][fieldNum];
        for (int i = 0; i <= recordNum; ++i) {
            if (fieldNum < 0) continue;
            System.arraycopy(allrecord, (i + 1) * fieldNum, r2[i], 0, fieldNum);
        }
        return r2;
    }

    public static Date parseGLBTransTime(String transferDate) {
        try {
            return DateTimeUtils.parseDate((String)transferDate, (String)"yyyyMMdd");
        }
        catch (ParseException e) {
            throw EBExceiptionUtil.serviceException((Throwable)e);
        }
    }

    public static BankResponse parseHeader(Element head) {
        BankResponse rsp = new BankResponse();
        String retCode = head.getChildTextTrim("ret_code");
        String retMsg = head.getChild("ret_info") != null ? head.getChild("ret_info").getTextTrim() : "";
        rsp.setResponseCode(retCode);
        rsp.setResponseMessage(StringUtils.catWithSpace((String[])new String[]{retCode, retMsg}));
        return rsp;
    }

    private static String e2StrPlain(Element element, String encoding) {
        XMLOutputter outputter = new XMLOutputter();
        Format format = Format.getPrettyFormat();
        format.setEncoding(encoding);
        format.setIndent("");
        format.setLineSeparator("");
        format.setExpandEmptyElements(true);
        outputter.setFormat(format);
        return outputter.outputString(element).trim();
    }
}

