/*
 * Decompiled with CFR 0.152.
 */
package kd.ebg.aqap.banks.mufgb.chn.payment;

import java.util.List;
import java.util.Map;
import kd.bos.dataentity.resource.ResManager;
import kd.ebg.aqap.banks.mufgb.chn.payment.PayState;
import kd.ebg.aqap.banks.mufgb.chn.utils.Packer;
import kd.ebg.aqap.banks.mufgb.chn.utils.Paser;
import kd.ebg.aqap.business.payment.atomic.AbstractQueryPayImpl;
import kd.ebg.aqap.business.payment.atomic.IQueryPay;
import kd.ebg.aqap.business.payment.bank.BankPayRequest;
import kd.ebg.aqap.business.payment.bank.EBBankPayResponse;
import kd.ebg.aqap.business.payment.utils.EBGBusinessUtils;
import kd.ebg.aqap.common.entity.biz.status.PaymentState;
import kd.ebg.aqap.common.model.PaymentInfo;
import kd.ebg.egf.common.context.RequestContextUtils;
import kd.ebg.egf.common.exception.EBExceiptionUtil;
import kd.ebg.egf.common.framework.communication.ConnectionFactory;
import kd.ebg.egf.common.log.EBGLogger;
import kd.ebg.egf.common.utils.string.StringUtils;
import kd.ebg.egf.common.utils.xml.JDomUtils;
import org.jdom2.Element;

public class QueryPayImpl
extends AbstractQueryPayImpl
implements IQueryPay {
    private EBGLogger logger = EBGLogger.getInstance().getLogger(QueryPayImpl.class);

    public void configFactory(ConnectionFactory factory) {
        factory.setUri(RequestContextUtils.getBankParameterValue((String)"uri"));
        factory.setHttpHeader("Content-Type", "text/xml");
        factory.setHttpHeader("User-Agent", "Mozilla/5.0 (compatible; MSIE 9.0; Windows NT 6.1; Trident/5.0)");
    }

    public int getBatchSize() {
        return 1;
    }

    public String pack(BankPayRequest bankPayRequest) {
        PaymentInfo paymentInfo = (PaymentInfo)bankPayRequest.getPaymentInfos().get(0);
        Element root = Packer.createRootWithHead("h2h.002.004");
        Element body = JDomUtils.createRoot((String)"req");
        JDomUtils.addChild((Element)body, (String)"corpSerial", (String)paymentInfo.getBankDetailSeqId());
        JDomUtils.addChild((Element)root, (Element)body);
        String reqMsg = JDomUtils.root2String((Element)root, (String)RequestContextUtils.getCharset());
        this.logger.info("\u4ed8\u6b3e\u72b6\u6001\u67e5\u8be2\u8bf7\u6c42\u62a5\u6587\u539f\u6587:" + reqMsg);
        return Packer.transferRequestToWsdl(reqMsg);
    }

    public EBBankPayResponse parse(BankPayRequest bankPayRequest, String rspStr) {
        List paymentInfos = bankPayRequest.getPaymentInfos();
        Element root = Paser.parseH2H(rspStr);
        Element head = root.getChild("respInfo");
        String respCode = head.getChildTextTrim("respCode");
        String respMsg = head.getChildTextTrim("respMsg");
        String acceptFlag = head.getChildTextTrim("acceptFlag");
        if (!"1".equalsIgnoreCase(acceptFlag)) {
            throw EBExceiptionUtil.serviceException((String)String.format(ResManager.loadKDString((String)"\u67e5\u8be2\u4ed8\u6b3e\u72b6\u6001\u5f02\u5e38\uff0c\u94f6\u884c\u8fd4\u56de\u9519\u8bef\u7801:%1$s,\u9519\u8bef\u4fe1\u606f:%2$s", (String)"QueryPayImpl_0", (String)"ebg-aqap-banks-mufgb-chn", (Object[])new Object[0]), respCode, respMsg));
        }
        Element resp = root.getChild("resp");
        String statusFlag = resp.getChildTextTrim("statusFlag");
        if ("1".equalsIgnoreCase(statusFlag)) {
            List rows = resp.getChildren("row");
            Element row = (Element)rows.get(0);
            String tranStatus = row.getChildTextTrim("tranStatus");
            Map<String, String> paymetStateMap = PayState.getPaymetStateMap();
            String statusMsg = paymetStateMap.get(tranStatus);
            if ("01".equalsIgnoreCase(tranStatus) || "02".equalsIgnoreCase(tranStatus) || "03".equalsIgnoreCase(tranStatus) || "06".equalsIgnoreCase(tranStatus) || "07".equalsIgnoreCase(tranStatus) || "11".equalsIgnoreCase(tranStatus)) {
                EBGBusinessUtils.setPaymentState((List)paymentInfos, (PaymentState)PaymentState.SUBMITED, (String)ResManager.loadKDString((String)"\u94f6\u884c\u5904\u7406\u4e2d", (String)"QueryPayImpl_1", (String)"ebg-aqap-banks-mufgb-chn", (Object[])new Object[0]), (String)tranStatus, (String)statusMsg);
            } else if ("13".equalsIgnoreCase(tranStatus)) {
                EBGBusinessUtils.setPaymentState((List)paymentInfos, (PaymentState)PaymentState.SUCCESS, (String)ResManager.loadKDString((String)"\u4ea4\u6613\u6210\u529f", (String)"QueryPayImpl_2", (String)"ebg-aqap-banks-mufgb-chn", (Object[])new Object[0]), (String)tranStatus, (String)statusMsg);
            } else if ("14".equalsIgnoreCase(tranStatus)) {
                EBGBusinessUtils.setPaymentState((List)paymentInfos, (PaymentState)PaymentState.FAIL, (String)ResManager.loadKDString((String)"\u4ea4\u6613\u5931\u8d25", (String)"QueryPayImpl_3", (String)"ebg-aqap-banks-mufgb-chn", (Object[])new Object[0]), (String)tranStatus, (String)statusMsg);
            } else {
                EBGBusinessUtils.setPaymentState((List)paymentInfos, (PaymentState)PaymentState.UNKNOWN, (String)ResManager.loadKDString((String)"\u4ea4\u6613\u7ed3\u679c\u672a\u77e5", (String)"QueryPayImpl_4", (String)"ebg-aqap-banks-mufgb-chn", (Object[])new Object[0]), (String)tranStatus, (String)(StringUtils.isNotEmpty((String)statusMsg) ? statusMsg : respMsg));
            }
        } else {
            EBGBusinessUtils.setPaymentState((List)paymentInfos, (PaymentState)PaymentState.UNKNOWN, (String)ResManager.loadKDString((String)"\u4ea4\u6613\u7ed3\u679c\u672a\u77e5", (String)"QueryPayImpl_4", (String)"ebg-aqap-banks-mufgb-chn", (Object[])new Object[0]), (String)respCode, (String)respMsg);
        }
        return new EBBankPayResponse(paymentInfos);
    }

    public String getDeveloper() {
        return null;
    }

    public String getBizCode() {
        return "h2h.002.004";
    }

    public String getBizDesc() {
        return ResManager.loadKDString((String)"\u652f\u4ed8\u6307\u4ee4\u53d7\u7406\u5904\u7406\u4fe1\u606f\u67e5\u8be2", (String)"QueryPayImpl_5", (String)"ebg-aqap-banks-mufgb-chn", (Object[])new Object[0]);
    }
}

